/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.action.trail.thread.config;

import com.alibaba.ttl.spi.TtlWrapper;
import com.alibaba.ttl.threadpool.TtlExecutors;
import com.xforceplus.action.trail.thread.config.ThreadPoolConfigProps;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.collections4.MapUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@EnableAsync
@ConditionalOnExpression(value="${action.trail.enable:false}")
@Configuration(value="globalTrailThreadPoolConfig")
@EnableConfigurationProperties(value={ThreadPoolConfigProps.class})
public class TrailThreadPoolConfig
implements ApplicationContextAware,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(TrailThreadPoolConfig.class);
    private final ThreadPoolConfigProps threadPoolConfigProps;
    private static final String THREAD_NAME_PREFIX = "async-thread-trail-";
    public static final String ASYNC_THREAD_POOL_EXECUTOR_TRAIL_NAME = "asyncThreadPoolExecutorTrail";
    private ApplicationContext applicationContext;

    public TrailThreadPoolConfig(ThreadPoolConfigProps threadPoolConfigProps) {
        log.info("TrailThreadPoolConfig-initialized,threadPoolConfigProps:{}", (Object)threadPoolConfigProps);
        this.threadPoolConfigProps = threadPoolConfigProps;
    }

    public void setApplicationContext(@NotNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Bean(value={"asyncThreadPoolExecutorTrail"})
    public ThreadPoolExecutor getAsyncThreadPoolExecutor() {
        TtlWrapper ttlWrapper = (TtlWrapper)this.getAsyncExecutor();
        if (ttlWrapper == null) {
            throw new RuntimeException("ttlWrapper is null");
        }
        ThreadPoolExecutor executor = (ThreadPoolExecutor)ttlWrapper.unwrap();
        return executor;
    }

    private Executor getAsyncExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.threadPoolConfigProps.getCorePoolSize());
        executor.setMaxPoolSize(this.threadPoolConfigProps.getMaxPoolSize());
        executor.setQueueCapacity(this.threadPoolConfigProps.getQueueCapacity());
        executor.setThreadNamePrefix(THREAD_NAME_PREFIX);
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        executor.initialize();
        return TtlExecutors.getTtlExecutorService((ExecutorService)executor.getThreadPoolExecutor());
    }

    public void destroy() {
        Map executorMap = this.applicationContext.getBeansOfType(ThreadPoolExecutor.class);
        if (MapUtils.isNotEmpty((Map)executorMap)) {
            executorMap.forEach((key, executor) -> {
                try {
                    executor.shutdown();
                }
                catch (Exception e) {
                    log.warn("{}.TrailThreadPoolExecutor shutdown failed, reason:{}", key, (Object)e.toString());
                }
            });
        }
    }
}

