package com.xforceplus.action.trail.thread.config;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author duanhy
 */
@Getter
@Setter
@ToString
@ConfigurationProperties(prefix = "action.trail.threadpool")
public class ThreadPoolConfigProps {

    private static final Integer CPU_SIZE = Math.max(Runtime.getRuntime().availableProcessors(), 8);

    private int corePoolSize = CPU_SIZE;

    private int maxPoolSize = CPU_SIZE * 2;

    private int queueCapacity = 100000;
}
