/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ant.coop.config;

import com.xforceplus.ant.coop.config.CoopFeignProperties;
import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.Logger;
import feign.Request;
import feign.RequestInterceptor;
import feign.Retryer;
import feign.codec.Decoder;
import feign.codec.Encoder;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.cloud.openfeign.support.SpringDecoder;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.cloud.openfeign.support.SpringMvcContract;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.StringUtils;

public class CoopFeignClientFactoryBean
implements FactoryBean<Object>,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(CoopFeignClientFactoryBean.class);
    private ApplicationContext applicationContext;
    private Class<?> type;
    private String name;
    private String url;
    private String path;

    public Object getObject() {
        CoopFeignProperties coopFeignProperties = (CoopFeignProperties)this.applicationContext.getBean(CoopFeignProperties.class);
        Feign.Builder builder = Feign.builder().client((Client)this.applicationContext.getBean("coopFeignClient", Client.class)).contract((Contract)this.applicationContext.getBean(SpringMvcContract.class)).decoder((Decoder)this.applicationContext.getBean(SpringDecoder.class)).encoder((Encoder)this.applicationContext.getBean(SpringEncoder.class)).options(new Request.Options(coopFeignProperties.getConnectTimeout().intValue(), coopFeignProperties.getReadTimeout().intValue())).retryer((Retryer)new Retryer.Default(coopFeignProperties.getPeriod().longValue(), coopFeignProperties.getMaxPeriod().longValue(), coopFeignProperties.getMaxAttempts().intValue())).logLevel(Logger.Level.FULL);
        this.addInterceptor(builder, coopFeignProperties.getInterceptors());
        CoopFeignProperties.ClientConfig clientConfig = coopFeignProperties.getConfig().get(this.name);
        if (null != clientConfig) {
            this.url = StringUtils.isEmpty((Object)clientConfig.getUrl()) ? this.url : clientConfig.getUrl();
            log.info("##### {} config url: {}", (Object)this.name, (Object)clientConfig.getUrl());
            this.addInterceptor(builder, clientConfig.getInterceptors());
        }
        this.url = this.getUrl(this.url, this.name);
        Object feignProxy = builder.target(this.type, this.url + this.path);
        log.info("##### " + this.name + " FeignClient init, url: {}; path: {}", (Object)this.url, (Object)this.path);
        return feignProxy;
    }

    public Class<?> getObjectType() {
        return this.type;
    }

    public boolean isSingleton() {
        return false;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private void addInterceptor(Feign.Builder builder, List<Class<RequestInterceptor>> interceptors) {
        if (interceptors.isEmpty()) {
            return;
        }
        for (Class<RequestInterceptor> interceptor : interceptors) {
            RequestInterceptor interceptorBean = null;
            try {
                interceptorBean = (RequestInterceptor)this.applicationContext.getBean(interceptor.getName());
            }
            catch (NoSuchBeanDefinitionException e) {
                if (null == interceptorBean) {
                    this.registerInterceptorBean(interceptor);
                }
                interceptorBean = (RequestInterceptor)this.applicationContext.getBean(interceptor.getName());
            }
            builder.requestInterceptor(interceptorBean);
        }
    }

    private void registerInterceptorBean(Class aClass) {
        ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)this.applicationContext;
        DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)configurableApplicationContext.getBeanFactory();
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition((Class)aClass);
        defaultListableBeanFactory.registerBeanDefinition(aClass.getName(), (BeanDefinition)beanDefinitionBuilder.getRawBeanDefinition());
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    private String getUrl(String url, String name) {
        if (StringUtils.hasText((String)url)) {
            if (!url.contains("://")) {
                url = "http://" + url;
            }
            try {
                new URL(url);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(url + " is malformed", e);
            }
        } else {
            url = "http://" + name;
        }
        return url;
    }
}

