/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ant.coop.feign.config;

import feign.RequestInterceptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="feign.coop")
public class CoopFeignProperties {
    private static final Logger log = LoggerFactory.getLogger(CoopFeignProperties.class);
    private Integer connectTimeout = 2000;
    private Integer readTimeout = 10000;
    private Long period = 1000L;
    private Long maxPeriod = 5000L;
    private Integer maxAttempts = 0;
    private HttpLoggingInterceptor.Level logLevel = HttpLoggingInterceptor.Level.BODY;
    private boolean gzip = true;
    private List<Class<RequestInterceptor>> interceptors = new ArrayList<Class<RequestInterceptor>>();
    private Map<String, ClientConfig> config = new HashMap<String, ClientConfig>();

    public CoopFeignProperties() {
        log.info("##### init CoopFeignProperties");
    }

    public Map<String, ClientConfig> getConfigMap() {
        return this.config;
    }

    public ClientConfig getConfig(String feignName) {
        return this.config.get(feignName);
    }

    public void setConfig(Map<String, ClientConfig> config) {
        this.config = config;
        config.forEach((key, value) -> value.setName((String)key));
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public Long getPeriod() {
        return this.period;
    }

    public Long getMaxPeriod() {
        return this.maxPeriod;
    }

    public Integer getMaxAttempts() {
        return this.maxAttempts;
    }

    public HttpLoggingInterceptor.Level getLogLevel() {
        return this.logLevel;
    }

    public boolean isGzip() {
        return this.gzip;
    }

    public List<Class<RequestInterceptor>> getInterceptors() {
        return this.interceptors;
    }

    public Map<String, ClientConfig> getConfig() {
        return this.config;
    }

    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setPeriod(Long period) {
        this.period = period;
    }

    public void setMaxPeriod(Long maxPeriod) {
        this.maxPeriod = maxPeriod;
    }

    public void setMaxAttempts(Integer maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public void setLogLevel(HttpLoggingInterceptor.Level logLevel) {
        this.logLevel = logLevel;
    }

    public void setGzip(boolean gzip) {
        this.gzip = gzip;
    }

    public void setInterceptors(List<Class<RequestInterceptor>> interceptors) {
        this.interceptors = interceptors;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CoopFeignProperties)) {
            return false;
        }
        CoopFeignProperties other = (CoopFeignProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$connectTimeout = this.getConnectTimeout();
        Integer other$connectTimeout = other.getConnectTimeout();
        if (this$connectTimeout == null ? other$connectTimeout != null : !((Object)this$connectTimeout).equals(other$connectTimeout)) {
            return false;
        }
        Integer this$readTimeout = this.getReadTimeout();
        Integer other$readTimeout = other.getReadTimeout();
        if (this$readTimeout == null ? other$readTimeout != null : !((Object)this$readTimeout).equals(other$readTimeout)) {
            return false;
        }
        Long this$period = this.getPeriod();
        Long other$period = other.getPeriod();
        if (this$period == null ? other$period != null : !((Object)this$period).equals(other$period)) {
            return false;
        }
        Long this$maxPeriod = this.getMaxPeriod();
        Long other$maxPeriod = other.getMaxPeriod();
        if (this$maxPeriod == null ? other$maxPeriod != null : !((Object)this$maxPeriod).equals(other$maxPeriod)) {
            return false;
        }
        Integer this$maxAttempts = this.getMaxAttempts();
        Integer other$maxAttempts = other.getMaxAttempts();
        if (this$maxAttempts == null ? other$maxAttempts != null : !((Object)this$maxAttempts).equals(other$maxAttempts)) {
            return false;
        }
        HttpLoggingInterceptor.Level this$logLevel = this.getLogLevel();
        HttpLoggingInterceptor.Level other$logLevel = other.getLogLevel();
        if (this$logLevel == null ? other$logLevel != null : !this$logLevel.equals(other$logLevel)) {
            return false;
        }
        if (this.isGzip() != other.isGzip()) {
            return false;
        }
        List<Class<RequestInterceptor>> this$interceptors = this.getInterceptors();
        List<Class<RequestInterceptor>> other$interceptors = other.getInterceptors();
        if (this$interceptors == null ? other$interceptors != null : !((Object)this$interceptors).equals(other$interceptors)) {
            return false;
        }
        Map<String, ClientConfig> this$config = this.getConfig();
        Map<String, ClientConfig> other$config = other.getConfig();
        return !(this$config == null ? other$config != null : !((Object)this$config).equals(other$config));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CoopFeignProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $connectTimeout = this.getConnectTimeout();
        result = result * 59 + ($connectTimeout == null ? 43 : ((Object)$connectTimeout).hashCode());
        Integer $readTimeout = this.getReadTimeout();
        result = result * 59 + ($readTimeout == null ? 43 : ((Object)$readTimeout).hashCode());
        Long $period = this.getPeriod();
        result = result * 59 + ($period == null ? 43 : ((Object)$period).hashCode());
        Long $maxPeriod = this.getMaxPeriod();
        result = result * 59 + ($maxPeriod == null ? 43 : ((Object)$maxPeriod).hashCode());
        Integer $maxAttempts = this.getMaxAttempts();
        result = result * 59 + ($maxAttempts == null ? 43 : ((Object)$maxAttempts).hashCode());
        HttpLoggingInterceptor.Level $logLevel = this.getLogLevel();
        result = result * 59 + ($logLevel == null ? 43 : $logLevel.hashCode());
        result = result * 59 + (this.isGzip() ? 79 : 97);
        List<Class<RequestInterceptor>> $interceptors = this.getInterceptors();
        result = result * 59 + ($interceptors == null ? 43 : ((Object)$interceptors).hashCode());
        Map<String, ClientConfig> $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        return result;
    }

    public String toString() {
        return "CoopFeignProperties(connectTimeout=" + this.getConnectTimeout() + ", readTimeout=" + this.getReadTimeout() + ", period=" + this.getPeriod() + ", maxPeriod=" + this.getMaxPeriod() + ", maxAttempts=" + this.getMaxAttempts() + ", logLevel=" + this.getLogLevel() + ", gzip=" + this.isGzip() + ", interceptors=" + this.getInterceptors() + ", config=" + this.getConfig() + ")";
    }

    public static class ClientConfig {
        private String name;
        private String url;
        private List<String> interceptors = new ArrayList<String>();

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public List<String> getInterceptors() {
            return this.interceptors;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setInterceptors(List<String> interceptors) {
            this.interceptors = interceptors;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClientConfig)) {
                return false;
            }
            ClientConfig other = (ClientConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            List<String> this$interceptors = this.getInterceptors();
            List<String> other$interceptors = other.getInterceptors();
            return !(this$interceptors == null ? other$interceptors != null : !((Object)this$interceptors).equals(other$interceptors));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ClientConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            List<String> $interceptors = this.getInterceptors();
            result = result * 59 + ($interceptors == null ? 43 : ((Object)$interceptors).hashCode());
            return result;
        }

        public String toString() {
            return "CoopFeignProperties.ClientConfig(name=" + this.getName() + ", url=" + this.getUrl() + ", interceptors=" + this.getInterceptors() + ")";
        }
    }
}

