/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ant.coop.feign.intercepter;

import com.xforceplus.ant.coop.feign.domain.CoopRouteHolder;
import com.xforceplus.ant.coop.feign.domain.CoopRouteInfo;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;

public class CoopRouteParserInterceptor
implements HandlerInterceptor {
    private Logger logger = LoggerFactory.getLogger(CoopRouteParserInterceptor.class);
    @Value(value="${coop.route.header-key:coop-route}")
    private String routeHeaderKey;

    public CoopRouteParserInterceptor() {
        this.logger.info("##### CoopRouteParserInterceptor \u521d\u59cb\u5316");
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        try {
            String routeValue = request.getHeader(this.routeHeaderKey);
            if (!StringUtils.isEmpty((Object)routeValue)) {
                CoopRouteInfo coopRouteInfo = new CoopRouteInfo();
                coopRouteInfo.setHeaderKey(this.routeHeaderKey);
                coopRouteInfo.setCoopRoute(routeValue);
                CoopRouteHolder.put(coopRouteInfo);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        CoopRouteHolder.clearContext();
    }
}

