/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ant.coop.feign.config;

import com.xforceplus.ant.coop.feign.annotation.EnableCoopFeignClients;
import com.xforceplus.ant.coop.feign.config.CoopFeignClientFactoryBean;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AbstractClassTestingTypeFilter;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class CoopFeignClientRegistrar
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(CoopFeignClientRegistrar.class);
    public static Set<String> feignNames = new HashSet<String>();
    private ResourceLoader resourceLoader;
    private Environment environment;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        this.registerFeignClients(importingClassMetadata, registry);
        System.out.println("Feign\u670d\u52a1\u5217\u8868------------------------------------------------------------------------------");
        for (String feignName : feignNames) {
            System.out.println("@@@@@ = " + feignName);
        }
        System.out.println("Feign\u670d\u52a1\u5217\u8868------------------------------------------------------------------------------");
    }

    public void registerFeignClients(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        Set<String> basePackages;
        Class[] clients;
        ClassPathScanningCandidateComponentProvider scanner = this.getScanner();
        scanner.setResourceLoader(this.resourceLoader);
        Map attrs = metadata.getAnnotationAttributes(EnableCoopFeignClients.class.getName());
        AnnotationTypeFilter annotationTypeFilter = new AnnotationTypeFilter(FeignClient.class);
        Class[] classArray = clients = attrs == null ? null : (Class[])attrs.get("clients");
        if (clients == null || clients.length == 0) {
            scanner.addIncludeFilter((TypeFilter)annotationTypeFilter);
            basePackages = this.getBasePackages(metadata);
        } else {
            final HashSet<String> clientClasses = new HashSet<String>();
            basePackages = new HashSet<String>();
            for (Class clazz : clients) {
                basePackages.add(ClassUtils.getPackageName((Class)clazz));
                clientClasses.add(clazz.getCanonicalName());
            }
            AbstractClassTestingTypeFilter filter = new AbstractClassTestingTypeFilter(){

                protected boolean match(ClassMetadata metadata) {
                    String cleaned = metadata.getClassName().replaceAll("\\$", ".");
                    return clientClasses.contains(cleaned);
                }
            };
            scanner.addIncludeFilter((TypeFilter)new AllTypeFilter(Arrays.asList(filter, annotationTypeFilter)));
        }
        for (String basePackage : basePackages) {
            Set candidateComponents = scanner.findCandidateComponents(basePackage);
            for (BeanDefinition candidateComponent : candidateComponents) {
                if (!(candidateComponent instanceof AnnotatedBeanDefinition)) continue;
                AnnotatedBeanDefinition beanDefinition = (AnnotatedBeanDefinition)candidateComponent;
                AnnotationMetadata annotationMetadata = beanDefinition.getMetadata();
                Assert.isTrue((boolean)annotationMetadata.isInterface(), (String)"@FeignClient can only be specified on an interface");
                Map attributes = annotationMetadata.getAnnotationAttributes(FeignClient.class.getCanonicalName());
                String name = this.getClientName(attributes);
                feignNames.add(name);
                this.registerFeignClient(registry, annotationMetadata, attributes);
            }
        }
    }

    private void registerFeignClient(BeanDefinitionRegistry registry, AnnotationMetadata annotationMetadata, Map<String, Object> attributes) {
        String className = annotationMetadata.getClassName();
        BeanDefinitionBuilder definition = BeanDefinitionBuilder.genericBeanDefinition(CoopFeignClientFactoryBean.class);
        this.validate(attributes);
        String name = this.getClientName(attributes);
        definition.addPropertyValue("path", (Object)this.getPath(attributes));
        definition.addPropertyValue("name", (Object)name.toLowerCase());
        definition.addPropertyValue("type", (Object)className);
        definition.setAutowireMode(2);
        String url = this.getUrl(attributes);
        if (!StringUtils.isEmpty((Object)url)) {
            definition.addPropertyValue("url", (Object)url);
        }
        String alias = name + "FeignClient";
        AbstractBeanDefinition beanDefinition = definition.getBeanDefinition();
        boolean primary = (Boolean)attributes.get("primary");
        beanDefinition.setPrimary(primary);
        BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)beanDefinition, className, new String[]{className});
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry);
    }

    protected Set<String> getBasePackages(AnnotationMetadata importingClassMetadata) {
        String[] split;
        HashSet<String> basePackages = new HashSet<String>();
        String placeholder = "${feign.coop.backages}";
        String backages = this.resolve(placeholder);
        if (placeholder.equals(backages)) {
            backages = "com.xforceplus";
        }
        log.info("##### coopFeign scan backages: {}", (Object)backages);
        for (String backage : split = backages.split(",")) {
            basePackages.add(backage);
        }
        if (basePackages.isEmpty()) {
            basePackages.add(ClassUtils.getPackageName((String)importingClassMetadata.getClassName()));
        }
        return basePackages;
    }

    protected ClassPathScanningCandidateComponentProvider getScanner() {
        return new ClassPathScanningCandidateComponentProvider(false, this.environment){

            protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                boolean isCandidate = false;
                if (beanDefinition.getMetadata().isIndependent() && !beanDefinition.getMetadata().isAnnotation()) {
                    isCandidate = true;
                }
                return isCandidate;
            }
        };
    }

    private String getClientName(Map<String, Object> client) {
        if (client == null) {
            return null;
        }
        String name = (String)client.get("value");
        if (!StringUtils.hasText((String)name)) {
            name = (String)client.get("name");
        }
        if (!StringUtils.hasText((String)name)) {
            name = (String)client.get("serviceId");
        }
        if (StringUtils.hasText((String)(name = this.resolve(name)))) {
            return name;
        }
        throw new IllegalStateException("Either 'name' or 'value' must be provided in @" + FeignClient.class.getSimpleName());
    }

    private void validate(Map<String, Object> attributes) {
        AnnotationAttributes annotation = AnnotationAttributes.fromMap(attributes);
        Assert.isTrue((!annotation.getClass("fallback").isInterface() ? 1 : 0) != 0, (String)"Fallback class must implement the interface annotated by @FeignClient");
        Assert.isTrue((!annotation.getClass("fallbackFactory").isInterface() ? 1 : 0) != 0, (String)"Fallback factory must produce instances of fallback classes that implement the interface annotated by @FeignClient");
    }

    private String getUrl(Map<String, Object> attributes) {
        String url = this.resolve((String)attributes.get("url"));
        if (!(!StringUtils.hasText((String)url) || url.startsWith("#{") && url.contains("}"))) {
            if (!url.contains("://")) {
                url = "http://" + url;
            }
            try {
                new URL(url);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(url + " is malformed", e);
            }
        }
        return url;
    }

    private String getName(Map<String, Object> attributes) {
        String name = (String)attributes.get("serviceId");
        if (!StringUtils.hasText((String)name)) {
            name = (String)attributes.get("name");
        }
        if (!StringUtils.hasText((String)name)) {
            name = (String)attributes.get("value");
        }
        if (!StringUtils.hasText((String)(name = this.resolve(name)))) {
            return "";
        }
        String host = null;
        try {
            String url = !name.startsWith("http://") && !name.startsWith("https://") ? "http://" + name : name;
            host = new URI(url).getHost();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        Assert.state((host != null ? 1 : 0) != 0, (String)("Service id not legal hostname (" + name + ")"));
        return name;
    }

    private String resolve(String value) {
        if (StringUtils.hasText((String)value)) {
            return this.environment.resolvePlaceholders(value);
        }
        return value;
    }

    private String getPath(Map<String, Object> attributes) {
        String path = this.resolve((String)attributes.get("path"));
        if (StringUtils.hasText((String)path)) {
            if (!(path = path.trim()).startsWith("/")) {
                path = "/" + path;
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
        }
        return path;
    }

    private static class AllTypeFilter
    implements TypeFilter {
        private final List<TypeFilter> delegates;

        public AllTypeFilter(List<TypeFilter> delegates) {
            Assert.notNull(delegates, (String)"This argument is required, it must not be null");
            this.delegates = delegates;
        }

        public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
            for (TypeFilter filter : this.delegates) {
                if (filter.match(metadataReader, metadataReaderFactory)) continue;
                return false;
            }
            return true;
        }
    }
}

