/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ant.coop.feign.config;

import com.xforceplus.ant.coop.feign.config.CoopFeignClientRegistrar;
import com.xforceplus.ant.coop.feign.config.CoopFeignProperties;
import feign.Feign;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.commons.httpclient.OkHttpClientConnectionPoolFactory;
import org.springframework.cloud.commons.httpclient.OkHttpClientFactory;
import org.springframework.cloud.openfeign.FeignAutoConfiguration;
import org.springframework.cloud.openfeign.support.FeignHttpClientProperties;
import org.springframework.cloud.openfeign.support.SpringDecoder;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.cloud.openfeign.support.SpringMvcContract;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.core.convert.ConversionService;

@Configuration
@ConditionalOnProperty(value={"feign.coop.enabled"})
@ConditionalOnClass(value={Feign.class})
@AutoConfigureBefore(value={FeignAutoConfiguration.class})
@EnableConfigurationProperties(value={CoopFeignProperties.class})
@Import(value={CoopFeignClientRegistrar.class})
public class CoopFeignConfig {
    private static final Logger log = LoggerFactory.getLogger(CoopFeignConfig.class);

    @Primary
    @Bean(name={"coopFeignClient"})
    public feign.okhttp.OkHttpClient okHttpClient(OkHttpClient okHttpClient) {
        log.info("##### init coopFeignClient");
        feign.okhttp.OkHttpClient client = new feign.okhttp.OkHttpClient(okHttpClient);
        return client;
    }

    @Bean
    @ConditionalOnMissingBean(value={SpringEncoder.class})
    public SpringEncoder encoder(ObjectFactory<HttpMessageConverters> httpMessageConverters) {
        return new SpringEncoder(httpMessageConverters);
    }

    @Bean
    @ConditionalOnMissingBean(value={SpringDecoder.class})
    public SpringDecoder decoder(ObjectFactory<HttpMessageConverters> httpMessageConverters) {
        return new SpringDecoder(httpMessageConverters);
    }

    @Bean
    @ConditionalOnMissingBean(value={SpringMvcContract.class})
    public SpringMvcContract springMvcContract(ConversionService feignConversionService) {
        return new SpringMvcContract(new ArrayList(), feignConversionService);
    }

    static SSLSocketFactory createSSLSocketFactory() {
        SSLSocketFactory ssfFactory = null;
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, new TrustManager[]{new TrustAllCerts()}, new SecureRandom());
            ssfFactory = sc.getSocketFactory();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ssfFactory;
    }

    static class TrustAllCerts
    implements X509TrustManager {
        TrustAllCerts() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    @ConditionalOnProperty(value={"feign.coop.enabled"})
    @Configuration
    @ConditionalOnMissingBean(value={OkHttpClient.class})
    protected static class TenantOkHttpConfiguration {
        private OkHttpClient okHttpClient;

        protected TenantOkHttpConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={ConnectionPool.class})
        public ConnectionPool httpClientConnectionPool(FeignHttpClientProperties httpClientProperties, OkHttpClientConnectionPoolFactory connectionPoolFactory) {
            int maxTotalConnections = httpClientProperties.getMaxConnections();
            log.info("##### httpClient>maxTotalConnections: {}", (Object)maxTotalConnections);
            long timeToLive = httpClientProperties.getTimeToLive();
            log.info("##### httpClient>timeToLive: {}", (Object)timeToLive);
            TimeUnit ttlUnit = httpClientProperties.getTimeToLiveUnit();
            return connectionPoolFactory.create(maxTotalConnections, timeToLive, ttlUnit);
        }

        @Bean
        @ConditionalOnMissingBean(value={OkHttpClient.class})
        public OkHttpClient okHttpClient(OkHttpClientFactory httpClientFactory, ConnectionPool connectionPool, FeignHttpClientProperties httpClientProperties, CoopFeignProperties coopFeignSettings) {
            boolean followRedirects = httpClientProperties.isFollowRedirects();
            int connectTimeout = httpClientProperties.getConnectionTimeout();
            log.info("##### httpClient>connectTimeout: {}", (Object)connectTimeout);
            log.info("##### okhttp LogLevel: {}", (Object)coopFeignSettings.getLogLevel());
            OkHttpClient.Builder builder = httpClientFactory.createBuilder(httpClientProperties.isDisableSslValidation()).connectTimeout((long)connectTimeout, TimeUnit.MILLISECONDS).sslSocketFactory(CoopFeignConfig.createSSLSocketFactory()).hostnameVerifier((s, sslSession) -> true).followRedirects(followRedirects).connectionPool(connectionPool);
            builder.addInterceptor((Interceptor)new HttpLoggingInterceptor().setLevel(coopFeignSettings.getLogLevel()));
            this.okHttpClient = builder.build();
            return this.okHttpClient;
        }

        @PreDestroy
        public void destroy() {
            if (this.okHttpClient != null) {
                this.okHttpClient.dispatcher().executorService().shutdown();
                this.okHttpClient.connectionPool().evictAll();
            }
        }
    }
}

