/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ant.coop.feign.intercepter;

import com.xforceplus.ant.coop.feign.domain.CoopCanaryHolder;
import com.xforceplus.ant.coop.feign.domain.CoopCanaryInfo;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;

public class CoopCanaryParserInterceptor
implements HandlerInterceptor {
    private Logger logger = LoggerFactory.getLogger(CoopCanaryParserInterceptor.class);
    @Value(value="${coop.rule.header-key:coop-rule}")
    private String canaryHeaderKey;

    public CoopCanaryParserInterceptor() {
        this.logger.info("##### CoopCanaryParserInterceptor \u521d\u59cb\u5316");
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        try {
            String canaryValue = request.getHeader(this.canaryHeaderKey);
            if (!StringUtils.isEmpty((Object)canaryValue)) {
                CoopCanaryInfo coopRouteInfo = new CoopCanaryInfo();
                coopRouteInfo.setHeaderKey(this.canaryHeaderKey);
                coopRouteInfo.setCoopCanary(canaryValue);
                CoopCanaryHolder.put(coopRouteInfo);
                this.logger.info("##### header {} key\uff1a{}", (Object)this.canaryHeaderKey, (Object)canaryValue);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        CoopCanaryHolder.clearContext();
    }
}

