/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ant.coop.feign.intercepter;

import com.xforceplus.ant.coop.feign.intercepter.CoopCanaryParserInterceptor;
import com.xforceplus.ant.coop.feign.intercepter.MixCanaryParserInterceptor;
import java.util.ArrayList;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@Import(value={CoopCanaryParserInterceptor.class, MixCanaryParserInterceptor.class})
public class IntercepterConfig
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(IntercepterConfig.class);
    @Autowired(required=false)
    CoopCanaryParserInterceptor coopRouteParserInterceptor;
    @Autowired(required=false)
    MixCanaryParserInterceptor mixCanaryParserInterceptor;

    public void addInterceptors(InterceptorRegistry registry) {
        log.info("##### coopFeign \u62e6\u622a\u5668\u542f\u52a8 #####");
        ArrayList<String> patterns = this.getExcludePathPatterns();
        registry.addInterceptor((HandlerInterceptor)this.coopRouteParserInterceptor).excludePathPatterns(patterns.toArray(new String[0]));
        registry.addInterceptor((HandlerInterceptor)this.mixCanaryParserInterceptor).excludePathPatterns(patterns.toArray(new String[0]));
    }

    private ArrayList<String> getExcludePathPatterns() {
        ArrayList<String> list = new ArrayList<String>();
        String[] urls = new String[]{"/v2/api-docs", "/swagger-resources/**", "/client/**", "/health", "/xplat/health", "/refresh", "/info", "error"};
        Collections.addAll(list, urls);
        return list;
    }
}

