/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ant.coop.feign.intercepter;

import com.xforceplus.ant.coop.feign.domain.MixCanaryHolder;
import com.xforceplus.ant.coop.feign.domain.MixCanaryInfo;
import java.io.IOException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.util.WebUtils;

public class MixCanaryParserInterceptor
implements HandlerInterceptor {
    private Logger logger = LoggerFactory.getLogger(MixCanaryParserInterceptor.class);
    private String canaryHeaderKey = "mix-rule";

    public MixCanaryParserInterceptor() {
        this.logger.info("##### MixCanaryParserInterceptor \u521d\u59cb\u5316");
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        try {
            Cookie tokenCookie;
            String canaryValue = request.getHeader(this.canaryHeaderKey);
            if (null == canaryValue && (tokenCookie = WebUtils.getCookie((HttpServletRequest)request, (String)this.canaryHeaderKey)) != null) {
                canaryValue = tokenCookie.getValue();
            }
            if (!StringUtils.isEmpty((Object)canaryValue)) {
                MixCanaryInfo mixCanaryInfo = new MixCanaryInfo();
                mixCanaryInfo.setTenantId(canaryValue);
                mixCanaryInfo.setHeaderKey(this.canaryHeaderKey);
                MixCanaryHolder.put(mixCanaryInfo);
                this.logger.info("#####mix rule header {} key\uff1a{}", (Object)this.canaryHeaderKey, (Object)canaryValue);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        MixCanaryHolder.clearContext();
    }
}

