/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ant.coop.feign.util;

import com.xforceplus.ant.coop.feign.domain.CoopCanaryHolder;
import com.xforceplus.ant.coop.feign.domain.CoopCanaryInfo;
import com.xforceplus.ant.coop.feign.domain.MixCanaryHolder;
import com.xforceplus.ant.coop.feign.domain.MixCanaryInfo;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHeaderUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpHeaderUtil.class);

    public static void coopCanary(Object requestBase) {
        CoopCanaryInfo coopRouteInfo = CoopCanaryHolder.get();
        if (null == coopRouteInfo) {
            log.info("##### \u5f53\u524d\u4e0a\u4e0b\u6587coop-canary\u4e0d\u5b58\u5728");
            return;
        }
        try {
            Method setHeader = requestBase.getClass().getMethod("setHeader", String.class, String.class);
            setHeader.invoke(requestBase, coopRouteInfo.getHeaderKey(), coopRouteInfo.getCoopCanary());
            log.info("##### \u8bbe\u7f6eheader \u6210\u529f\uff1a{}", (Object)coopRouteInfo);
        }
        catch (Exception e) {
            log.warn("##### \u8bbe\u7f6e\u8bf7\u6c42\u5934 coop-canary\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
        MixCanaryInfo mixCanaryInfo = MixCanaryHolder.get();
        if (null == mixCanaryInfo) {
            log.info("##### \u5f53\u524d\u4e0a\u4e0b\u6587mix-canary\u4e0d\u5b58\u5728");
            return;
        }
        try {
            Method setHeader = requestBase.getClass().getMethod("setHeader", String.class, String.class);
            setHeader.invoke(requestBase, mixCanaryInfo.getHeaderKey(), mixCanaryInfo.getTenantId());
            log.info("##### \u8bbe\u7f6eheader \u6210\u529f\uff1a{}", (Object)mixCanaryInfo);
        }
        catch (Exception e) {
            log.warn("##### \u8bbe\u7f6e\u8bf7\u6c42\u5934 mix-canary\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
    }
}

