/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.coop.mix.client;

import com.xforceplus.coop.mix.client.MixClient;
import com.xforceplus.coop.mix.common.config.SpringContextHolder;
import com.xforceplus.coop.mix.common.enums.ClientType;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.CollectionUtils;

public class ClientFactory {
    private static final Logger log = LoggerFactory.getLogger(ClientFactory.class);
    private static Map<String, MixClient> serviceMap = new HashMap<String, MixClient>();

    public static <T> MixClient getClinet(ClientType typeEnum) {
        if (CollectionUtils.isEmpty(serviceMap)) {
            ClientFactory.init();
        }
        return serviceMap.get(typeEnum);
    }

    public static void init() {
        ApplicationContext applicationContext = SpringContextHolder.getApplicationContext();
        Map beanMap = applicationContext.getBeansOfType(MixClient.class);
        beanMap.forEach((k, v) -> {
            log.info("##### init work client : {}", k);
            System.out.println(v.getClass().getSimpleName());
        });
    }
}

