package com.xforceplus.coop.mix.client;

import com.xforceplus.coop.mix.common.config.SpringContextHolder;
import com.xforceplus.coop.mix.common.enums.ClientType;
import com.xforceplus.coop.mix.common.enums.InvoiceClientTypeEnum;
import com.xforceplus.coop.mix.utils.AopTargetUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.util.CollectionUtils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.*;

/**
 * Describe: TODO
 *
 * @Author xiezhongyong
 * @Date 2023-02-28
 */
@Slf4j
public class ClientFactory {

    private static Map<String, MixClient> serviceMap = new HashMap<>();

    private static List<ClientType> clientTypeList = new ArrayList<>();

    static {
        clientTypeList.addAll(Arrays.asList(InvoiceClientTypeEnum.values()));
    }

    public static <T> MixClient getClinet(ClientType typeEnum) {
        if (CollectionUtils.isEmpty(serviceMap)) {
            init();
        }
        return serviceMap.get(typeEnum.getClientName());
    }


    public static void init() {
        ApplicationContext applicationContext = SpringContextHolder.getApplicationContext();
        for (ClientType clientType : clientTypeList) {
            MixClient client = (MixClient) applicationContext.getBean(clientType.getClientClass());
            serviceMap.put(clientType.getClientName(), client);
        }


    }

}