package com.xforceplus.coop.mix.client.invoice;

import com.xforceplus.coop.mix.client.MixClient;
import com.xforceplus.seller.invoice.client.annotation.MsPhoenixInvoiceApi;
import com.xforceplus.seller.invoice.client.model.InvoiceDetailsInfoResponse;
import com.xforceplus.seller.invoice.client.model.QuerySellerInvoiceDetailsRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * Describe: InvoiceClient
 *
 * @Author xiezhongyong
 * @Date 2023-02-24
 */
@FeignClient(value = MsPhoenixInvoiceApi.SERVICE_NAME,
        path = MsPhoenixInvoiceApi.PHOENIX_SERVICE_PATH)
public interface PhoenixInvoiceClient extends MixClient {

    /**
     * 通过发票ID 查询发票
     * invoiceId	string
     * 必须
     * 发票id
     * sellerGroupId	string
     * 非必须
     * 租户id（只有商户发票池查询详情需要传）
     *
     * @param querySellerInvoiceDetailsRequest
     * @return
     */
    @RequestMapping(value = {"/invoice/queryInvoiceDetailsById"}, method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    InvoiceDetailsInfoResponse queryInvoiceDetailsById(@RequestBody QuerySellerInvoiceDetailsRequest querySellerInvoiceDetailsRequest);

}
