package com.xforceplus.coop.mix.client.preinvoice;

import com.xforceplus.coop.mix.client.MixClient;
import com.xforceplus.seller.invoice.client.annotation.MsPhoenixInvoiceApi;
import com.xforceplus.seller.invoice.client.model.PreInvoiceOpLog;
import com.xforceplus.seller.invoice.client.model.PreviewInvoiceResponse;
import com.xforceplus.seller.invoice.client.model.SellerPreInvoiceQueryByConditionRequest;
import com.xforceplus.seller.invoice.client.model.SellerPreInvoiceQueryResponse;
import io.swagger.annotations.ApiParam;
import javax.validation.constraints.NotNull;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = MsPhoenixInvoiceApi.SERVICE_NAME,
    path = MsPhoenixInvoiceApi.PHOENIX_PREINVOICE_SERVICE_PATH)
public interface PhoenixPreInvoiceClient extends MixClient {

    /**
     * 根据预制发票id查询预制发票信息
     *
     * @param preInvoiceId
     * @return
     */
    @RequestMapping(value = {"/preInvoice/previewInvoice"}, method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    PreviewInvoiceResponse previewInvoice(@ApiParam("预制发票Id") @RequestParam(value = "preInvoiceId", required = false) Long preInvoiceId);

    /**
     * 预制发票查询--多条件
     * @param request
     * @return
     */
    @RequestMapping(value = {"/preInvoice/query-by-condition"}, method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    SellerPreInvoiceQueryResponse queryByCondition(@ApiParam(value = "发票查询请求") @RequestBody SellerPreInvoiceQueryByConditionRequest request);

    @RequestMapping(value = "/logList",
        produces = {"application/json"},
        method = RequestMethod.GET)
    PreInvoiceOpLog logList(@NotNull @ApiParam(value = "预制发票id", required = true) @RequestParam(value = "preInvoiceId") Long preInvoiceId);

}
