package com.xforceplus.coop.mix.common.enums;

import com.xforceplus.coop.mix.client.invoice.PhoenixInvoiceClient;

import java.util.Arrays;

/**
 * Describe: client 类型
 *
 * @Author xiezhongyong
 * @Date 2023-02-24
 */
public enum InvoiceClientTypeEnum implements ClientType {

    INVOICE_QUERY(PhoenixInvoiceClient.class.getSimpleName(), PhoenixInvoiceClient.class, "消息发票业务处理");

    InvoiceClientTypeEnum(String clientName, Class clientClass, String clientDesc) {
        this.clientName = clientName;
        this.clientClass = clientClass;
        this.clientDesc = clientDesc;
    }

    private String clientName;
    private Class clientClass;
    private String clientDesc;

    @Override
    public String getClientName() {
        return this.clientName;
    }

    @Override
    public Class getClientClass() {
        return this.clientClass;
    }

    @Override
    public String getClientDesc() {
        return this.clientDesc;
    }

    @Override
    public InvoiceClientTypeEnum fromValue(String name) {
        return Arrays.stream(InvoiceClientTypeEnum.values())
                .filter(s -> s.clientName.equals(name))
                .findAny()
                .orElse(null);
    }
}