package com.xforceplus.coop.mix.common.exception;

import com.xforceplus.xplatframework.exception.IResultCode;
import com.xforceplus.xplatframework.exception.ResultCode;
import lombok.Getter;
import lombok.Setter;

/**
 * Describe: 融合层异常定义
 *
 * @Author xiezhongyong
 * @Date 2023/2/24
 */
public class CoopMixException extends RuntimeException {
    private static final long serialVersionUID = 2072748964898271445L;

    @Getter
    @Setter
    private IResultCode resultCode;

    public CoopMixException() {
        this(ResultCode.SYSTEM_INNER_ERROR);
    }

    public CoopMixException(String message) {
        this(ResultCode.SYSTEM_INNER_ERROR, message);
    }

    public CoopMixException(IResultCode resultCode) {
        this(resultCode, resultCode.getMessage());
    }

    public CoopMixException(IResultCode resultCode, String message) {
        super(message);
        this.resultCode = resultCode;
    }

    public CoopMixException(String message, Throwable throwable) {
        super(message, throwable);
    }
}
