package com.xforceplus.coop.mix.config;

import com.xforceplus.ant.coop.security.user.domain.UserAuthInfoHolder;
import com.xforceplus.ant.coop.security.utils.JsonUtils;
import com.xforceplus.coop.mix.model.MixUserInfo;
import com.xforceplus.tenantsecurity.domain.IAuthorizedUser;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.Base64Utils;

/**
 * Describe: TODO
 *
 * @Author xiezhongyong
 * @Date 2023-03-06
 */
@Slf4j
public class MixUserInfoInterceptor implements RequestInterceptor {

    private static final String HEADER_KEY = "x-phoenix-userinfo";
    @Override
    public void apply(RequestTemplate requestTemplate) {
        try {
            log.info("##### MixFeignConfig.RequestInterceptor 拦截启动");
            IAuthorizedUser authorizedUser = UserAuthInfoHolder.get();
            if (authorizedUser != null) {
                MixUserInfo mixUserInfo = new MixUserInfo();
                mixUserInfo.setGroupId(authorizedUser.getTenantId());
                mixUserInfo.setGroupCode(authorizedUser.getTenantCode());
                mixUserInfo.setGroupName(authorizedUser.getTenantName());
                mixUserInfo.setUserId(authorizedUser.getId());
                mixUserInfo.setUserName(authorizedUser.getUsername());
                mixUserInfo.setMobile(authorizedUser.getMobile());
                mixUserInfo.setEmail(authorizedUser.getEmail());
                String userInfoJson = JsonUtils.writeObjectToJson(mixUserInfo);
                String userInfoJsonBase64 = Base64Utils.encodeToString(userInfoJson.getBytes("UTF-8"));
                log.info("##### MixFeignConfig.RequestInterceptor 拦截设置用户信息header key：{}，userInfoJson ：{}; userInfoJsonBase64：{}", HEADER_KEY, userInfoJson, userInfoJsonBase64);
                requestTemplate.header(HEADER_KEY, userInfoJsonBase64);
            } else {
                log.info("##### MixFeignConfig.RequestInterceptor 拦截未设置用户信息,上下文未获取到用户信息");

            }
        } catch (Exception e) {
            log.error("##### MixFeignConfig.RequestInterceptor 拦截异常： {}", e);
        }

    }
}