package com.xforceplus.coop.mix.model;


import java.math.BigDecimal;
import java.util.Date;

public class MixPreInvoiceEntity extends MixBaseEntity {
    /**
     * 外部id
     * 表 : ant_pre_invoice
     * 对应字段 : external_id
     */
    private String externalId;

    /**
     * 批次号
     * 表 : ant_pre_invoice
     * 对应字段 : batch_no
     */
    private Long batchNo;

    /**
     * 系统外批次号  默认batch_no的值
     * 表 : ant_pre_invoice
     * 对应字段 : out_batch_no
     */
    private Long outBatchNo;

    /**
     * 单据号
     * 表 : ant_pre_invoice
     * 对应字段 : salesbill_no
     */
    private String salesbillNo;

    /**
     * 用户Id 下发数据需要  由属地直接传过来
     * 表 : ant_pre_invoice
     * 对应字段 : customer_no
     */
    private String customerNo;

    /**
     * 系统来源  下发数据需要  由属地直接传过来
     * 表 : ant_pre_invoice
     * 对应字段 : system_orig
     */
    private String systemOrig;

    /**
     * 购方租户id
     * 表 : ant_pre_invoice
     * 对应字段 : purchaser_tenant_id
     */
    private Long purchaserTenantId;

    /**
     * 购方公司id
     * 表 : ant_pre_invoice
     * 对应字段 : purchaser_id
     */
    private Long purchaserId;

    /**
     * 购方编号
     * 表 : ant_pre_invoice
     * 对应字段 : purchaser_no
     */
    private String purchaserNo;

    /**
     * 购方名称
     * 表 : ant_pre_invoice
     * 对应字段 : purchaser_name
     */
    private String purchaserName;

    /**
     * 购方税号
     * 表 : ant_pre_invoice
     * 对应字段 : purchaser_tax_no
     */
    private String purchaserTaxNo;

    /**
     * 购方电话
     * 表 : ant_pre_invoice
     * 对应字段 : purchaser_tel
     */
    private String purchaserTel;

    /**
     * 购方地址
     * 表 : ant_pre_invoice
     * 对应字段 : purchaser_address
     */
    private String purchaserAddress;

    /**
     * 购方开户行
     * 表 : ant_pre_invoice
     * 对应字段 : purchaser_bank_name
     */
    private String purchaserBankName;

    /**
     * 购方银行账号
     * 表 : ant_pre_invoice
     * 对应字段 : purchaser_bank_account
     */
    private String purchaserBankAccount;

    /**
     * 销方租户id
     * 表 : ant_pre_invoice
     * 对应字段 : seller_tenant_id
     */
    private Long sellerTenantId;

    /**
     * 销方编号
     * 表 : ant_pre_invoice
     * 对应字段 : seller_no
     */
    private String sellerNo;

    /**
     * 销方税号
     * 表 : ant_pre_invoice
     * 对应字段 : seller_tax_no
     */
    private String sellerTaxNo;

    /**
     * 销方名称
     * 表 : ant_pre_invoice
     * 对应字段 : seller_name
     */
    private String sellerName;

    /**
     * 销方电话
     * 表 : ant_pre_invoice
     * 对应字段 : seller_tel
     */
    private String sellerTel;

    /**
     * 销方地址
     * 表 : ant_pre_invoice
     * 对应字段 : seller_address
     */
    private String sellerAddress;

    /**
     * 销方开户行
     * 表 : ant_pre_invoice
     * 对应字段 : seller_bank_name
     */
    private String sellerBankName;

    /**
     * 销方银行账号
     * 表 : ant_pre_invoice
     * 对应字段 : seller_bank_account
     */
    private String sellerBankAccount;

    /**
     * 销方公司id
     * 表 : ant_pre_invoice
     * 对应字段 : seller_id
     */
    private Long sellerId;

    /**
     * 发票类型
     * 表 : ant_pre_invoice
     * 对应字段 : invoice_type
     */
    private String invoiceType;

    /**
     * 税控发票来源 qd - 全电发票; sk - 税控发票
     * 表 : ant_pre_invoice
     * 对应字段 : tax_invoice_source
     */
    private String taxInvoiceSource;

    /**
     * 发票票种 s - 纸专; se - 电专; c - 纸普; ce - 电普; v - 机动车; vs - 二手机动车; ju - 卷票
     * 表 : ant_pre_invoice
     * 对应字段 : invoice_kind
     */
    private String invoiceKind;

    /**
     * 业务单据类型
     * 表 : ant_pre_invoice
     * 对应字段 : business_bill_type
     */
    private String businessBillType;

    /**
     * 单据类型
     * 表 : ant_pre_invoice
     * 对应字段 : salesbill_type
     */
    private String salesbillType;

    /**
     * 发票号码
     * 表 : ant_pre_invoice
     * 对应字段 : invoice_no
     */
    private String invoiceNo;

    /**
     * 发票代码
     * 表 : ant_pre_invoice
     * 对应字段 : invoice_code
     */
    private String invoiceCode;

    /**
     * 开票日期
     * 表 : ant_pre_invoice
     * 对应字段 : paper_draw_date
     */
    private String paperDrawDate;

    /**
     * 机器编码
     * 表 : ant_pre_invoice
     * 对应字段 : machine_code
     */
    private String machineCode;

    /**
     * 校验码
     * 表 : ant_pre_invoice
     * 对应字段 : check_code
     */
    private String checkCode;

    /**
     * 不含税金额
     * 表 : ant_pre_invoice
     * 对应字段 : amount_without_tax
     */
    private BigDecimal amountWithoutTax;

    /**
     * 税额
     * 表 : ant_pre_invoice
     * 对应字段 : tax_amount
     */
    private BigDecimal taxAmount;

    /**
     * 含税金额
     * 表 : ant_pre_invoice
     * 对应字段 : amount_with_tax
     */
    private BigDecimal amountWithTax;

    /**
     * 税率
     * 表 : ant_pre_invoice
     * 对应字段 : tax_rate
     */
    private String taxRate;

    /**
     * 备注
     * 表 : ant_pre_invoice
     * 对应字段 : remark
     */
    private String remark;

    /**
     * 自定义备注
     * 表 : ant_pre_invoice
     * 对应字段 : ext_remark
     */
    private String extRemark;

    /**
     * 收款人
     * 表 : ant_pre_invoice
     * 对应字段 : cashier_name
     */
    private String cashierName;

    /**
     * 复核人
     * 表 : ant_pre_invoice
     * 对应字段 : checker_name
     */
    private String checkerName;

    /**
     * 开票人
     * 表 : ant_pre_invoice
     * 对应字段 : invoicer_name
     */
    private String invoicerName;

    /**
     * 电子签章
     * 表 : ant_pre_invoice
     * 对应字段 : electronic_signature
     */
    private String electronicSignature;

    /**
     * 预制发票状态，0=删除，1=待确认,2=有变更,3=购方确认中(销方待确认),4=销方确认中(购方待确认),5=待开票,6=开票中,7已开票
     * 表 : ant_pre_invoice
     * 对应字段 : status
     */
    private Integer status;

    /**
     * 开具结果
     * 表 : ant_pre_invoice
     * 对应字段 : process_remark
     */
    private String processRemark;

    /**
     * 预制发票是否锁定,0=未锁,1=锁定
     * 表 : ant_pre_invoice
     * 对应字段 : is_lock
     */
    private Integer isLock;

    /**
     * 规则id
     * 表 : ant_pre_invoice
     * 对应字段 : rule_id
     */
    private Long ruleId;

    /**
     * 组织机构id
     * 表 : ant_pre_invoice
     * 对应字段 : sys_org_id
     */
    private Long sysOrgId;

    /**
     * 原发票号码
     * 表 : ant_pre_invoice
     * 对应字段 : origin_invoice_no
     */
    private String originInvoiceNo;

    /**
     * 原发票代码
     * 表 : ant_pre_invoice
     * 对应字段 : origin_invoice_code
     */
    private String originInvoiceCode;

    /**
     * 原蓝票发票类型
     * 表 : ant_pre_invoice
     * 对应字段 : origin_invoice_type
     */
    private String originInvoiceType;

    /**
     * 原蓝票的开票日期 YYYYMMDD
     * 表 : ant_pre_invoice
     * 对应字段 : origin_paper_draw_date
     */
    private String originPaperDrawDate;

    /**
     * 红字信息表编号
     * 表 : ant_pre_invoice
     * 对应字段 : red_notification_no
     */
    private String redNotificationNo;

    /**
     * 红字信息编号申请状态 0-默认 1-发起申请 2-已申请
     * 表 : ant_pre_invoice
     * 对应字段 : red_notification_flag
     */
    private Integer redNotificationFlag;

    /**
     * 接收方邮箱
     * 表 : ant_pre_invoice
     * 对应字段 : receive_user_email
     */
    private String receiveUserEmail;

    /**
     * 接收方电话
     * 表 : ant_pre_invoice
     * 对应字段 : receive_user_tel
     */
    private String receiveUserTel;

    /**
     * 发票签名 用于抽取匹配
     * 表 : ant_pre_invoice
     * 对应字段 : invoice_signature
     */
    private String invoiceSignature;

    /**
     * 创建时间
     * 表 : ant_pre_invoice
     * 对应字段 : create_time
     */
    private Date createTime;

    /**
     * 创建人id
     * 表 : ant_pre_invoice
     * 对应字段 : create_user_id
     */
    private Long createUserId;

    /**
     * 更新时间
     * 表 : ant_pre_invoice
     * 对应字段 : update_time
     */
    private Date updateTime;

    /**
     * 更新用户id
     * 表 : ant_pre_invoice
     * 对应字段 : update_user_id
     */
    private Long updateUserId;

    /**
     * 来源产品线
     * 表 : ant_pre_invoice
     * 对应字段 : source_line
     */
    private String sourceLine;

    /**
     * 扩展1
     * 表 : ant_pre_invoice
     * 对应字段 : ext1
     */
    private String ext1;

    /**
     * 扩展2
     * 表 : ant_pre_invoice
     * 对应字段 : ext2
     */
    private String ext2;

    /**
     * 扩展3
     * 表 : ant_pre_invoice
     * 对应字段 : ext3
     */
    private String ext3;

    /**
     * 扩展4
     * 表 : ant_pre_invoice
     * 对应字段 : ext4
     */
    private String ext4;

    /**
     * 扩展5
     * 表 : ant_pre_invoice
     * 对应字段 : ext5
     */
    private String ext5;

    /**
     * 扩展6
     * 表 : ant_pre_invoice
     * 对应字段 : ext6
     */
    private String ext6;

    /**
     * 扩展7
     * 表 : ant_pre_invoice
     * 对应字段 : ext7
     */
    private String ext7;

    /**
     * 扩展8
     * 表 : ant_pre_invoice
     * 对应字段 : ext8
     */
    private String ext8;

    /**
     * 扩展9
     * 表 : ant_pre_invoice
     * 对应字段 : ext9
     */
    private String ext9;

    /**
     * 扩展10
     * 表 : ant_pre_invoice
     * 对应字段 : ext10
     */
    private String ext10;

    /**
     * 扩展11
     * 表 : ant_pre_invoice
     * 对应字段 : ext11
     */
    private String ext11;

    /**
     * 扩展12
     * 表 : ant_pre_invoice
     * 对应字段 : ext12
     */
    private String ext12;

    /**
     * 扩展13
     * 表 : ant_pre_invoice
     * 对应字段 : ext13
     */
    private String ext13;

    /**
     * 扩展14
     * 表 : ant_pre_invoice
     * 对应字段 : ext14
     */
    private String ext14;

    /**
     * 扩展15
     * 表 : ant_pre_invoice
     * 对应字段 : ext15
     */
    private String ext15;

    /**
     * 扩展16
     * 表 : ant_pre_invoice
     * 对应字段 : ext16
     */
    private String ext16;

    /**
     * 扩展17
     * 表 : ant_pre_invoice
     * 对应字段 : ext17
     */
    private String ext17;

    /**
     * 扩展18
     * 表 : ant_pre_invoice
     * 对应字段 : ext18
     */
    private String ext18;

    /**
     * 扩展19
     * 表 : ant_pre_invoice
     * 对应字段 : ext19
     */
    private String ext19;

    /**
     * 扩展20
     * 表 : ant_pre_invoice
     * 对应字段 : ext20
     */
    private String ext20;

    /**
     * 扩展21
     * 表 : ant_pre_invoice
     * 对应字段 : ext21
     */
    private String ext21;

    /**
     * 扩展22
     * 表 : ant_pre_invoice
     * 对应字段 : ext22
     */
    private String ext22;

    /**
     * 扩展23
     * 表 : ant_pre_invoice
     * 对应字段 : ext23
     */
    private String ext23;

    /**
     * 扩展24
     * 表 : ant_pre_invoice
     * 对应字段 : ext24
     */
    private String ext24;

    /**
     * 扩展25
     * 表 : ant_pre_invoice
     * 对应字段 : ext25
     */
    private String ext25;

    /**
     * 0:  init (初始状态，无红冲，默认值)  1:  sales_return (销货退回)   2:  making_error  (开票有误)      3:  taxable_service_end  (应税服务中止)    4:  sales_allowance  (发生销售折让)
     * 表 : ant_pre_invoice
     * 对应字段 : red_reason
     */
    private Integer redReason;

    /**
     * get method 
     *
     * @return ant_pre_invoice.external_id：外部id
     */
    public String getExternalId() {
        return externalId;
    }

    /**
     * set method 
     *
     * @param externalId  外部id
     */
    public void setExternalId(String externalId) {
        this.externalId = externalId == null ? null : externalId.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.batch_no：批次号
     */
    public Long getBatchNo() {
        return batchNo;
    }

    /**
     * set method 
     *
     * @param batchNo  批次号
     */
    public void setBatchNo(Long batchNo) {
        this.batchNo = batchNo;
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.out_batch_no：系统外批次号  默认batch_no的值
     */
    public Long getOutBatchNo() {
        return outBatchNo;
    }

    /**
     * set method 
     *
     * @param outBatchNo  系统外批次号  默认batch_no的值
     */
    public void setOutBatchNo(Long outBatchNo) {
        this.outBatchNo = outBatchNo;
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.salesbill_no：单据号
     */
    public String getSalesbillNo() {
        return salesbillNo;
    }

    /**
     * set method 
     *
     * @param salesbillNo  单据号
     */
    public void setSalesbillNo(String salesbillNo) {
        this.salesbillNo = salesbillNo == null ? null : salesbillNo.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.customer_no：用户Id 下发数据需要  由属地直接传过来
     */
    public String getCustomerNo() {
        return customerNo;
    }

    /**
     * set method 
     *
     * @param customerNo  用户Id 下发数据需要  由属地直接传过来
     */
    public void setCustomerNo(String customerNo) {
        this.customerNo = customerNo == null ? null : customerNo.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.system_orig：系统来源  下发数据需要  由属地直接传过来
     */
    public String getSystemOrig() {
        return systemOrig;
    }

    /**
     * set method 
     *
     * @param systemOrig  系统来源  下发数据需要  由属地直接传过来
     */
    public void setSystemOrig(String systemOrig) {
        this.systemOrig = systemOrig == null ? null : systemOrig.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.purchaser_tenant_id：购方租户id
     */
    public Long getPurchaserTenantId() {
        return purchaserTenantId;
    }

    /**
     * set method 
     *
     * @param purchaserTenantId  购方租户id
     */
    public void setPurchaserTenantId(Long purchaserTenantId) {
        this.purchaserTenantId = purchaserTenantId;
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.purchaser_id：购方公司id
     */
    public Long getPurchaserId() {
        return purchaserId;
    }

    /**
     * set method 
     *
     * @param purchaserId  购方公司id
     */
    public void setPurchaserId(Long purchaserId) {
        this.purchaserId = purchaserId;
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.purchaser_no：购方编号
     */
    public String getPurchaserNo() {
        return purchaserNo;
    }

    /**
     * set method 
     *
     * @param purchaserNo  购方编号
     */
    public void setPurchaserNo(String purchaserNo) {
        this.purchaserNo = purchaserNo == null ? null : purchaserNo.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.purchaser_name：购方名称
     */
    public String getPurchaserName() {
        return purchaserName;
    }

    /**
     * set method 
     *
     * @param purchaserName  购方名称
     */
    public void setPurchaserName(String purchaserName) {
        this.purchaserName = purchaserName == null ? null : purchaserName.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.purchaser_tax_no：购方税号
     */
    public String getPurchaserTaxNo() {
        return purchaserTaxNo;
    }

    /**
     * set method 
     *
     * @param purchaserTaxNo  购方税号
     */
    public void setPurchaserTaxNo(String purchaserTaxNo) {
        this.purchaserTaxNo = purchaserTaxNo == null ? null : purchaserTaxNo.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.purchaser_tel：购方电话
     */
    public String getPurchaserTel() {
        return purchaserTel;
    }

    /**
     * set method 
     *
     * @param purchaserTel  购方电话
     */
    public void setPurchaserTel(String purchaserTel) {
        this.purchaserTel = purchaserTel == null ? null : purchaserTel.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.purchaser_address：购方地址
     */
    public String getPurchaserAddress() {
        return purchaserAddress;
    }

    /**
     * set method 
     *
     * @param purchaserAddress  购方地址
     */
    public void setPurchaserAddress(String purchaserAddress) {
        this.purchaserAddress = purchaserAddress == null ? null : purchaserAddress.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.purchaser_bank_name：购方开户行
     */
    public String getPurchaserBankName() {
        return purchaserBankName;
    }

    /**
     * set method 
     *
     * @param purchaserBankName  购方开户行
     */
    public void setPurchaserBankName(String purchaserBankName) {
        this.purchaserBankName = purchaserBankName == null ? null : purchaserBankName.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.purchaser_bank_account：购方银行账号
     */
    public String getPurchaserBankAccount() {
        return purchaserBankAccount;
    }

    /**
     * set method 
     *
     * @param purchaserBankAccount  购方银行账号
     */
    public void setPurchaserBankAccount(String purchaserBankAccount) {
        this.purchaserBankAccount = purchaserBankAccount == null ? null : purchaserBankAccount.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.seller_tenant_id：销方租户id
     */
    public Long getSellerTenantId() {
        return sellerTenantId;
    }

    /**
     * set method 
     *
     * @param sellerTenantId  销方租户id
     */
    public void setSellerTenantId(Long sellerTenantId) {
        this.sellerTenantId = sellerTenantId;
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.seller_no：销方编号
     */
    public String getSellerNo() {
        return sellerNo;
    }

    /**
     * set method 
     *
     * @param sellerNo  销方编号
     */
    public void setSellerNo(String sellerNo) {
        this.sellerNo = sellerNo == null ? null : sellerNo.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.seller_tax_no：销方税号
     */
    public String getSellerTaxNo() {
        return sellerTaxNo;
    }

    /**
     * set method 
     *
     * @param sellerTaxNo  销方税号
     */
    public void setSellerTaxNo(String sellerTaxNo) {
        this.sellerTaxNo = sellerTaxNo == null ? null : sellerTaxNo.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.seller_name：销方名称
     */
    public String getSellerName() {
        return sellerName;
    }

    /**
     * set method 
     *
     * @param sellerName  销方名称
     */
    public void setSellerName(String sellerName) {
        this.sellerName = sellerName == null ? null : sellerName.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.seller_tel：销方电话
     */
    public String getSellerTel() {
        return sellerTel;
    }

    /**
     * set method 
     *
     * @param sellerTel  销方电话
     */
    public void setSellerTel(String sellerTel) {
        this.sellerTel = sellerTel == null ? null : sellerTel.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.seller_address：销方地址
     */
    public String getSellerAddress() {
        return sellerAddress;
    }

    /**
     * set method 
     *
     * @param sellerAddress  销方地址
     */
    public void setSellerAddress(String sellerAddress) {
        this.sellerAddress = sellerAddress == null ? null : sellerAddress.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.seller_bank_name：销方开户行
     */
    public String getSellerBankName() {
        return sellerBankName;
    }

    /**
     * set method 
     *
     * @param sellerBankName  销方开户行
     */
    public void setSellerBankName(String sellerBankName) {
        this.sellerBankName = sellerBankName == null ? null : sellerBankName.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.seller_bank_account：销方银行账号
     */
    public String getSellerBankAccount() {
        return sellerBankAccount;
    }

    /**
     * set method 
     *
     * @param sellerBankAccount  销方银行账号
     */
    public void setSellerBankAccount(String sellerBankAccount) {
        this.sellerBankAccount = sellerBankAccount == null ? null : sellerBankAccount.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.seller_id：销方公司id
     */
    public Long getSellerId() {
        return sellerId;
    }

    /**
     * set method 
     *
     * @param sellerId  销方公司id
     */
    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.invoice_type：发票类型
     */
    public String getInvoiceType() {
        return invoiceType;
    }

    /**
     * set method 
     *
     * @param invoiceType  发票类型
     */
    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType == null ? null : invoiceType.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.tax_invoice_source：税控发票来源 qd - 全电发票; sk - 税控发票
     */
    public String getTaxInvoiceSource() {
        return taxInvoiceSource;
    }

    /**
     * set method 
     *
     * @param taxInvoiceSource  税控发票来源 qd - 全电发票; sk - 税控发票
     */
    public void setTaxInvoiceSource(String taxInvoiceSource) {
        this.taxInvoiceSource = taxInvoiceSource == null ? null : taxInvoiceSource.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.invoice_kind：发票票种 s - 纸专; se - 电专; c - 纸普; ce - 电普; v - 机动车; vs - 二手机动车; ju - 卷票
     */
    public String getInvoiceKind() {
        return invoiceKind;
    }

    /**
     * set method 
     *
     * @param invoiceKind  发票票种 s - 纸专; se - 电专; c - 纸普; ce - 电普; v - 机动车; vs - 二手机动车; ju - 卷票
     */
    public void setInvoiceKind(String invoiceKind) {
        this.invoiceKind = invoiceKind == null ? null : invoiceKind.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.business_bill_type：业务单据类型
     */
    public String getBusinessBillType() {
        return businessBillType;
    }

    /**
     * set method 
     *
     * @param businessBillType  业务单据类型
     */
    public void setBusinessBillType(String businessBillType) {
        this.businessBillType = businessBillType == null ? null : businessBillType.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.salesbill_type：单据类型
     */
    public String getSalesbillType() {
        return salesbillType;
    }

    /**
     * set method 
     *
     * @param salesbillType  单据类型
     */
    public void setSalesbillType(String salesbillType) {
        this.salesbillType = salesbillType == null ? null : salesbillType.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.invoice_no：发票号码
     */
    public String getInvoiceNo() {
        return invoiceNo;
    }

    /**
     * set method 
     *
     * @param invoiceNo  发票号码
     */
    public void setInvoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo == null ? null : invoiceNo.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.invoice_code：发票代码
     */
    public String getInvoiceCode() {
        return invoiceCode;
    }

    /**
     * set method 
     *
     * @param invoiceCode  发票代码
     */
    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode == null ? null : invoiceCode.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.paper_draw_date：开票日期
     */
    public String getPaperDrawDate() {
        return paperDrawDate;
    }

    /**
     * set method 
     *
     * @param paperDrawDate  开票日期
     */
    public void setPaperDrawDate(String paperDrawDate) {
        this.paperDrawDate = paperDrawDate == null ? null : paperDrawDate.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.machine_code：机器编码
     */
    public String getMachineCode() {
        return machineCode;
    }

    /**
     * set method 
     *
     * @param machineCode  机器编码
     */
    public void setMachineCode(String machineCode) {
        this.machineCode = machineCode == null ? null : machineCode.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.check_code：校验码
     */
    public String getCheckCode() {
        return checkCode;
    }

    /**
     * set method 
     *
     * @param checkCode  校验码
     */
    public void setCheckCode(String checkCode) {
        this.checkCode = checkCode == null ? null : checkCode.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.amount_without_tax：不含税金额
     */
    public BigDecimal getAmountWithoutTax() {
        return amountWithoutTax;
    }

    /**
     * set method 
     *
     * @param amountWithoutTax  不含税金额
     */
    public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.tax_amount：税额
     */
    public BigDecimal getTaxAmount() {
        return taxAmount;
    }

    /**
     * set method 
     *
     * @param taxAmount  税额
     */
    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.amount_with_tax：含税金额
     */
    public BigDecimal getAmountWithTax() {
        return amountWithTax;
    }

    /**
     * set method 
     *
     * @param amountWithTax  含税金额
     */
    public void setAmountWithTax(BigDecimal amountWithTax) {
        this.amountWithTax = amountWithTax;
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.tax_rate：税率
     */
    public String getTaxRate() {
        return taxRate;
    }

    /**
     * set method 
     *
     * @param taxRate  税率
     */
    public void setTaxRate(String taxRate) {
        this.taxRate = taxRate == null ? null : taxRate.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.remark：备注
     */
    public String getRemark() {
        return remark;
    }

    /**
     * set method 
     *
     * @param remark  备注
     */
    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.ext_remark：自定义备注
     */
    public String getExtRemark() {
        return extRemark;
    }

    /**
     * set method 
     *
     * @param extRemark  自定义备注
     */
    public void setExtRemark(String extRemark) {
        this.extRemark = extRemark == null ? null : extRemark.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.cashier_name：收款人
     */
    public String getCashierName() {
        return cashierName;
    }

    /**
     * set method 
     *
     * @param cashierName  收款人
     */
    public void setCashierName(String cashierName) {
        this.cashierName = cashierName == null ? null : cashierName.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.checker_name：复核人
     */
    public String getCheckerName() {
        return checkerName;
    }

    /**
     * set method 
     *
     * @param checkerName  复核人
     */
    public void setCheckerName(String checkerName) {
        this.checkerName = checkerName == null ? null : checkerName.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.invoicer_name：开票人
     */
    public String getInvoicerName() {
        return invoicerName;
    }

    /**
     * set method 
     *
     * @param invoicerName  开票人
     */
    public void setInvoicerName(String invoicerName) {
        this.invoicerName = invoicerName == null ? null : invoicerName.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.electronic_signature：电子签章
     */
    public String getElectronicSignature() {
        return electronicSignature;
    }

    /**
     * set method 
     *
     * @param electronicSignature  电子签章
     */
    public void setElectronicSignature(String electronicSignature) {
        this.electronicSignature = electronicSignature == null ? null : electronicSignature.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.status：预制发票状态，0=删除，1=待确认,2=有变更,3=购方确认中(销方待确认),4=销方确认中(购方待确认),5=待开票,6=开票中,7已开票
     */
    public Integer getStatus() {
        return status;
    }

    /**
     * set method 
     *
     * @param status  预制发票状态，0=删除，1=待确认,2=有变更,3=购方确认中(销方待确认),4=销方确认中(购方待确认),5=待开票,6=开票中,7已开票
     */
    public void setStatus(Integer status) {
        this.status = status;
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.process_remark：开具结果
     */
    public String getProcessRemark() {
        return processRemark;
    }

    /**
     * set method 
     *
     * @param processRemark  开具结果
     */
    public void setProcessRemark(String processRemark) {
        this.processRemark = processRemark == null ? null : processRemark.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.is_lock：预制发票是否锁定,0=未锁,1=锁定
     */
    public Integer getIsLock() {
        return isLock;
    }

    /**
     * set method 
     *
     * @param isLock  预制发票是否锁定,0=未锁,1=锁定
     */
    public void setIsLock(Integer isLock) {
        this.isLock = isLock;
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.rule_id：规则id
     */
    public Long getRuleId() {
        return ruleId;
    }

    /**
     * set method 
     *
     * @param ruleId  规则id
     */
    public void setRuleId(Long ruleId) {
        this.ruleId = ruleId;
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.sys_org_id：组织机构id
     */
    public Long getSysOrgId() {
        return sysOrgId;
    }

    /**
     * set method 
     *
     * @param sysOrgId  组织机构id
     */
    public void setSysOrgId(Long sysOrgId) {
        this.sysOrgId = sysOrgId;
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.origin_invoice_no：原发票号码
     */
    public String getOriginInvoiceNo() {
        return originInvoiceNo;
    }

    /**
     * set method 
     *
     * @param originInvoiceNo  原发票号码
     */
    public void setOriginInvoiceNo(String originInvoiceNo) {
        this.originInvoiceNo = originInvoiceNo == null ? null : originInvoiceNo.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.origin_invoice_code：原发票代码
     */
    public String getOriginInvoiceCode() {
        return originInvoiceCode;
    }

    /**
     * set method 
     *
     * @param originInvoiceCode  原发票代码
     */
    public void setOriginInvoiceCode(String originInvoiceCode) {
        this.originInvoiceCode = originInvoiceCode == null ? null : originInvoiceCode.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.origin_invoice_type：原蓝票发票类型
     */
    public String getOriginInvoiceType() {
        return originInvoiceType;
    }

    /**
     * set method 
     *
     * @param originInvoiceType  原蓝票发票类型
     */
    public void setOriginInvoiceType(String originInvoiceType) {
        this.originInvoiceType = originInvoiceType == null ? null : originInvoiceType.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.origin_paper_draw_date：原蓝票的开票日期 YYYYMMDD
     */
    public String getOriginPaperDrawDate() {
        return originPaperDrawDate;
    }

    /**
     * set method 
     *
     * @param originPaperDrawDate  原蓝票的开票日期 YYYYMMDD
     */
    public void setOriginPaperDrawDate(String originPaperDrawDate) {
        this.originPaperDrawDate = originPaperDrawDate == null ? null : originPaperDrawDate.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.red_notification_no：红字信息表编号
     */
    public String getRedNotificationNo() {
        return redNotificationNo;
    }

    /**
     * set method 
     *
     * @param redNotificationNo  红字信息表编号
     */
    public void setRedNotificationNo(String redNotificationNo) {
        this.redNotificationNo = redNotificationNo == null ? null : redNotificationNo.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.red_notification_flag：红字信息编号申请状态 0-默认 1-发起申请 2-已申请
     */
    public Integer getRedNotificationFlag() {
        return redNotificationFlag;
    }

    /**
     * set method 
     *
     * @param redNotificationFlag  红字信息编号申请状态 0-默认 1-发起申请 2-已申请
     */
    public void setRedNotificationFlag(Integer redNotificationFlag) {
        this.redNotificationFlag = redNotificationFlag;
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.receive_user_email：接收方邮箱
     */
    public String getReceiveUserEmail() {
        return receiveUserEmail;
    }

    /**
     * set method 
     *
     * @param receiveUserEmail  接收方邮箱
     */
    public void setReceiveUserEmail(String receiveUserEmail) {
        this.receiveUserEmail = receiveUserEmail == null ? null : receiveUserEmail.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.receive_user_tel：接收方电话
     */
    public String getReceiveUserTel() {
        return receiveUserTel;
    }

    /**
     * set method 
     *
     * @param receiveUserTel  接收方电话
     */
    public void setReceiveUserTel(String receiveUserTel) {
        this.receiveUserTel = receiveUserTel == null ? null : receiveUserTel.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.invoice_signature：发票签名 用于抽取匹配
     */
    public String getInvoiceSignature() {
        return invoiceSignature;
    }

    /**
     * set method 
     *
     * @param invoiceSignature  发票签名 用于抽取匹配
     */
    public void setInvoiceSignature(String invoiceSignature) {
        this.invoiceSignature = invoiceSignature == null ? null : invoiceSignature.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.create_time：创建时间
     */
    public Date getCreateTime() {
        return createTime;
    }

    /**
     * set method 
     *
     * @param createTime  创建时间
     */
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.create_user_id：创建人id
     */
    public Long getCreateUserId() {
        return createUserId;
    }

    /**
     * set method 
     *
     * @param createUserId  创建人id
     */
    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.update_time：更新时间
     */
    public Date getUpdateTime() {
        return updateTime;
    }

    /**
     * set method 
     *
     * @param updateTime  更新时间
     */
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.update_user_id：更新用户id
     */
    public Long getUpdateUserId() {
        return updateUserId;
    }

    /**
     * set method 
     *
     * @param updateUserId  更新用户id
     */
    public void setUpdateUserId(Long updateUserId) {
        this.updateUserId = updateUserId;
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.source_line：来源产品线
     */
    public String getSourceLine() {
        return sourceLine;
    }

    /**
     * set method 
     *
     * @param sourceLine  来源产品线
     */
    public void setSourceLine(String sourceLine) {
        this.sourceLine = sourceLine == null ? null : sourceLine.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.ext1：扩展1
     */
    public String getExt1() {
        return ext1;
    }

    /**
     * set method 
     *
     * @param ext1  扩展1
     */
    public void setExt1(String ext1) {
        this.ext1 = ext1 == null ? null : ext1.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.ext2：扩展2
     */
    public String getExt2() {
        return ext2;
    }

    /**
     * set method 
     *
     * @param ext2  扩展2
     */
    public void setExt2(String ext2) {
        this.ext2 = ext2 == null ? null : ext2.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.ext3：扩展3
     */
    public String getExt3() {
        return ext3;
    }

    /**
     * set method 
     *
     * @param ext3  扩展3
     */
    public void setExt3(String ext3) {
        this.ext3 = ext3 == null ? null : ext3.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.ext4：扩展4
     */
    public String getExt4() {
        return ext4;
    }

    /**
     * set method 
     *
     * @param ext4  扩展4
     */
    public void setExt4(String ext4) {
        this.ext4 = ext4 == null ? null : ext4.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.ext5：扩展5
     */
    public String getExt5() {
        return ext5;
    }

    /**
     * set method 
     *
     * @param ext5  扩展5
     */
    public void setExt5(String ext5) {
        this.ext5 = ext5 == null ? null : ext5.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.ext6：扩展6
     */
    public String getExt6() {
        return ext6;
    }

    /**
     * set method 
     *
     * @param ext6  扩展6
     */
    public void setExt6(String ext6) {
        this.ext6 = ext6 == null ? null : ext6.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.ext7：扩展7
     */
    public String getExt7() {
        return ext7;
    }

    /**
     * set method 
     *
     * @param ext7  扩展7
     */
    public void setExt7(String ext7) {
        this.ext7 = ext7 == null ? null : ext7.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.ext8：扩展8
     */
    public String getExt8() {
        return ext8;
    }

    /**
     * set method 
     *
     * @param ext8  扩展8
     */
    public void setExt8(String ext8) {
        this.ext8 = ext8 == null ? null : ext8.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.ext9：扩展9
     */
    public String getExt9() {
        return ext9;
    }

    /**
     * set method 
     *
     * @param ext9  扩展9
     */
    public void setExt9(String ext9) {
        this.ext9 = ext9 == null ? null : ext9.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.ext10：扩展10
     */
    public String getExt10() {
        return ext10;
    }

    /**
     * set method 
     *
     * @param ext10  扩展10
     */
    public void setExt10(String ext10) {
        this.ext10 = ext10 == null ? null : ext10.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.ext11：扩展11
     */
    public String getExt11() {
        return ext11;
    }

    /**
     * set method 
     *
     * @param ext11  扩展11
     */
    public void setExt11(String ext11) {
        this.ext11 = ext11 == null ? null : ext11.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.ext12：扩展12
     */
    public String getExt12() {
        return ext12;
    }

    /**
     * set method 
     *
     * @param ext12  扩展12
     */
    public void setExt12(String ext12) {
        this.ext12 = ext12 == null ? null : ext12.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.ext13：扩展13
     */
    public String getExt13() {
        return ext13;
    }

    /**
     * set method 
     *
     * @param ext13  扩展13
     */
    public void setExt13(String ext13) {
        this.ext13 = ext13 == null ? null : ext13.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.ext14：扩展14
     */
    public String getExt14() {
        return ext14;
    }

    /**
     * set method 
     *
     * @param ext14  扩展14
     */
    public void setExt14(String ext14) {
        this.ext14 = ext14 == null ? null : ext14.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.ext15：扩展15
     */
    public String getExt15() {
        return ext15;
    }

    /**
     * set method 
     *
     * @param ext15  扩展15
     */
    public void setExt15(String ext15) {
        this.ext15 = ext15 == null ? null : ext15.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.ext16：扩展16
     */
    public String getExt16() {
        return ext16;
    }

    /**
     * set method 
     *
     * @param ext16  扩展16
     */
    public void setExt16(String ext16) {
        this.ext16 = ext16 == null ? null : ext16.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.ext17：扩展17
     */
    public String getExt17() {
        return ext17;
    }

    /**
     * set method 
     *
     * @param ext17  扩展17
     */
    public void setExt17(String ext17) {
        this.ext17 = ext17 == null ? null : ext17.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.ext18：扩展18
     */
    public String getExt18() {
        return ext18;
    }

    /**
     * set method 
     *
     * @param ext18  扩展18
     */
    public void setExt18(String ext18) {
        this.ext18 = ext18 == null ? null : ext18.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.ext19：扩展19
     */
    public String getExt19() {
        return ext19;
    }

    /**
     * set method 
     *
     * @param ext19  扩展19
     */
    public void setExt19(String ext19) {
        this.ext19 = ext19 == null ? null : ext19.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.ext20：扩展20
     */
    public String getExt20() {
        return ext20;
    }

    /**
     * set method 
     *
     * @param ext20  扩展20
     */
    public void setExt20(String ext20) {
        this.ext20 = ext20 == null ? null : ext20.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.ext21：扩展21
     */
    public String getExt21() {
        return ext21;
    }

    /**
     * set method 
     *
     * @param ext21  扩展21
     */
    public void setExt21(String ext21) {
        this.ext21 = ext21 == null ? null : ext21.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.ext22：扩展22
     */
    public String getExt22() {
        return ext22;
    }

    /**
     * set method 
     *
     * @param ext22  扩展22
     */
    public void setExt22(String ext22) {
        this.ext22 = ext22 == null ? null : ext22.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.ext23：扩展23
     */
    public String getExt23() {
        return ext23;
    }

    /**
     * set method 
     *
     * @param ext23  扩展23
     */
    public void setExt23(String ext23) {
        this.ext23 = ext23 == null ? null : ext23.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.ext24：扩展24
     */
    public String getExt24() {
        return ext24;
    }

    /**
     * set method 
     *
     * @param ext24  扩展24
     */
    public void setExt24(String ext24) {
        this.ext24 = ext24 == null ? null : ext24.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.ext25：扩展25
     */
    public String getExt25() {
        return ext25;
    }

    /**
     * set method 
     *
     * @param ext25  扩展25
     */
    public void setExt25(String ext25) {
        this.ext25 = ext25 == null ? null : ext25.trim();
    }

    /**
     * get method 
     *
     * @return ant_pre_invoice.red_reason：0:  init (初始状态，无红冲，默认值)  1:  sales_return (销货退回)   2:  making_error  (开票有误)      3:  taxable_service_end  (应税服务中止)    4:  sales_allowance  (发生销售折让)
     */
    public Integer getRedReason() {
        return redReason;
    }

    /**
     * set method 
     *
     * @param redReason  0:  init (初始状态，无红冲，默认值)  1:  sales_return (销货退回)   2:  making_error  (开票有误)      3:  taxable_service_end  (应税服务中止)    4:  sales_allowance  (发生销售折让)
     */
    public void setRedReason(Integer redReason) {
        this.redReason = redReason;
    }

    /**
     *
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", externalId=").append(externalId);
        sb.append(", batchNo=").append(batchNo);
        sb.append(", outBatchNo=").append(outBatchNo);
        sb.append(", salesbillNo=").append(salesbillNo);
        sb.append(", customerNo=").append(customerNo);
        sb.append(", systemOrig=").append(systemOrig);
        sb.append(", purchaserTenantId=").append(purchaserTenantId);
        sb.append(", purchaserId=").append(purchaserId);
        sb.append(", purchaserNo=").append(purchaserNo);
        sb.append(", purchaserName=").append(purchaserName);
        sb.append(", purchaserTaxNo=").append(purchaserTaxNo);
        sb.append(", purchaserTel=").append(purchaserTel);
        sb.append(", purchaserAddress=").append(purchaserAddress);
        sb.append(", purchaserBankName=").append(purchaserBankName);
        sb.append(", purchaserBankAccount=").append(purchaserBankAccount);
        sb.append(", sellerTenantId=").append(sellerTenantId);
        sb.append(", sellerNo=").append(sellerNo);
        sb.append(", sellerTaxNo=").append(sellerTaxNo);
        sb.append(", sellerName=").append(sellerName);
        sb.append(", sellerTel=").append(sellerTel);
        sb.append(", sellerAddress=").append(sellerAddress);
        sb.append(", sellerBankName=").append(sellerBankName);
        sb.append(", sellerBankAccount=").append(sellerBankAccount);
        sb.append(", sellerId=").append(sellerId);
        sb.append(", invoiceType=").append(invoiceType);
        sb.append(", taxInvoiceSource=").append(taxInvoiceSource);
        sb.append(", invoiceKind=").append(invoiceKind);
        sb.append(", businessBillType=").append(businessBillType);
        sb.append(", salesbillType=").append(salesbillType);
        sb.append(", invoiceNo=").append(invoiceNo);
        sb.append(", invoiceCode=").append(invoiceCode);
        sb.append(", paperDrawDate=").append(paperDrawDate);
        sb.append(", machineCode=").append(machineCode);
        sb.append(", checkCode=").append(checkCode);
        sb.append(", amountWithoutTax=").append(amountWithoutTax);
        sb.append(", taxAmount=").append(taxAmount);
        sb.append(", amountWithTax=").append(amountWithTax);
        sb.append(", taxRate=").append(taxRate);
        sb.append(", remark=").append(remark);
        sb.append(", extRemark=").append(extRemark);
        sb.append(", cashierName=").append(cashierName);
        sb.append(", checkerName=").append(checkerName);
        sb.append(", invoicerName=").append(invoicerName);
        sb.append(", electronicSignature=").append(electronicSignature);
        sb.append(", status=").append(status);
        sb.append(", processRemark=").append(processRemark);
        sb.append(", isLock=").append(isLock);
        sb.append(", ruleId=").append(ruleId);
        sb.append(", sysOrgId=").append(sysOrgId);
        sb.append(", originInvoiceNo=").append(originInvoiceNo);
        sb.append(", originInvoiceCode=").append(originInvoiceCode);
        sb.append(", originInvoiceType=").append(originInvoiceType);
        sb.append(", originPaperDrawDate=").append(originPaperDrawDate);
        sb.append(", redNotificationNo=").append(redNotificationNo);
        sb.append(", redNotificationFlag=").append(redNotificationFlag);
        sb.append(", receiveUserEmail=").append(receiveUserEmail);
        sb.append(", receiveUserTel=").append(receiveUserTel);
        sb.append(", invoiceSignature=").append(invoiceSignature);
        sb.append(", createTime=").append(createTime);
        sb.append(", createUserId=").append(createUserId);
        sb.append(", updateTime=").append(updateTime);
        sb.append(", updateUserId=").append(updateUserId);
        sb.append(", sourceLine=").append(sourceLine);
        sb.append(", ext1=").append(ext1);
        sb.append(", ext2=").append(ext2);
        sb.append(", ext3=").append(ext3);
        sb.append(", ext4=").append(ext4);
        sb.append(", ext5=").append(ext5);
        sb.append(", ext6=").append(ext6);
        sb.append(", ext7=").append(ext7);
        sb.append(", ext8=").append(ext8);
        sb.append(", ext9=").append(ext9);
        sb.append(", ext10=").append(ext10);
        sb.append(", ext11=").append(ext11);
        sb.append(", ext12=").append(ext12);
        sb.append(", ext13=").append(ext13);
        sb.append(", ext14=").append(ext14);
        sb.append(", ext15=").append(ext15);
        sb.append(", ext16=").append(ext16);
        sb.append(", ext17=").append(ext17);
        sb.append(", ext18=").append(ext18);
        sb.append(", ext19=").append(ext19);
        sb.append(", ext20=").append(ext20);
        sb.append(", ext21=").append(ext21);
        sb.append(", ext22=").append(ext22);
        sb.append(", ext23=").append(ext23);
        sb.append(", ext24=").append(ext24);
        sb.append(", ext25=").append(ext25);
        sb.append(", redReason=").append(redReason);
        sb.append("]");
        return sb.toString();
    }

    /**
     *
     * @param that
     */
    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        MixPreInvoiceEntity other = (MixPreInvoiceEntity) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getExternalId() == null ? other.getExternalId() == null : this.getExternalId().equals(other.getExternalId()))
            && (this.getBatchNo() == null ? other.getBatchNo() == null : this.getBatchNo().equals(other.getBatchNo()))
            && (this.getOutBatchNo() == null ? other.getOutBatchNo() == null : this.getOutBatchNo().equals(other.getOutBatchNo()))
            && (this.getSalesbillNo() == null ? other.getSalesbillNo() == null : this.getSalesbillNo().equals(other.getSalesbillNo()))
            && (this.getCustomerNo() == null ? other.getCustomerNo() == null : this.getCustomerNo().equals(other.getCustomerNo()))
            && (this.getSystemOrig() == null ? other.getSystemOrig() == null : this.getSystemOrig().equals(other.getSystemOrig()))
            && (this.getPurchaserTenantId() == null ? other.getPurchaserTenantId() == null : this.getPurchaserTenantId().equals(other.getPurchaserTenantId()))
            && (this.getPurchaserId() == null ? other.getPurchaserId() == null : this.getPurchaserId().equals(other.getPurchaserId()))
            && (this.getPurchaserNo() == null ? other.getPurchaserNo() == null : this.getPurchaserNo().equals(other.getPurchaserNo()))
            && (this.getPurchaserName() == null ? other.getPurchaserName() == null : this.getPurchaserName().equals(other.getPurchaserName()))
            && (this.getPurchaserTaxNo() == null ? other.getPurchaserTaxNo() == null : this.getPurchaserTaxNo().equals(other.getPurchaserTaxNo()))
            && (this.getPurchaserTel() == null ? other.getPurchaserTel() == null : this.getPurchaserTel().equals(other.getPurchaserTel()))
            && (this.getPurchaserAddress() == null ? other.getPurchaserAddress() == null : this.getPurchaserAddress().equals(other.getPurchaserAddress()))
            && (this.getPurchaserBankName() == null ? other.getPurchaserBankName() == null : this.getPurchaserBankName().equals(other.getPurchaserBankName()))
            && (this.getPurchaserBankAccount() == null ? other.getPurchaserBankAccount() == null : this.getPurchaserBankAccount().equals(other.getPurchaserBankAccount()))
            && (this.getSellerTenantId() == null ? other.getSellerTenantId() == null : this.getSellerTenantId().equals(other.getSellerTenantId()))
            && (this.getSellerNo() == null ? other.getSellerNo() == null : this.getSellerNo().equals(other.getSellerNo()))
            && (this.getSellerTaxNo() == null ? other.getSellerTaxNo() == null : this.getSellerTaxNo().equals(other.getSellerTaxNo()))
            && (this.getSellerName() == null ? other.getSellerName() == null : this.getSellerName().equals(other.getSellerName()))
            && (this.getSellerTel() == null ? other.getSellerTel() == null : this.getSellerTel().equals(other.getSellerTel()))
            && (this.getSellerAddress() == null ? other.getSellerAddress() == null : this.getSellerAddress().equals(other.getSellerAddress()))
            && (this.getSellerBankName() == null ? other.getSellerBankName() == null : this.getSellerBankName().equals(other.getSellerBankName()))
            && (this.getSellerBankAccount() == null ? other.getSellerBankAccount() == null : this.getSellerBankAccount().equals(other.getSellerBankAccount()))
            && (this.getSellerId() == null ? other.getSellerId() == null : this.getSellerId().equals(other.getSellerId()))
            && (this.getInvoiceType() == null ? other.getInvoiceType() == null : this.getInvoiceType().equals(other.getInvoiceType()))
            && (this.getTaxInvoiceSource() == null ? other.getTaxInvoiceSource() == null : this.getTaxInvoiceSource().equals(other.getTaxInvoiceSource()))
            && (this.getInvoiceKind() == null ? other.getInvoiceKind() == null : this.getInvoiceKind().equals(other.getInvoiceKind()))
            && (this.getBusinessBillType() == null ? other.getBusinessBillType() == null : this.getBusinessBillType().equals(other.getBusinessBillType()))
            && (this.getSalesbillType() == null ? other.getSalesbillType() == null : this.getSalesbillType().equals(other.getSalesbillType()))
            && (this.getInvoiceNo() == null ? other.getInvoiceNo() == null : this.getInvoiceNo().equals(other.getInvoiceNo()))
            && (this.getInvoiceCode() == null ? other.getInvoiceCode() == null : this.getInvoiceCode().equals(other.getInvoiceCode()))
            && (this.getPaperDrawDate() == null ? other.getPaperDrawDate() == null : this.getPaperDrawDate().equals(other.getPaperDrawDate()))
            && (this.getMachineCode() == null ? other.getMachineCode() == null : this.getMachineCode().equals(other.getMachineCode()))
            && (this.getCheckCode() == null ? other.getCheckCode() == null : this.getCheckCode().equals(other.getCheckCode()))
            && (this.getAmountWithoutTax() == null ? other.getAmountWithoutTax() == null : this.getAmountWithoutTax().equals(other.getAmountWithoutTax()))
            && (this.getTaxAmount() == null ? other.getTaxAmount() == null : this.getTaxAmount().equals(other.getTaxAmount()))
            && (this.getAmountWithTax() == null ? other.getAmountWithTax() == null : this.getAmountWithTax().equals(other.getAmountWithTax()))
            && (this.getTaxRate() == null ? other.getTaxRate() == null : this.getTaxRate().equals(other.getTaxRate()))
            && (this.getRemark() == null ? other.getRemark() == null : this.getRemark().equals(other.getRemark()))
            && (this.getExtRemark() == null ? other.getExtRemark() == null : this.getExtRemark().equals(other.getExtRemark()))
            && (this.getCashierName() == null ? other.getCashierName() == null : this.getCashierName().equals(other.getCashierName()))
            && (this.getCheckerName() == null ? other.getCheckerName() == null : this.getCheckerName().equals(other.getCheckerName()))
            && (this.getInvoicerName() == null ? other.getInvoicerName() == null : this.getInvoicerName().equals(other.getInvoicerName()))
            && (this.getElectronicSignature() == null ? other.getElectronicSignature() == null : this.getElectronicSignature().equals(other.getElectronicSignature()))
            && (this.getStatus() == null ? other.getStatus() == null : this.getStatus().equals(other.getStatus()))
            && (this.getProcessRemark() == null ? other.getProcessRemark() == null : this.getProcessRemark().equals(other.getProcessRemark()))
            && (this.getIsLock() == null ? other.getIsLock() == null : this.getIsLock().equals(other.getIsLock()))
            && (this.getRuleId() == null ? other.getRuleId() == null : this.getRuleId().equals(other.getRuleId()))
            && (this.getSysOrgId() == null ? other.getSysOrgId() == null : this.getSysOrgId().equals(other.getSysOrgId()))
            && (this.getOriginInvoiceNo() == null ? other.getOriginInvoiceNo() == null : this.getOriginInvoiceNo().equals(other.getOriginInvoiceNo()))
            && (this.getOriginInvoiceCode() == null ? other.getOriginInvoiceCode() == null : this.getOriginInvoiceCode().equals(other.getOriginInvoiceCode()))
            && (this.getOriginInvoiceType() == null ? other.getOriginInvoiceType() == null : this.getOriginInvoiceType().equals(other.getOriginInvoiceType()))
            && (this.getOriginPaperDrawDate() == null ? other.getOriginPaperDrawDate() == null : this.getOriginPaperDrawDate().equals(other.getOriginPaperDrawDate()))
            && (this.getRedNotificationNo() == null ? other.getRedNotificationNo() == null : this.getRedNotificationNo().equals(other.getRedNotificationNo()))
            && (this.getRedNotificationFlag() == null ? other.getRedNotificationFlag() == null : this.getRedNotificationFlag().equals(other.getRedNotificationFlag()))
            && (this.getReceiveUserEmail() == null ? other.getReceiveUserEmail() == null : this.getReceiveUserEmail().equals(other.getReceiveUserEmail()))
            && (this.getReceiveUserTel() == null ? other.getReceiveUserTel() == null : this.getReceiveUserTel().equals(other.getReceiveUserTel()))
            && (this.getInvoiceSignature() == null ? other.getInvoiceSignature() == null : this.getInvoiceSignature().equals(other.getInvoiceSignature()))
            && (this.getCreateTime() == null ? other.getCreateTime() == null : this.getCreateTime().equals(other.getCreateTime()))
            && (this.getCreateUserId() == null ? other.getCreateUserId() == null : this.getCreateUserId().equals(other.getCreateUserId()))
            && (this.getUpdateTime() == null ? other.getUpdateTime() == null : this.getUpdateTime().equals(other.getUpdateTime()))
            && (this.getUpdateUserId() == null ? other.getUpdateUserId() == null : this.getUpdateUserId().equals(other.getUpdateUserId()))
            && (this.getSourceLine() == null ? other.getSourceLine() == null : this.getSourceLine().equals(other.getSourceLine()))
            && (this.getExt1() == null ? other.getExt1() == null : this.getExt1().equals(other.getExt1()))
            && (this.getExt2() == null ? other.getExt2() == null : this.getExt2().equals(other.getExt2()))
            && (this.getExt3() == null ? other.getExt3() == null : this.getExt3().equals(other.getExt3()))
            && (this.getExt4() == null ? other.getExt4() == null : this.getExt4().equals(other.getExt4()))
            && (this.getExt5() == null ? other.getExt5() == null : this.getExt5().equals(other.getExt5()))
            && (this.getExt6() == null ? other.getExt6() == null : this.getExt6().equals(other.getExt6()))
            && (this.getExt7() == null ? other.getExt7() == null : this.getExt7().equals(other.getExt7()))
            && (this.getExt8() == null ? other.getExt8() == null : this.getExt8().equals(other.getExt8()))
            && (this.getExt9() == null ? other.getExt9() == null : this.getExt9().equals(other.getExt9()))
            && (this.getExt10() == null ? other.getExt10() == null : this.getExt10().equals(other.getExt10()))
            && (this.getExt11() == null ? other.getExt11() == null : this.getExt11().equals(other.getExt11()))
            && (this.getExt12() == null ? other.getExt12() == null : this.getExt12().equals(other.getExt12()))
            && (this.getExt13() == null ? other.getExt13() == null : this.getExt13().equals(other.getExt13()))
            && (this.getExt14() == null ? other.getExt14() == null : this.getExt14().equals(other.getExt14()))
            && (this.getExt15() == null ? other.getExt15() == null : this.getExt15().equals(other.getExt15()))
            && (this.getExt16() == null ? other.getExt16() == null : this.getExt16().equals(other.getExt16()))
            && (this.getExt17() == null ? other.getExt17() == null : this.getExt17().equals(other.getExt17()))
            && (this.getExt18() == null ? other.getExt18() == null : this.getExt18().equals(other.getExt18()))
            && (this.getExt19() == null ? other.getExt19() == null : this.getExt19().equals(other.getExt19()))
            && (this.getExt20() == null ? other.getExt20() == null : this.getExt20().equals(other.getExt20()))
            && (this.getExt21() == null ? other.getExt21() == null : this.getExt21().equals(other.getExt21()))
            && (this.getExt22() == null ? other.getExt22() == null : this.getExt22().equals(other.getExt22()))
            && (this.getExt23() == null ? other.getExt23() == null : this.getExt23().equals(other.getExt23()))
            && (this.getExt24() == null ? other.getExt24() == null : this.getExt24().equals(other.getExt24()))
            && (this.getExt25() == null ? other.getExt25() == null : this.getExt25().equals(other.getExt25()))
            && (this.getRedReason() == null ? other.getRedReason() == null : this.getRedReason().equals(other.getRedReason()));
    }

    /**
     *
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getExternalId() == null) ? 0 : getExternalId().hashCode());
        result = prime * result + ((getBatchNo() == null) ? 0 : getBatchNo().hashCode());
        result = prime * result + ((getOutBatchNo() == null) ? 0 : getOutBatchNo().hashCode());
        result = prime * result + ((getSalesbillNo() == null) ? 0 : getSalesbillNo().hashCode());
        result = prime * result + ((getCustomerNo() == null) ? 0 : getCustomerNo().hashCode());
        result = prime * result + ((getSystemOrig() == null) ? 0 : getSystemOrig().hashCode());
        result = prime * result + ((getPurchaserTenantId() == null) ? 0 : getPurchaserTenantId().hashCode());
        result = prime * result + ((getPurchaserId() == null) ? 0 : getPurchaserId().hashCode());
        result = prime * result + ((getPurchaserNo() == null) ? 0 : getPurchaserNo().hashCode());
        result = prime * result + ((getPurchaserName() == null) ? 0 : getPurchaserName().hashCode());
        result = prime * result + ((getPurchaserTaxNo() == null) ? 0 : getPurchaserTaxNo().hashCode());
        result = prime * result + ((getPurchaserTel() == null) ? 0 : getPurchaserTel().hashCode());
        result = prime * result + ((getPurchaserAddress() == null) ? 0 : getPurchaserAddress().hashCode());
        result = prime * result + ((getPurchaserBankName() == null) ? 0 : getPurchaserBankName().hashCode());
        result = prime * result + ((getPurchaserBankAccount() == null) ? 0 : getPurchaserBankAccount().hashCode());
        result = prime * result + ((getSellerTenantId() == null) ? 0 : getSellerTenantId().hashCode());
        result = prime * result + ((getSellerNo() == null) ? 0 : getSellerNo().hashCode());
        result = prime * result + ((getSellerTaxNo() == null) ? 0 : getSellerTaxNo().hashCode());
        result = prime * result + ((getSellerName() == null) ? 0 : getSellerName().hashCode());
        result = prime * result + ((getSellerTel() == null) ? 0 : getSellerTel().hashCode());
        result = prime * result + ((getSellerAddress() == null) ? 0 : getSellerAddress().hashCode());
        result = prime * result + ((getSellerBankName() == null) ? 0 : getSellerBankName().hashCode());
        result = prime * result + ((getSellerBankAccount() == null) ? 0 : getSellerBankAccount().hashCode());
        result = prime * result + ((getSellerId() == null) ? 0 : getSellerId().hashCode());
        result = prime * result + ((getInvoiceType() == null) ? 0 : getInvoiceType().hashCode());
        result = prime * result + ((getTaxInvoiceSource() == null) ? 0 : getTaxInvoiceSource().hashCode());
        result = prime * result + ((getInvoiceKind() == null) ? 0 : getInvoiceKind().hashCode());
        result = prime * result + ((getBusinessBillType() == null) ? 0 : getBusinessBillType().hashCode());
        result = prime * result + ((getSalesbillType() == null) ? 0 : getSalesbillType().hashCode());
        result = prime * result + ((getInvoiceNo() == null) ? 0 : getInvoiceNo().hashCode());
        result = prime * result + ((getInvoiceCode() == null) ? 0 : getInvoiceCode().hashCode());
        result = prime * result + ((getPaperDrawDate() == null) ? 0 : getPaperDrawDate().hashCode());
        result = prime * result + ((getMachineCode() == null) ? 0 : getMachineCode().hashCode());
        result = prime * result + ((getCheckCode() == null) ? 0 : getCheckCode().hashCode());
        result = prime * result + ((getAmountWithoutTax() == null) ? 0 : getAmountWithoutTax().hashCode());
        result = prime * result + ((getTaxAmount() == null) ? 0 : getTaxAmount().hashCode());
        result = prime * result + ((getAmountWithTax() == null) ? 0 : getAmountWithTax().hashCode());
        result = prime * result + ((getTaxRate() == null) ? 0 : getTaxRate().hashCode());
        result = prime * result + ((getRemark() == null) ? 0 : getRemark().hashCode());
        result = prime * result + ((getExtRemark() == null) ? 0 : getExtRemark().hashCode());
        result = prime * result + ((getCashierName() == null) ? 0 : getCashierName().hashCode());
        result = prime * result + ((getCheckerName() == null) ? 0 : getCheckerName().hashCode());
        result = prime * result + ((getInvoicerName() == null) ? 0 : getInvoicerName().hashCode());
        result = prime * result + ((getElectronicSignature() == null) ? 0 : getElectronicSignature().hashCode());
        result = prime * result + ((getStatus() == null) ? 0 : getStatus().hashCode());
        result = prime * result + ((getProcessRemark() == null) ? 0 : getProcessRemark().hashCode());
        result = prime * result + ((getIsLock() == null) ? 0 : getIsLock().hashCode());
        result = prime * result + ((getRuleId() == null) ? 0 : getRuleId().hashCode());
        result = prime * result + ((getSysOrgId() == null) ? 0 : getSysOrgId().hashCode());
        result = prime * result + ((getOriginInvoiceNo() == null) ? 0 : getOriginInvoiceNo().hashCode());
        result = prime * result + ((getOriginInvoiceCode() == null) ? 0 : getOriginInvoiceCode().hashCode());
        result = prime * result + ((getOriginInvoiceType() == null) ? 0 : getOriginInvoiceType().hashCode());
        result = prime * result + ((getOriginPaperDrawDate() == null) ? 0 : getOriginPaperDrawDate().hashCode());
        result = prime * result + ((getRedNotificationNo() == null) ? 0 : getRedNotificationNo().hashCode());
        result = prime * result + ((getRedNotificationFlag() == null) ? 0 : getRedNotificationFlag().hashCode());
        result = prime * result + ((getReceiveUserEmail() == null) ? 0 : getReceiveUserEmail().hashCode());
        result = prime * result + ((getReceiveUserTel() == null) ? 0 : getReceiveUserTel().hashCode());
        result = prime * result + ((getInvoiceSignature() == null) ? 0 : getInvoiceSignature().hashCode());
        result = prime * result + ((getCreateTime() == null) ? 0 : getCreateTime().hashCode());
        result = prime * result + ((getCreateUserId() == null) ? 0 : getCreateUserId().hashCode());
        result = prime * result + ((getUpdateTime() == null) ? 0 : getUpdateTime().hashCode());
        result = prime * result + ((getUpdateUserId() == null) ? 0 : getUpdateUserId().hashCode());
        result = prime * result + ((getSourceLine() == null) ? 0 : getSourceLine().hashCode());
        result = prime * result + ((getExt1() == null) ? 0 : getExt1().hashCode());
        result = prime * result + ((getExt2() == null) ? 0 : getExt2().hashCode());
        result = prime * result + ((getExt3() == null) ? 0 : getExt3().hashCode());
        result = prime * result + ((getExt4() == null) ? 0 : getExt4().hashCode());
        result = prime * result + ((getExt5() == null) ? 0 : getExt5().hashCode());
        result = prime * result + ((getExt6() == null) ? 0 : getExt6().hashCode());
        result = prime * result + ((getExt7() == null) ? 0 : getExt7().hashCode());
        result = prime * result + ((getExt8() == null) ? 0 : getExt8().hashCode());
        result = prime * result + ((getExt9() == null) ? 0 : getExt9().hashCode());
        result = prime * result + ((getExt10() == null) ? 0 : getExt10().hashCode());
        result = prime * result + ((getExt11() == null) ? 0 : getExt11().hashCode());
        result = prime * result + ((getExt12() == null) ? 0 : getExt12().hashCode());
        result = prime * result + ((getExt13() == null) ? 0 : getExt13().hashCode());
        result = prime * result + ((getExt14() == null) ? 0 : getExt14().hashCode());
        result = prime * result + ((getExt15() == null) ? 0 : getExt15().hashCode());
        result = prime * result + ((getExt16() == null) ? 0 : getExt16().hashCode());
        result = prime * result + ((getExt17() == null) ? 0 : getExt17().hashCode());
        result = prime * result + ((getExt18() == null) ? 0 : getExt18().hashCode());
        result = prime * result + ((getExt19() == null) ? 0 : getExt19().hashCode());
        result = prime * result + ((getExt20() == null) ? 0 : getExt20().hashCode());
        result = prime * result + ((getExt21() == null) ? 0 : getExt21().hashCode());
        result = prime * result + ((getExt22() == null) ? 0 : getExt22().hashCode());
        result = prime * result + ((getExt23() == null) ? 0 : getExt23().hashCode());
        result = prime * result + ((getExt24() == null) ? 0 : getExt24().hashCode());
        result = prime * result + ((getExt25() == null) ? 0 : getExt25().hashCode());
        result = prime * result + ((getRedReason() == null) ? 0 : getRedReason().hashCode());
        return result;
    }
}