package com.xforceplus.coop.mix.model;


import java.math.BigDecimal;
import java.util.Date;

public class MixPreInvoiceItemEntity extends MixBaseEntity {
    /**
     * 预制发票id
     * 表 : ant_pre_invoice_item
     * 对应字段 : pre_invoice_id
     */
    private Long preInvoiceId;

    /**
     * 税收分类编码
     * 表 : ant_pre_invoice_item
     * 对应字段 : goods_tax_no
     */
    private String goodsTaxNo;

    /**
     * 货物或应税劳务名称
     * 表 : ant_pre_invoice_item
     * 对应字段 : cargo_name
     */
    private String cargoName;

    /**
     * 货物或应税劳务代码
     * 表 : ant_pre_invoice_item
     * 对应字段 : cargo_code
     */
    private String cargoCode;

    /**
     * 规格型号
     * 表 : ant_pre_invoice_item
     * 对应字段 : item_spec
     */
    private String itemSpec;

    /**
     * 单价不含税
     * 表 : ant_pre_invoice_item
     * 对应字段 : unit_price
     */
    private BigDecimal unitPrice;

    /**
     * 数量
     * 表 : ant_pre_invoice_item
     * 对应字段 : quantity
     */
    private BigDecimal quantity;

    /**
     * 单位
     * 表 : ant_pre_invoice_item
     * 对应字段 : quantity_unit
     */
    private String quantityUnit;

    /**
     * 税率
     * 表 : ant_pre_invoice_item
     * 对应字段 : tax_rate
     */
    private BigDecimal taxRate;

    /**
     * 不含税金额
     * 表 : ant_pre_invoice_item
     * 对应字段 : amount_without_tax
     */
    private BigDecimal amountWithoutTax;

    /**
     * 税额
     * 表 : ant_pre_invoice_item
     * 对应字段 : tax_amount
     */
    private BigDecimal taxAmount;

    /**
     * 含税金额
     * 表 : ant_pre_invoice_item
     * 对应字段 : amount_with_tax
     */
    private BigDecimal amountWithTax;

    /**
     * 折扣率
     * 表 : ant_pre_invoice_item
     * 对应字段 : discount_rate
     */
    private BigDecimal discountRate;

    /**
     * 折扣不含税金额
     * 表 : ant_pre_invoice_item
     * 对应字段 : discount_without_tax
     */
    private BigDecimal discountWithoutTax;

    /**
     * 折扣含税金额
     * 表 : ant_pre_invoice_item
     * 对应字段 : discount_with_tax
     */
    private BigDecimal discountWithTax;

    /**
     * 折扣税额
     * 表 : ant_pre_invoice_item
     * 对应字段 : discount_tax
     */
    private BigDecimal discountTax;

    /**
     * 浮动金额(调整的容差金额)
     * 表 : ant_pre_invoice_item
     * 对应字段 : floating_amount
     */
    private BigDecimal floatingAmount;

    /**
     * 商品税目
     * 表 : ant_pre_invoice_item
     * 对应字段 : tax_item
     */
    private String taxItem;

    /**
     * 编码版本号
     * 表 : ant_pre_invoice_item
     * 对应字段 : goods_no_ver
     */
    private String goodsNoVer;

    /**
     * 是否享受税收优惠政策
     * 表 : ant_pre_invoice_item
     * 对应字段 : tax_pre
     */
    private String taxPre;

    /**
     * 是否享受税收优惠政策内容
     * 表 : ant_pre_invoice_item
     * 对应字段 : tax_pre_con
     */
    private String taxPreCon;

    /**
     * 零税率标识
     * 表 : ant_pre_invoice_item
     * 对应字段 : zero_tax
     */
    private String zeroTax;

    /**
     * 扣除额
     * 表 : ant_pre_invoice_item
     * 对应字段 : deduction
     */
    private BigDecimal deduction;

    /**
     * 扣除行标记
     * 表 : ant_pre_invoice_item
     * 对应字段 : discount_flag
     */
    private String discountFlag;

    /**
     * 价格方式
     * 表 : ant_pre_invoice_item
     * 对应字段 : price_method
     */
    private String priceMethod;

    /**
     * 是否打印单价数量
     * 表 : ant_pre_invoice_item
     * 对应字段 : print_content_flag
     */
    private String printContentFlag;

    /**
     * 分类码
     * 表 : ant_pre_invoice_item
     * 对应字段 : item_type_code
     */
    private String itemTypeCode;

    /**
     * 创建时间
     * 表 : ant_pre_invoice_item
     * 对应字段 : create_time
     */
    private Date createTime;

    /**
     * 创建用户id
     * 表 : ant_pre_invoice_item
     * 对应字段 : create_user_id
     */
    private Long createUserId;

    /**
     * 更新时间
     * 表 : ant_pre_invoice_item
     * 对应字段 : update_time
     */
    private Date updateTime;

    /**
     * 更新用户id
     * 表 : ant_pre_invoice_item
     * 对应字段 : update_user_id
     */
    private Long updateUserId;

    /**
     * 扩展1
     * 表 : ant_pre_invoice_item
     * 对应字段 : ext1
     */
    private String ext1;

    /**
     * 扩展2
     * 表 : ant_pre_invoice_item
     * 对应字段 : ext2
     */
    private String ext2;

    /**
     * 扩展3
     * 表 : ant_pre_invoice_item
     * 对应字段 : ext3
     */
    private String ext3;

    /**
     * 扩展4
     * 表 : ant_pre_invoice_item
     * 对应字段 : ext4
     */
    private String ext4;

    /**
     * 扩展5
     * 表 : ant_pre_invoice_item
     * 对应字段 : ext5
     */
    private String ext5;

    /**
     * 扩展6
     * 表 : ant_pre_invoice_item
     * 对应字段 : ext6
     */
    private String ext6;

    /**
     * 扩展7
     * 表 : ant_pre_invoice_item
     * 对应字段 : ext7
     */
    private String ext7;

    /**
     * 扩展8
     * 表 : ant_pre_invoice_item
     * 对应字段 : ext8
     */
    private String ext8;

    /**
     * 扩展9
     * 表 : ant_pre_invoice_item
     * 对应字段 : ext9
     */
    private String ext9;

    /**
     * 扩展10
     * 表 : ant_pre_invoice_item
     * 对应字段 : ext10
     */
    private String ext10;

    /**
     * 扩展11
     * 表 : ant_pre_invoice_item
     * 对应字段 : ext11
     */
    private String ext11;

    /**
     * 扩展12
     * 表 : ant_pre_invoice_item
     * 对应字段 : ext12
     */
    private String ext12;

    /**
     * 扩展13
     * 表 : ant_pre_invoice_item
     * 对应字段 : ext13
     */
    private String ext13;

    /**
     * 扩展14
     * 表 : ant_pre_invoice_item
     * 对应字段 : ext14
     */
    private String ext14;

    /**
     * 扩展15
     * 表 : ant_pre_invoice_item
     * 对应字段 : ext15
     */
    private String ext15;

    /**
     * 扩展16
     * 表 : ant_pre_invoice_item
     * 对应字段 : ext16
     */
    private String ext16;

    /**
     * 扩展17
     * 表 : ant_pre_invoice_item
     * 对应字段 : ext17
     */
    private String ext17;

    /**
     * 扩展18
     * 表 : ant_pre_invoice_item
     * 对应字段 : ext18
     */
    private String ext18;

    /**
     * 扩展19
     * 表 : ant_pre_invoice_item
     * 对应字段 : ext19
     */
    private String ext19;

    /**
     * 扩展20
     * 表 : ant_pre_invoice_item
     * 对应字段 : ext20
     */
    private String ext20;

    /**
     * get method
     *
     * @return ant_pre_invoice_item.pre_invoice_id：预制发票id
     */
    public Long getPreInvoiceId() {
        return preInvoiceId;
    }

    /**
     * set method
     *
     * @param preInvoiceId 预制发票id
     */
    public void setPreInvoiceId(Long preInvoiceId) {
        this.preInvoiceId = preInvoiceId;
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.goods_tax_no：税收分类编码
     */
    public String getGoodsTaxNo() {
        return goodsTaxNo;
    }

    /**
     * set method
     *
     * @param goodsTaxNo 税收分类编码
     */
    public void setGoodsTaxNo(String goodsTaxNo) {
        this.goodsTaxNo = goodsTaxNo == null ? null : goodsTaxNo.trim();
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.cargo_name：货物或应税劳务名称
     */
    public String getCargoName() {
        return cargoName;
    }

    /**
     * set method
     *
     * @param cargoName 货物或应税劳务名称
     */
    public void setCargoName(String cargoName) {
        this.cargoName = cargoName == null ? null : cargoName.trim();
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.cargo_code：货物或应税劳务代码
     */
    public String getCargoCode() {
        return cargoCode;
    }

    /**
     * set method
     *
     * @param cargoCode 货物或应税劳务代码
     */
    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode == null ? null : cargoCode.trim();
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.item_spec：规格型号
     */
    public String getItemSpec() {
        return itemSpec;
    }

    /**
     * set method
     *
     * @param itemSpec 规格型号
     */
    public void setItemSpec(String itemSpec) {
        this.itemSpec = itemSpec == null ? null : itemSpec.trim();
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.unit_price：单价不含税
     */
    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    /**
     * set method
     *
     * @param unitPrice 单价不含税
     */
    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.quantity：数量
     */
    public BigDecimal getQuantity() {
        return quantity;
    }

    /**
     * set method
     *
     * @param quantity 数量
     */
    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.quantity_unit：单位
     */
    public String getQuantityUnit() {
        return quantityUnit;
    }

    /**
     * set method
     *
     * @param quantityUnit 单位
     */
    public void setQuantityUnit(String quantityUnit) {
        this.quantityUnit = quantityUnit == null ? null : quantityUnit.trim();
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.tax_rate：税率
     */
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * set method
     *
     * @param taxRate 税率
     */
    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.amount_without_tax：不含税金额
     */
    public BigDecimal getAmountWithoutTax() {
        return amountWithoutTax;
    }

    /**
     * set method
     *
     * @param amountWithoutTax 不含税金额
     */
    public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.tax_amount：税额
     */
    public BigDecimal getTaxAmount() {
        return taxAmount;
    }

    /**
     * set method
     *
     * @param taxAmount 税额
     */
    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.amount_with_tax：含税金额
     */
    public BigDecimal getAmountWithTax() {
        return amountWithTax;
    }

    /**
     * set method
     *
     * @param amountWithTax 含税金额
     */
    public void setAmountWithTax(BigDecimal amountWithTax) {
        this.amountWithTax = amountWithTax;
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.discount_rate：折扣率
     */
    public BigDecimal getDiscountRate() {
        return discountRate;
    }

    /**
     * set method
     *
     * @param discountRate 折扣率
     */
    public void setDiscountRate(BigDecimal discountRate) {
        this.discountRate = discountRate;
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.discount_without_tax：折扣不含税金额
     */
    public BigDecimal getDiscountWithoutTax() {
        return discountWithoutTax;
    }

    /**
     * set method
     *
     * @param discountWithoutTax 折扣不含税金额
     */
    public void setDiscountWithoutTax(BigDecimal discountWithoutTax) {
        this.discountWithoutTax = discountWithoutTax;
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.discount_with_tax：折扣含税金额
     */
    public BigDecimal getDiscountWithTax() {
        return discountWithTax;
    }

    /**
     * set method
     *
     * @param discountWithTax 折扣含税金额
     */
    public void setDiscountWithTax(BigDecimal discountWithTax) {
        this.discountWithTax = discountWithTax;
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.discount_tax：折扣税额
     */
    public BigDecimal getDiscountTax() {
        return discountTax;
    }

    /**
     * set method
     *
     * @param discountTax 折扣税额
     */
    public void setDiscountTax(BigDecimal discountTax) {
        this.discountTax = discountTax;
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.floating_amount：浮动金额(调整的容差金额)
     */
    public BigDecimal getFloatingAmount() {
        return floatingAmount;
    }

    /**
     * set method
     *
     * @param floatingAmount 浮动金额(调整的容差金额)
     */
    public void setFloatingAmount(BigDecimal floatingAmount) {
        this.floatingAmount = floatingAmount;
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.tax_item：商品税目
     */
    public String getTaxItem() {
        return taxItem;
    }

    /**
     * set method
     *
     * @param taxItem 商品税目
     */
    public void setTaxItem(String taxItem) {
        this.taxItem = taxItem == null ? null : taxItem.trim();
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.goods_no_ver：编码版本号
     */
    public String getGoodsNoVer() {
        return goodsNoVer;
    }

    /**
     * set method
     *
     * @param goodsNoVer 编码版本号
     */
    public void setGoodsNoVer(String goodsNoVer) {
        this.goodsNoVer = goodsNoVer == null ? null : goodsNoVer.trim();
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.tax_pre：是否享受税收优惠政策
     */
    public String getTaxPre() {
        return taxPre;
    }

    /**
     * set method
     *
     * @param taxPre 是否享受税收优惠政策
     */
    public void setTaxPre(String taxPre) {
        this.taxPre = taxPre == null ? null : taxPre.trim();
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.tax_pre_con：是否享受税收优惠政策内容
     */
    public String getTaxPreCon() {
        return taxPreCon;
    }

    /**
     * set method
     *
     * @param taxPreCon 是否享受税收优惠政策内容
     */
    public void setTaxPreCon(String taxPreCon) {
        this.taxPreCon = taxPreCon == null ? null : taxPreCon.trim();
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.zero_tax：零税率标识
     */
    public String getZeroTax() {
        return zeroTax;
    }

    /**
     * set method
     *
     * @param zeroTax 零税率标识
     */
    public void setZeroTax(String zeroTax) {
        this.zeroTax = zeroTax == null ? null : zeroTax.trim();
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.deduction：扣除额
     */
    public BigDecimal getDeduction() {
        return deduction;
    }

    /**
     * set method
     *
     * @param deduction 扣除额
     */
    public void setDeduction(BigDecimal deduction) {
        this.deduction = deduction;
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.discount_flag：扣除行标记
     */
    public String getDiscountFlag() {
        return discountFlag;
    }

    /**
     * set method
     *
     * @param discountFlag 扣除行标记
     */
    public void setDiscountFlag(String discountFlag) {
        this.discountFlag = discountFlag == null ? null : discountFlag.trim();
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.price_method：价格方式
     */
    public String getPriceMethod() {
        return priceMethod;
    }

    /**
     * set method
     *
     * @param priceMethod 价格方式
     */
    public void setPriceMethod(String priceMethod) {
        this.priceMethod = priceMethod == null ? null : priceMethod.trim();
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.print_content_flag：是否打印单价数量
     */
    public String getPrintContentFlag() {
        return printContentFlag;
    }

    /**
     * set method
     *
     * @param printContentFlag 是否打印单价数量
     */
    public void setPrintContentFlag(String printContentFlag) {
        this.printContentFlag = printContentFlag == null ? null : printContentFlag.trim();
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.item_type_code：分类码
     */
    public String getItemTypeCode() {
        return itemTypeCode;
    }

    /**
     * set method
     *
     * @param itemTypeCode 分类码
     */
    public void setItemTypeCode(String itemTypeCode) {
        this.itemTypeCode = itemTypeCode == null ? null : itemTypeCode.trim();
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.create_time：创建时间
     */
    public Date getCreateTime() {
        return createTime;
    }

    /**
     * set method
     *
     * @param createTime 创建时间
     */
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.create_user_id：创建用户id
     */
    public Long getCreateUserId() {
        return createUserId;
    }

    /**
     * set method
     *
     * @param createUserId 创建用户id
     */
    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.update_time：更新时间
     */
    public Date getUpdateTime() {
        return updateTime;
    }

    /**
     * set method
     *
     * @param updateTime 更新时间
     */
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.update_user_id：更新用户id
     */
    public Long getUpdateUserId() {
        return updateUserId;
    }

    /**
     * set method
     *
     * @param updateUserId 更新用户id
     */
    public void setUpdateUserId(Long updateUserId) {
        this.updateUserId = updateUserId;
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.ext1：扩展1
     */
    public String getExt1() {
        return ext1;
    }

    /**
     * set method
     *
     * @param ext1 扩展1
     */
    public void setExt1(String ext1) {
        this.ext1 = ext1 == null ? null : ext1.trim();
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.ext2：扩展2
     */
    public String getExt2() {
        return ext2;
    }

    /**
     * set method
     *
     * @param ext2 扩展2
     */
    public void setExt2(String ext2) {
        this.ext2 = ext2 == null ? null : ext2.trim();
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.ext3：扩展3
     */
    public String getExt3() {
        return ext3;
    }

    /**
     * set method
     *
     * @param ext3 扩展3
     */
    public void setExt3(String ext3) {
        this.ext3 = ext3 == null ? null : ext3.trim();
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.ext4：扩展4
     */
    public String getExt4() {
        return ext4;
    }

    /**
     * set method
     *
     * @param ext4 扩展4
     */
    public void setExt4(String ext4) {
        this.ext4 = ext4 == null ? null : ext4.trim();
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.ext5：扩展5
     */
    public String getExt5() {
        return ext5;
    }

    /**
     * set method
     *
     * @param ext5 扩展5
     */
    public void setExt5(String ext5) {
        this.ext5 = ext5 == null ? null : ext5.trim();
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.ext6：扩展6
     */
    public String getExt6() {
        return ext6;
    }

    /**
     * set method
     *
     * @param ext6 扩展6
     */
    public void setExt6(String ext6) {
        this.ext6 = ext6 == null ? null : ext6.trim();
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.ext7：扩展7
     */
    public String getExt7() {
        return ext7;
    }

    /**
     * set method
     *
     * @param ext7 扩展7
     */
    public void setExt7(String ext7) {
        this.ext7 = ext7 == null ? null : ext7.trim();
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.ext8：扩展8
     */
    public String getExt8() {
        return ext8;
    }

    /**
     * set method
     *
     * @param ext8 扩展8
     */
    public void setExt8(String ext8) {
        this.ext8 = ext8 == null ? null : ext8.trim();
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.ext9：扩展9
     */
    public String getExt9() {
        return ext9;
    }

    /**
     * set method
     *
     * @param ext9 扩展9
     */
    public void setExt9(String ext9) {
        this.ext9 = ext9 == null ? null : ext9.trim();
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.ext10：扩展10
     */
    public String getExt10() {
        return ext10;
    }

    /**
     * set method
     *
     * @param ext10 扩展10
     */
    public void setExt10(String ext10) {
        this.ext10 = ext10 == null ? null : ext10.trim();
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.ext11：扩展11
     */
    public String getExt11() {
        return ext11;
    }

    /**
     * set method
     *
     * @param ext11 扩展11
     */
    public void setExt11(String ext11) {
        this.ext11 = ext11 == null ? null : ext11.trim();
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.ext12：扩展12
     */
    public String getExt12() {
        return ext12;
    }

    /**
     * set method
     *
     * @param ext12 扩展12
     */
    public void setExt12(String ext12) {
        this.ext12 = ext12 == null ? null : ext12.trim();
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.ext13：扩展13
     */
    public String getExt13() {
        return ext13;
    }

    /**
     * set method
     *
     * @param ext13 扩展13
     */
    public void setExt13(String ext13) {
        this.ext13 = ext13 == null ? null : ext13.trim();
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.ext14：扩展14
     */
    public String getExt14() {
        return ext14;
    }

    /**
     * set method
     *
     * @param ext14 扩展14
     */
    public void setExt14(String ext14) {
        this.ext14 = ext14 == null ? null : ext14.trim();
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.ext15：扩展15
     */
    public String getExt15() {
        return ext15;
    }

    /**
     * set method
     *
     * @param ext15 扩展15
     */
    public void setExt15(String ext15) {
        this.ext15 = ext15 == null ? null : ext15.trim();
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.ext16：扩展16
     */
    public String getExt16() {
        return ext16;
    }

    /**
     * set method
     *
     * @param ext16 扩展16
     */
    public void setExt16(String ext16) {
        this.ext16 = ext16 == null ? null : ext16.trim();
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.ext17：扩展17
     */
    public String getExt17() {
        return ext17;
    }

    /**
     * set method
     *
     * @param ext17 扩展17
     */
    public void setExt17(String ext17) {
        this.ext17 = ext17 == null ? null : ext17.trim();
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.ext18：扩展18
     */
    public String getExt18() {
        return ext18;
    }

    /**
     * set method
     *
     * @param ext18 扩展18
     */
    public void setExt18(String ext18) {
        this.ext18 = ext18 == null ? null : ext18.trim();
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.ext19：扩展19
     */
    public String getExt19() {
        return ext19;
    }

    /**
     * set method
     *
     * @param ext19 扩展19
     */
    public void setExt19(String ext19) {
        this.ext19 = ext19 == null ? null : ext19.trim();
    }

    /**
     * get method
     *
     * @return ant_pre_invoice_item.ext20：扩展20
     */
    public String getExt20() {
        return ext20;
    }

    /**
     * set method
     *
     * @param ext20 扩展20
     */
    public void setExt20(String ext20) {
        this.ext20 = ext20 == null ? null : ext20.trim();
    }

    /**
     *
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", preInvoiceId=").append(preInvoiceId);
        sb.append(", goodsTaxNo=").append(goodsTaxNo);
        sb.append(", cargoName=").append(cargoName);
        sb.append(", cargoCode=").append(cargoCode);
        sb.append(", itemSpec=").append(itemSpec);
        sb.append(", unitPrice=").append(unitPrice);
        sb.append(", quantity=").append(quantity);
        sb.append(", quantityUnit=").append(quantityUnit);
        sb.append(", taxRate=").append(taxRate);
        sb.append(", amountWithoutTax=").append(amountWithoutTax);
        sb.append(", taxAmount=").append(taxAmount);
        sb.append(", amountWithTax=").append(amountWithTax);
        sb.append(", discountRate=").append(discountRate);
        sb.append(", discountWithoutTax=").append(discountWithoutTax);
        sb.append(", discountWithTax=").append(discountWithTax);
        sb.append(", discountTax=").append(discountTax);
        sb.append(", floatingAmount=").append(floatingAmount);
        sb.append(", taxItem=").append(taxItem);
        sb.append(", goodsNoVer=").append(goodsNoVer);
        sb.append(", taxPre=").append(taxPre);
        sb.append(", taxPreCon=").append(taxPreCon);
        sb.append(", zeroTax=").append(zeroTax);
        sb.append(", deduction=").append(deduction);
        sb.append(", discountFlag=").append(discountFlag);
        sb.append(", priceMethod=").append(priceMethod);
        sb.append(", printContentFlag=").append(printContentFlag);
        sb.append(", itemTypeCode=").append(itemTypeCode);
        sb.append(", createTime=").append(createTime);
        sb.append(", createUserId=").append(createUserId);
        sb.append(", updateTime=").append(updateTime);
        sb.append(", updateUserId=").append(updateUserId);
        sb.append(", ext1=").append(ext1);
        sb.append(", ext2=").append(ext2);
        sb.append(", ext3=").append(ext3);
        sb.append(", ext4=").append(ext4);
        sb.append(", ext5=").append(ext5);
        sb.append(", ext6=").append(ext6);
        sb.append(", ext7=").append(ext7);
        sb.append(", ext8=").append(ext8);
        sb.append(", ext9=").append(ext9);
        sb.append(", ext10=").append(ext10);
        sb.append(", ext11=").append(ext11);
        sb.append(", ext12=").append(ext12);
        sb.append(", ext13=").append(ext13);
        sb.append(", ext14=").append(ext14);
        sb.append(", ext15=").append(ext15);
        sb.append(", ext16=").append(ext16);
        sb.append(", ext17=").append(ext17);
        sb.append(", ext18=").append(ext18);
        sb.append(", ext19=").append(ext19);
        sb.append(", ext20=").append(ext20);
        sb.append("]");
        return sb.toString();
    }

    /**
     * @param that
     */
    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        MixPreInvoiceItemEntity other = (MixPreInvoiceItemEntity) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
                && (this.getPreInvoiceId() == null ? other.getPreInvoiceId() == null : this.getPreInvoiceId().equals(other.getPreInvoiceId()))
                && (this.getGoodsTaxNo() == null ? other.getGoodsTaxNo() == null : this.getGoodsTaxNo().equals(other.getGoodsTaxNo()))
                && (this.getCargoName() == null ? other.getCargoName() == null : this.getCargoName().equals(other.getCargoName()))
                && (this.getCargoCode() == null ? other.getCargoCode() == null : this.getCargoCode().equals(other.getCargoCode()))
                && (this.getItemSpec() == null ? other.getItemSpec() == null : this.getItemSpec().equals(other.getItemSpec()))
                && (this.getUnitPrice() == null ? other.getUnitPrice() == null : this.getUnitPrice().equals(other.getUnitPrice()))
                && (this.getQuantity() == null ? other.getQuantity() == null : this.getQuantity().equals(other.getQuantity()))
                && (this.getQuantityUnit() == null ? other.getQuantityUnit() == null : this.getQuantityUnit().equals(other.getQuantityUnit()))
                && (this.getTaxRate() == null ? other.getTaxRate() == null : this.getTaxRate().equals(other.getTaxRate()))
                && (this.getAmountWithoutTax() == null ? other.getAmountWithoutTax() == null : this.getAmountWithoutTax().equals(other.getAmountWithoutTax()))
                && (this.getTaxAmount() == null ? other.getTaxAmount() == null : this.getTaxAmount().equals(other.getTaxAmount()))
                && (this.getAmountWithTax() == null ? other.getAmountWithTax() == null : this.getAmountWithTax().equals(other.getAmountWithTax()))
                && (this.getDiscountRate() == null ? other.getDiscountRate() == null : this.getDiscountRate().equals(other.getDiscountRate()))
                && (this.getDiscountWithoutTax() == null ? other.getDiscountWithoutTax() == null : this.getDiscountWithoutTax().equals(other.getDiscountWithoutTax()))
                && (this.getDiscountWithTax() == null ? other.getDiscountWithTax() == null : this.getDiscountWithTax().equals(other.getDiscountWithTax()))
                && (this.getDiscountTax() == null ? other.getDiscountTax() == null : this.getDiscountTax().equals(other.getDiscountTax()))
                && (this.getFloatingAmount() == null ? other.getFloatingAmount() == null : this.getFloatingAmount().equals(other.getFloatingAmount()))
                && (this.getTaxItem() == null ? other.getTaxItem() == null : this.getTaxItem().equals(other.getTaxItem()))
                && (this.getGoodsNoVer() == null ? other.getGoodsNoVer() == null : this.getGoodsNoVer().equals(other.getGoodsNoVer()))
                && (this.getTaxPre() == null ? other.getTaxPre() == null : this.getTaxPre().equals(other.getTaxPre()))
                && (this.getTaxPreCon() == null ? other.getTaxPreCon() == null : this.getTaxPreCon().equals(other.getTaxPreCon()))
                && (this.getZeroTax() == null ? other.getZeroTax() == null : this.getZeroTax().equals(other.getZeroTax()))
                && (this.getDeduction() == null ? other.getDeduction() == null : this.getDeduction().equals(other.getDeduction()))
                && (this.getDiscountFlag() == null ? other.getDiscountFlag() == null : this.getDiscountFlag().equals(other.getDiscountFlag()))
                && (this.getPriceMethod() == null ? other.getPriceMethod() == null : this.getPriceMethod().equals(other.getPriceMethod()))
                && (this.getPrintContentFlag() == null ? other.getPrintContentFlag() == null : this.getPrintContentFlag().equals(other.getPrintContentFlag()))
                && (this.getItemTypeCode() == null ? other.getItemTypeCode() == null : this.getItemTypeCode().equals(other.getItemTypeCode()))
                && (this.getCreateTime() == null ? other.getCreateTime() == null : this.getCreateTime().equals(other.getCreateTime()))
                && (this.getCreateUserId() == null ? other.getCreateUserId() == null : this.getCreateUserId().equals(other.getCreateUserId()))
                && (this.getUpdateTime() == null ? other.getUpdateTime() == null : this.getUpdateTime().equals(other.getUpdateTime()))
                && (this.getUpdateUserId() == null ? other.getUpdateUserId() == null : this.getUpdateUserId().equals(other.getUpdateUserId()))
                && (this.getExt1() == null ? other.getExt1() == null : this.getExt1().equals(other.getExt1()))
                && (this.getExt2() == null ? other.getExt2() == null : this.getExt2().equals(other.getExt2()))
                && (this.getExt3() == null ? other.getExt3() == null : this.getExt3().equals(other.getExt3()))
                && (this.getExt4() == null ? other.getExt4() == null : this.getExt4().equals(other.getExt4()))
                && (this.getExt5() == null ? other.getExt5() == null : this.getExt5().equals(other.getExt5()))
                && (this.getExt6() == null ? other.getExt6() == null : this.getExt6().equals(other.getExt6()))
                && (this.getExt7() == null ? other.getExt7() == null : this.getExt7().equals(other.getExt7()))
                && (this.getExt8() == null ? other.getExt8() == null : this.getExt8().equals(other.getExt8()))
                && (this.getExt9() == null ? other.getExt9() == null : this.getExt9().equals(other.getExt9()))
                && (this.getExt10() == null ? other.getExt10() == null : this.getExt10().equals(other.getExt10()))
                && (this.getExt11() == null ? other.getExt11() == null : this.getExt11().equals(other.getExt11()))
                && (this.getExt12() == null ? other.getExt12() == null : this.getExt12().equals(other.getExt12()))
                && (this.getExt13() == null ? other.getExt13() == null : this.getExt13().equals(other.getExt13()))
                && (this.getExt14() == null ? other.getExt14() == null : this.getExt14().equals(other.getExt14()))
                && (this.getExt15() == null ? other.getExt15() == null : this.getExt15().equals(other.getExt15()))
                && (this.getExt16() == null ? other.getExt16() == null : this.getExt16().equals(other.getExt16()))
                && (this.getExt17() == null ? other.getExt17() == null : this.getExt17().equals(other.getExt17()))
                && (this.getExt18() == null ? other.getExt18() == null : this.getExt18().equals(other.getExt18()))
                && (this.getExt19() == null ? other.getExt19() == null : this.getExt19().equals(other.getExt19()))
                && (this.getExt20() == null ? other.getExt20() == null : this.getExt20().equals(other.getExt20()));
    }

    /**
     *
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getPreInvoiceId() == null) ? 0 : getPreInvoiceId().hashCode());
        result = prime * result + ((getGoodsTaxNo() == null) ? 0 : getGoodsTaxNo().hashCode());
        result = prime * result + ((getCargoName() == null) ? 0 : getCargoName().hashCode());
        result = prime * result + ((getCargoCode() == null) ? 0 : getCargoCode().hashCode());
        result = prime * result + ((getItemSpec() == null) ? 0 : getItemSpec().hashCode());
        result = prime * result + ((getUnitPrice() == null) ? 0 : getUnitPrice().hashCode());
        result = prime * result + ((getQuantity() == null) ? 0 : getQuantity().hashCode());
        result = prime * result + ((getQuantityUnit() == null) ? 0 : getQuantityUnit().hashCode());
        result = prime * result + ((getTaxRate() == null) ? 0 : getTaxRate().hashCode());
        result = prime * result + ((getAmountWithoutTax() == null) ? 0 : getAmountWithoutTax().hashCode());
        result = prime * result + ((getTaxAmount() == null) ? 0 : getTaxAmount().hashCode());
        result = prime * result + ((getAmountWithTax() == null) ? 0 : getAmountWithTax().hashCode());
        result = prime * result + ((getDiscountRate() == null) ? 0 : getDiscountRate().hashCode());
        result = prime * result + ((getDiscountWithoutTax() == null) ? 0 : getDiscountWithoutTax().hashCode());
        result = prime * result + ((getDiscountWithTax() == null) ? 0 : getDiscountWithTax().hashCode());
        result = prime * result + ((getDiscountTax() == null) ? 0 : getDiscountTax().hashCode());
        result = prime * result + ((getFloatingAmount() == null) ? 0 : getFloatingAmount().hashCode());
        result = prime * result + ((getTaxItem() == null) ? 0 : getTaxItem().hashCode());
        result = prime * result + ((getGoodsNoVer() == null) ? 0 : getGoodsNoVer().hashCode());
        result = prime * result + ((getTaxPre() == null) ? 0 : getTaxPre().hashCode());
        result = prime * result + ((getTaxPreCon() == null) ? 0 : getTaxPreCon().hashCode());
        result = prime * result + ((getZeroTax() == null) ? 0 : getZeroTax().hashCode());
        result = prime * result + ((getDeduction() == null) ? 0 : getDeduction().hashCode());
        result = prime * result + ((getDiscountFlag() == null) ? 0 : getDiscountFlag().hashCode());
        result = prime * result + ((getPriceMethod() == null) ? 0 : getPriceMethod().hashCode());
        result = prime * result + ((getPrintContentFlag() == null) ? 0 : getPrintContentFlag().hashCode());
        result = prime * result + ((getItemTypeCode() == null) ? 0 : getItemTypeCode().hashCode());
        result = prime * result + ((getCreateTime() == null) ? 0 : getCreateTime().hashCode());
        result = prime * result + ((getCreateUserId() == null) ? 0 : getCreateUserId().hashCode());
        result = prime * result + ((getUpdateTime() == null) ? 0 : getUpdateTime().hashCode());
        result = prime * result + ((getUpdateUserId() == null) ? 0 : getUpdateUserId().hashCode());
        result = prime * result + ((getExt1() == null) ? 0 : getExt1().hashCode());
        result = prime * result + ((getExt2() == null) ? 0 : getExt2().hashCode());
        result = prime * result + ((getExt3() == null) ? 0 : getExt3().hashCode());
        result = prime * result + ((getExt4() == null) ? 0 : getExt4().hashCode());
        result = prime * result + ((getExt5() == null) ? 0 : getExt5().hashCode());
        result = prime * result + ((getExt6() == null) ? 0 : getExt6().hashCode());
        result = prime * result + ((getExt7() == null) ? 0 : getExt7().hashCode());
        result = prime * result + ((getExt8() == null) ? 0 : getExt8().hashCode());
        result = prime * result + ((getExt9() == null) ? 0 : getExt9().hashCode());
        result = prime * result + ((getExt10() == null) ? 0 : getExt10().hashCode());
        result = prime * result + ((getExt11() == null) ? 0 : getExt11().hashCode());
        result = prime * result + ((getExt12() == null) ? 0 : getExt12().hashCode());
        result = prime * result + ((getExt13() == null) ? 0 : getExt13().hashCode());
        result = prime * result + ((getExt14() == null) ? 0 : getExt14().hashCode());
        result = prime * result + ((getExt15() == null) ? 0 : getExt15().hashCode());
        result = prime * result + ((getExt16() == null) ? 0 : getExt16().hashCode());
        result = prime * result + ((getExt17() == null) ? 0 : getExt17().hashCode());
        result = prime * result + ((getExt18() == null) ? 0 : getExt18().hashCode());
        result = prime * result + ((getExt19() == null) ? 0 : getExt19().hashCode());
        result = prime * result + ((getExt20() == null) ? 0 : getExt20().hashCode());
        return result;
    }
}