package com.xforceplus.coop.mix.model;


import java.math.BigDecimal;
import java.util.Date;

public class MixSellerInvoiceEntity extends MixBaseEntity {
    /**
     * 外部id
     * 表 : ant_seller_invoice
     * 对应字段 : external_id
     */
    private String externalId;

    /**
     * 预制发票序列号
     * 表 : ant_seller_invoice
     * 对应字段 : pre_invoice_id
     */
    private Long preInvoiceId;

    /**
     * 批次号
     * 表 : ant_seller_invoice
     * 对应字段 : batch_no
     */
    private Long batchNo;

    /**
     * 系统外批次号  默认batch_no的值
     * 表 : ant_seller_invoice
     * 对应字段 : out_batch_no
     */
    private Long outBatchNo;

    /**
     * 业务单序号
     * 表 : ant_seller_invoice
     * 对应字段 : salesbill_id
     */
    private Long salesbillId;

    /**
     * 业务单号
     * 表 : ant_seller_invoice
     * 对应字段 : salesbill_no
     */
    private String salesbillNo;

    /**
     * 销方租户id
     * 表 : ant_seller_invoice
     * 对应字段 : seller_tenant_id
     */
    private Long sellerTenantId;

    /**
     * 销方租户公司编号
     * 表 : ant_seller_invoice
     * 对应字段 : seller_no
     */
    private String sellerNo;

    /**
     * 销方公司ID
     * 表 : ant_seller_invoice
     * 对应字段 : seller_id
     */
    private Long sellerId;

    /**
     * 销方名称
     * 表 : ant_seller_invoice
     * 对应字段 : seller_name
     */
    private String sellerName;

    /**
     * 销方纳税人识别号
     * 表 : ant_seller_invoice
     * 对应字段 : seller_tax_no
     */
    private String sellerTaxNo;

    /**
     * 销方电话
     * 表 : ant_seller_invoice
     * 对应字段 : seller_tel
     */
    private String sellerTel;

    /**
     * 销方地址
     * 表 : ant_seller_invoice
     * 对应字段 : seller_address
     */
    private String sellerAddress;

    /**
     * 销方银行名称
     * 表 : ant_seller_invoice
     * 对应字段 : seller_bank_name
     */
    private String sellerBankName;

    /**
     * 销方银行账号
     * 表 : ant_seller_invoice
     * 对应字段 : seller_bank_account
     */
    private String sellerBankAccount;

    /**
     * 销方地址电话
     * 表 : ant_seller_invoice
     * 对应字段 : seller_addr_tel
     */
    private String sellerAddrTel;

    /**
     * 销方银行名称账号
     * 表 : ant_seller_invoice
     * 对应字段 : seller_bank_info
     */
    private String sellerBankInfo;

    /**
     * 购方名称
     * 表 : ant_seller_invoice
     * 对应字段 : purchaser_name
     */
    private String purchaserName;

    /**
     * 购方租户id
     * 表 : ant_seller_invoice
     * 对应字段 : purchaser_tenant_id
     */
    private Long purchaserTenantId;

    /**
     * 购方公司id
     * 表 : ant_seller_invoice
     * 对应字段 : purchaser_id
     */
    private Long purchaserId;

    /**
     * 购方租户公司编号
     * 表 : ant_seller_invoice
     * 对应字段 : purchaser_no
     */
    private String purchaserNo;

    /**
     * 购方纳税人识别号
     * 表 : ant_seller_invoice
     * 对应字段 : purchaser_tax_no
     */
    private String purchaserTaxNo;

    /**
     * 购方电话
     * 表 : ant_seller_invoice
     * 对应字段 : purchaser_tel
     */
    private String purchaserTel;

    /**
     * 购方地址
     * 表 : ant_seller_invoice
     * 对应字段 : purchaser_address
     */
    private String purchaserAddress;

    /**
     * 购方银行名称
     * 表 : ant_seller_invoice
     * 对应字段 : purchaser_bank_name
     */
    private String purchaserBankName;

    /**
     * 购方银行账号
     * 表 : ant_seller_invoice
     * 对应字段 : purchaser_bank_account
     */
    private String purchaserBankAccount;

    /**
     * 购方银行名称账号
     * 表 : ant_seller_invoice
     * 对应字段 : purchaser_bank_info
     */
    private String purchaserBankInfo;

    /**
     * 购方地址电话
     * 表 : ant_seller_invoice
     * 对应字段 : purchaser_addr_tel
     */
    private String purchaserAddrTel;

    /**
     * 购方电子支付标识
     * 表 : ant_seller_invoice
     * 对应字段 : purchaser_e_pay_id
     */
    private String purchaserEPayId;

    /**
     * 红蓝标识 1-蓝票 2-红票 3-红冲票
     * 表 : ant_seller_invoice
     * 对应字段 : invoice_color
     */
    private String invoiceColor;

    /**
     * 发票类型
     * 表 : ant_seller_invoice
     * 对应字段 : invoice_type
     */
    private String invoiceType;

    /**
     * 税控发票来源 qd - 全电发票; sk - 税控发票
     * 表 : ant_seller_invoice
     * 对应字段 : tax_invoice_source
     */
    private String taxInvoiceSource;

    /**
     * 发票票种 s - 纸专; se - 电专; c - 纸普; ce - 电普; v - 机动车; vs - 二手机动车; ju - 卷票
     * 表 : ant_seller_invoice
     * 对应字段 : invoice_kind
     */
    private String invoiceKind;

    /**
     * 发票代码
     * 表 : ant_seller_invoice
     * 对应字段 : invoice_code
     */
    private String invoiceCode;

    /**
     * 发票号码
     * 表 : ant_seller_invoice
     * 对应字段 : invoice_no
     */
    private String invoiceNo;

    /**
     * 机器编码
     * 表 : ant_seller_invoice
     * 对应字段 : machine_code
     */
    private String machineCode;

    /**
     * 发票开票日期
     * 表 : ant_seller_invoice
     * 对应字段 : paper_draw_date
     */
    private Date paperDrawDate;

    /**
     * 校验码
     * 表 : ant_seller_invoice
     * 对应字段 : check_code
     */
    private String checkCode;

    /**
     * 收款人姓名
     * 表 : ant_seller_invoice
     * 对应字段 : cashier_name
     */
    private String cashierName;

    /**
     * 复核人姓名
     * 表 : ant_seller_invoice
     * 对应字段 : checker_name
     */
    private String checkerName;

    /**
     * 开票人姓名
     * 表 : ant_seller_invoice
     * 对应字段 : invoicer_name
     */
    private String invoicerName;

    /**
     * 备注
     * 表 : ant_seller_invoice
     * 对应字段 : remark
     */
    private String remark;

    /**
     * 电子签名
     * 表 : ant_seller_invoice
     * 对应字段 : electronic_signature
     */
    private String electronicSignature;

    /**
     * 发票来源 0-直连开票 1-抽取回填 2-验真回填 3-识别回填 4-手工回填 5-预制发票回填 6-底账回填 7-OFD解析
     * 表 : ant_seller_invoice
     * 对应字段 : invoice_origin
     */
    private String invoiceOrigin;

    /**
     * 来源方式  0-默认 21-扫码验真  22-手工验真 23-导入验真 24-识别验真
     * 表 : ant_seller_invoice
     * 对应字段 : origin_type
     */
    private Integer originType;

    /**
     * 系统来源 下发数据需要  由属地直接传过来
     * 表 : ant_seller_invoice
     * 对应字段 : system_orig
     */
    private String systemOrig;

    /**
     * 特殊发票标记  0-默认  1-通行费   2-成品油
     * 表 : ant_seller_invoice
     * 对应字段 : special_invoice_flag
     */
    private String specialInvoiceFlag;

    /**
     * 单据类型
     * 表 : ant_seller_invoice
     * 对应字段 : bill_type
     */
    private String billType;

    /**
     * 适用业务单据类型
     * 表 : ant_seller_invoice
     * 对应字段 : business_bill_type
     */
    private String businessBillType;

    /**
     * 含税金额
     * 表 : ant_seller_invoice
     * 对应字段 : amount_with_tax
     */
    private BigDecimal amountWithTax;

    /**
     * 不含税金额
     * 表 : ant_seller_invoice
     * 对应字段 : amount_without_tax
     */
    private BigDecimal amountWithoutTax;

    /**
     * 税额
     * 表 : ant_seller_invoice
     * 对应字段 : tax_amount
     */
    private BigDecimal taxAmount;

    /**
     * 税率
     * 表 : ant_seller_invoice
     * 对应字段 : tax_rate
     */
    private String taxRate;

    /**
     * 原发票号码
     * 表 : ant_seller_invoice
     * 对应字段 : origin_invoice_no
     */
    private String originInvoiceNo;

    /**
     * 原发票代码
     * 表 : ant_seller_invoice
     * 对应字段 : origin_invoice_code
     */
    private String originInvoiceCode;

    /**
     * 原蓝票发票类型
     * 表 : ant_seller_invoice
     * 对应字段 : origin_invoice_type
     */
    private String originInvoiceType;

    /**
     * 原蓝票的开票日期 YYYYMMDD
     * 表 : ant_seller_invoice
     * 对应字段 : origin_paper_draw_date
     */
    private String originPaperDrawDate;

    /**
     * 密文
     * 表 : ant_seller_invoice
     * 对应字段 : cipher_text
     */
    private String cipherText;

    /**
     * 二维密文
     * 表 : ant_seller_invoice
     * 对应字段 : cipher_text_two_code
     */
    private String cipherTextTwoCode;

    /**
     * 抽取时间
     * 表 : ant_seller_invoice
     * 对应字段 : drawout_time
     */
    private Date drawoutTime;

    /**
     * 抽取操作账号
     * 表 : ant_seller_invoice
     * 对应字段 : drawout_user_id
     */
    private Long drawoutUserId;

    /**
     * 作废标识 0-默认 1-批次内 2-批次外
     * 表 : ant_seller_invoice
     * 对应字段 : abandon_flag
     */
    private String abandonFlag;

    /**
     * 红冲时间
     * 表 : ant_seller_invoice
     * 对应字段 : red_time
     */
    private Date redTime;

    /**
     * 红冲人id
     * 表 : ant_seller_invoice
     * 对应字段 : red_user_id
     */
    private Long redUserId;

    /**
     * 红冲人姓名
     * 表 : ant_seller_invoice
     * 对应字段 : red_user_name
     */
    private String redUserName;

    /**
     * 红冲状态 0-默认 1-待红冲 2-待部分红冲3-红冲4-部分红冲5-红冲票
     * 表 : ant_seller_invoice
     * 对应字段 : red_flag
     */
    private String redFlag;

    /**
     * 红字信息表编号
     * 表 : ant_seller_invoice
     * 对应字段 : red_notification_no
     */
    private String redNotificationNo;

    /**
     * 抽取状态 0-默认状态：非抽取
     * 表 : ant_seller_invoice
     * 对应字段 : drawout_status
     */
    private Integer drawoutStatus;

    /**
     * 发票状态1-正常 0-作废 2-待处理 9-删除
     * 表 : ant_seller_invoice
     * 对应字段 : status
     */
    private Integer status;

    /**
     * 销货清单文件打印标志（0-否,1-是）默认0
     * 表 : ant_seller_invoice
     * 对应字段 : sale_list_file_flag
     */
    private Integer saleListFileFlag;

    /**
     * 打印内容标志0-打印单价和数量1-不打印单价和数量,默认0
     * 表 : ant_seller_invoice
     * 对应字段 : print_content_flag
     */
    private Integer printContentFlag;

    /**
     * pdf路径
     * 表 : ant_seller_invoice
     * 对应字段 : pdf_path
     */
    private String pdfPath;

    /**
     * ofd转换成的图片地址
     * 表 : ant_seller_invoice
     * 对应字段 : ofd_to_img
     */
    private String ofdToImg;

    /**
     * xml地址
     * 表 : ant_seller_invoice
     * 对应字段 : xml_url
     */
    private String xmlUrl;

    /**
     * 二维码地址
     * 表 : ant_seller_invoice
     * 对应字段 : qr_code_url
     */
    private String qrCodeUrl;

    /**
     * ofd转换成的PDF地址
     * 表 : ant_seller_invoice
     * 对应字段 : ofd_to_pdf
     */
    private String ofdToPdf;

    /**
     * 接收人邮箱
     * 表 : ant_seller_invoice
     * 对应字段 : receive_user_email
     */
    private String receiveUserEmail;

    /**
     * 接收人电话
     * 表 : ant_seller_invoice
     * 对应字段 : receive_user_tel
     */
    private String receiveUserTel;

    /**
     * 开票点名称
     * 表 : ant_seller_invoice
     * 对应字段 : make_out_unit_name
     */
    private String makeOutUnitName;

    /**
     * 处理状态 1-正常  2-处理中
     * 表 : ant_seller_invoice
     * 对应字段 : handle_status
     */
    private String handleStatus;

    /**
     * 处理备注
     * 表 : ant_seller_invoice
     * 对应字段 : handle_remark
     */
    private String handleRemark;

    /**
     * 外部批次生成标志 1-不生成 0-生成
     * 表 : ant_seller_invoice
     * 对应字段 : out_check_status
     */
    private String outCheckStatus;

    /**
     * 系统外锁定配置 0-锁红冲作废 1-锁红冲 2-锁作废
     * 表 : ant_seller_invoice
     * 对应字段 : out_lock_config
     */
    private String outLockConfig;

    /**
     * 查验状态 0-未查验(默认) 2-查验中 3-查验成功 4-查验失败 5-次日查
     * 表 : ant_seller_invoice
     * 对应字段 : verify_status
     */
    private Integer verifyStatus;

    /**
     * 查验发送时间
     * 表 : ant_seller_invoice
     * 对应字段 : verify_request_time
     */
    private Date verifyRequestTime;

    /**
     * 查验完成时间
     * 表 : ant_seller_invoice
     * 对应字段 : verify_response_time
     */
    private Date verifyResponseTime;

    /**
     * 查验备注
     * 表 : ant_seller_invoice
     * 对应字段 : verify_remark
     */
    private String verifyRemark;

    /**
     * 获取状态 0-默认 1-获取中 2-获取成功 3-获取失败
     * 表 : ant_seller_invoice
     * 对应字段 : gain_status
     */
    private Integer gainStatus;

    /**
     * 获取时间
     * 表 : ant_seller_invoice
     * 对应字段 : gain_time
     */
    private Date gainTime;

    /**
     * 获取备注
     * 表 : ant_seller_invoice
     * 对应字段 : gain_remark
     */
    private String gainRemark;

    /**
     * 关联状态 0-默认 1-关联中 2-关联成功 3-关联失败
     * 表 : ant_seller_invoice
     * 对应字段 : associate_status
     */
    private Integer associateStatus;

    /**
     * 关联时间
     * 表 : ant_seller_invoice
     * 对应字段 : associate_time
     */
    private Date associateTime;

    /**
     * 关联备注
     * 表 : ant_seller_invoice
     * 对应字段 : associate_remark
     */
    private String associateRemark;

    /**
     * 锁定状态1-已锁定 0-未锁定
     * 表 : ant_seller_invoice
     * 对应字段 : lock_status
     */
    private String lockStatus;

    /**
     * 扫描状态 0-未扫描 1-已扫描
     * 表 : ant_seller_invoice
     * 对应字段 : scan_status
     */
    private Integer scanStatus;

    /**
     * 扫描发票图片路径
     * 表 : ant_seller_invoice
     * 对应字段 : scan_image_url
     */
    private String scanImageUrl;

    /**
     * 扫描时间
     * 表 : ant_seller_invoice
     * 对应字段 : scan_time
     */
    private Date scanTime;

    /**
     * 影像上传状态 0-未上传 1-已上传
     * 表 : ant_seller_invoice
     * 对应字段 : image_upload_status
     */
    private Integer imageUploadStatus;

    /**
     * 影像上传时间
     * 表 : ant_seller_invoice
     * 对应字段 : image_upload_time
     */
    private Date imageUploadTime;

    /**
     * 签收状态 0-无物流信息 1-未签收 2-已签收
     * 表 : ant_seller_invoice
     * 对应字段 : receipt_status
     */
    private Integer receiptStatus;

    /**
     * 签收时间
     * 表 : ant_seller_invoice
     * 对应字段 : receipt_time
     */
    private Date receiptTime;

    /**
     * 认证状态 0-默认 1-不可认证 2-未认证 3-认证中 4-已勾选 5-认证失败 6-认证异常 7-已转出 8-已认证
     * 表 : ant_seller_invoice
     * 对应字段 : identify_status
     */
    private String identifyStatus;

    /**
     * 认证时间
     * 表 : ant_seller_invoice
     * 对应字段 : identify_time
     */
    private Date identifyTime;

    /**
     * 勾选时间
     * 表 : ant_seller_invoice
     * 对应字段 : check_time
     */
    private Date checkTime;

    /**
     * 打印状态1-已打印 0-未打印
     * 表 : ant_seller_invoice
     * 对应字段 : print_status
     */
    private String printStatus;

    /**
     * 退票状态 0-未退(默认) 1-已退
     * 表 : ant_seller_invoice
     * 对应字段 : retreat_status
     */
    private String retreatStatus;

    /**
     * 退票时间
     * 表 : ant_seller_invoice
     * 对应字段 : retreat_time
     */
    private Date retreatTime;

    /**
     * 审核状态 0-未审核 1-已审核
     * 表 : ant_seller_invoice
     * 对应字段 : approve_status
     */
    private Integer approveStatus;

    /**
     * 审核时间
     * 表 : ant_seller_invoice
     * 对应字段 : approve_time
     */
    private Date approveTime;

    /**
     * 付款状态 0-未付款(默认) 1-部分付款 2-已付款
     * 表 : ant_seller_invoice
     * 对应字段 : payment_status
     */
    private String paymentStatus;

    /**
     * 付款时间
     * 表 : ant_seller_invoice
     * 对应字段 : payment_time
     */
    private Date paymentTime;

    /**
     * 物流单号
     * 表 : ant_seller_invoice
     * 对应字段 : parcel_no
     */
    private String parcelNo;

    /**
     * 物流公司代码
     * 表 : ant_seller_invoice
     * 对应字段 : express_code
     */
    private String expressCode;

    /**
     * 协同状态 0-不协同 1-协同
     * 表 : ant_seller_invoice
     * 对应字段 : cooperate_flag
     */
    private Integer cooperateFlag;

    /**
     * 开票点代码
     * 表 : ant_seller_invoice
     * 对应字段 : make_out_unit_code
     */
    private String makeOutUnitCode;

    /**
     * 设备唯一码
     * 表 : ant_seller_invoice
     * 对应字段 : device_un
     */
    private String deviceUn;

    /**
     * 终端唯一码
     * 表 : ant_seller_invoice
     * 对应字段 : terminal_un
     */
    private String terminalUn;

    /**
     * 终端类型 1-单盘 2-服务器 4-区块链
     * 表 : ant_seller_invoice
     * 对应字段 : terminal_type
     */
    private Integer terminalType;

    /**
     * 创建人姓名
     * 表 : ant_seller_invoice
     * 对应字段 : create_user_name
     */
    private String createUserName;

    /**
     * 创建时间
     * 表 : ant_seller_invoice
     * 对应字段 : create_time
     */
    private Date createTime;

    /**
     * 创建人账号
     * 表 : ant_seller_invoice
     * 对应字段 : create_user_id
     */
    private Long createUserId;

    /**
     * 修改时间
     * 表 : ant_seller_invoice
     * 对应字段 : update_time
     */
    private Date updateTime;

    /**
     * 更新人姓名
     * 表 : ant_seller_invoice
     * 对应字段 : update_user_name
     */
    private String updateUserName;

    /**
     * 更新账号
     * 表 : ant_seller_invoice
     * 对应字段 : update_user_id
     */
    private Long updateUserId;

    /**
     * 删除时间
     * 表 : ant_seller_invoice
     * 对应字段 : delete_time
     */
    private Date deleteTime;

    /**
     * 删除操作账号
     * 表 : ant_seller_invoice
     * 对应字段 : delete_user_id
     */
    private Long deleteUserId;

    /**
     * 作废的人名字
     * 表 : ant_seller_invoice
     * 对应字段 : depose_user_name
     */
    private String deposeUserName;

    /**
     * 作废时间
     * 表 : ant_seller_invoice
     * 对应字段 : depose_time
     */
    private Date deposeTime;

    /**
     * 作废操作账号
     * 表 : ant_seller_invoice
     * 对应字段 : depose_user_id
     */
    private Long deposeUserId;

    /**
     * 用户Id 下发数据需要  由属地直接传过来
     * 表 : ant_seller_invoice
     * 对应字段 : customer_no
     */
    private String customerNo;

    /**
     * 权限ID
     * 表 : ant_seller_invoice
     * 对应字段 : sys_org_id
     */
    private Long sysOrgId;

    /**
     * 辅助抽取发票详情的URL
     * 表 : ant_seller_invoice
     * 对应字段 : invoice_url
     */
    private String invoiceUrl;

    /**
     * 来源产品线
     * 表 : ant_seller_invoice
     * 对应字段 : source_line
     */
    private String sourceLine;

    /**
     * 代开机构税号
     * 表 : ant_seller_invoice
     * 对应字段 : agency_tax_no
     */
    private String agencyTaxNo;

    /**
     * 代开机构名称
     * 表 : ant_seller_invoice
     * 对应字段 : agency_name
     */
    private String agencyName;

    /**
     * 是否是代开发票 0否 1是
     * 表 : ant_seller_invoice
     * 对应字段 : is_agency
     */
    private Integer isAgency;

    /**
     * 红字确认单申请状态
     * 表 : ant_seller_invoice
     * 对应字段 : red_letter_apply_status
     */
    private String redLetterApplyStatus;

    /**
     * 扩展1
     * 表 : ant_seller_invoice
     * 对应字段 : ext1
     */
    private String ext1;

    /**
     * 扩展2
     * 表 : ant_seller_invoice
     * 对应字段 : ext2
     */
    private String ext2;

    /**
     * 扩展3
     * 表 : ant_seller_invoice
     * 对应字段 : ext3
     */
    private String ext3;

    /**
     * 扩展4
     * 表 : ant_seller_invoice
     * 对应字段 : ext4
     */
    private String ext4;

    /**
     * 扩展5
     * 表 : ant_seller_invoice
     * 对应字段 : ext5
     */
    private String ext5;

    /**
     * 扩展6
     * 表 : ant_seller_invoice
     * 对应字段 : ext6
     */
    private String ext6;

    /**
     * 扩展7
     * 表 : ant_seller_invoice
     * 对应字段 : ext7
     */
    private String ext7;

    /**
     * 扩展8
     * 表 : ant_seller_invoice
     * 对应字段 : ext8
     */
    private String ext8;

    /**
     * 扩展9
     * 表 : ant_seller_invoice
     * 对应字段 : ext9
     */
    private String ext9;

    /**
     * 扩展10
     * 表 : ant_seller_invoice
     * 对应字段 : ext10
     */
    private String ext10;

    /**
     * 扩展11
     * 表 : ant_seller_invoice
     * 对应字段 : ext11
     */
    private String ext11;

    /**
     * 扩展12
     * 表 : ant_seller_invoice
     * 对应字段 : ext12
     */
    private String ext12;

    /**
     * 扩展13
     * 表 : ant_seller_invoice
     * 对应字段 : ext13
     */
    private String ext13;

    /**
     * 扩展14
     * 表 : ant_seller_invoice
     * 对应字段 : ext14
     */
    private String ext14;

    /**
     * 扩展15
     * 表 : ant_seller_invoice
     * 对应字段 : ext15
     */
    private String ext15;

    /**
     * 扩展16
     * 表 : ant_seller_invoice
     * 对应字段 : ext16
     */
    private String ext16;

    /**
     * 扩展17
     * 表 : ant_seller_invoice
     * 对应字段 : ext17
     */
    private String ext17;

    /**
     * 扩展18
     * 表 : ant_seller_invoice
     * 对应字段 : ext18
     */
    private String ext18;

    /**
     * 扩展19
     * 表 : ant_seller_invoice
     * 对应字段 : ext19
     */
    private String ext19;

    /**
     * 扩展20
     * 表 : ant_seller_invoice
     * 对应字段 : ext20
     */
    private String ext20;

    /**
     * 扩展21
     * 表 : ant_seller_invoice
     * 对应字段 : ext21
     */
    private String ext21;

    /**
     * 扩展22
     * 表 : ant_seller_invoice
     * 对应字段 : ext22
     */
    private String ext22;

    /**
     * 扩展23
     * 表 : ant_seller_invoice
     * 对应字段 : ext23
     */
    private String ext23;

    /**
     * 扩展24
     * 表 : ant_seller_invoice
     * 对应字段 : ext24
     */
    private String ext24;

    /**
     * 扩展25
     * 表 : ant_seller_invoice
     * 对应字段 : ext25
     */
    private String ext25;

    /**
     * 全电发票号码
     * 表 : ant_seller_invoice
     * 对应字段 : all_electric_invoice_no
     */
    private String allElectricInvoiceNo;

    /**
     * get method
     *
     * @return ant_seller_invoice.external_id：外部id
     */
    public String getExternalId() {
        return externalId;
    }

    /**
     * set method
     *
     * @param externalId 外部id
     */
    public void setExternalId(String externalId) {
        this.externalId = externalId == null ? null : externalId.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.pre_invoice_id：预制发票序列号
     */
    public Long getPreInvoiceId() {
        return preInvoiceId;
    }

    /**
     * set method
     *
     * @param preInvoiceId 预制发票序列号
     */
    public void setPreInvoiceId(Long preInvoiceId) {
        this.preInvoiceId = preInvoiceId;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.batch_no：批次号
     */
    public Long getBatchNo() {
        return batchNo;
    }

    /**
     * set method
     *
     * @param batchNo 批次号
     */
    public void setBatchNo(Long batchNo) {
        this.batchNo = batchNo;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.out_batch_no：系统外批次号  默认batch_no的值
     */
    public Long getOutBatchNo() {
        return outBatchNo;
    }

    /**
     * set method
     *
     * @param outBatchNo 系统外批次号  默认batch_no的值
     */
    public void setOutBatchNo(Long outBatchNo) {
        this.outBatchNo = outBatchNo;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.salesbill_id：业务单序号
     */
    public Long getSalesbillId() {
        return salesbillId;
    }

    /**
     * set method
     *
     * @param salesbillId 业务单序号
     */
    public void setSalesbillId(Long salesbillId) {
        this.salesbillId = salesbillId;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.salesbill_no：业务单号
     */
    public String getSalesbillNo() {
        return salesbillNo;
    }

    /**
     * set method
     *
     * @param salesbillNo 业务单号
     */
    public void setSalesbillNo(String salesbillNo) {
        this.salesbillNo = salesbillNo == null ? null : salesbillNo.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.seller_tenant_id：销方租户id
     */
    public Long getSellerTenantId() {
        return sellerTenantId;
    }

    /**
     * set method
     *
     * @param sellerTenantId 销方租户id
     */
    public void setSellerTenantId(Long sellerTenantId) {
        this.sellerTenantId = sellerTenantId;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.seller_no：销方租户公司编号
     */
    public String getSellerNo() {
        return sellerNo;
    }

    /**
     * set method
     *
     * @param sellerNo 销方租户公司编号
     */
    public void setSellerNo(String sellerNo) {
        this.sellerNo = sellerNo == null ? null : sellerNo.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.seller_id：销方公司ID
     */
    public Long getSellerId() {
        return sellerId;
    }

    /**
     * set method
     *
     * @param sellerId 销方公司ID
     */
    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.seller_name：销方名称
     */
    public String getSellerName() {
        return sellerName;
    }

    /**
     * set method
     *
     * @param sellerName 销方名称
     */
    public void setSellerName(String sellerName) {
        this.sellerName = sellerName == null ? null : sellerName.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.seller_tax_no：销方纳税人识别号
     */
    public String getSellerTaxNo() {
        return sellerTaxNo;
    }

    /**
     * set method
     *
     * @param sellerTaxNo 销方纳税人识别号
     */
    public void setSellerTaxNo(String sellerTaxNo) {
        this.sellerTaxNo = sellerTaxNo == null ? null : sellerTaxNo.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.seller_tel：销方电话
     */
    public String getSellerTel() {
        return sellerTel;
    }

    /**
     * set method
     *
     * @param sellerTel 销方电话
     */
    public void setSellerTel(String sellerTel) {
        this.sellerTel = sellerTel == null ? null : sellerTel.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.seller_address：销方地址
     */
    public String getSellerAddress() {
        return sellerAddress;
    }

    /**
     * set method
     *
     * @param sellerAddress 销方地址
     */
    public void setSellerAddress(String sellerAddress) {
        this.sellerAddress = sellerAddress == null ? null : sellerAddress.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.seller_bank_name：销方银行名称
     */
    public String getSellerBankName() {
        return sellerBankName;
    }

    /**
     * set method
     *
     * @param sellerBankName 销方银行名称
     */
    public void setSellerBankName(String sellerBankName) {
        this.sellerBankName = sellerBankName == null ? null : sellerBankName.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.seller_bank_account：销方银行账号
     */
    public String getSellerBankAccount() {
        return sellerBankAccount;
    }

    /**
     * set method
     *
     * @param sellerBankAccount 销方银行账号
     */
    public void setSellerBankAccount(String sellerBankAccount) {
        this.sellerBankAccount = sellerBankAccount == null ? null : sellerBankAccount.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.seller_addr_tel：销方地址电话
     */
    public String getSellerAddrTel() {
        return sellerAddrTel;
    }

    /**
     * set method
     *
     * @param sellerAddrTel 销方地址电话
     */
    public void setSellerAddrTel(String sellerAddrTel) {
        this.sellerAddrTel = sellerAddrTel == null ? null : sellerAddrTel.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.seller_bank_info：销方银行名称账号
     */
    public String getSellerBankInfo() {
        return sellerBankInfo;
    }

    /**
     * set method
     *
     * @param sellerBankInfo 销方银行名称账号
     */
    public void setSellerBankInfo(String sellerBankInfo) {
        this.sellerBankInfo = sellerBankInfo == null ? null : sellerBankInfo.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.purchaser_name：购方名称
     */
    public String getPurchaserName() {
        return purchaserName;
    }

    /**
     * set method
     *
     * @param purchaserName 购方名称
     */
    public void setPurchaserName(String purchaserName) {
        this.purchaserName = purchaserName == null ? null : purchaserName.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.purchaser_tenant_id：购方租户id
     */
    public Long getPurchaserTenantId() {
        return purchaserTenantId;
    }

    /**
     * set method
     *
     * @param purchaserTenantId 购方租户id
     */
    public void setPurchaserTenantId(Long purchaserTenantId) {
        this.purchaserTenantId = purchaserTenantId;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.purchaser_id：购方公司id
     */
    public Long getPurchaserId() {
        return purchaserId;
    }

    /**
     * set method
     *
     * @param purchaserId 购方公司id
     */
    public void setPurchaserId(Long purchaserId) {
        this.purchaserId = purchaserId;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.purchaser_no：购方租户公司编号
     */
    public String getPurchaserNo() {
        return purchaserNo;
    }

    /**
     * set method
     *
     * @param purchaserNo 购方租户公司编号
     */
    public void setPurchaserNo(String purchaserNo) {
        this.purchaserNo = purchaserNo == null ? null : purchaserNo.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.purchaser_tax_no：购方纳税人识别号
     */
    public String getPurchaserTaxNo() {
        return purchaserTaxNo;
    }

    /**
     * set method
     *
     * @param purchaserTaxNo 购方纳税人识别号
     */
    public void setPurchaserTaxNo(String purchaserTaxNo) {
        this.purchaserTaxNo = purchaserTaxNo == null ? null : purchaserTaxNo.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.purchaser_tel：购方电话
     */
    public String getPurchaserTel() {
        return purchaserTel;
    }

    /**
     * set method
     *
     * @param purchaserTel 购方电话
     */
    public void setPurchaserTel(String purchaserTel) {
        this.purchaserTel = purchaserTel == null ? null : purchaserTel.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.purchaser_address：购方地址
     */
    public String getPurchaserAddress() {
        return purchaserAddress;
    }

    /**
     * set method
     *
     * @param purchaserAddress 购方地址
     */
    public void setPurchaserAddress(String purchaserAddress) {
        this.purchaserAddress = purchaserAddress == null ? null : purchaserAddress.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.purchaser_bank_name：购方银行名称
     */
    public String getPurchaserBankName() {
        return purchaserBankName;
    }

    /**
     * set method
     *
     * @param purchaserBankName 购方银行名称
     */
    public void setPurchaserBankName(String purchaserBankName) {
        this.purchaserBankName = purchaserBankName == null ? null : purchaserBankName.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.purchaser_bank_account：购方银行账号
     */
    public String getPurchaserBankAccount() {
        return purchaserBankAccount;
    }

    /**
     * set method
     *
     * @param purchaserBankAccount 购方银行账号
     */
    public void setPurchaserBankAccount(String purchaserBankAccount) {
        this.purchaserBankAccount = purchaserBankAccount == null ? null : purchaserBankAccount.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.purchaser_bank_info：购方银行名称账号
     */
    public String getPurchaserBankInfo() {
        return purchaserBankInfo;
    }

    /**
     * set method
     *
     * @param purchaserBankInfo 购方银行名称账号
     */
    public void setPurchaserBankInfo(String purchaserBankInfo) {
        this.purchaserBankInfo = purchaserBankInfo == null ? null : purchaserBankInfo.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.purchaser_addr_tel：购方地址电话
     */
    public String getPurchaserAddrTel() {
        return purchaserAddrTel;
    }

    /**
     * set method
     *
     * @param purchaserAddrTel 购方地址电话
     */
    public void setPurchaserAddrTel(String purchaserAddrTel) {
        this.purchaserAddrTel = purchaserAddrTel == null ? null : purchaserAddrTel.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.purchaser_e_pay_id：购方电子支付标识
     */
    public String getPurchaserEPayId() {
        return purchaserEPayId;
    }

    /**
     * set method
     *
     * @param purchaserEPayId 购方电子支付标识
     */
    public void setPurchaserEPayId(String purchaserEPayId) {
        this.purchaserEPayId = purchaserEPayId == null ? null : purchaserEPayId.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.invoice_color：红蓝标识 1-蓝票 2-红票 3-红冲票
     */
    public String getInvoiceColor() {
        return invoiceColor;
    }

    /**
     * set method
     *
     * @param invoiceColor 红蓝标识 1-蓝票 2-红票 3-红冲票
     */
    public void setInvoiceColor(String invoiceColor) {
        this.invoiceColor = invoiceColor == null ? null : invoiceColor.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.invoice_type：发票类型
     */
    public String getInvoiceType() {
        return invoiceType;
    }

    /**
     * set method
     *
     * @param invoiceType 发票类型
     */
    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType == null ? null : invoiceType.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.tax_invoice_source：税控发票来源 qd - 全电发票; sk - 税控发票
     */
    public String getTaxInvoiceSource() {
        return taxInvoiceSource;
    }

    /**
     * set method
     *
     * @param taxInvoiceSource 税控发票来源 qd - 全电发票; sk - 税控发票
     */
    public void setTaxInvoiceSource(String taxInvoiceSource) {
        this.taxInvoiceSource = taxInvoiceSource == null ? null : taxInvoiceSource.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.invoice_kind：发票票种 s - 纸专; se - 电专; c - 纸普; ce - 电普; v - 机动车; vs - 二手机动车; ju - 卷票
     */
    public String getInvoiceKind() {
        return invoiceKind;
    }

    /**
     * set method
     *
     * @param invoiceKind 发票票种 s - 纸专; se - 电专; c - 纸普; ce - 电普; v - 机动车; vs - 二手机动车; ju - 卷票
     */
    public void setInvoiceKind(String invoiceKind) {
        this.invoiceKind = invoiceKind == null ? null : invoiceKind.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.invoice_code：发票代码
     */
    public String getInvoiceCode() {
        return invoiceCode;
    }

    /**
     * set method
     *
     * @param invoiceCode 发票代码
     */
    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode == null ? null : invoiceCode.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.invoice_no：发票号码
     */
    public String getInvoiceNo() {
        return invoiceNo;
    }

    /**
     * set method
     *
     * @param invoiceNo 发票号码
     */
    public void setInvoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo == null ? null : invoiceNo.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.machine_code：机器编码
     */
    public String getMachineCode() {
        return machineCode;
    }

    /**
     * set method
     *
     * @param machineCode 机器编码
     */
    public void setMachineCode(String machineCode) {
        this.machineCode = machineCode == null ? null : machineCode.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.paper_draw_date：发票开票日期
     */
    public Date getPaperDrawDate() {
        return paperDrawDate;
    }

    /**
     * set method
     *
     * @param paperDrawDate 发票开票日期
     */
    public void setPaperDrawDate(Date paperDrawDate) {
        this.paperDrawDate = paperDrawDate;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.check_code：校验码
     */
    public String getCheckCode() {
        return checkCode;
    }

    /**
     * set method
     *
     * @param checkCode 校验码
     */
    public void setCheckCode(String checkCode) {
        this.checkCode = checkCode == null ? null : checkCode.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.cashier_name：收款人姓名
     */
    public String getCashierName() {
        return cashierName;
    }

    /**
     * set method
     *
     * @param cashierName 收款人姓名
     */
    public void setCashierName(String cashierName) {
        this.cashierName = cashierName == null ? null : cashierName.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.checker_name：复核人姓名
     */
    public String getCheckerName() {
        return checkerName;
    }

    /**
     * set method
     *
     * @param checkerName 复核人姓名
     */
    public void setCheckerName(String checkerName) {
        this.checkerName = checkerName == null ? null : checkerName.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.invoicer_name：开票人姓名
     */
    public String getInvoicerName() {
        return invoicerName;
    }

    /**
     * set method
     *
     * @param invoicerName 开票人姓名
     */
    public void setInvoicerName(String invoicerName) {
        this.invoicerName = invoicerName == null ? null : invoicerName.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.remark：备注
     */
    public String getRemark() {
        return remark;
    }

    /**
     * set method
     *
     * @param remark 备注
     */
    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.electronic_signature：电子签名
     */
    public String getElectronicSignature() {
        return electronicSignature;
    }

    /**
     * set method
     *
     * @param electronicSignature 电子签名
     */
    public void setElectronicSignature(String electronicSignature) {
        this.electronicSignature = electronicSignature == null ? null : electronicSignature.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.invoice_origin：发票来源 0-直连开票 1-抽取回填 2-验真回填 3-识别回填 4-手工回填 5-预制发票回填 6-底账回填 7-OFD解析
     */
    public String getInvoiceOrigin() {
        return invoiceOrigin;
    }

    /**
     * set method
     *
     * @param invoiceOrigin 发票来源 0-直连开票 1-抽取回填 2-验真回填 3-识别回填 4-手工回填 5-预制发票回填 6-底账回填 7-OFD解析
     */
    public void setInvoiceOrigin(String invoiceOrigin) {
        this.invoiceOrigin = invoiceOrigin == null ? null : invoiceOrigin.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.origin_type：来源方式  0-默认 21-扫码验真  22-手工验真 23-导入验真 24-识别验真
     */
    public Integer getOriginType() {
        return originType;
    }

    /**
     * set method
     *
     * @param originType 来源方式  0-默认 21-扫码验真  22-手工验真 23-导入验真 24-识别验真
     */
    public void setOriginType(Integer originType) {
        this.originType = originType;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.system_orig：系统来源 下发数据需要  由属地直接传过来
     */
    public String getSystemOrig() {
        return systemOrig;
    }

    /**
     * set method
     *
     * @param systemOrig 系统来源 下发数据需要  由属地直接传过来
     */
    public void setSystemOrig(String systemOrig) {
        this.systemOrig = systemOrig == null ? null : systemOrig.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.special_invoice_flag：特殊发票标记  0-默认  1-通行费   2-成品油
     */
    public String getSpecialInvoiceFlag() {
        return specialInvoiceFlag;
    }

    /**
     * set method
     *
     * @param specialInvoiceFlag 特殊发票标记  0-默认  1-通行费   2-成品油
     */
    public void setSpecialInvoiceFlag(String specialInvoiceFlag) {
        this.specialInvoiceFlag = specialInvoiceFlag == null ? null : specialInvoiceFlag.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.bill_type：单据类型
     */
    public String getBillType() {
        return billType;
    }

    /**
     * set method
     *
     * @param billType 单据类型
     */
    public void setBillType(String billType) {
        this.billType = billType == null ? null : billType.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.business_bill_type：适用业务单据类型
     */
    public String getBusinessBillType() {
        return businessBillType;
    }

    /**
     * set method
     *
     * @param businessBillType 适用业务单据类型
     */
    public void setBusinessBillType(String businessBillType) {
        this.businessBillType = businessBillType == null ? null : businessBillType.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.amount_with_tax：含税金额
     */
    public BigDecimal getAmountWithTax() {
        return amountWithTax;
    }

    /**
     * set method
     *
     * @param amountWithTax 含税金额
     */
    public void setAmountWithTax(BigDecimal amountWithTax) {
        this.amountWithTax = amountWithTax;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.amount_without_tax：不含税金额
     */
    public BigDecimal getAmountWithoutTax() {
        return amountWithoutTax;
    }

    /**
     * set method
     *
     * @param amountWithoutTax 不含税金额
     */
    public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.tax_amount：税额
     */
    public BigDecimal getTaxAmount() {
        return taxAmount;
    }

    /**
     * set method
     *
     * @param taxAmount 税额
     */
    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.tax_rate：税率
     */
    public String getTaxRate() {
        return taxRate;
    }

    /**
     * set method
     *
     * @param taxRate 税率
     */
    public void setTaxRate(String taxRate) {
        this.taxRate = taxRate == null ? null : taxRate.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.origin_invoice_no：原发票号码
     */
    public String getOriginInvoiceNo() {
        return originInvoiceNo;
    }

    /**
     * set method
     *
     * @param originInvoiceNo 原发票号码
     */
    public void setOriginInvoiceNo(String originInvoiceNo) {
        this.originInvoiceNo = originInvoiceNo == null ? null : originInvoiceNo.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.origin_invoice_code：原发票代码
     */
    public String getOriginInvoiceCode() {
        return originInvoiceCode;
    }

    /**
     * set method
     *
     * @param originInvoiceCode 原发票代码
     */
    public void setOriginInvoiceCode(String originInvoiceCode) {
        this.originInvoiceCode = originInvoiceCode == null ? null : originInvoiceCode.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.origin_invoice_type：原蓝票发票类型
     */
    public String getOriginInvoiceType() {
        return originInvoiceType;
    }

    /**
     * set method
     *
     * @param originInvoiceType 原蓝票发票类型
     */
    public void setOriginInvoiceType(String originInvoiceType) {
        this.originInvoiceType = originInvoiceType == null ? null : originInvoiceType.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.origin_paper_draw_date：原蓝票的开票日期 YYYYMMDD
     */
    public String getOriginPaperDrawDate() {
        return originPaperDrawDate;
    }

    /**
     * set method
     *
     * @param originPaperDrawDate 原蓝票的开票日期 YYYYMMDD
     */
    public void setOriginPaperDrawDate(String originPaperDrawDate) {
        this.originPaperDrawDate = originPaperDrawDate == null ? null : originPaperDrawDate.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.cipher_text：密文
     */
    public String getCipherText() {
        return cipherText;
    }

    /**
     * set method
     *
     * @param cipherText 密文
     */
    public void setCipherText(String cipherText) {
        this.cipherText = cipherText == null ? null : cipherText.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.cipher_text_two_code：二维密文
     */
    public String getCipherTextTwoCode() {
        return cipherTextTwoCode;
    }

    /**
     * set method
     *
     * @param cipherTextTwoCode 二维密文
     */
    public void setCipherTextTwoCode(String cipherTextTwoCode) {
        this.cipherTextTwoCode = cipherTextTwoCode == null ? null : cipherTextTwoCode.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.drawout_time：抽取时间
     */
    public Date getDrawoutTime() {
        return drawoutTime;
    }

    /**
     * set method
     *
     * @param drawoutTime 抽取时间
     */
    public void setDrawoutTime(Date drawoutTime) {
        this.drawoutTime = drawoutTime;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.drawout_user_id：抽取操作账号
     */
    public Long getDrawoutUserId() {
        return drawoutUserId;
    }

    /**
     * set method
     *
     * @param drawoutUserId 抽取操作账号
     */
    public void setDrawoutUserId(Long drawoutUserId) {
        this.drawoutUserId = drawoutUserId;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.abandon_flag：作废标识 0-默认 1-批次内 2-批次外
     */
    public String getAbandonFlag() {
        return abandonFlag;
    }

    /**
     * set method
     *
     * @param abandonFlag 作废标识 0-默认 1-批次内 2-批次外
     */
    public void setAbandonFlag(String abandonFlag) {
        this.abandonFlag = abandonFlag == null ? null : abandonFlag.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.red_time：红冲时间
     */
    public Date getRedTime() {
        return redTime;
    }

    /**
     * set method
     *
     * @param redTime 红冲时间
     */
    public void setRedTime(Date redTime) {
        this.redTime = redTime;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.red_user_id：红冲人id
     */
    public Long getRedUserId() {
        return redUserId;
    }

    /**
     * set method
     *
     * @param redUserId 红冲人id
     */
    public void setRedUserId(Long redUserId) {
        this.redUserId = redUserId;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.red_user_name：红冲人姓名
     */
    public String getRedUserName() {
        return redUserName;
    }

    /**
     * set method
     *
     * @param redUserName 红冲人姓名
     */
    public void setRedUserName(String redUserName) {
        this.redUserName = redUserName == null ? null : redUserName.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.red_flag：红冲状态 0-默认 1-待红冲 2-待部分红冲3-红冲4-部分红冲5-红冲票
     */
    public String getRedFlag() {
        return redFlag;
    }

    /**
     * set method
     *
     * @param redFlag 红冲状态 0-默认 1-待红冲 2-待部分红冲3-红冲4-部分红冲5-红冲票
     */
    public void setRedFlag(String redFlag) {
        this.redFlag = redFlag == null ? null : redFlag.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.red_notification_no：红字信息表编号
     */
    public String getRedNotificationNo() {
        return redNotificationNo;
    }

    /**
     * set method
     *
     * @param redNotificationNo 红字信息表编号
     */
    public void setRedNotificationNo(String redNotificationNo) {
        this.redNotificationNo = redNotificationNo == null ? null : redNotificationNo.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.drawout_status：抽取状态 0-默认状态：非抽取
     */
    public Integer getDrawoutStatus() {
        return drawoutStatus;
    }

    /**
     * set method
     *
     * @param drawoutStatus 抽取状态 0-默认状态：非抽取
     */
    public void setDrawoutStatus(Integer drawoutStatus) {
        this.drawoutStatus = drawoutStatus;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.status：发票状态1-正常 0-作废 2-待处理 9-删除
     */
    public Integer getStatus() {
        return status;
    }

    /**
     * set method
     *
     * @param status 发票状态1-正常 0-作废 2-待处理 9-删除
     */
    public void setStatus(Integer status) {
        this.status = status;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.sale_list_file_flag：销货清单文件打印标志（0-否,1-是）默认0
     */
    public Integer getSaleListFileFlag() {
        return saleListFileFlag;
    }

    /**
     * set method
     *
     * @param saleListFileFlag 销货清单文件打印标志（0-否,1-是）默认0
     */
    public void setSaleListFileFlag(Integer saleListFileFlag) {
        this.saleListFileFlag = saleListFileFlag;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.print_content_flag：打印内容标志0-打印单价和数量1-不打印单价和数量,默认0
     */
    public Integer getPrintContentFlag() {
        return printContentFlag;
    }

    /**
     * set method
     *
     * @param printContentFlag 打印内容标志0-打印单价和数量1-不打印单价和数量,默认0
     */
    public void setPrintContentFlag(Integer printContentFlag) {
        this.printContentFlag = printContentFlag;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.pdf_path：pdf路径
     */
    public String getPdfPath() {
        return pdfPath;
    }

    /**
     * set method
     *
     * @param pdfPath pdf路径
     */
    public void setPdfPath(String pdfPath) {
        this.pdfPath = pdfPath == null ? null : pdfPath.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.ofd_to_img：ofd转换成的图片地址
     */
    public String getOfdToImg() {
        return ofdToImg;
    }

    /**
     * set method
     *
     * @param ofdToImg ofd转换成的图片地址
     */
    public void setOfdToImg(String ofdToImg) {
        this.ofdToImg = ofdToImg == null ? null : ofdToImg.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.xml_url：xml地址
     */
    public String getXmlUrl() {
        return xmlUrl;
    }

    /**
     * set method
     *
     * @param xmlUrl xml地址
     */
    public void setXmlUrl(String xmlUrl) {
        this.xmlUrl = xmlUrl == null ? null : xmlUrl.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.qr_code_url：二维码地址
     */
    public String getQrCodeUrl() {
        return qrCodeUrl;
    }

    /**
     * set method
     *
     * @param qrCodeUrl 二维码地址
     */
    public void setQrCodeUrl(String qrCodeUrl) {
        this.qrCodeUrl = qrCodeUrl == null ? null : qrCodeUrl.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.ofd_to_pdf：ofd转换成的PDF地址
     */
    public String getOfdToPdf() {
        return ofdToPdf;
    }

    /**
     * set method
     *
     * @param ofdToPdf ofd转换成的PDF地址
     */
    public void setOfdToPdf(String ofdToPdf) {
        this.ofdToPdf = ofdToPdf == null ? null : ofdToPdf.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.receive_user_email：接收人邮箱
     */
    public String getReceiveUserEmail() {
        return receiveUserEmail;
    }

    /**
     * set method
     *
     * @param receiveUserEmail 接收人邮箱
     */
    public void setReceiveUserEmail(String receiveUserEmail) {
        this.receiveUserEmail = receiveUserEmail == null ? null : receiveUserEmail.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.receive_user_tel：接收人电话
     */
    public String getReceiveUserTel() {
        return receiveUserTel;
    }

    /**
     * set method
     *
     * @param receiveUserTel 接收人电话
     */
    public void setReceiveUserTel(String receiveUserTel) {
        this.receiveUserTel = receiveUserTel == null ? null : receiveUserTel.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.make_out_unit_name：开票点名称
     */
    public String getMakeOutUnitName() {
        return makeOutUnitName;
    }

    /**
     * set method
     *
     * @param makeOutUnitName 开票点名称
     */
    public void setMakeOutUnitName(String makeOutUnitName) {
        this.makeOutUnitName = makeOutUnitName == null ? null : makeOutUnitName.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.handle_status：处理状态 1-正常  2-处理中
     */
    public String getHandleStatus() {
        return handleStatus;
    }

    /**
     * set method
     *
     * @param handleStatus 处理状态 1-正常  2-处理中
     */
    public void setHandleStatus(String handleStatus) {
        this.handleStatus = handleStatus == null ? null : handleStatus.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.handle_remark：处理备注
     */
    public String getHandleRemark() {
        return handleRemark;
    }

    /**
     * set method
     *
     * @param handleRemark 处理备注
     */
    public void setHandleRemark(String handleRemark) {
        this.handleRemark = handleRemark == null ? null : handleRemark.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.out_check_status：外部批次生成标志 1-不生成 0-生成
     */
    public String getOutCheckStatus() {
        return outCheckStatus;
    }

    /**
     * set method
     *
     * @param outCheckStatus 外部批次生成标志 1-不生成 0-生成
     */
    public void setOutCheckStatus(String outCheckStatus) {
        this.outCheckStatus = outCheckStatus == null ? null : outCheckStatus.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.out_lock_config：系统外锁定配置 0-锁红冲作废 1-锁红冲 2-锁作废
     */
    public String getOutLockConfig() {
        return outLockConfig;
    }

    /**
     * set method
     *
     * @param outLockConfig 系统外锁定配置 0-锁红冲作废 1-锁红冲 2-锁作废
     */
    public void setOutLockConfig(String outLockConfig) {
        this.outLockConfig = outLockConfig == null ? null : outLockConfig.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.verify_status：查验状态 0-未查验(默认) 2-查验中 3-查验成功 4-查验失败 5-次日查
     */
    public Integer getVerifyStatus() {
        return verifyStatus;
    }

    /**
     * set method
     *
     * @param verifyStatus 查验状态 0-未查验(默认) 2-查验中 3-查验成功 4-查验失败 5-次日查
     */
    public void setVerifyStatus(Integer verifyStatus) {
        this.verifyStatus = verifyStatus;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.verify_request_time：查验发送时间
     */
    public Date getVerifyRequestTime() {
        return verifyRequestTime;
    }

    /**
     * set method
     *
     * @param verifyRequestTime 查验发送时间
     */
    public void setVerifyRequestTime(Date verifyRequestTime) {
        this.verifyRequestTime = verifyRequestTime;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.verify_response_time：查验完成时间
     */
    public Date getVerifyResponseTime() {
        return verifyResponseTime;
    }

    /**
     * set method
     *
     * @param verifyResponseTime 查验完成时间
     */
    public void setVerifyResponseTime(Date verifyResponseTime) {
        this.verifyResponseTime = verifyResponseTime;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.verify_remark：查验备注
     */
    public String getVerifyRemark() {
        return verifyRemark;
    }

    /**
     * set method
     *
     * @param verifyRemark 查验备注
     */
    public void setVerifyRemark(String verifyRemark) {
        this.verifyRemark = verifyRemark == null ? null : verifyRemark.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.gain_status：获取状态 0-默认 1-获取中 2-获取成功 3-获取失败
     */
    public Integer getGainStatus() {
        return gainStatus;
    }

    /**
     * set method
     *
     * @param gainStatus 获取状态 0-默认 1-获取中 2-获取成功 3-获取失败
     */
    public void setGainStatus(Integer gainStatus) {
        this.gainStatus = gainStatus;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.gain_time：获取时间
     */
    public Date getGainTime() {
        return gainTime;
    }

    /**
     * set method
     *
     * @param gainTime 获取时间
     */
    public void setGainTime(Date gainTime) {
        this.gainTime = gainTime;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.gain_remark：获取备注
     */
    public String getGainRemark() {
        return gainRemark;
    }

    /**
     * set method
     *
     * @param gainRemark 获取备注
     */
    public void setGainRemark(String gainRemark) {
        this.gainRemark = gainRemark == null ? null : gainRemark.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.associate_status：关联状态 0-默认 1-关联中 2-关联成功 3-关联失败
     */
    public Integer getAssociateStatus() {
        return associateStatus;
    }

    /**
     * set method
     *
     * @param associateStatus 关联状态 0-默认 1-关联中 2-关联成功 3-关联失败
     */
    public void setAssociateStatus(Integer associateStatus) {
        this.associateStatus = associateStatus;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.associate_time：关联时间
     */
    public Date getAssociateTime() {
        return associateTime;
    }

    /**
     * set method
     *
     * @param associateTime 关联时间
     */
    public void setAssociateTime(Date associateTime) {
        this.associateTime = associateTime;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.associate_remark：关联备注
     */
    public String getAssociateRemark() {
        return associateRemark;
    }

    /**
     * set method
     *
     * @param associateRemark 关联备注
     */
    public void setAssociateRemark(String associateRemark) {
        this.associateRemark = associateRemark == null ? null : associateRemark.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.lock_status：锁定状态1-已锁定 0-未锁定
     */
    public String getLockStatus() {
        return lockStatus;
    }

    /**
     * set method
     *
     * @param lockStatus 锁定状态1-已锁定 0-未锁定
     */
    public void setLockStatus(String lockStatus) {
        this.lockStatus = lockStatus == null ? null : lockStatus.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.scan_status：扫描状态 0-未扫描 1-已扫描
     */
    public Integer getScanStatus() {
        return scanStatus;
    }

    /**
     * set method
     *
     * @param scanStatus 扫描状态 0-未扫描 1-已扫描
     */
    public void setScanStatus(Integer scanStatus) {
        this.scanStatus = scanStatus;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.scan_image_url：扫描发票图片路径
     */
    public String getScanImageUrl() {
        return scanImageUrl;
    }

    /**
     * set method
     *
     * @param scanImageUrl 扫描发票图片路径
     */
    public void setScanImageUrl(String scanImageUrl) {
        this.scanImageUrl = scanImageUrl == null ? null : scanImageUrl.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.scan_time：扫描时间
     */
    public Date getScanTime() {
        return scanTime;
    }

    /**
     * set method
     *
     * @param scanTime 扫描时间
     */
    public void setScanTime(Date scanTime) {
        this.scanTime = scanTime;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.image_upload_status：影像上传状态 0-未上传 1-已上传
     */
    public Integer getImageUploadStatus() {
        return imageUploadStatus;
    }

    /**
     * set method
     *
     * @param imageUploadStatus 影像上传状态 0-未上传 1-已上传
     */
    public void setImageUploadStatus(Integer imageUploadStatus) {
        this.imageUploadStatus = imageUploadStatus;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.image_upload_time：影像上传时间
     */
    public Date getImageUploadTime() {
        return imageUploadTime;
    }

    /**
     * set method
     *
     * @param imageUploadTime 影像上传时间
     */
    public void setImageUploadTime(Date imageUploadTime) {
        this.imageUploadTime = imageUploadTime;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.receipt_status：签收状态 0-无物流信息 1-未签收 2-已签收
     */
    public Integer getReceiptStatus() {
        return receiptStatus;
    }

    /**
     * set method
     *
     * @param receiptStatus 签收状态 0-无物流信息 1-未签收 2-已签收
     */
    public void setReceiptStatus(Integer receiptStatus) {
        this.receiptStatus = receiptStatus;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.receipt_time：签收时间
     */
    public Date getReceiptTime() {
        return receiptTime;
    }

    /**
     * set method
     *
     * @param receiptTime 签收时间
     */
    public void setReceiptTime(Date receiptTime) {
        this.receiptTime = receiptTime;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.identify_status：认证状态 0-默认 1-不可认证 2-未认证 3-认证中 4-已勾选 5-认证失败 6-认证异常 7-已转出 8-已认证
     */
    public String getIdentifyStatus() {
        return identifyStatus;
    }

    /**
     * set method
     *
     * @param identifyStatus 认证状态 0-默认 1-不可认证 2-未认证 3-认证中 4-已勾选 5-认证失败 6-认证异常 7-已转出 8-已认证
     */
    public void setIdentifyStatus(String identifyStatus) {
        this.identifyStatus = identifyStatus == null ? null : identifyStatus.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.identify_time：认证时间
     */
    public Date getIdentifyTime() {
        return identifyTime;
    }

    /**
     * set method
     *
     * @param identifyTime 认证时间
     */
    public void setIdentifyTime(Date identifyTime) {
        this.identifyTime = identifyTime;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.check_time：勾选时间
     */
    public Date getCheckTime() {
        return checkTime;
    }

    /**
     * set method
     *
     * @param checkTime 勾选时间
     */
    public void setCheckTime(Date checkTime) {
        this.checkTime = checkTime;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.print_status：打印状态1-已打印 0-未打印
     */
    public String getPrintStatus() {
        return printStatus;
    }

    /**
     * set method
     *
     * @param printStatus 打印状态1-已打印 0-未打印
     */
    public void setPrintStatus(String printStatus) {
        this.printStatus = printStatus == null ? null : printStatus.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.retreat_status：退票状态 0-未退(默认) 1-已退
     */
    public String getRetreatStatus() {
        return retreatStatus;
    }

    /**
     * set method
     *
     * @param retreatStatus 退票状态 0-未退(默认) 1-已退
     */
    public void setRetreatStatus(String retreatStatus) {
        this.retreatStatus = retreatStatus == null ? null : retreatStatus.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.retreat_time：退票时间
     */
    public Date getRetreatTime() {
        return retreatTime;
    }

    /**
     * set method
     *
     * @param retreatTime 退票时间
     */
    public void setRetreatTime(Date retreatTime) {
        this.retreatTime = retreatTime;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.approve_status：审核状态 0-未审核 1-已审核
     */
    public Integer getApproveStatus() {
        return approveStatus;
    }

    /**
     * set method
     *
     * @param approveStatus 审核状态 0-未审核 1-已审核
     */
    public void setApproveStatus(Integer approveStatus) {
        this.approveStatus = approveStatus;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.approve_time：审核时间
     */
    public Date getApproveTime() {
        return approveTime;
    }

    /**
     * set method
     *
     * @param approveTime 审核时间
     */
    public void setApproveTime(Date approveTime) {
        this.approveTime = approveTime;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.payment_status：付款状态 0-未付款(默认) 1-部分付款 2-已付款
     */
    public String getPaymentStatus() {
        return paymentStatus;
    }

    /**
     * set method
     *
     * @param paymentStatus 付款状态 0-未付款(默认) 1-部分付款 2-已付款
     */
    public void setPaymentStatus(String paymentStatus) {
        this.paymentStatus = paymentStatus == null ? null : paymentStatus.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.payment_time：付款时间
     */
    public Date getPaymentTime() {
        return paymentTime;
    }

    /**
     * set method
     *
     * @param paymentTime 付款时间
     */
    public void setPaymentTime(Date paymentTime) {
        this.paymentTime = paymentTime;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.parcel_no：物流单号
     */
    public String getParcelNo() {
        return parcelNo;
    }

    /**
     * set method
     *
     * @param parcelNo 物流单号
     */
    public void setParcelNo(String parcelNo) {
        this.parcelNo = parcelNo == null ? null : parcelNo.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.express_code：物流公司代码
     */
    public String getExpressCode() {
        return expressCode;
    }

    /**
     * set method
     *
     * @param expressCode 物流公司代码
     */
    public void setExpressCode(String expressCode) {
        this.expressCode = expressCode == null ? null : expressCode.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.cooperate_flag：协同状态 0-不协同 1-协同
     */
    public Integer getCooperateFlag() {
        return cooperateFlag;
    }

    /**
     * set method
     *
     * @param cooperateFlag 协同状态 0-不协同 1-协同
     */
    public void setCooperateFlag(Integer cooperateFlag) {
        this.cooperateFlag = cooperateFlag;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.make_out_unit_code：开票点代码
     */
    public String getMakeOutUnitCode() {
        return makeOutUnitCode;
    }

    /**
     * set method
     *
     * @param makeOutUnitCode 开票点代码
     */
    public void setMakeOutUnitCode(String makeOutUnitCode) {
        this.makeOutUnitCode = makeOutUnitCode == null ? null : makeOutUnitCode.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.device_un：设备唯一码
     */
    public String getDeviceUn() {
        return deviceUn;
    }

    /**
     * set method
     *
     * @param deviceUn 设备唯一码
     */
    public void setDeviceUn(String deviceUn) {
        this.deviceUn = deviceUn == null ? null : deviceUn.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.terminal_un：终端唯一码
     */
    public String getTerminalUn() {
        return terminalUn;
    }

    /**
     * set method
     *
     * @param terminalUn 终端唯一码
     */
    public void setTerminalUn(String terminalUn) {
        this.terminalUn = terminalUn == null ? null : terminalUn.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.terminal_type：终端类型 1-单盘 2-服务器 4-区块链
     */
    public Integer getTerminalType() {
        return terminalType;
    }

    /**
     * set method
     *
     * @param terminalType 终端类型 1-单盘 2-服务器 4-区块链
     */
    public void setTerminalType(Integer terminalType) {
        this.terminalType = terminalType;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.create_user_name：创建人姓名
     */
    public String getCreateUserName() {
        return createUserName;
    }

    /**
     * set method
     *
     * @param createUserName 创建人姓名
     */
    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName == null ? null : createUserName.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.create_time：创建时间
     */
    public Date getCreateTime() {
        return createTime;
    }

    /**
     * set method
     *
     * @param createTime 创建时间
     */
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.create_user_id：创建人账号
     */
    public Long getCreateUserId() {
        return createUserId;
    }

    /**
     * set method
     *
     * @param createUserId 创建人账号
     */
    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.update_time：修改时间
     */
    public Date getUpdateTime() {
        return updateTime;
    }

    /**
     * set method
     *
     * @param updateTime 修改时间
     */
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.update_user_name：更新人姓名
     */
    public String getUpdateUserName() {
        return updateUserName;
    }

    /**
     * set method
     *
     * @param updateUserName 更新人姓名
     */
    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName == null ? null : updateUserName.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.update_user_id：更新账号
     */
    public Long getUpdateUserId() {
        return updateUserId;
    }

    /**
     * set method
     *
     * @param updateUserId 更新账号
     */
    public void setUpdateUserId(Long updateUserId) {
        this.updateUserId = updateUserId;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.delete_time：删除时间
     */
    public Date getDeleteTime() {
        return deleteTime;
    }

    /**
     * set method
     *
     * @param deleteTime 删除时间
     */
    public void setDeleteTime(Date deleteTime) {
        this.deleteTime = deleteTime;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.delete_user_id：删除操作账号
     */
    public Long getDeleteUserId() {
        return deleteUserId;
    }

    /**
     * set method
     *
     * @param deleteUserId 删除操作账号
     */
    public void setDeleteUserId(Long deleteUserId) {
        this.deleteUserId = deleteUserId;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.depose_user_name：作废的人名字
     */
    public String getDeposeUserName() {
        return deposeUserName;
    }

    /**
     * set method
     *
     * @param deposeUserName 作废的人名字
     */
    public void setDeposeUserName(String deposeUserName) {
        this.deposeUserName = deposeUserName == null ? null : deposeUserName.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.depose_time：作废时间
     */
    public Date getDeposeTime() {
        return deposeTime;
    }

    /**
     * set method
     *
     * @param deposeTime 作废时间
     */
    public void setDeposeTime(Date deposeTime) {
        this.deposeTime = deposeTime;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.depose_user_id：作废操作账号
     */
    public Long getDeposeUserId() {
        return deposeUserId;
    }

    /**
     * set method
     *
     * @param deposeUserId 作废操作账号
     */
    public void setDeposeUserId(Long deposeUserId) {
        this.deposeUserId = deposeUserId;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.customer_no：用户Id 下发数据需要  由属地直接传过来
     */
    public String getCustomerNo() {
        return customerNo;
    }

    /**
     * set method
     *
     * @param customerNo 用户Id 下发数据需要  由属地直接传过来
     */
    public void setCustomerNo(String customerNo) {
        this.customerNo = customerNo == null ? null : customerNo.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.sys_org_id：权限ID
     */
    public Long getSysOrgId() {
        return sysOrgId;
    }

    /**
     * set method
     *
     * @param sysOrgId 权限ID
     */
    public void setSysOrgId(Long sysOrgId) {
        this.sysOrgId = sysOrgId;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.invoice_url：辅助抽取发票详情的URL
     */
    public String getInvoiceUrl() {
        return invoiceUrl;
    }

    /**
     * set method
     *
     * @param invoiceUrl 辅助抽取发票详情的URL
     */
    public void setInvoiceUrl(String invoiceUrl) {
        this.invoiceUrl = invoiceUrl == null ? null : invoiceUrl.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.source_line：来源产品线
     */
    public String getSourceLine() {
        return sourceLine;
    }

    /**
     * set method
     *
     * @param sourceLine 来源产品线
     */
    public void setSourceLine(String sourceLine) {
        this.sourceLine = sourceLine == null ? null : sourceLine.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.agency_tax_no：代开机构税号
     */
    public String getAgencyTaxNo() {
        return agencyTaxNo;
    }

    /**
     * set method
     *
     * @param agencyTaxNo 代开机构税号
     */
    public void setAgencyTaxNo(String agencyTaxNo) {
        this.agencyTaxNo = agencyTaxNo == null ? null : agencyTaxNo.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.agency_name：代开机构名称
     */
    public String getAgencyName() {
        return agencyName;
    }

    /**
     * set method
     *
     * @param agencyName 代开机构名称
     */
    public void setAgencyName(String agencyName) {
        this.agencyName = agencyName == null ? null : agencyName.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.is_agency：是否是代开发票 0否 1是
     */
    public Integer getIsAgency() {
        return isAgency;
    }

    /**
     * set method
     *
     * @param isAgency 是否是代开发票 0否 1是
     */
    public void setIsAgency(Integer isAgency) {
        this.isAgency = isAgency;
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.red_letter_apply_status：红字确认单申请状态
     */
    public String getRedLetterApplyStatus() {
        return redLetterApplyStatus;
    }

    /**
     * set method
     *
     * @param redLetterApplyStatus 红字确认单申请状态
     */
    public void setRedLetterApplyStatus(String redLetterApplyStatus) {
        this.redLetterApplyStatus = redLetterApplyStatus == null ? null : redLetterApplyStatus.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.ext1：扩展1
     */
    public String getExt1() {
        return ext1;
    }

    /**
     * set method
     *
     * @param ext1 扩展1
     */
    public void setExt1(String ext1) {
        this.ext1 = ext1 == null ? null : ext1.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.ext2：扩展2
     */
    public String getExt2() {
        return ext2;
    }

    /**
     * set method
     *
     * @param ext2 扩展2
     */
    public void setExt2(String ext2) {
        this.ext2 = ext2 == null ? null : ext2.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.ext3：扩展3
     */
    public String getExt3() {
        return ext3;
    }

    /**
     * set method
     *
     * @param ext3 扩展3
     */
    public void setExt3(String ext3) {
        this.ext3 = ext3 == null ? null : ext3.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.ext4：扩展4
     */
    public String getExt4() {
        return ext4;
    }

    /**
     * set method
     *
     * @param ext4 扩展4
     */
    public void setExt4(String ext4) {
        this.ext4 = ext4 == null ? null : ext4.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.ext5：扩展5
     */
    public String getExt5() {
        return ext5;
    }

    /**
     * set method
     *
     * @param ext5 扩展5
     */
    public void setExt5(String ext5) {
        this.ext5 = ext5 == null ? null : ext5.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.ext6：扩展6
     */
    public String getExt6() {
        return ext6;
    }

    /**
     * set method
     *
     * @param ext6 扩展6
     */
    public void setExt6(String ext6) {
        this.ext6 = ext6 == null ? null : ext6.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.ext7：扩展7
     */
    public String getExt7() {
        return ext7;
    }

    /**
     * set method
     *
     * @param ext7 扩展7
     */
    public void setExt7(String ext7) {
        this.ext7 = ext7 == null ? null : ext7.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.ext8：扩展8
     */
    public String getExt8() {
        return ext8;
    }

    /**
     * set method
     *
     * @param ext8 扩展8
     */
    public void setExt8(String ext8) {
        this.ext8 = ext8 == null ? null : ext8.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.ext9：扩展9
     */
    public String getExt9() {
        return ext9;
    }

    /**
     * set method
     *
     * @param ext9 扩展9
     */
    public void setExt9(String ext9) {
        this.ext9 = ext9 == null ? null : ext9.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.ext10：扩展10
     */
    public String getExt10() {
        return ext10;
    }

    /**
     * set method
     *
     * @param ext10 扩展10
     */
    public void setExt10(String ext10) {
        this.ext10 = ext10 == null ? null : ext10.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.ext11：扩展11
     */
    public String getExt11() {
        return ext11;
    }

    /**
     * set method
     *
     * @param ext11 扩展11
     */
    public void setExt11(String ext11) {
        this.ext11 = ext11 == null ? null : ext11.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.ext12：扩展12
     */
    public String getExt12() {
        return ext12;
    }

    /**
     * set method
     *
     * @param ext12 扩展12
     */
    public void setExt12(String ext12) {
        this.ext12 = ext12 == null ? null : ext12.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.ext13：扩展13
     */
    public String getExt13() {
        return ext13;
    }

    /**
     * set method
     *
     * @param ext13 扩展13
     */
    public void setExt13(String ext13) {
        this.ext13 = ext13 == null ? null : ext13.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.ext14：扩展14
     */
    public String getExt14() {
        return ext14;
    }

    /**
     * set method
     *
     * @param ext14 扩展14
     */
    public void setExt14(String ext14) {
        this.ext14 = ext14 == null ? null : ext14.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.ext15：扩展15
     */
    public String getExt15() {
        return ext15;
    }

    /**
     * set method
     *
     * @param ext15 扩展15
     */
    public void setExt15(String ext15) {
        this.ext15 = ext15 == null ? null : ext15.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.ext16：扩展16
     */
    public String getExt16() {
        return ext16;
    }

    /**
     * set method
     *
     * @param ext16 扩展16
     */
    public void setExt16(String ext16) {
        this.ext16 = ext16 == null ? null : ext16.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.ext17：扩展17
     */
    public String getExt17() {
        return ext17;
    }

    /**
     * set method
     *
     * @param ext17 扩展17
     */
    public void setExt17(String ext17) {
        this.ext17 = ext17 == null ? null : ext17.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.ext18：扩展18
     */
    public String getExt18() {
        return ext18;
    }

    /**
     * set method
     *
     * @param ext18 扩展18
     */
    public void setExt18(String ext18) {
        this.ext18 = ext18 == null ? null : ext18.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.ext19：扩展19
     */
    public String getExt19() {
        return ext19;
    }

    /**
     * set method
     *
     * @param ext19 扩展19
     */
    public void setExt19(String ext19) {
        this.ext19 = ext19 == null ? null : ext19.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.ext20：扩展20
     */
    public String getExt20() {
        return ext20;
    }

    /**
     * set method
     *
     * @param ext20 扩展20
     */
    public void setExt20(String ext20) {
        this.ext20 = ext20 == null ? null : ext20.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.ext21：扩展21
     */
    public String getExt21() {
        return ext21;
    }

    /**
     * set method
     *
     * @param ext21 扩展21
     */
    public void setExt21(String ext21) {
        this.ext21 = ext21 == null ? null : ext21.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.ext22：扩展22
     */
    public String getExt22() {
        return ext22;
    }

    /**
     * set method
     *
     * @param ext22 扩展22
     */
    public void setExt22(String ext22) {
        this.ext22 = ext22 == null ? null : ext22.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.ext23：扩展23
     */
    public String getExt23() {
        return ext23;
    }

    /**
     * set method
     *
     * @param ext23 扩展23
     */
    public void setExt23(String ext23) {
        this.ext23 = ext23 == null ? null : ext23.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.ext24：扩展24
     */
    public String getExt24() {
        return ext24;
    }

    /**
     * set method
     *
     * @param ext24 扩展24
     */
    public void setExt24(String ext24) {
        this.ext24 = ext24 == null ? null : ext24.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.ext25：扩展25
     */
    public String getExt25() {
        return ext25;
    }

    /**
     * set method
     *
     * @param ext25 扩展25
     */
    public void setExt25(String ext25) {
        this.ext25 = ext25 == null ? null : ext25.trim();
    }

    /**
     * get method
     *
     * @return ant_seller_invoice.all_electric_invoice_no：全电发票号码
     */
    public String getAllElectricInvoiceNo() {
        return allElectricInvoiceNo;
    }

    /**
     * set method
     *
     * @param allElectricInvoiceNo 全电发票号码
     */
    public void setAllElectricInvoiceNo(String allElectricInvoiceNo) {
        this.allElectricInvoiceNo = allElectricInvoiceNo == null ? null : allElectricInvoiceNo.trim();
    }

    /**
     *
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", externalId=").append(externalId);
        sb.append(", preInvoiceId=").append(preInvoiceId);
        sb.append(", batchNo=").append(batchNo);
        sb.append(", outBatchNo=").append(outBatchNo);
        sb.append(", salesbillId=").append(salesbillId);
        sb.append(", salesbillNo=").append(salesbillNo);
        sb.append(", sellerTenantId=").append(sellerTenantId);
        sb.append(", sellerNo=").append(sellerNo);
        sb.append(", sellerId=").append(sellerId);
        sb.append(", sellerName=").append(sellerName);
        sb.append(", sellerTaxNo=").append(sellerTaxNo);
        sb.append(", sellerTel=").append(sellerTel);
        sb.append(", sellerAddress=").append(sellerAddress);
        sb.append(", sellerBankName=").append(sellerBankName);
        sb.append(", sellerBankAccount=").append(sellerBankAccount);
        sb.append(", sellerAddrTel=").append(sellerAddrTel);
        sb.append(", sellerBankInfo=").append(sellerBankInfo);
        sb.append(", purchaserName=").append(purchaserName);
        sb.append(", purchaserTenantId=").append(purchaserTenantId);
        sb.append(", purchaserId=").append(purchaserId);
        sb.append(", purchaserNo=").append(purchaserNo);
        sb.append(", purchaserTaxNo=").append(purchaserTaxNo);
        sb.append(", purchaserTel=").append(purchaserTel);
        sb.append(", purchaserAddress=").append(purchaserAddress);
        sb.append(", purchaserBankName=").append(purchaserBankName);
        sb.append(", purchaserBankAccount=").append(purchaserBankAccount);
        sb.append(", purchaserBankInfo=").append(purchaserBankInfo);
        sb.append(", purchaserAddrTel=").append(purchaserAddrTel);
        sb.append(", purchaserEPayId=").append(purchaserEPayId);
        sb.append(", invoiceColor=").append(invoiceColor);
        sb.append(", invoiceType=").append(invoiceType);
        sb.append(", taxInvoiceSource=").append(taxInvoiceSource);
        sb.append(", invoiceKind=").append(invoiceKind);
        sb.append(", invoiceCode=").append(invoiceCode);
        sb.append(", invoiceNo=").append(invoiceNo);
        sb.append(", machineCode=").append(machineCode);
        sb.append(", paperDrawDate=").append(paperDrawDate);
        sb.append(", checkCode=").append(checkCode);
        sb.append(", cashierName=").append(cashierName);
        sb.append(", checkerName=").append(checkerName);
        sb.append(", invoicerName=").append(invoicerName);
        sb.append(", remark=").append(remark);
        sb.append(", electronicSignature=").append(electronicSignature);
        sb.append(", invoiceOrigin=").append(invoiceOrigin);
        sb.append(", originType=").append(originType);
        sb.append(", systemOrig=").append(systemOrig);
        sb.append(", specialInvoiceFlag=").append(specialInvoiceFlag);
        sb.append(", billType=").append(billType);
        sb.append(", businessBillType=").append(businessBillType);
        sb.append(", amountWithTax=").append(amountWithTax);
        sb.append(", amountWithoutTax=").append(amountWithoutTax);
        sb.append(", taxAmount=").append(taxAmount);
        sb.append(", taxRate=").append(taxRate);
        sb.append(", originInvoiceNo=").append(originInvoiceNo);
        sb.append(", originInvoiceCode=").append(originInvoiceCode);
        sb.append(", originInvoiceType=").append(originInvoiceType);
        sb.append(", originPaperDrawDate=").append(originPaperDrawDate);
        sb.append(", cipherText=").append(cipherText);
        sb.append(", cipherTextTwoCode=").append(cipherTextTwoCode);
        sb.append(", drawoutTime=").append(drawoutTime);
        sb.append(", drawoutUserId=").append(drawoutUserId);
        sb.append(", abandonFlag=").append(abandonFlag);
        sb.append(", redTime=").append(redTime);
        sb.append(", redUserId=").append(redUserId);
        sb.append(", redUserName=").append(redUserName);
        sb.append(", redFlag=").append(redFlag);
        sb.append(", redNotificationNo=").append(redNotificationNo);
        sb.append(", drawoutStatus=").append(drawoutStatus);
        sb.append(", status=").append(status);
        sb.append(", saleListFileFlag=").append(saleListFileFlag);
        sb.append(", printContentFlag=").append(printContentFlag);
        sb.append(", pdfPath=").append(pdfPath);
        sb.append(", ofdToImg=").append(ofdToImg);
        sb.append(", xmlUrl=").append(xmlUrl);
        sb.append(", qrCodeUrl=").append(qrCodeUrl);
        sb.append(", ofdToPdf=").append(ofdToPdf);
        sb.append(", receiveUserEmail=").append(receiveUserEmail);
        sb.append(", receiveUserTel=").append(receiveUserTel);
        sb.append(", makeOutUnitName=").append(makeOutUnitName);
        sb.append(", handleStatus=").append(handleStatus);
        sb.append(", handleRemark=").append(handleRemark);
        sb.append(", outCheckStatus=").append(outCheckStatus);
        sb.append(", outLockConfig=").append(outLockConfig);
        sb.append(", verifyStatus=").append(verifyStatus);
        sb.append(", verifyRequestTime=").append(verifyRequestTime);
        sb.append(", verifyResponseTime=").append(verifyResponseTime);
        sb.append(", verifyRemark=").append(verifyRemark);
        sb.append(", gainStatus=").append(gainStatus);
        sb.append(", gainTime=").append(gainTime);
        sb.append(", gainRemark=").append(gainRemark);
        sb.append(", associateStatus=").append(associateStatus);
        sb.append(", associateTime=").append(associateTime);
        sb.append(", associateRemark=").append(associateRemark);
        sb.append(", lockStatus=").append(lockStatus);
        sb.append(", scanStatus=").append(scanStatus);
        sb.append(", scanImageUrl=").append(scanImageUrl);
        sb.append(", scanTime=").append(scanTime);
        sb.append(", imageUploadStatus=").append(imageUploadStatus);
        sb.append(", imageUploadTime=").append(imageUploadTime);
        sb.append(", receiptStatus=").append(receiptStatus);
        sb.append(", receiptTime=").append(receiptTime);
        sb.append(", identifyStatus=").append(identifyStatus);
        sb.append(", identifyTime=").append(identifyTime);
        sb.append(", checkTime=").append(checkTime);
        sb.append(", printStatus=").append(printStatus);
        sb.append(", retreatStatus=").append(retreatStatus);
        sb.append(", retreatTime=").append(retreatTime);
        sb.append(", approveStatus=").append(approveStatus);
        sb.append(", approveTime=").append(approveTime);
        sb.append(", paymentStatus=").append(paymentStatus);
        sb.append(", paymentTime=").append(paymentTime);
        sb.append(", parcelNo=").append(parcelNo);
        sb.append(", expressCode=").append(expressCode);
        sb.append(", cooperateFlag=").append(cooperateFlag);
        sb.append(", makeOutUnitCode=").append(makeOutUnitCode);
        sb.append(", deviceUn=").append(deviceUn);
        sb.append(", terminalUn=").append(terminalUn);
        sb.append(", terminalType=").append(terminalType);
        sb.append(", createUserName=").append(createUserName);
        sb.append(", createTime=").append(createTime);
        sb.append(", createUserId=").append(createUserId);
        sb.append(", updateTime=").append(updateTime);
        sb.append(", updateUserName=").append(updateUserName);
        sb.append(", updateUserId=").append(updateUserId);
        sb.append(", deleteTime=").append(deleteTime);
        sb.append(", deleteUserId=").append(deleteUserId);
        sb.append(", deposeUserName=").append(deposeUserName);
        sb.append(", deposeTime=").append(deposeTime);
        sb.append(", deposeUserId=").append(deposeUserId);
        sb.append(", customerNo=").append(customerNo);
        sb.append(", sysOrgId=").append(sysOrgId);
        sb.append(", invoiceUrl=").append(invoiceUrl);
        sb.append(", sourceLine=").append(sourceLine);
        sb.append(", agencyTaxNo=").append(agencyTaxNo);
        sb.append(", agencyName=").append(agencyName);
        sb.append(", isAgency=").append(isAgency);
        sb.append(", redLetterApplyStatus=").append(redLetterApplyStatus);
        sb.append(", ext1=").append(ext1);
        sb.append(", ext2=").append(ext2);
        sb.append(", ext3=").append(ext3);
        sb.append(", ext4=").append(ext4);
        sb.append(", ext5=").append(ext5);
        sb.append(", ext6=").append(ext6);
        sb.append(", ext7=").append(ext7);
        sb.append(", ext8=").append(ext8);
        sb.append(", ext9=").append(ext9);
        sb.append(", ext10=").append(ext10);
        sb.append(", ext11=").append(ext11);
        sb.append(", ext12=").append(ext12);
        sb.append(", ext13=").append(ext13);
        sb.append(", ext14=").append(ext14);
        sb.append(", ext15=").append(ext15);
        sb.append(", ext16=").append(ext16);
        sb.append(", ext17=").append(ext17);
        sb.append(", ext18=").append(ext18);
        sb.append(", ext19=").append(ext19);
        sb.append(", ext20=").append(ext20);
        sb.append(", ext21=").append(ext21);
        sb.append(", ext22=").append(ext22);
        sb.append(", ext23=").append(ext23);
        sb.append(", ext24=").append(ext24);
        sb.append(", ext25=").append(ext25);
        sb.append(", allElectricInvoiceNo=").append(allElectricInvoiceNo);
        sb.append("]");
        return sb.toString();
    }

    /**
     * @param that
     */
    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        MixSellerInvoiceEntity other = (MixSellerInvoiceEntity) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
                && (this.getExternalId() == null ? other.getExternalId() == null : this.getExternalId().equals(other.getExternalId()))
                && (this.getPreInvoiceId() == null ? other.getPreInvoiceId() == null : this.getPreInvoiceId().equals(other.getPreInvoiceId()))
                && (this.getBatchNo() == null ? other.getBatchNo() == null : this.getBatchNo().equals(other.getBatchNo()))
                && (this.getOutBatchNo() == null ? other.getOutBatchNo() == null : this.getOutBatchNo().equals(other.getOutBatchNo()))
                && (this.getSalesbillId() == null ? other.getSalesbillId() == null : this.getSalesbillId().equals(other.getSalesbillId()))
                && (this.getSalesbillNo() == null ? other.getSalesbillNo() == null : this.getSalesbillNo().equals(other.getSalesbillNo()))
                && (this.getSellerTenantId() == null ? other.getSellerTenantId() == null : this.getSellerTenantId().equals(other.getSellerTenantId()))
                && (this.getSellerNo() == null ? other.getSellerNo() == null : this.getSellerNo().equals(other.getSellerNo()))
                && (this.getSellerId() == null ? other.getSellerId() == null : this.getSellerId().equals(other.getSellerId()))
                && (this.getSellerName() == null ? other.getSellerName() == null : this.getSellerName().equals(other.getSellerName()))
                && (this.getSellerTaxNo() == null ? other.getSellerTaxNo() == null : this.getSellerTaxNo().equals(other.getSellerTaxNo()))
                && (this.getSellerTel() == null ? other.getSellerTel() == null : this.getSellerTel().equals(other.getSellerTel()))
                && (this.getSellerAddress() == null ? other.getSellerAddress() == null : this.getSellerAddress().equals(other.getSellerAddress()))
                && (this.getSellerBankName() == null ? other.getSellerBankName() == null : this.getSellerBankName().equals(other.getSellerBankName()))
                && (this.getSellerBankAccount() == null ? other.getSellerBankAccount() == null : this.getSellerBankAccount().equals(other.getSellerBankAccount()))
                && (this.getSellerAddrTel() == null ? other.getSellerAddrTel() == null : this.getSellerAddrTel().equals(other.getSellerAddrTel()))
                && (this.getSellerBankInfo() == null ? other.getSellerBankInfo() == null : this.getSellerBankInfo().equals(other.getSellerBankInfo()))
                && (this.getPurchaserName() == null ? other.getPurchaserName() == null : this.getPurchaserName().equals(other.getPurchaserName()))
                && (this.getPurchaserTenantId() == null ? other.getPurchaserTenantId() == null : this.getPurchaserTenantId().equals(other.getPurchaserTenantId()))
                && (this.getPurchaserId() == null ? other.getPurchaserId() == null : this.getPurchaserId().equals(other.getPurchaserId()))
                && (this.getPurchaserNo() == null ? other.getPurchaserNo() == null : this.getPurchaserNo().equals(other.getPurchaserNo()))
                && (this.getPurchaserTaxNo() == null ? other.getPurchaserTaxNo() == null : this.getPurchaserTaxNo().equals(other.getPurchaserTaxNo()))
                && (this.getPurchaserTel() == null ? other.getPurchaserTel() == null : this.getPurchaserTel().equals(other.getPurchaserTel()))
                && (this.getPurchaserAddress() == null ? other.getPurchaserAddress() == null : this.getPurchaserAddress().equals(other.getPurchaserAddress()))
                && (this.getPurchaserBankName() == null ? other.getPurchaserBankName() == null : this.getPurchaserBankName().equals(other.getPurchaserBankName()))
                && (this.getPurchaserBankAccount() == null ? other.getPurchaserBankAccount() == null : this.getPurchaserBankAccount().equals(other.getPurchaserBankAccount()))
                && (this.getPurchaserBankInfo() == null ? other.getPurchaserBankInfo() == null : this.getPurchaserBankInfo().equals(other.getPurchaserBankInfo()))
                && (this.getPurchaserAddrTel() == null ? other.getPurchaserAddrTel() == null : this.getPurchaserAddrTel().equals(other.getPurchaserAddrTel()))
                && (this.getPurchaserEPayId() == null ? other.getPurchaserEPayId() == null : this.getPurchaserEPayId().equals(other.getPurchaserEPayId()))
                && (this.getInvoiceColor() == null ? other.getInvoiceColor() == null : this.getInvoiceColor().equals(other.getInvoiceColor()))
                && (this.getInvoiceType() == null ? other.getInvoiceType() == null : this.getInvoiceType().equals(other.getInvoiceType()))
                && (this.getTaxInvoiceSource() == null ? other.getTaxInvoiceSource() == null : this.getTaxInvoiceSource().equals(other.getTaxInvoiceSource()))
                && (this.getInvoiceKind() == null ? other.getInvoiceKind() == null : this.getInvoiceKind().equals(other.getInvoiceKind()))
                && (this.getInvoiceCode() == null ? other.getInvoiceCode() == null : this.getInvoiceCode().equals(other.getInvoiceCode()))
                && (this.getInvoiceNo() == null ? other.getInvoiceNo() == null : this.getInvoiceNo().equals(other.getInvoiceNo()))
                && (this.getMachineCode() == null ? other.getMachineCode() == null : this.getMachineCode().equals(other.getMachineCode()))
                && (this.getPaperDrawDate() == null ? other.getPaperDrawDate() == null : this.getPaperDrawDate().equals(other.getPaperDrawDate()))
                && (this.getCheckCode() == null ? other.getCheckCode() == null : this.getCheckCode().equals(other.getCheckCode()))
                && (this.getCashierName() == null ? other.getCashierName() == null : this.getCashierName().equals(other.getCashierName()))
                && (this.getCheckerName() == null ? other.getCheckerName() == null : this.getCheckerName().equals(other.getCheckerName()))
                && (this.getInvoicerName() == null ? other.getInvoicerName() == null : this.getInvoicerName().equals(other.getInvoicerName()))
                && (this.getRemark() == null ? other.getRemark() == null : this.getRemark().equals(other.getRemark()))
                && (this.getElectronicSignature() == null ? other.getElectronicSignature() == null : this.getElectronicSignature().equals(other.getElectronicSignature()))
                && (this.getInvoiceOrigin() == null ? other.getInvoiceOrigin() == null : this.getInvoiceOrigin().equals(other.getInvoiceOrigin()))
                && (this.getOriginType() == null ? other.getOriginType() == null : this.getOriginType().equals(other.getOriginType()))
                && (this.getSystemOrig() == null ? other.getSystemOrig() == null : this.getSystemOrig().equals(other.getSystemOrig()))
                && (this.getSpecialInvoiceFlag() == null ? other.getSpecialInvoiceFlag() == null : this.getSpecialInvoiceFlag().equals(other.getSpecialInvoiceFlag()))
                && (this.getBillType() == null ? other.getBillType() == null : this.getBillType().equals(other.getBillType()))
                && (this.getBusinessBillType() == null ? other.getBusinessBillType() == null : this.getBusinessBillType().equals(other.getBusinessBillType()))
                && (this.getAmountWithTax() == null ? other.getAmountWithTax() == null : this.getAmountWithTax().equals(other.getAmountWithTax()))
                && (this.getAmountWithoutTax() == null ? other.getAmountWithoutTax() == null : this.getAmountWithoutTax().equals(other.getAmountWithoutTax()))
                && (this.getTaxAmount() == null ? other.getTaxAmount() == null : this.getTaxAmount().equals(other.getTaxAmount()))
                && (this.getTaxRate() == null ? other.getTaxRate() == null : this.getTaxRate().equals(other.getTaxRate()))
                && (this.getOriginInvoiceNo() == null ? other.getOriginInvoiceNo() == null : this.getOriginInvoiceNo().equals(other.getOriginInvoiceNo()))
                && (this.getOriginInvoiceCode() == null ? other.getOriginInvoiceCode() == null : this.getOriginInvoiceCode().equals(other.getOriginInvoiceCode()))
                && (this.getOriginInvoiceType() == null ? other.getOriginInvoiceType() == null : this.getOriginInvoiceType().equals(other.getOriginInvoiceType()))
                && (this.getOriginPaperDrawDate() == null ? other.getOriginPaperDrawDate() == null : this.getOriginPaperDrawDate().equals(other.getOriginPaperDrawDate()))
                && (this.getCipherText() == null ? other.getCipherText() == null : this.getCipherText().equals(other.getCipherText()))
                && (this.getCipherTextTwoCode() == null ? other.getCipherTextTwoCode() == null : this.getCipherTextTwoCode().equals(other.getCipherTextTwoCode()))
                && (this.getDrawoutTime() == null ? other.getDrawoutTime() == null : this.getDrawoutTime().equals(other.getDrawoutTime()))
                && (this.getDrawoutUserId() == null ? other.getDrawoutUserId() == null : this.getDrawoutUserId().equals(other.getDrawoutUserId()))
                && (this.getAbandonFlag() == null ? other.getAbandonFlag() == null : this.getAbandonFlag().equals(other.getAbandonFlag()))
                && (this.getRedTime() == null ? other.getRedTime() == null : this.getRedTime().equals(other.getRedTime()))
                && (this.getRedUserId() == null ? other.getRedUserId() == null : this.getRedUserId().equals(other.getRedUserId()))
                && (this.getRedUserName() == null ? other.getRedUserName() == null : this.getRedUserName().equals(other.getRedUserName()))
                && (this.getRedFlag() == null ? other.getRedFlag() == null : this.getRedFlag().equals(other.getRedFlag()))
                && (this.getRedNotificationNo() == null ? other.getRedNotificationNo() == null : this.getRedNotificationNo().equals(other.getRedNotificationNo()))
                && (this.getDrawoutStatus() == null ? other.getDrawoutStatus() == null : this.getDrawoutStatus().equals(other.getDrawoutStatus()))
                && (this.getStatus() == null ? other.getStatus() == null : this.getStatus().equals(other.getStatus()))
                && (this.getSaleListFileFlag() == null ? other.getSaleListFileFlag() == null : this.getSaleListFileFlag().equals(other.getSaleListFileFlag()))
                && (this.getPrintContentFlag() == null ? other.getPrintContentFlag() == null : this.getPrintContentFlag().equals(other.getPrintContentFlag()))
                && (this.getPdfPath() == null ? other.getPdfPath() == null : this.getPdfPath().equals(other.getPdfPath()))
                && (this.getOfdToImg() == null ? other.getOfdToImg() == null : this.getOfdToImg().equals(other.getOfdToImg()))
                && (this.getXmlUrl() == null ? other.getXmlUrl() == null : this.getXmlUrl().equals(other.getXmlUrl()))
                && (this.getQrCodeUrl() == null ? other.getQrCodeUrl() == null : this.getQrCodeUrl().equals(other.getQrCodeUrl()))
                && (this.getOfdToPdf() == null ? other.getOfdToPdf() == null : this.getOfdToPdf().equals(other.getOfdToPdf()))
                && (this.getReceiveUserEmail() == null ? other.getReceiveUserEmail() == null : this.getReceiveUserEmail().equals(other.getReceiveUserEmail()))
                && (this.getReceiveUserTel() == null ? other.getReceiveUserTel() == null : this.getReceiveUserTel().equals(other.getReceiveUserTel()))
                && (this.getMakeOutUnitName() == null ? other.getMakeOutUnitName() == null : this.getMakeOutUnitName().equals(other.getMakeOutUnitName()))
                && (this.getHandleStatus() == null ? other.getHandleStatus() == null : this.getHandleStatus().equals(other.getHandleStatus()))
                && (this.getHandleRemark() == null ? other.getHandleRemark() == null : this.getHandleRemark().equals(other.getHandleRemark()))
                && (this.getOutCheckStatus() == null ? other.getOutCheckStatus() == null : this.getOutCheckStatus().equals(other.getOutCheckStatus()))
                && (this.getOutLockConfig() == null ? other.getOutLockConfig() == null : this.getOutLockConfig().equals(other.getOutLockConfig()))
                && (this.getVerifyStatus() == null ? other.getVerifyStatus() == null : this.getVerifyStatus().equals(other.getVerifyStatus()))
                && (this.getVerifyRequestTime() == null ? other.getVerifyRequestTime() == null : this.getVerifyRequestTime().equals(other.getVerifyRequestTime()))
                && (this.getVerifyResponseTime() == null ? other.getVerifyResponseTime() == null : this.getVerifyResponseTime().equals(other.getVerifyResponseTime()))
                && (this.getVerifyRemark() == null ? other.getVerifyRemark() == null : this.getVerifyRemark().equals(other.getVerifyRemark()))
                && (this.getGainStatus() == null ? other.getGainStatus() == null : this.getGainStatus().equals(other.getGainStatus()))
                && (this.getGainTime() == null ? other.getGainTime() == null : this.getGainTime().equals(other.getGainTime()))
                && (this.getGainRemark() == null ? other.getGainRemark() == null : this.getGainRemark().equals(other.getGainRemark()))
                && (this.getAssociateStatus() == null ? other.getAssociateStatus() == null : this.getAssociateStatus().equals(other.getAssociateStatus()))
                && (this.getAssociateTime() == null ? other.getAssociateTime() == null : this.getAssociateTime().equals(other.getAssociateTime()))
                && (this.getAssociateRemark() == null ? other.getAssociateRemark() == null : this.getAssociateRemark().equals(other.getAssociateRemark()))
                && (this.getLockStatus() == null ? other.getLockStatus() == null : this.getLockStatus().equals(other.getLockStatus()))
                && (this.getScanStatus() == null ? other.getScanStatus() == null : this.getScanStatus().equals(other.getScanStatus()))
                && (this.getScanImageUrl() == null ? other.getScanImageUrl() == null : this.getScanImageUrl().equals(other.getScanImageUrl()))
                && (this.getScanTime() == null ? other.getScanTime() == null : this.getScanTime().equals(other.getScanTime()))
                && (this.getImageUploadStatus() == null ? other.getImageUploadStatus() == null : this.getImageUploadStatus().equals(other.getImageUploadStatus()))
                && (this.getImageUploadTime() == null ? other.getImageUploadTime() == null : this.getImageUploadTime().equals(other.getImageUploadTime()))
                && (this.getReceiptStatus() == null ? other.getReceiptStatus() == null : this.getReceiptStatus().equals(other.getReceiptStatus()))
                && (this.getReceiptTime() == null ? other.getReceiptTime() == null : this.getReceiptTime().equals(other.getReceiptTime()))
                && (this.getIdentifyStatus() == null ? other.getIdentifyStatus() == null : this.getIdentifyStatus().equals(other.getIdentifyStatus()))
                && (this.getIdentifyTime() == null ? other.getIdentifyTime() == null : this.getIdentifyTime().equals(other.getIdentifyTime()))
                && (this.getCheckTime() == null ? other.getCheckTime() == null : this.getCheckTime().equals(other.getCheckTime()))
                && (this.getPrintStatus() == null ? other.getPrintStatus() == null : this.getPrintStatus().equals(other.getPrintStatus()))
                && (this.getRetreatStatus() == null ? other.getRetreatStatus() == null : this.getRetreatStatus().equals(other.getRetreatStatus()))
                && (this.getRetreatTime() == null ? other.getRetreatTime() == null : this.getRetreatTime().equals(other.getRetreatTime()))
                && (this.getApproveStatus() == null ? other.getApproveStatus() == null : this.getApproveStatus().equals(other.getApproveStatus()))
                && (this.getApproveTime() == null ? other.getApproveTime() == null : this.getApproveTime().equals(other.getApproveTime()))
                && (this.getPaymentStatus() == null ? other.getPaymentStatus() == null : this.getPaymentStatus().equals(other.getPaymentStatus()))
                && (this.getPaymentTime() == null ? other.getPaymentTime() == null : this.getPaymentTime().equals(other.getPaymentTime()))
                && (this.getParcelNo() == null ? other.getParcelNo() == null : this.getParcelNo().equals(other.getParcelNo()))
                && (this.getExpressCode() == null ? other.getExpressCode() == null : this.getExpressCode().equals(other.getExpressCode()))
                && (this.getCooperateFlag() == null ? other.getCooperateFlag() == null : this.getCooperateFlag().equals(other.getCooperateFlag()))
                && (this.getMakeOutUnitCode() == null ? other.getMakeOutUnitCode() == null : this.getMakeOutUnitCode().equals(other.getMakeOutUnitCode()))
                && (this.getDeviceUn() == null ? other.getDeviceUn() == null : this.getDeviceUn().equals(other.getDeviceUn()))
                && (this.getTerminalUn() == null ? other.getTerminalUn() == null : this.getTerminalUn().equals(other.getTerminalUn()))
                && (this.getTerminalType() == null ? other.getTerminalType() == null : this.getTerminalType().equals(other.getTerminalType()))
                && (this.getCreateUserName() == null ? other.getCreateUserName() == null : this.getCreateUserName().equals(other.getCreateUserName()))
                && (this.getCreateTime() == null ? other.getCreateTime() == null : this.getCreateTime().equals(other.getCreateTime()))
                && (this.getCreateUserId() == null ? other.getCreateUserId() == null : this.getCreateUserId().equals(other.getCreateUserId()))
                && (this.getUpdateTime() == null ? other.getUpdateTime() == null : this.getUpdateTime().equals(other.getUpdateTime()))
                && (this.getUpdateUserName() == null ? other.getUpdateUserName() == null : this.getUpdateUserName().equals(other.getUpdateUserName()))
                && (this.getUpdateUserId() == null ? other.getUpdateUserId() == null : this.getUpdateUserId().equals(other.getUpdateUserId()))
                && (this.getDeleteTime() == null ? other.getDeleteTime() == null : this.getDeleteTime().equals(other.getDeleteTime()))
                && (this.getDeleteUserId() == null ? other.getDeleteUserId() == null : this.getDeleteUserId().equals(other.getDeleteUserId()))
                && (this.getDeposeUserName() == null ? other.getDeposeUserName() == null : this.getDeposeUserName().equals(other.getDeposeUserName()))
                && (this.getDeposeTime() == null ? other.getDeposeTime() == null : this.getDeposeTime().equals(other.getDeposeTime()))
                && (this.getDeposeUserId() == null ? other.getDeposeUserId() == null : this.getDeposeUserId().equals(other.getDeposeUserId()))
                && (this.getCustomerNo() == null ? other.getCustomerNo() == null : this.getCustomerNo().equals(other.getCustomerNo()))
                && (this.getSysOrgId() == null ? other.getSysOrgId() == null : this.getSysOrgId().equals(other.getSysOrgId()))
                && (this.getInvoiceUrl() == null ? other.getInvoiceUrl() == null : this.getInvoiceUrl().equals(other.getInvoiceUrl()))
                && (this.getSourceLine() == null ? other.getSourceLine() == null : this.getSourceLine().equals(other.getSourceLine()))
                && (this.getAgencyTaxNo() == null ? other.getAgencyTaxNo() == null : this.getAgencyTaxNo().equals(other.getAgencyTaxNo()))
                && (this.getAgencyName() == null ? other.getAgencyName() == null : this.getAgencyName().equals(other.getAgencyName()))
                && (this.getIsAgency() == null ? other.getIsAgency() == null : this.getIsAgency().equals(other.getIsAgency()))
                && (this.getRedLetterApplyStatus() == null ? other.getRedLetterApplyStatus() == null : this.getRedLetterApplyStatus().equals(other.getRedLetterApplyStatus()))
                && (this.getExt1() == null ? other.getExt1() == null : this.getExt1().equals(other.getExt1()))
                && (this.getExt2() == null ? other.getExt2() == null : this.getExt2().equals(other.getExt2()))
                && (this.getExt3() == null ? other.getExt3() == null : this.getExt3().equals(other.getExt3()))
                && (this.getExt4() == null ? other.getExt4() == null : this.getExt4().equals(other.getExt4()))
                && (this.getExt5() == null ? other.getExt5() == null : this.getExt5().equals(other.getExt5()))
                && (this.getExt6() == null ? other.getExt6() == null : this.getExt6().equals(other.getExt6()))
                && (this.getExt7() == null ? other.getExt7() == null : this.getExt7().equals(other.getExt7()))
                && (this.getExt8() == null ? other.getExt8() == null : this.getExt8().equals(other.getExt8()))
                && (this.getExt9() == null ? other.getExt9() == null : this.getExt9().equals(other.getExt9()))
                && (this.getExt10() == null ? other.getExt10() == null : this.getExt10().equals(other.getExt10()))
                && (this.getExt11() == null ? other.getExt11() == null : this.getExt11().equals(other.getExt11()))
                && (this.getExt12() == null ? other.getExt12() == null : this.getExt12().equals(other.getExt12()))
                && (this.getExt13() == null ? other.getExt13() == null : this.getExt13().equals(other.getExt13()))
                && (this.getExt14() == null ? other.getExt14() == null : this.getExt14().equals(other.getExt14()))
                && (this.getExt15() == null ? other.getExt15() == null : this.getExt15().equals(other.getExt15()))
                && (this.getExt16() == null ? other.getExt16() == null : this.getExt16().equals(other.getExt16()))
                && (this.getExt17() == null ? other.getExt17() == null : this.getExt17().equals(other.getExt17()))
                && (this.getExt18() == null ? other.getExt18() == null : this.getExt18().equals(other.getExt18()))
                && (this.getExt19() == null ? other.getExt19() == null : this.getExt19().equals(other.getExt19()))
                && (this.getExt20() == null ? other.getExt20() == null : this.getExt20().equals(other.getExt20()))
                && (this.getExt21() == null ? other.getExt21() == null : this.getExt21().equals(other.getExt21()))
                && (this.getExt22() == null ? other.getExt22() == null : this.getExt22().equals(other.getExt22()))
                && (this.getExt23() == null ? other.getExt23() == null : this.getExt23().equals(other.getExt23()))
                && (this.getExt24() == null ? other.getExt24() == null : this.getExt24().equals(other.getExt24()))
                && (this.getExt25() == null ? other.getExt25() == null : this.getExt25().equals(other.getExt25()))
                && (this.getAllElectricInvoiceNo() == null ? other.getAllElectricInvoiceNo() == null : this.getAllElectricInvoiceNo().equals(other.getAllElectricInvoiceNo()));
    }

    /**
     *
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getExternalId() == null) ? 0 : getExternalId().hashCode());
        result = prime * result + ((getPreInvoiceId() == null) ? 0 : getPreInvoiceId().hashCode());
        result = prime * result + ((getBatchNo() == null) ? 0 : getBatchNo().hashCode());
        result = prime * result + ((getOutBatchNo() == null) ? 0 : getOutBatchNo().hashCode());
        result = prime * result + ((getSalesbillId() == null) ? 0 : getSalesbillId().hashCode());
        result = prime * result + ((getSalesbillNo() == null) ? 0 : getSalesbillNo().hashCode());
        result = prime * result + ((getSellerTenantId() == null) ? 0 : getSellerTenantId().hashCode());
        result = prime * result + ((getSellerNo() == null) ? 0 : getSellerNo().hashCode());
        result = prime * result + ((getSellerId() == null) ? 0 : getSellerId().hashCode());
        result = prime * result + ((getSellerName() == null) ? 0 : getSellerName().hashCode());
        result = prime * result + ((getSellerTaxNo() == null) ? 0 : getSellerTaxNo().hashCode());
        result = prime * result + ((getSellerTel() == null) ? 0 : getSellerTel().hashCode());
        result = prime * result + ((getSellerAddress() == null) ? 0 : getSellerAddress().hashCode());
        result = prime * result + ((getSellerBankName() == null) ? 0 : getSellerBankName().hashCode());
        result = prime * result + ((getSellerBankAccount() == null) ? 0 : getSellerBankAccount().hashCode());
        result = prime * result + ((getSellerAddrTel() == null) ? 0 : getSellerAddrTel().hashCode());
        result = prime * result + ((getSellerBankInfo() == null) ? 0 : getSellerBankInfo().hashCode());
        result = prime * result + ((getPurchaserName() == null) ? 0 : getPurchaserName().hashCode());
        result = prime * result + ((getPurchaserTenantId() == null) ? 0 : getPurchaserTenantId().hashCode());
        result = prime * result + ((getPurchaserId() == null) ? 0 : getPurchaserId().hashCode());
        result = prime * result + ((getPurchaserNo() == null) ? 0 : getPurchaserNo().hashCode());
        result = prime * result + ((getPurchaserTaxNo() == null) ? 0 : getPurchaserTaxNo().hashCode());
        result = prime * result + ((getPurchaserTel() == null) ? 0 : getPurchaserTel().hashCode());
        result = prime * result + ((getPurchaserAddress() == null) ? 0 : getPurchaserAddress().hashCode());
        result = prime * result + ((getPurchaserBankName() == null) ? 0 : getPurchaserBankName().hashCode());
        result = prime * result + ((getPurchaserBankAccount() == null) ? 0 : getPurchaserBankAccount().hashCode());
        result = prime * result + ((getPurchaserBankInfo() == null) ? 0 : getPurchaserBankInfo().hashCode());
        result = prime * result + ((getPurchaserAddrTel() == null) ? 0 : getPurchaserAddrTel().hashCode());
        result = prime * result + ((getPurchaserEPayId() == null) ? 0 : getPurchaserEPayId().hashCode());
        result = prime * result + ((getInvoiceColor() == null) ? 0 : getInvoiceColor().hashCode());
        result = prime * result + ((getInvoiceType() == null) ? 0 : getInvoiceType().hashCode());
        result = prime * result + ((getTaxInvoiceSource() == null) ? 0 : getTaxInvoiceSource().hashCode());
        result = prime * result + ((getInvoiceKind() == null) ? 0 : getInvoiceKind().hashCode());
        result = prime * result + ((getInvoiceCode() == null) ? 0 : getInvoiceCode().hashCode());
        result = prime * result + ((getInvoiceNo() == null) ? 0 : getInvoiceNo().hashCode());
        result = prime * result + ((getMachineCode() == null) ? 0 : getMachineCode().hashCode());
        result = prime * result + ((getPaperDrawDate() == null) ? 0 : getPaperDrawDate().hashCode());
        result = prime * result + ((getCheckCode() == null) ? 0 : getCheckCode().hashCode());
        result = prime * result + ((getCashierName() == null) ? 0 : getCashierName().hashCode());
        result = prime * result + ((getCheckerName() == null) ? 0 : getCheckerName().hashCode());
        result = prime * result + ((getInvoicerName() == null) ? 0 : getInvoicerName().hashCode());
        result = prime * result + ((getRemark() == null) ? 0 : getRemark().hashCode());
        result = prime * result + ((getElectronicSignature() == null) ? 0 : getElectronicSignature().hashCode());
        result = prime * result + ((getInvoiceOrigin() == null) ? 0 : getInvoiceOrigin().hashCode());
        result = prime * result + ((getOriginType() == null) ? 0 : getOriginType().hashCode());
        result = prime * result + ((getSystemOrig() == null) ? 0 : getSystemOrig().hashCode());
        result = prime * result + ((getSpecialInvoiceFlag() == null) ? 0 : getSpecialInvoiceFlag().hashCode());
        result = prime * result + ((getBillType() == null) ? 0 : getBillType().hashCode());
        result = prime * result + ((getBusinessBillType() == null) ? 0 : getBusinessBillType().hashCode());
        result = prime * result + ((getAmountWithTax() == null) ? 0 : getAmountWithTax().hashCode());
        result = prime * result + ((getAmountWithoutTax() == null) ? 0 : getAmountWithoutTax().hashCode());
        result = prime * result + ((getTaxAmount() == null) ? 0 : getTaxAmount().hashCode());
        result = prime * result + ((getTaxRate() == null) ? 0 : getTaxRate().hashCode());
        result = prime * result + ((getOriginInvoiceNo() == null) ? 0 : getOriginInvoiceNo().hashCode());
        result = prime * result + ((getOriginInvoiceCode() == null) ? 0 : getOriginInvoiceCode().hashCode());
        result = prime * result + ((getOriginInvoiceType() == null) ? 0 : getOriginInvoiceType().hashCode());
        result = prime * result + ((getOriginPaperDrawDate() == null) ? 0 : getOriginPaperDrawDate().hashCode());
        result = prime * result + ((getCipherText() == null) ? 0 : getCipherText().hashCode());
        result = prime * result + ((getCipherTextTwoCode() == null) ? 0 : getCipherTextTwoCode().hashCode());
        result = prime * result + ((getDrawoutTime() == null) ? 0 : getDrawoutTime().hashCode());
        result = prime * result + ((getDrawoutUserId() == null) ? 0 : getDrawoutUserId().hashCode());
        result = prime * result + ((getAbandonFlag() == null) ? 0 : getAbandonFlag().hashCode());
        result = prime * result + ((getRedTime() == null) ? 0 : getRedTime().hashCode());
        result = prime * result + ((getRedUserId() == null) ? 0 : getRedUserId().hashCode());
        result = prime * result + ((getRedUserName() == null) ? 0 : getRedUserName().hashCode());
        result = prime * result + ((getRedFlag() == null) ? 0 : getRedFlag().hashCode());
        result = prime * result + ((getRedNotificationNo() == null) ? 0 : getRedNotificationNo().hashCode());
        result = prime * result + ((getDrawoutStatus() == null) ? 0 : getDrawoutStatus().hashCode());
        result = prime * result + ((getStatus() == null) ? 0 : getStatus().hashCode());
        result = prime * result + ((getSaleListFileFlag() == null) ? 0 : getSaleListFileFlag().hashCode());
        result = prime * result + ((getPrintContentFlag() == null) ? 0 : getPrintContentFlag().hashCode());
        result = prime * result + ((getPdfPath() == null) ? 0 : getPdfPath().hashCode());
        result = prime * result + ((getOfdToImg() == null) ? 0 : getOfdToImg().hashCode());
        result = prime * result + ((getXmlUrl() == null) ? 0 : getXmlUrl().hashCode());
        result = prime * result + ((getQrCodeUrl() == null) ? 0 : getQrCodeUrl().hashCode());
        result = prime * result + ((getOfdToPdf() == null) ? 0 : getOfdToPdf().hashCode());
        result = prime * result + ((getReceiveUserEmail() == null) ? 0 : getReceiveUserEmail().hashCode());
        result = prime * result + ((getReceiveUserTel() == null) ? 0 : getReceiveUserTel().hashCode());
        result = prime * result + ((getMakeOutUnitName() == null) ? 0 : getMakeOutUnitName().hashCode());
        result = prime * result + ((getHandleStatus() == null) ? 0 : getHandleStatus().hashCode());
        result = prime * result + ((getHandleRemark() == null) ? 0 : getHandleRemark().hashCode());
        result = prime * result + ((getOutCheckStatus() == null) ? 0 : getOutCheckStatus().hashCode());
        result = prime * result + ((getOutLockConfig() == null) ? 0 : getOutLockConfig().hashCode());
        result = prime * result + ((getVerifyStatus() == null) ? 0 : getVerifyStatus().hashCode());
        result = prime * result + ((getVerifyRequestTime() == null) ? 0 : getVerifyRequestTime().hashCode());
        result = prime * result + ((getVerifyResponseTime() == null) ? 0 : getVerifyResponseTime().hashCode());
        result = prime * result + ((getVerifyRemark() == null) ? 0 : getVerifyRemark().hashCode());
        result = prime * result + ((getGainStatus() == null) ? 0 : getGainStatus().hashCode());
        result = prime * result + ((getGainTime() == null) ? 0 : getGainTime().hashCode());
        result = prime * result + ((getGainRemark() == null) ? 0 : getGainRemark().hashCode());
        result = prime * result + ((getAssociateStatus() == null) ? 0 : getAssociateStatus().hashCode());
        result = prime * result + ((getAssociateTime() == null) ? 0 : getAssociateTime().hashCode());
        result = prime * result + ((getAssociateRemark() == null) ? 0 : getAssociateRemark().hashCode());
        result = prime * result + ((getLockStatus() == null) ? 0 : getLockStatus().hashCode());
        result = prime * result + ((getScanStatus() == null) ? 0 : getScanStatus().hashCode());
        result = prime * result + ((getScanImageUrl() == null) ? 0 : getScanImageUrl().hashCode());
        result = prime * result + ((getScanTime() == null) ? 0 : getScanTime().hashCode());
        result = prime * result + ((getImageUploadStatus() == null) ? 0 : getImageUploadStatus().hashCode());
        result = prime * result + ((getImageUploadTime() == null) ? 0 : getImageUploadTime().hashCode());
        result = prime * result + ((getReceiptStatus() == null) ? 0 : getReceiptStatus().hashCode());
        result = prime * result + ((getReceiptTime() == null) ? 0 : getReceiptTime().hashCode());
        result = prime * result + ((getIdentifyStatus() == null) ? 0 : getIdentifyStatus().hashCode());
        result = prime * result + ((getIdentifyTime() == null) ? 0 : getIdentifyTime().hashCode());
        result = prime * result + ((getCheckTime() == null) ? 0 : getCheckTime().hashCode());
        result = prime * result + ((getPrintStatus() == null) ? 0 : getPrintStatus().hashCode());
        result = prime * result + ((getRetreatStatus() == null) ? 0 : getRetreatStatus().hashCode());
        result = prime * result + ((getRetreatTime() == null) ? 0 : getRetreatTime().hashCode());
        result = prime * result + ((getApproveStatus() == null) ? 0 : getApproveStatus().hashCode());
        result = prime * result + ((getApproveTime() == null) ? 0 : getApproveTime().hashCode());
        result = prime * result + ((getPaymentStatus() == null) ? 0 : getPaymentStatus().hashCode());
        result = prime * result + ((getPaymentTime() == null) ? 0 : getPaymentTime().hashCode());
        result = prime * result + ((getParcelNo() == null) ? 0 : getParcelNo().hashCode());
        result = prime * result + ((getExpressCode() == null) ? 0 : getExpressCode().hashCode());
        result = prime * result + ((getCooperateFlag() == null) ? 0 : getCooperateFlag().hashCode());
        result = prime * result + ((getMakeOutUnitCode() == null) ? 0 : getMakeOutUnitCode().hashCode());
        result = prime * result + ((getDeviceUn() == null) ? 0 : getDeviceUn().hashCode());
        result = prime * result + ((getTerminalUn() == null) ? 0 : getTerminalUn().hashCode());
        result = prime * result + ((getTerminalType() == null) ? 0 : getTerminalType().hashCode());
        result = prime * result + ((getCreateUserName() == null) ? 0 : getCreateUserName().hashCode());
        result = prime * result + ((getCreateTime() == null) ? 0 : getCreateTime().hashCode());
        result = prime * result + ((getCreateUserId() == null) ? 0 : getCreateUserId().hashCode());
        result = prime * result + ((getUpdateTime() == null) ? 0 : getUpdateTime().hashCode());
        result = prime * result + ((getUpdateUserName() == null) ? 0 : getUpdateUserName().hashCode());
        result = prime * result + ((getUpdateUserId() == null) ? 0 : getUpdateUserId().hashCode());
        result = prime * result + ((getDeleteTime() == null) ? 0 : getDeleteTime().hashCode());
        result = prime * result + ((getDeleteUserId() == null) ? 0 : getDeleteUserId().hashCode());
        result = prime * result + ((getDeposeUserName() == null) ? 0 : getDeposeUserName().hashCode());
        result = prime * result + ((getDeposeTime() == null) ? 0 : getDeposeTime().hashCode());
        result = prime * result + ((getDeposeUserId() == null) ? 0 : getDeposeUserId().hashCode());
        result = prime * result + ((getCustomerNo() == null) ? 0 : getCustomerNo().hashCode());
        result = prime * result + ((getSysOrgId() == null) ? 0 : getSysOrgId().hashCode());
        result = prime * result + ((getInvoiceUrl() == null) ? 0 : getInvoiceUrl().hashCode());
        result = prime * result + ((getSourceLine() == null) ? 0 : getSourceLine().hashCode());
        result = prime * result + ((getAgencyTaxNo() == null) ? 0 : getAgencyTaxNo().hashCode());
        result = prime * result + ((getAgencyName() == null) ? 0 : getAgencyName().hashCode());
        result = prime * result + ((getIsAgency() == null) ? 0 : getIsAgency().hashCode());
        result = prime * result + ((getRedLetterApplyStatus() == null) ? 0 : getRedLetterApplyStatus().hashCode());
        result = prime * result + ((getExt1() == null) ? 0 : getExt1().hashCode());
        result = prime * result + ((getExt2() == null) ? 0 : getExt2().hashCode());
        result = prime * result + ((getExt3() == null) ? 0 : getExt3().hashCode());
        result = prime * result + ((getExt4() == null) ? 0 : getExt4().hashCode());
        result = prime * result + ((getExt5() == null) ? 0 : getExt5().hashCode());
        result = prime * result + ((getExt6() == null) ? 0 : getExt6().hashCode());
        result = prime * result + ((getExt7() == null) ? 0 : getExt7().hashCode());
        result = prime * result + ((getExt8() == null) ? 0 : getExt8().hashCode());
        result = prime * result + ((getExt9() == null) ? 0 : getExt9().hashCode());
        result = prime * result + ((getExt10() == null) ? 0 : getExt10().hashCode());
        result = prime * result + ((getExt11() == null) ? 0 : getExt11().hashCode());
        result = prime * result + ((getExt12() == null) ? 0 : getExt12().hashCode());
        result = prime * result + ((getExt13() == null) ? 0 : getExt13().hashCode());
        result = prime * result + ((getExt14() == null) ? 0 : getExt14().hashCode());
        result = prime * result + ((getExt15() == null) ? 0 : getExt15().hashCode());
        result = prime * result + ((getExt16() == null) ? 0 : getExt16().hashCode());
        result = prime * result + ((getExt17() == null) ? 0 : getExt17().hashCode());
        result = prime * result + ((getExt18() == null) ? 0 : getExt18().hashCode());
        result = prime * result + ((getExt19() == null) ? 0 : getExt19().hashCode());
        result = prime * result + ((getExt20() == null) ? 0 : getExt20().hashCode());
        result = prime * result + ((getExt21() == null) ? 0 : getExt21().hashCode());
        result = prime * result + ((getExt22() == null) ? 0 : getExt22().hashCode());
        result = prime * result + ((getExt23() == null) ? 0 : getExt23().hashCode());
        result = prime * result + ((getExt24() == null) ? 0 : getExt24().hashCode());
        result = prime * result + ((getExt25() == null) ? 0 : getExt25().hashCode());
        result = prime * result + ((getAllElectricInvoiceNo() == null) ? 0 : getAllElectricInvoiceNo().hashCode());
        return result;
    }
}