package com.xforceplus.coop.mix.service;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.xforceplus.coop.mix.client.ClientFactory;
import com.xforceplus.coop.mix.common.enums.ClientType;
import com.xforceplus.coop.mix.utils.AssertTools;
import com.xforceplus.coop.mix.utils.FieldNameUtils;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.utils.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * Describe: CommonMixService
 *
 * @Author xiezhongyong
 * @Date 2023-02-24
 */
@Slf4j
@Service
public class CommonMixService {

    /**
     * 通过枚举获取client ClientFactory ps:需要提前添加枚举对象
     *
     * @param clientType
     * @param <T>
     * @return
     */
    public static <T> T getClient(ClientType clientType) {
        return (T) ClientFactory.getClinet(clientType);
    }

    /**
     * 默认获取result + 子属性
     *
     * @param response
     * @param aClass
     * @param <T>
     * @return
     */
    public static <T, R> T convertData(Object response, Class<T> aClass, FieldNameUtils.TypeFunctional<R> typeFunctional) {
        String json = JSONObject.toJSONString(response);
        String propertyName = FieldNameUtils.getPropertyName(typeFunctional);
        Object read = JSONPath.read(json, String.format(".result.%s", propertyName));
        T parse = JSONObject.parseObject(read.toString(), aClass);
        return parse;
    }

    /**
     * 指定jsonpath 转换
     *
     * @param response
     * @param aClass
     * @param jsonPath
     * @param <T>
     * @return
     */
    public static <T> T convertData(Object response, Class<T> aClass, String jsonPath) {
        String json = JSONObject.toJSONString(response);
        Object read = JSONPath.read(json, jsonPath);
        T parse = JSONObject.parseObject(read.toString(), aClass);
        return parse;
    }

    /**
     * 默认获取result 对象
     *
     * @param response
     * @param aClass
     * @param <T>
     * @return
     */
    public static <T> T convertData(Object response, Class<T> aClass) {
        return convertData(response, aClass, ".result");
    }


    /**
     * 校验响应状态是否正常(默认用 1 进行对比)
     *
     * @param response
     */
    public static void checkResponseCode(Object response) {
        checkResponseCode(response, Response.OK.toString());
    }

    /**
     * 校验响应状态是否正常（指定状态）
     *
     * @param response
     * @param code
     */
    public static void checkResponseCode(Object response, String code) {
        String json = JSONObject.toJSONString(response);
        Object read = JSONPath.read(json, "code");
        AssertTools.isTrue(code.equals(read.toString()), String.format("接口需要状态非[1]: %s", JsonUtils.writeObjectToJson(response)));
    }
}
