package com.xforceplus.coop.mix.service;

import com.xforceplus.coop.common.utils.BeanUtils;
import com.xforceplus.coop.mix.client.invoice.PhoenixInvoiceClient;
import com.xforceplus.coop.mix.model.MixSellerInvoiceEntity;
import com.xforceplus.seller.invoice.client.model.InvoiceDetails;
import com.xforceplus.seller.invoice.client.model.InvoiceDetailsInfoResponse;
import com.xforceplus.seller.invoice.client.model.QuerySellerInvoiceDetailsRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 * Describe: 发票融合层
 *
 * @Author xiezhongyong
 * @Date 2023/2/24 21:30
 */
@Service
public class PhoenixInvoiceMixService {


    @Autowired
    PhoenixInvoiceClient phoenixInvoiceClient;


    /**
     * 通过 发票ID 获取发票信息
     * @param invoiceId
     * @return
     */
    public MixSellerInvoiceEntity getSellerInvoiceEntity(Long invoiceId) {
        QuerySellerInvoiceDetailsRequest request = new QuerySellerInvoiceDetailsRequest();
        request.setInvoiceId(invoiceId);
        InvoiceDetailsInfoResponse response = phoenixInvoiceClient.queryInvoiceDetailsById(request);

        // 响应状态校验
        CommonMixService.checkResponseCode(response);

        InvoiceDetails invoiceDetails = response.getResult();

        if (null == invoiceDetails) {
            return null;
        }

        MixSellerInvoiceEntity mixSellerInvoiceEntity = BeanUtils.copyProperties(invoiceDetails.getInvoiceInfo(), MixSellerInvoiceEntity.class);

        return mixSellerInvoiceEntity;

    }


}
