package com.xforceplus.coop.mix.utils;

import com.alibaba.fastjson.JSON;
import com.xforceplus.ant.coop.feign.domain.MixCanaryHolder;
import com.xforceplus.coop.mix.model.MixSellerInvoiceEntity;
import com.xforceplus.xplatframework.utils.JsonUtils;


/**
 * Describe: TODO
 *
 * @Author xiezhongyong
 * @Date 2023-02-28
 */
public class CanaryMethodUtils {


    /**
     * 方法灰度调用（自行处理业务响应数据以及对象转换）
     *
     * @param originalCall 老业务
     * @param mixCall      融合新业务
     * @param <T>
     * @return
     */
    public static <T> T execute(MethodCall<T> originalCall, MethodCall<T> mixCall) {
        T result = null;
        if (null != MixCanaryHolder.get()) {
            result = originalCall.call();
        } else {
            result = mixCall.call();
        }
        return result;
    }

    /**
     * 方法灰度调用（默认使用json 进行数据转换）
     *
     * @param originalCall 老业务
     * @param mixCall      融合新业务
     * @param <T>
     * @return
     */
    public static <T, P1, P2> T execute(MethodCall<P1> originalCall, MethodCall<P2> mixCall, Class<T> resultClass) {
        Object result = null;
        if (null != MixCanaryHolder.get()) {
            result = originalCall.call();
        } else {
            result = mixCall.call();
        }
        if (result instanceof String) {
            return JSON.parseObject(result.toString(), resultClass);
        }
        return JSON.parseObject(JSON.toJSONString(result), resultClass);
    }

    public static void main(String[] args) {
        MixSellerInvoiceEntity ie = new MixSellerInvoiceEntity();
        ie.setInvoiceCode("123");
        ie.setInvoiceNo("678");
        System.out.println(JSON.toJSONString(ie));


        MethodCall<MixSellerInvoiceEntity> methodCall1 = new MethodCall<MixSellerInvoiceEntity>() {
            @Override
            public MixSellerInvoiceEntity call() {
                String json = "{\"invoiceCode\":\"123\",\"invoiceNo\":\"678\",\"id\":\"123\"}";
                MixSellerInvoiceEntity invoiceEntity = JsonUtils.writeFastJsonToObject(json, MixSellerInvoiceEntity.class);
                return invoiceEntity;
            }
        };

        MethodCall<MixSellerInvoiceEntity> methodCall2 = new MethodCall<MixSellerInvoiceEntity>() {
            @Override
            public MixSellerInvoiceEntity call() {
                String json = "{\"invoiceCode\":123,\"invoiceNo\":\"678\",\"type\":\"A\"}";
                MixSellerInvoiceEntity invoiceEntity = JsonUtils.writeFastJsonToObject(json, MixSellerInvoiceEntity.class);

                return invoiceEntity;
            }
        };

        MixSellerInvoiceEntity execute1 = execute(methodCall1, methodCall2, MixSellerInvoiceEntity.class);

        System.out.println(execute1);

    }


}