package com.xforceplus.coop.mix.utils;

import java.beans.Introspector;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;

/**
 * Describe: 字段名称获取工具类
 *
 * @Author xiezhongyong
 * @Date 2023/2/24 21:30
 */
public class FieldNameUtils {


    @FunctionalInterface
    public interface TypeFunctional<T> extends Serializable {
        Object apply(T source);
    }

    public static <T> String getPropertyName(TypeFunctional<T> lambda) {
        try {
            Method method = lambda.getClass().getDeclaredMethod("writeReplace");
            method.setAccessible(Boolean.TRUE);
            SerializedLambda serializedLambda = (SerializedLambda) method.invoke(lambda);
            String getterMethod = serializedLambda.getImplMethodName();
            String fieldName = Introspector.decapitalize(getterMethod.replace("get", ""));
            return fieldName;
        } catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

}
