/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.coop.mix.service;

import com.alibaba.fastjson.JSON;
import com.xforceplus.coop.mix.client.invoice.PhoenixInvoiceOperateClient;
import com.xforceplus.coop.mix.model.MixSellerInvoiceEntity;
import com.xforceplus.seller.enums.InvoiceStatus;
import com.xforceplus.seller.invoice.client.model.AbandonSellerInvoiceRequest;
import com.xforceplus.seller.invoice.client.model.BatchReverseRequest;
import com.xforceplus.xplatframework.apimodel.BaseAsyncResponse;
import com.xforceplus.xplatframework.model.Response;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PhoenixInvoiceOperateMixService {
    private static final Logger log = LoggerFactory.getLogger(PhoenixInvoiceOperateMixService.class);
    @Autowired
    private PhoenixInvoiceOperateClient phoenixInvoiceOperateClient;

    public Response updateInvoiceEntityById(MixSellerInvoiceEntity invoiceEntity) {
        return Response.ok((String)"\u66f4\u65b0\u5b8c\u6210");
    }

    public BaseAsyncResponse abandonInvoice(List<Long> invoiceIdList, String reason, Long txId) {
        BaseAsyncResponse baseAsyncResponse = new BaseAsyncResponse();
        try {
            AbandonSellerInvoiceRequest abandonSellerInvoiceRequest = new AbandonSellerInvoiceRequest();
            abandonSellerInvoiceRequest.setInvoiceIds(invoiceIdList);
            abandonSellerInvoiceRequest.setReleaseType(Integer.valueOf(1));
            abandonSellerInvoiceRequest.setReason(reason);
            abandonSellerInvoiceRequest.setStatus(InvoiceStatus.NORMAL.value());
            abandonSellerInvoiceRequest.setTaskId(txId);
            log.info("\u53d1\u7968\u4f5c\u5e9f\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)abandonSellerInvoiceRequest));
            baseAsyncResponse = this.phoenixInvoiceOperateClient.abandonInvoice(abandonSellerInvoiceRequest);
        }
        catch (Error | Exception e) {
            log.error("\u53d1\u7968\u4f5c\u5e9f\u8bf7\u6c42\u5f02\u5e38:{}", (Object)txId, (Object)e);
            baseAsyncResponse.setCode(Response.Fail);
            baseAsyncResponse.setMessage(e.getMessage());
        }
        return baseAsyncResponse;
    }

    public BaseAsyncResponse redFlushInvoice(BatchReverseRequest redFlushRequest) {
        BaseAsyncResponse baseAsyncResponse = new BaseAsyncResponse();
        try {
            redFlushRequest = new BatchReverseRequest();
            redFlushRequest.setRequestSource("90");
            redFlushRequest.setReleaseType(Integer.valueOf(1));
            log.info("\u53d1\u7968\u7ea2\u51b2\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)redFlushRequest));
            baseAsyncResponse = this.phoenixInvoiceOperateClient.batchReverse(redFlushRequest);
        }
        catch (Error | Exception e) {
            log.error("\u53d1\u7968\u7ea2\u51b2\u8bf7\u6c42\u5f02\u5e38:{}", (Object)redFlushRequest.getTaskId(), (Object)e);
            baseAsyncResponse.setCode(Response.Fail);
            baseAsyncResponse.setMessage(e.getMessage());
        }
        return baseAsyncResponse;
    }
}

