/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.coop.mix.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.xforceplus.ant.coop.security.user.domain.CurrentUser;
import com.xforceplus.coop.common.snowflake.IdGenerator;
import com.xforceplus.coop.mix.client.preinvoice.PhoenixPreviewInvoiceClient;
import com.xforceplus.coop.mix.client.preinvoice.PhoenixPreviewInvoiceSplitClient;
import com.xforceplus.coop.mix.model.MixPreInvoiceEntity;
import com.xforceplus.coop.mix.model.response.MakeOutResponse;
import com.xforceplus.coop.mix.service.CommonMixService;
import com.xforceplus.coop.mix.utils.RequestTools;
import com.xforceplus.seller.enums.BusinessOperationType;
import com.xforceplus.seller.invoice.client.model.BillInfo;
import com.xforceplus.seller.invoice.client.model.DeletePreInvoicesRequest;
import com.xforceplus.seller.invoice.client.model.LogAddRequest;
import com.xforceplus.seller.invoice.client.model.MakeOutPreInvoiceInfo;
import com.xforceplus.seller.invoice.client.model.SplitPreInvoiceRequest;
import com.xforceplus.seller.invoice.client.model.SplitPreInvoiceResponse;
import com.xforceplus.seller.invoice.client.model.SplitRule;
import com.xforceplus.seller.invoice.client.model.UpdatePreInvoiceByIdRequest;
import com.xforceplus.seller.invoice.client.model.UpdatePreInvoiceByIdsRequest;
import com.xforceplus.xplatframework.model.Response;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PhoenixPreviewInvoiceOperationMixService {
    private static final Logger log = LoggerFactory.getLogger(PhoenixPreviewInvoiceOperationMixService.class);
    @Autowired
    private PhoenixPreviewInvoiceClient phoenixPreviewInvoiceClient;
    @Autowired
    private PhoenixPreviewInvoiceSplitClient phoenixPreviewInvoiceSplitClient;

    public MakeOutResponse makeOut(MakeOutPreInvoiceInfo makeOutPreInvoiceInfo) {
        MakeOutResponse makeOutResponse = new MakeOutResponse();
        try {
            Response response = this.phoenixPreviewInvoiceClient.makeOut(makeOutPreInvoiceInfo);
            makeOutResponse.setCode(response.getCode());
            makeOutResponse.setMessage(response.getMessage());
            if (Response.OK.equals(response.getCode())) {
                String taskId = CommonMixService.convertData((Object)response, String.class, "result.taskId");
                makeOutResponse.setTaskId(taskId);
            }
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u9500\u9879\u5f00\u5177\u63a5\u53e3error\uff1a", (Throwable)e);
            makeOutResponse.setCode(Response.Fail);
            makeOutResponse.setMessage(e.getMessage());
        }
        return makeOutResponse;
    }

    public SplitPreInvoiceResponse splitPreInvoice(BillInfo billInfo, SplitRule splitRule, Long txId) {
        SplitPreInvoiceResponse response = new SplitPreInvoiceResponse();
        try {
            SplitPreInvoiceRequest splitPreInvoiceRequest = new SplitPreInvoiceRequest();
            splitPreInvoiceRequest.setBillInfo(billInfo);
            splitPreInvoiceRequest.setMergeType(0);
            splitPreInvoiceRequest.setSplitRule(splitRule);
            splitPreInvoiceRequest.setBatchNo(Long.valueOf(IdGenerator.nextId()));
            splitPreInvoiceRequest.setSplitType(1);
            splitPreInvoiceRequest.setOperatorUser(CurrentUser.getCurrentUserName());
            splitPreInvoiceRequest.setTaskId(txId);
            splitPreInvoiceRequest.setRequestSource("90");
            response = this.phoenixPreviewInvoiceSplitClient.splitAndMakeOut(Lists.newArrayList((Object[])new SplitPreInvoiceRequest[]{splitPreInvoiceRequest}));
        }
        catch (Error | Exception e) {
            log.error("\u53d1\u8d77\u62c6\u7968\u8bf7\u6c42\u5f02\u5e38:", e);
            response.setCode(Response.Fail);
            response.setMessage(e.getMessage());
        }
        return response;
    }

    public Response deletePreInvoice(List<Long> preInvoiceIds) {
        if (CollectionUtils.isEmpty(preInvoiceIds)) {
            return Response.ok((String)"\u53c2\u6570\u4e3a\u7a7a");
        }
        DeletePreInvoicesRequest deletePreInvoicesRequest = new DeletePreInvoicesRequest();
        deletePreInvoicesRequest.setPreInvoiceIds(preInvoiceIds);
        return this.deletePreInvoice(deletePreInvoicesRequest);
    }

    public Response deletePreInvoiceByBill(List<Long> billIds) {
        if (CollectionUtils.isEmpty(billIds)) {
            return Response.ok((String)"\u53c2\u6570\u4e3a\u7a7a");
        }
        DeletePreInvoicesRequest deletePreInvoicesRequest = new DeletePreInvoicesRequest();
        deletePreInvoicesRequest.setBillIds(billIds);
        return this.deletePreInvoice(deletePreInvoicesRequest);
    }

    public Response deletePreInvoice(DeletePreInvoicesRequest request) {
        try {
            return this.phoenixPreviewInvoiceClient.deletePreInvoice(request);
        }
        catch (Error | Exception e) {
            log.error("\u5220\u9664\u9884\u5236\u53d1\u7968\u5f02\u5e38 \u53c2\u6570:{} error:", (Object)JSON.toJSONString((Object)request), (Object)e);
            return Response.failed((String)e.getMessage());
        }
    }

    public Response updateByPreInvoiceIds(MixPreInvoiceEntity preInvoiceEntity, List<Long> preInvoiceIds) {
        if (CollectionUtils.isEmpty(preInvoiceIds)) {
            return Response.failed((String)"\u9884\u5236\u53d1\u7968id\u4e0d\u53ef\u4e3a\u7a7a");
        }
        UpdatePreInvoiceByIdsRequest request = new UpdatePreInvoiceByIdsRequest();
        request.setPreInvoiceIds(preInvoiceIds);
        request.setRequestSource("cooperate");
        RequestTools.setObject(StringUtils::isNotEmpty, arg_0 -> ((UpdatePreInvoiceByIdsRequest)request).setInvoiceType(arg_0), preInvoiceEntity.getInvoiceType());
        RequestTools.setObject(Objects::nonNull, arg_0 -> ((UpdatePreInvoiceByIdsRequest)request).setStatus(arg_0), preInvoiceEntity.getStatus());
        RequestTools.setObject(StringUtils::isNotEmpty, arg_0 -> ((UpdatePreInvoiceByIdsRequest)request).setPurchaserName(arg_0), preInvoiceEntity.getPurchaserName());
        RequestTools.setObject(StringUtils::isNotEmpty, arg_0 -> ((UpdatePreInvoiceByIdsRequest)request).setPurchaserTaxNo(arg_0), preInvoiceEntity.getPurchaserTaxNo());
        RequestTools.setObject(StringUtils::isNotEmpty, arg_0 -> ((UpdatePreInvoiceByIdsRequest)request).setPurchaserTel(arg_0), preInvoiceEntity.getPurchaserTel());
        RequestTools.setObject(StringUtils::isNotEmpty, arg_0 -> ((UpdatePreInvoiceByIdsRequest)request).setPurchaserAddress(arg_0), preInvoiceEntity.getPurchaserAddress());
        RequestTools.setObject(StringUtils::isNotEmpty, arg_0 -> ((UpdatePreInvoiceByIdsRequest)request).setPurchaserBankName(arg_0), preInvoiceEntity.getPurchaserBankName());
        RequestTools.setObject(StringUtils::isNotEmpty, arg_0 -> ((UpdatePreInvoiceByIdsRequest)request).setPurchaserBankAccount(arg_0), preInvoiceEntity.getPurchaserBankAccount());
        RequestTools.setObject(StringUtils::isNotEmpty, arg_0 -> ((UpdatePreInvoiceByIdsRequest)request).setSellerTaxNo(arg_0), preInvoiceEntity.getSellerTaxNo());
        RequestTools.setObject(StringUtils::isNotEmpty, arg_0 -> ((UpdatePreInvoiceByIdsRequest)request).setSellerName(arg_0), preInvoiceEntity.getSellerName());
        RequestTools.setObject(StringUtils::isNotEmpty, arg_0 -> ((UpdatePreInvoiceByIdsRequest)request).setSellerTel(arg_0), preInvoiceEntity.getSellerTel());
        RequestTools.setObject(StringUtils::isNotEmpty, arg_0 -> ((UpdatePreInvoiceByIdsRequest)request).setSellerAddress(arg_0), preInvoiceEntity.getSellerAddress());
        RequestTools.setObject(StringUtils::isNotEmpty, arg_0 -> ((UpdatePreInvoiceByIdsRequest)request).setSellerBankName(arg_0), preInvoiceEntity.getSellerBankName());
        RequestTools.setObject(StringUtils::isNotEmpty, arg_0 -> ((UpdatePreInvoiceByIdsRequest)request).setSellerBankAccount(arg_0), preInvoiceEntity.getSellerBankAccount());
        try {
            return this.phoenixPreviewInvoiceClient.updatePreInvoiceByIds(request);
        }
        catch (Error | Exception e) {
            log.error("\u6279\u91cf\u66f4\u65b0\u9884\u5236\u53d1\u7968\u5f02\u5e38 {}\uff0cerror:", preInvoiceIds, (Object)e);
            return Response.failed((String)e.getMessage());
        }
    }

    public Response updateByPreInvoiceId(MixPreInvoiceEntity preInvoiceEntity) {
        if (RequestTools.isEdit(preInvoiceEntity.getId())) {
            return Response.failed((String)"\u9884\u5236\u53d1\u7968id\u4e0d\u53ef\u4e3a\u7a7a");
        }
        return this.updatePreInvoiceList(Lists.newArrayList((Object[])new MixPreInvoiceEntity[]{preInvoiceEntity}));
    }

    public Response updateByPreInvoiceId(List<MixPreInvoiceEntity> preInvoiceEntityList) {
        if (CollectionUtils.isEmpty(preInvoiceEntityList)) {
            return Response.failed((String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (preInvoiceEntityList.stream().anyMatch(entity -> !RequestTools.isEdit(entity.getId()))) {
            return Response.failed((String)"\u9884\u5236\u53d1\u7968id\u4e0d\u53ef\u4e3a\u7a7a");
        }
        return null;
    }

    public void addLog(Long preInvoiceId, BusinessOperationType operationType, String content) {
        if (RequestTools.isEdit(preInvoiceId)) {
            return;
        }
        LogAddRequest logAddRequest = new LogAddRequest();
        logAddRequest.setPreInvoiceId(preInvoiceId);
        logAddRequest.setOperationType(Long.valueOf(Integer.valueOf(operationType.getType()).longValue()));
        logAddRequest.setOperationRemark("");
        logAddRequest.setOperationContent(content);
        try {
            this.phoenixPreviewInvoiceClient.logAdd(Lists.newArrayList());
        }
        catch (Error | Exception e) {
            log.error("\u6dfb\u52a0\u9884\u5236\u53d1\u7968\u65e5\u5fd7\u5f02\u5e38 {}\uff0cerror:", (Object)preInvoiceId, (Object)e);
        }
    }

    public Response updatePreInvoiceList(List<MixPreInvoiceEntity> preInvoiceEntityList) {
        if (CollectionUtils.isEmpty(preInvoiceEntityList)) {
            return Response.failed((String)"\u9884\u5236\u53d1\u7968\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (preInvoiceEntityList.stream().anyMatch(entity -> !RequestTools.isEdit(entity.getId()))) {
            return Response.failed((String)"\u9884\u5236\u53d1\u7968id\u4e0d\u53ef\u4e3a\u7a7a");
        }
        List<UpdatePreInvoiceByIdRequest> updateList = preInvoiceEntityList.stream().map(this::Convert).collect(Collectors.toList());
        try {
            return this.phoenixPreviewInvoiceClient.updatePreInvoiceList(updateList);
        }
        catch (Error | Exception e) {
            log.error("updatePreInvoiceList {}\uff0cerror:", (Object)JSON.toJSONString(preInvoiceEntityList), (Object)e);
            return Response.failed((String)e.getMessage());
        }
    }

    private UpdatePreInvoiceByIdRequest Convert(MixPreInvoiceEntity preInvoiceEntity) {
        UpdatePreInvoiceByIdRequest request = new UpdatePreInvoiceByIdRequest();
        request.setId(preInvoiceEntity.getId());
        RequestTools.setObject(StringUtils::isNotEmpty, arg_0 -> ((UpdatePreInvoiceByIdRequest)request).setInvoiceType(arg_0), preInvoiceEntity.getInvoiceType());
        RequestTools.setObject(StringUtils::isNotEmpty, arg_0 -> ((UpdatePreInvoiceByIdRequest)request).setPurchaserName(arg_0), preInvoiceEntity.getPurchaserName());
        RequestTools.setObject(StringUtils::isNotEmpty, arg_0 -> ((UpdatePreInvoiceByIdRequest)request).setPurchaserTaxNo(arg_0), preInvoiceEntity.getPurchaserTaxNo());
        RequestTools.setObject(StringUtils::isNotEmpty, arg_0 -> ((UpdatePreInvoiceByIdRequest)request).setPurchaserTel(arg_0), preInvoiceEntity.getPurchaserTel());
        RequestTools.setObject(StringUtils::isNotEmpty, arg_0 -> ((UpdatePreInvoiceByIdRequest)request).setPurchaserAddress(arg_0), preInvoiceEntity.getPurchaserAddress());
        RequestTools.setObject(StringUtils::isNotEmpty, arg_0 -> ((UpdatePreInvoiceByIdRequest)request).setPurchaserBankName(arg_0), preInvoiceEntity.getPurchaserBankName());
        RequestTools.setObject(StringUtils::isNotEmpty, arg_0 -> ((UpdatePreInvoiceByIdRequest)request).setPurchaserBankAccount(arg_0), preInvoiceEntity.getPurchaserBankAccount());
        RequestTools.setObject(StringUtils::isNotEmpty, arg_0 -> ((UpdatePreInvoiceByIdRequest)request).setSellerTaxNo(arg_0), preInvoiceEntity.getSellerTaxNo());
        RequestTools.setObject(StringUtils::isNotEmpty, arg_0 -> ((UpdatePreInvoiceByIdRequest)request).setSellerName(arg_0), preInvoiceEntity.getSellerName());
        RequestTools.setObject(StringUtils::isNotEmpty, arg_0 -> ((UpdatePreInvoiceByIdRequest)request).setSellerTel(arg_0), preInvoiceEntity.getSellerTel());
        RequestTools.setObject(StringUtils::isNotEmpty, arg_0 -> ((UpdatePreInvoiceByIdRequest)request).setSellerAddress(arg_0), preInvoiceEntity.getSellerAddress());
        RequestTools.setObject(StringUtils::isNotEmpty, arg_0 -> ((UpdatePreInvoiceByIdRequest)request).setSellerBankName(arg_0), preInvoiceEntity.getSellerBankName());
        RequestTools.setObject(StringUtils::isNotEmpty, arg_0 -> ((UpdatePreInvoiceByIdRequest)request).setSellerBankAccount(arg_0), preInvoiceEntity.getSellerBankAccount());
        RequestTools.setObject(StringUtils::isNotEmpty, arg_0 -> ((UpdatePreInvoiceByIdRequest)request).setCashierName(arg_0), preInvoiceEntity.getCashierName());
        RequestTools.setObject(StringUtils::isNotEmpty, arg_0 -> ((UpdatePreInvoiceByIdRequest)request).setCheckerName(arg_0), preInvoiceEntity.getCheckerName());
        RequestTools.setObject(StringUtils::isNotEmpty, arg_0 -> ((UpdatePreInvoiceByIdRequest)request).setInvoicerName(arg_0), preInvoiceEntity.getInvoicerName());
        RequestTools.setObject(StringUtils::isNotEmpty, arg_0 -> ((UpdatePreInvoiceByIdRequest)request).setRedNotificationNo(arg_0), preInvoiceEntity.getRedNotificationNo());
        RequestTools.setObject(StringUtils::isNotEmpty, arg_0 -> ((UpdatePreInvoiceByIdRequest)request).setOriginInvoiceCode(arg_0), preInvoiceEntity.getOriginInvoiceCode());
        RequestTools.setObject(StringUtils::isNotEmpty, arg_0 -> ((UpdatePreInvoiceByIdRequest)request).setOriginInvoiceNo(arg_0), preInvoiceEntity.getOriginInvoiceNo());
        RequestTools.setObject(StringUtils::isNotEmpty, arg_0 -> ((UpdatePreInvoiceByIdRequest)request).setOriginInvoiceType(arg_0), preInvoiceEntity.getOriginInvoiceType());
        RequestTools.setObject(StringUtils::isNotEmpty, arg_0 -> ((UpdatePreInvoiceByIdRequest)request).setOriginPaperDrawDate(arg_0), preInvoiceEntity.getOriginPaperDrawDate());
        RequestTools.setObject(StringUtils::isNotEmpty, arg_0 -> ((UpdatePreInvoiceByIdRequest)request).setMakingReason(arg_0), preInvoiceEntity.getRedReason());
        RequestTools.setObject(StringUtils::isNotEmpty, arg_0 -> ((UpdatePreInvoiceByIdRequest)request).setExtRemark(arg_0), preInvoiceEntity.getExtRemark());
        RequestTools.setObject(Objects::nonNull, arg_0 -> ((UpdatePreInvoiceByIdRequest)request).setStatus(arg_0), preInvoiceEntity.getStatus());
        return request;
    }
}

