/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.coop.mix.client;

import com.xforceplus.coop.mix.client.MixClient;
import com.xforceplus.coop.mix.common.config.SpringContextHolder;
import com.xforceplus.coop.mix.common.enums.ClientType;
import com.xforceplus.coop.mix.common.enums.CoopClientTypeEnum;
import com.xforceplus.coop.mix.common.enums.InvoiceClientTypeEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.CollectionUtils;

public class ClientFactory {
    private static final Logger log = LoggerFactory.getLogger(ClientFactory.class);
    private static Map<String, MixClient> serviceMap = new HashMap<String, MixClient>();
    private static List<ClientType> clientTypeList = new ArrayList<ClientType>();

    public static <T> MixClient getClinet(ClientType typeEnum) {
        if (CollectionUtils.isEmpty(serviceMap)) {
            ClientFactory.init();
        }
        return serviceMap.get(typeEnum.getClientName());
    }

    public static void init() {
        ApplicationContext applicationContext = SpringContextHolder.getApplicationContext();
        for (ClientType clientType : clientTypeList) {
            MixClient client = (MixClient)applicationContext.getBean(clientType.getClientClass());
            serviceMap.put(clientType.getClientName(), client);
        }
    }

    static {
        clientTypeList.addAll(Arrays.asList(InvoiceClientTypeEnum.values()));
        clientTypeList.addAll(Arrays.asList(CoopClientTypeEnum.values()));
    }
}

