/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.coop.mix.common.config;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringContextHolder
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SpringContextHolder.class);
    private static ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) {
        SpringContextHolder.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        SpringContextHolder.checkApplicationContext();
        return applicationContext;
    }

    public static <T> T getBean(String name) {
        SpringContextHolder.checkApplicationContext();
        return (T)applicationContext.getBean(name);
    }

    public static <T> T getHandler(String name, Class<T> cls) {
        Object t = null;
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            SpringContextHolder.checkApplicationContext();
            try {
                t = applicationContext.getBean(name, cls);
            }
            catch (Exception e) {
                log.error("####################" + name + "\u672a\u5b9a\u4e49");
            }
        }
        return (T)t;
    }

    public static <T> T getBean(Class<T> clazz) {
        SpringContextHolder.checkApplicationContext();
        return (T)applicationContext.getBean(clazz);
    }

    public static void cleanApplicationContext() {
        applicationContext = null;
    }

    private static void checkApplicationContext() {
        if (applicationContext == null) {
            throw new IllegalStateException("applicaitonContext\u672a\u6ce8\u5165,\u8bf7\u5728applicationContext.xml\u4e2d\u5b9a\u4e49SpringContextHolder");
        }
    }
}

