/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.coop.mix.utils;

import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

public class DateTimeUtils {
    public static final DateTimeFormatter DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter MONTH_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM");
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");
    private static String[] weekNames = new String[]{"\u5468\u4e00", "\u5468\u4e8c", "\u5468\u4e09", "\u5468\u56db", "\u5468\u4e94", "\u5468\u516d", "\u5468\u65e5"};

    public static LocalDate parseLocalDate(String dateStr) {
        return LocalDate.parse(dateStr, DATE_FORMATTER);
    }

    public static LocalDateTime parseLocalDateTime(String dateTimeStr) {
        return LocalDateTime.parse(dateTimeStr, DATETIME_FORMATTER);
    }

    public static LocalTime parseLocalTime(String timeStr) {
        return LocalTime.parse(timeStr, TIME_FORMATTER);
    }

    public static String formatLocalDate(LocalDate date) {
        return date.format(DATE_FORMATTER);
    }

    public static String formatLocalDate(LocalDate date, DateTimeFormatter formatter) {
        return date.format(formatter);
    }

    public static String formatLocalDateTime(LocalDateTime datetime, DateTimeFormatter formatter) {
        return datetime.format(formatter);
    }

    public static String formatLocalDateTime(LocalDateTime datetime) {
        return datetime.format(DATETIME_FORMATTER);
    }

    public static String formatLocalTime(LocalTime time) {
        return time.format(TIME_FORMATTER);
    }

    public static int periodDays(LocalDate startDateInclusive, LocalDate endDateExclusive) {
        return Period.between(startDateInclusive, endDateExclusive).getDays();
    }

    public static long durationHours(Temporal startInclusive, Temporal endExclusive) {
        return Duration.between(startInclusive, endExclusive).toHours();
    }

    public static long durationMinutes(Temporal startInclusive, Temporal endExclusive) {
        return Duration.between(startInclusive, endExclusive).toMinutes();
    }

    public static long durationMillis(Temporal startInclusive, Temporal endExclusive) {
        return Duration.between(startInclusive, endExclusive).toMillis();
    }

    public static LocalDate getCurrentLocalDate() {
        return LocalDate.now();
    }

    public static LocalTime getCurrentLocalTime() {
        return LocalTime.now();
    }

    public static LocalDateTime get() {
        return LocalDateTime.now();
    }

    public static int getYear() {
        return DateTimeUtils.get().getYear();
    }

    public static LocalDateTime withYear(int year) {
        return DateTimeUtils.get().withYear(year);
    }

    public static int getMonth() {
        return DateTimeUtils.get().getMonthValue();
    }

    public static LocalDateTime firstDayOfThisYear(int year) {
        return DateTimeUtils.withYear(year).with(TemporalAdjusters.firstDayOfYear()).with(LocalTime.MIN);
    }

    public static String getFirstDayOfThisYear(int year) {
        LocalDateTime firstDayOfThisYear = DateTimeUtils.firstDayOfThisYear(year);
        return DATETIME_FORMATTER.format(firstDayOfThisYear);
    }

    public static LocalDateTime lastDayOfThisYear(int year) {
        return DateTimeUtils.withYear(year).with(TemporalAdjusters.lastDayOfYear()).with(LocalTime.MAX);
    }

    public static String getLastDayOfThisYear(int year) {
        LocalDateTime lastDayOfThisYear = DateTimeUtils.lastDayOfThisYear(year);
        return DATETIME_FORMATTER.format(lastDayOfThisYear);
    }

    public static String getFirstDayOfThisMonth() {
        LocalDateTime firstDayOfThisYear = DateTimeUtils.get().with(TemporalAdjusters.firstDayOfMonth());
        return DATETIME_FORMATTER.format(firstDayOfThisYear);
    }

    public static String getLastDayOfThisMonth() {
        LocalDateTime firstDayOfThisYear = DateTimeUtils.get().with(TemporalAdjusters.lastDayOfMonth());
        return DATETIME_FORMATTER.format(firstDayOfThisYear);
    }

    public static LocalDateTime plusDays(int days) {
        return DateTimeUtils.get().plusDays(days);
    }

    public static LocalDateTime firstDayOfWeekInYearMonth(int year, int month) {
        return DateTimeUtils.get().withYear(year).withMonth(month).with(TemporalAdjusters.firstInMonth(DayOfWeek.MONDAY));
    }

    public static LocalDateTime todayStart() {
        return LocalDateTime.of(DateTimeUtils.getCurrentLocalDate(), LocalTime.MIN);
    }

    public static LocalDateTime todayEnd() {
        return LocalDateTime.of(DateTimeUtils.getCurrentLocalDate(), LocalTime.MAX);
    }

    public static String getStartDayOfWeekToString() {
        return DateTimeUtils.formatLocalDate(DateTimeUtils.getStartDayOfWeek());
    }

    public static LocalDate getStartDayOfWeek() {
        TemporalAdjuster FIRST_OF_WEEK = TemporalAdjusters.ofDateAdjuster(localDate -> localDate.minusDays(localDate.getDayOfWeek().getValue() - DayOfWeek.MONDAY.getValue()));
        return DateTimeUtils.getCurrentLocalDate().with(FIRST_OF_WEEK);
    }

    public static String getEndDayOfWeekToString() {
        return DateTimeUtils.formatLocalDate(DateTimeUtils.getEndDayOfWeek());
    }

    public static LocalDate getEndDayOfWeek() {
        TemporalAdjuster LAST_OF_WEEK = TemporalAdjusters.ofDateAdjuster(localDate -> localDate.plusDays(DayOfWeek.SUNDAY.getValue() - localDate.getDayOfWeek().getValue()));
        return DateTimeUtils.getCurrentLocalDate().with(LAST_OF_WEEK);
    }

    public static List<LocalDate> sectionList(LocalDate startDate, LocalDate endDate) {
        ArrayList<LocalDate> list = new ArrayList<LocalDate>();
        LocalDate start = startDate;
        LocalDate end = endDate;
        while (!start.isAfter(end)) {
            list.add(start);
            start = start.plusDays(1L);
        }
        return list;
    }

    public static Integer countDays(LocalDate startDate, LocalDate endDate, TreeSet<String> weekList) {
        int count = 0;
        LocalDate start = startDate;
        LocalDate end = endDate;
        while (!start.isAfter(end)) {
            if (weekList.contains(DateTimeUtils.getWeek(start).toString())) {
                ++count;
            }
            start = start.plusDays(1L);
        }
        return count;
    }

    public static Integer getWeek(LocalDate localDate) {
        Integer week = localDate.getDayOfWeek().getValue();
        return week;
    }

    public static String getWeekName(LocalDate localDate) {
        Integer week = localDate.getDayOfWeek().getValue();
        String weekName = weekNames[week - 1];
        return weekName;
    }

    public static String getYearWeekStr(LocalDate localDate) {
        WeekFields weekFields = WeekFields.ISO;
        int weekNumber = localDate.get(weekFields.weekOfWeekBasedYear());
        String weekStr = weekNumber > 10 ? String.valueOf(weekNumber) : String.format("0%s", weekNumber);
        int year = localDate.getYear();
        int month = localDate.getMonth().getValue();
        if (month < 12 && weekNumber > 51) {
            --year;
        }
        weekStr = year + weekStr;
        return weekStr;
    }

    public static int localDateBetween(LocalDate start, LocalDate end) {
        Period between = Period.between(start, end);
        return between.getDays();
    }

    public static void main(String[] args) {
        LocalDate localDate = DateTimeUtils.parseLocalDate("2022-01-09");
        LocalDate end = DateTimeUtils.parseLocalDate("2022-01-07");
        TreeSet<String> set = new TreeSet<String>();
        set.add("1");
        Integer integer = DateTimeUtils.countDays(localDate, end, set);
        System.out.println(integer);
        if (localDate.isAfter(end)) {
            System.out.println(">>>>>>>>>>");
        }
    }
}

