/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.coop.mix.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.xforceplus.ant.coop.rule.center.client.utils.BeanUtil;
import com.xforceplus.ant.coop.security.user.domain.CurrentUser;
import com.xforceplus.coop.mix.client.invoice.PhoenixInvoiceOperateClient;
import com.xforceplus.coop.mix.model.MixBaseEntity;
import com.xforceplus.coop.mix.model.MixSellerInvoiceEntity;
import com.xforceplus.coop.mix.model.MixSellerInvoiceItemEntity;
import com.xforceplus.coop.mix.utils.CommonTools;
import com.xforceplus.coop.mix.utils.RequestTools;
import com.xforceplus.seller.enums.InvoiceStatus;
import com.xforceplus.seller.invoice.client.model.AbandonSellerInvoiceRequest;
import com.xforceplus.seller.invoice.client.model.BatchReverseRequest;
import com.xforceplus.seller.invoice.client.model.InvoiceItem;
import com.xforceplus.seller.invoice.client.model.LockInvoiceRequest;
import com.xforceplus.seller.invoice.client.model.SellerInvoiceInfo;
import com.xforceplus.seller.invoice.client.model.UpdateInvoiceDetailRequest;
import com.xforceplus.seller.invoice.client.model.update.InvoiceUpdateRequest;
import com.xforceplus.xplatframework.apimodel.BaseAsyncResponse;
import com.xforceplus.xplatframework.model.Response;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PhoenixInvoiceOperateMixService {
    private static final Logger log = LoggerFactory.getLogger(PhoenixInvoiceOperateMixService.class);
    @Autowired
    private PhoenixInvoiceOperateClient phoenixInvoiceOperateClient;

    public Response updateInvoiceEntityById(MixSellerInvoiceEntity invoiceEntity) {
        return this.updateInvoiceBatch(Lists.newArrayList((Object[])new MixSellerInvoiceEntity[]{invoiceEntity}));
    }

    public Response updateInvoiceBatch(List<MixSellerInvoiceEntity> invoiceEntityList) {
        if (CollectionUtils.isEmpty(invoiceEntityList)) {
            return Response.failed((String)"\u66f4\u65b0\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List updateIdList = invoiceEntityList.stream().map(MixBaseEntity::getId).collect(Collectors.toList());
        if (!updateIdList.stream().allMatch(CommonTools::isEdit)) {
            return Response.failed((String)"\u53d1\u7968id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            List invoiceInfoList = invoiceEntityList.stream().map(this::convertByMixInvoice).collect(Collectors.toList());
            InvoiceUpdateRequest request = new InvoiceUpdateRequest();
            request.setSellerGroupId(CurrentUser.getTenantId());
            request.setUpdateInvoiceList(invoiceInfoList);
            return this.phoenixInvoiceOperateClient.updateInvoiceList(JSON.toJSONString((Object)request));
        }
        catch (Exception e) {
            log.error("\u6839\u636eid\u66f4\u65b0\u53d1\u7968\u5f02\u5e38:{}", updateIdList, (Object)e);
            return Response.failed((String)"\u66f4\u65b0\u5931\u8d25");
        }
    }

    public Response<?> updateInvoiceItemBatch(List<MixSellerInvoiceItemEntity> invoiceItemEntityList) {
        if (CollectionUtils.isEmpty(invoiceItemEntityList)) {
            return Response.failed((String)"\u53d1\u7968\u660e\u7ec6\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (invoiceItemEntityList.stream().anyMatch(entity -> !CommonTools.isEdit(entity.getId()))) {
            return Response.failed((String)"\u53d1\u7968\u660e\u7ec6id\u4e0d\u53ef\u4e3a\u7a7a");
        }
        try {
            List invoiceItemList = invoiceItemEntityList.stream().map(item -> {
                InvoiceItem invoiceItem = new InvoiceItem();
                BeanUtil.copyProperties((Object)item, (Object)invoiceItem);
                invoiceItem.setId(item.getId());
                return invoiceItem;
            }).collect(Collectors.toList());
            UpdateInvoiceDetailRequest updateInvoiceDetailRequest = new UpdateInvoiceDetailRequest();
            updateInvoiceDetailRequest.setInvoiceDetails(invoiceItemList);
            log.info("\u9500\u9879\u53d1\u7968\u660e\u7ec6\u66f4\u65b0:{}", (Object)JSON.toJSONString(invoiceItemList));
            Response response = this.phoenixInvoiceOperateClient.updateInvoiceItem(updateInvoiceDetailRequest);
            log.info("\u9500\u9879\u53d1\u7968\u660e\u7ec6\u66f4\u65b0\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)response));
            return response;
        }
        catch (Error | Exception e) {
            log.error("updateInvoiceItemBatch {}\uff0cerror:", (Object)JSON.toJSONString(invoiceItemEntityList), (Object)e);
            return Response.failed((String)e.getMessage());
        }
    }

    public BaseAsyncResponse abandonInvoice(List<Long> invoiceIdList, String reason, Long txId, Integer releaseType) {
        BaseAsyncResponse baseAsyncResponse = new BaseAsyncResponse();
        try {
            AbandonSellerInvoiceRequest abandonSellerInvoiceRequest = new AbandonSellerInvoiceRequest();
            abandonSellerInvoiceRequest.setInvoiceIds(invoiceIdList);
            abandonSellerInvoiceRequest.setReleaseType(releaseType);
            abandonSellerInvoiceRequest.setReason(reason);
            abandonSellerInvoiceRequest.setStatus(InvoiceStatus.NORMAL.value());
            abandonSellerInvoiceRequest.setTaskId(txId);
            log.info("\u53d1\u7968\u4f5c\u5e9f\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)abandonSellerInvoiceRequest));
            baseAsyncResponse = this.phoenixInvoiceOperateClient.abandonInvoice(abandonSellerInvoiceRequest);
        }
        catch (Error | Exception e) {
            log.error("\u53d1\u7968\u4f5c\u5e9f\u8bf7\u6c42\u5f02\u5e38:{}", (Object)txId, (Object)e);
            baseAsyncResponse.setCode(Response.Fail);
            baseAsyncResponse.setMessage(e.getMessage());
        }
        return baseAsyncResponse;
    }

    public BaseAsyncResponse redFlushInvoice(BatchReverseRequest redFlushRequest) {
        BaseAsyncResponse baseAsyncResponse = new BaseAsyncResponse();
        try {
            redFlushRequest.setRequestSource("90");
            redFlushRequest.setReleaseType(Integer.valueOf(1));
            log.info("\u53d1\u7968\u7ea2\u51b2\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)redFlushRequest));
            baseAsyncResponse = this.phoenixInvoiceOperateClient.batchReverse(redFlushRequest);
        }
        catch (Error | Exception e) {
            log.error("\u53d1\u7968\u7ea2\u51b2\u8bf7\u6c42\u5f02\u5e38:{}", (Object)redFlushRequest.getTaskId(), (Object)e);
            baseAsyncResponse.setCode(Response.Fail);
            baseAsyncResponse.setMessage(e.getMessage());
        }
        return baseAsyncResponse;
    }

    public Response lockInvoice(List<Long> idList) {
        Response result = new Response();
        LockInvoiceRequest lockInvoiceRequest = new LockInvoiceRequest();
        lockInvoiceRequest.setIncludes(idList);
        lockInvoiceRequest.setIsAllSelected(Boolean.FALSE);
        try {
            result = this.phoenixInvoiceOperateClient.lockInvoice(lockInvoiceRequest);
        }
        catch (Exception e) {
            log.error("lockInvoice error:{}", (Object)JSON.toJSONString(idList), (Object)e);
            result.setCode(Response.Fail);
        }
        return result;
    }

    public SellerInvoiceInfo convertByMixInvoice(MixSellerInvoiceEntity invoiceEntity) {
        if (invoiceEntity == null) {
            return null;
        }
        SellerInvoiceInfo sellerInvoiceInfo = new SellerInvoiceInfo();
        BeanUtil.copyProperties((Object)invoiceEntity, (Object)sellerInvoiceInfo);
        sellerInvoiceInfo.setId(invoiceEntity.getId());
        sellerInvoiceInfo.setSellerGroupId(invoiceEntity.getSellerTenantId());
        sellerInvoiceInfo.setPurchaserGroupId(invoiceEntity.getPurchaserTenantId());
        String pdfSuffix = ".pdf";
        String pdfPath = invoiceEntity.getPdfPath();
        if (Objects.nonNull(pdfPath)) {
            if (StringUtils.containsIgnoreCase((CharSequence)pdfPath, (CharSequence)".pdf")) {
                sellerInvoiceInfo.setPdfPath(pdfPath);
            } else {
                sellerInvoiceInfo.setOfdPath(pdfPath);
            }
        }
        RequestTools.setObject(Objects::nonNull, arg_0 -> ((SellerInvoiceInfo)sellerInvoiceInfo).setPdfPath(arg_0), invoiceEntity.getOfdToPdf());
        RequestTools.setObject(Objects::nonNull, arg_0 -> ((SellerInvoiceInfo)sellerInvoiceInfo).setInvoiceUrl(arg_0), invoiceEntity.getOfdToImg());
        RequestTools.setObject(Objects::nonNull, v -> sellerInvoiceInfo.setLockFlag(Integer.valueOf(v)), invoiceEntity.getLockStatus());
        RequestTools.setObject(Objects::nonNull, v -> sellerInvoiceInfo.setCreateUserId(String.valueOf(v)), invoiceEntity.getCreateUserId());
        RequestTools.setObject(Objects::nonNull, v -> sellerInvoiceInfo.setUpdateUserId(String.valueOf(v)), invoiceEntity.getUpdateUserId());
        RequestTools.setObject(Objects::nonNull, v -> sellerInvoiceInfo.setDeposeUserId(String.valueOf(v)), invoiceEntity.getDeposeUserId());
        return sellerInvoiceInfo;
    }
}

