/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.coop.mix.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.xforceplus.ant.coop.rule.center.client.utils.BeanUtil;
import com.xforceplus.ant.coop.security.user.domain.CurrentUser;
import com.xforceplus.coop.mix.client.preinvoice.PhoenixPreviewInvoiceClient;
import com.xforceplus.coop.mix.client.preinvoice.PhoenixPreviewInvoiceSplitClient;
import com.xforceplus.coop.mix.common.exception.CoopMixException;
import com.xforceplus.coop.mix.model.MixPreInvoiceEntity;
import com.xforceplus.coop.mix.model.MixPreInvoiceItemEntity;
import com.xforceplus.coop.mix.model.response.MakeOutResponse;
import com.xforceplus.coop.mix.service.CommonMixService;
import com.xforceplus.coop.mix.utils.CommonTools;
import com.xforceplus.coop.mix.utils.RequestTools;
import com.xforceplus.seller.enums.BusinessOperationType;
import com.xforceplus.seller.invoice.client.model.BillInfo;
import com.xforceplus.seller.invoice.client.model.DeletePreInvoicesRequest;
import com.xforceplus.seller.invoice.client.model.LogAddRequest;
import com.xforceplus.seller.invoice.client.model.MakeOutPreInvoiceInfo;
import com.xforceplus.seller.invoice.client.model.PreInvoiceDetail;
import com.xforceplus.seller.invoice.client.model.SplitPreInvoiceRequest;
import com.xforceplus.seller.invoice.client.model.SplitPreInvoiceResponse;
import com.xforceplus.seller.invoice.client.model.SplitRule;
import com.xforceplus.seller.invoice.client.model.UpdatePreDetailRequest;
import com.xforceplus.seller.invoice.client.model.UpdatePreInvoiceByIdRequest;
import com.xforceplus.seller.invoice.client.model.UpdatePreInvoiceByIdsRequest;
import com.xforceplus.xplatframework.model.Response;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PhoenixPreviewInvoiceOperationMixService {
    private static final Logger log = LoggerFactory.getLogger(PhoenixPreviewInvoiceOperationMixService.class);
    @Autowired
    private PhoenixPreviewInvoiceClient phoenixPreviewInvoiceClient;
    @Autowired
    private PhoenixPreviewInvoiceSplitClient phoenixPreviewInvoiceSplitClient;

    public MakeOutResponse makeOut(MakeOutPreInvoiceInfo makeOutPreInvoiceInfo) {
        MakeOutResponse makeOutResponse = new MakeOutResponse();
        try {
            Response response = this.phoenixPreviewInvoiceClient.makeOut(makeOutPreInvoiceInfo);
            makeOutResponse.setCode(response.getCode());
            makeOutResponse.setMessage(response.getMessage());
            if (Response.OK.equals(response.getCode())) {
                String taskId = CommonMixService.convertData((Object)response, String.class, "result.taskId");
                makeOutResponse.setTaskId(taskId);
            }
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u9500\u9879\u5f00\u5177\u63a5\u53e3error\uff1a", (Throwable)e);
            makeOutResponse.setCode(Response.Fail);
            makeOutResponse.setMessage(e.getMessage());
        }
        return makeOutResponse;
    }

    public SplitPreInvoiceResponse splitPreInvoice(BillInfo billInfo, SplitRule splitRule, Long txId) {
        SplitPreInvoiceResponse response = new SplitPreInvoiceResponse();
        try {
            SplitPreInvoiceRequest splitPreInvoiceRequest = new SplitPreInvoiceRequest();
            splitPreInvoiceRequest.setBillInfo(billInfo);
            splitPreInvoiceRequest.setMergeType(0);
            splitPreInvoiceRequest.setSplitRule(splitRule);
            splitPreInvoiceRequest.setBatchNo(Long.valueOf(Long.parseLong(billInfo.getSalesbillId())));
            splitPreInvoiceRequest.setSplitType(1);
            splitPreInvoiceRequest.setOperatorUser(CurrentUser.getCurrentUserName());
            splitPreInvoiceRequest.setTaskId(txId);
            splitPreInvoiceRequest.setRequestSource("90");
            response = this.phoenixPreviewInvoiceSplitClient.splitAndMakeOut(Lists.newArrayList((Object[])new SplitPreInvoiceRequest[]{splitPreInvoiceRequest}));
        }
        catch (Error | Exception e) {
            log.error("\u53d1\u8d77\u62c6\u7968\u8bf7\u6c42\u5f02\u5e38:", e);
            response.setCode(Response.Fail);
            response.setMessage(e.getMessage());
        }
        return response;
    }

    public Response deletePreInvoice(List<Long> preInvoiceIds) {
        if (CollectionUtils.isEmpty(preInvoiceIds)) {
            return Response.ok((String)"\u53c2\u6570\u4e3a\u7a7a");
        }
        DeletePreInvoicesRequest deletePreInvoicesRequest = new DeletePreInvoicesRequest();
        deletePreInvoicesRequest.setPreInvoiceIds(preInvoiceIds);
        return this.deletePreInvoice(deletePreInvoicesRequest);
    }

    public Response deletePreInvoiceByBill(List<Long> billIds) {
        if (CollectionUtils.isEmpty(billIds)) {
            return Response.ok((String)"\u53c2\u6570\u4e3a\u7a7a");
        }
        DeletePreInvoicesRequest deletePreInvoicesRequest = new DeletePreInvoicesRequest();
        deletePreInvoicesRequest.setBillIds(billIds);
        return this.deletePreInvoice(deletePreInvoicesRequest);
    }

    public Response deletePreInvoice(DeletePreInvoicesRequest request) {
        try {
            return this.phoenixPreviewInvoiceClient.deletePreInvoice(request);
        }
        catch (Error | Exception e) {
            log.error("\u5220\u9664\u9884\u5236\u53d1\u7968\u5f02\u5e38 \u53c2\u6570:{} error:", (Object)JSON.toJSONString((Object)request), (Object)e);
            return Response.failed((String)e.getMessage());
        }
    }

    public Response<?> deletePreInvoiceEx(List<Long> preInvoiceIds) {
        if (CollectionUtils.isEmpty(preInvoiceIds)) {
            return Response.ok((String)"\u53c2\u6570\u4e3a\u7a7a");
        }
        DeletePreInvoicesRequest deletePreInvoicesRequest = new DeletePreInvoicesRequest();
        deletePreInvoicesRequest.setPreInvoiceIds(preInvoiceIds);
        return this.deletePreInvoiceEx(deletePreInvoicesRequest);
    }

    public Response<?> deletePreInvoiceByBillEx(List<Long> billIds) {
        if (CollectionUtils.isEmpty(billIds)) {
            return Response.ok((String)"\u53c2\u6570\u4e3a\u7a7a");
        }
        DeletePreInvoicesRequest deletePreInvoicesRequest = new DeletePreInvoicesRequest();
        deletePreInvoicesRequest.setBillIds(billIds);
        return this.deletePreInvoiceEx(deletePreInvoicesRequest);
    }

    public Response<?> deletePreInvoiceEx(DeletePreInvoicesRequest request) {
        try {
            return this.phoenixPreviewInvoiceClient.deletePreInvoice(request);
        }
        catch (Error | Exception e) {
            log.error("\u5220\u9664\u9884\u5236\u53d1\u7968\u5f02\u5e38 \u53c2\u6570:{} error:", (Object)JSON.toJSONString((Object)request), (Object)e);
            throw new CoopMixException(e.getMessage());
        }
    }

    public Response<?> updatePreInvoiceItemList(List<MixPreInvoiceItemEntity> itemEntityList) {
        if (CollectionUtils.isEmpty(itemEntityList)) {
            return Response.failed((String)"\u9884\u5236\u53d1\u7968\u660e\u7ec6\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (itemEntityList.stream().anyMatch(entity -> !CommonTools.isEdit(entity.getId()))) {
            return Response.failed((String)"\u9884\u5236\u53d1\u7968\u660e\u7ec6id\u4e0d\u53ef\u4e3a\u7a7a");
        }
        try {
            List preInvoiceDetails = itemEntityList.stream().map(item -> {
                PreInvoiceDetail preInvoiceDetail = new PreInvoiceDetail();
                BeanUtil.copyProperties((Object)item, (Object)preInvoiceDetail);
                preInvoiceDetail.setId(item.getId());
                return preInvoiceDetail;
            }).collect(Collectors.toList());
            UpdatePreDetailRequest updatePreDetailRequest = new UpdatePreDetailRequest();
            updatePreDetailRequest.setPreInvoiceDetails(preInvoiceDetails);
            log.info("\u9500\u9879\u9884\u5236\u53d1\u7968\u660e\u7ec6\u66f4\u65b0:{}", (Object)JSON.toJSONString(preInvoiceDetails));
            Response response = this.phoenixPreviewInvoiceClient.updatePreDetails(updatePreDetailRequest);
            log.info("\u9500\u9879\u9884\u5236\u53d1\u7968\u660e\u7ec6\u66f4\u65b0\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)response));
            return response;
        }
        catch (Error | Exception e) {
            log.error("updatePreInvoiceItemList {}\uff0cerror:", (Object)JSON.toJSONString(itemEntityList), (Object)e);
            return Response.failed((String)e.getMessage());
        }
    }

    public Response updateByPreInvoiceIds(MixPreInvoiceEntity preInvoiceEntity, List<Long> preInvoiceIds) {
        if (CollectionUtils.isEmpty(preInvoiceIds)) {
            return Response.failed((String)"\u9884\u5236\u53d1\u7968id\u4e0d\u53ef\u4e3a\u7a7a");
        }
        UpdatePreInvoiceByIdsRequest request = new UpdatePreInvoiceByIdsRequest();
        BeanUtil.copyProperties((Object)preInvoiceEntity, (Object)request);
        request.setPreInvoiceIds(preInvoiceIds);
        request.setRequestSource("cooperate");
        try {
            return this.phoenixPreviewInvoiceClient.updatePreInvoiceByIds(request);
        }
        catch (Error | Exception e) {
            log.error("\u6279\u91cf\u66f4\u65b0\u9884\u5236\u53d1\u7968\u5f02\u5e38 {}\uff0cerror:", preInvoiceIds, (Object)e);
            return Response.failed((String)e.getMessage());
        }
    }

    public Response updateByPreInvoiceId(MixPreInvoiceEntity preInvoiceEntity) {
        if (!CommonTools.isEdit(preInvoiceEntity.getId())) {
            return Response.failed((String)"\u9884\u5236\u53d1\u7968id\u4e0d\u53ef\u4e3a\u7a7a");
        }
        return this.updatePreInvoiceList(Lists.newArrayList((Object[])new MixPreInvoiceEntity[]{preInvoiceEntity}));
    }

    public void addLog(Long preInvoiceId, BusinessOperationType operationType, String content) {
        if (CommonTools.isEdit(preInvoiceId)) {
            return;
        }
        LogAddRequest logAddRequest = new LogAddRequest();
        logAddRequest.setPreInvoiceId(preInvoiceId);
        logAddRequest.setOperationType(Long.valueOf(Integer.valueOf(operationType.getType()).longValue()));
        logAddRequest.setOperationRemark("");
        logAddRequest.setOperationContent(content);
        try {
            this.phoenixPreviewInvoiceClient.logAdd(Lists.newArrayList());
        }
        catch (Error | Exception e) {
            log.error("\u6dfb\u52a0\u9884\u5236\u53d1\u7968\u65e5\u5fd7\u5f02\u5e38 {}\uff0cerror:", (Object)preInvoiceId, (Object)e);
        }
    }

    public Response updatePreInvoiceList(List<MixPreInvoiceEntity> preInvoiceEntityList) {
        if (CollectionUtils.isEmpty(preInvoiceEntityList)) {
            return Response.failed((String)"\u9884\u5236\u53d1\u7968\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (preInvoiceEntityList.stream().anyMatch(entity -> !CommonTools.isEdit(entity.getId()))) {
            return Response.failed((String)"\u9884\u5236\u53d1\u7968id\u4e0d\u53ef\u4e3a\u7a7a");
        }
        List<UpdatePreInvoiceByIdRequest> updateList = preInvoiceEntityList.stream().map(this::Convert).collect(Collectors.toList());
        try {
            return this.phoenixPreviewInvoiceClient.updatePreInvoiceList(updateList);
        }
        catch (Error | Exception e) {
            log.error("updatePreInvoiceList {}\uff0cerror:", (Object)JSON.toJSONString(preInvoiceEntityList), (Object)e);
            return Response.failed((String)e.getMessage());
        }
    }

    private UpdatePreInvoiceByIdRequest Convert(MixPreInvoiceEntity preInvoiceEntity) {
        UpdatePreInvoiceByIdRequest request = new UpdatePreInvoiceByIdRequest();
        BeanUtil.copyProperties((Object)preInvoiceEntity, (Object)request);
        request.setId(preInvoiceEntity.getId());
        request.setSellerGroupId(CurrentUser.getTenantId());
        RequestTools.setObject(Objects::nonNull, arg_0 -> ((UpdatePreInvoiceByIdRequest)request).setMakingReason(arg_0), preInvoiceEntity.getRedReason());
        return request;
    }
}

