/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.coop.mix.utils;

import com.google.common.collect.Lists;
import com.xforceplus.seller.invoice.client.model.RequestField;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class SellerConditionQueryTools {
    public static void addLongField(List<RequestField> requestFieldList, String fieldName, Long value, QueryType queryType) {
        if (value == null || requestFieldList == null) {
            return;
        }
        requestFieldList.add(SellerConditionQueryTools.getRequestField(fieldName, value.toString(), queryType, QueryVirtual.MAIN.getCode()));
    }

    public static void addLongFieldList(List<RequestField> requestFieldList, String fieldName, List<Long> values, QueryType queryType) {
        if (CollectionUtils.isEmpty(values) || requestFieldList == null) {
            return;
        }
        requestFieldList.add(SellerConditionQueryTools.getRequestField(fieldName, values.stream().map(String::valueOf).collect(Collectors.toList()), queryType, QueryVirtual.MAIN.getCode()));
    }

    public static void addIntegerField(List<RequestField> requestFieldList, String fieldName, Integer value, QueryType queryType) {
        if (value == null || requestFieldList == null) {
            return;
        }
        requestFieldList.add(SellerConditionQueryTools.getRequestField(fieldName, value.toString(), queryType, QueryVirtual.MAIN.getCode()));
    }

    public static void addIntegerFieldList(List<RequestField> requestFieldList, String fieldName, List<Integer> values, QueryType queryType) {
        if (CollectionUtils.isEmpty(values) || requestFieldList == null) {
            return;
        }
        requestFieldList.add(SellerConditionQueryTools.getRequestField(fieldName, values.stream().map(String::valueOf).collect(Collectors.toList()), queryType, QueryVirtual.MAIN.getCode()));
    }

    public static void addFieldNotNull(List<RequestField> requestFieldList, String fieldName, String value, QueryType queryType) {
        if (value == null || requestFieldList == null) {
            return;
        }
        requestFieldList.add(SellerConditionQueryTools.getRequestField(fieldName, value, queryType, QueryVirtual.MAIN.getCode()));
    }

    public static void addFieldNotEmpty(List<RequestField> requestFieldList, String fieldName, String value, QueryType queryType) {
        if (StringUtils.isEmpty((Object)value) || requestFieldList == null) {
            return;
        }
        requestFieldList.add(SellerConditionQueryTools.getRequestField(fieldName, value, queryType, QueryVirtual.MAIN.getCode()));
    }

    public static void addFieldList(List<RequestField> requestFieldList, String fieldName, List<String> values, QueryType queryType) {
        if (CollectionUtils.isEmpty(values) || requestFieldList == null) {
            return;
        }
        requestFieldList.add(SellerConditionQueryTools.getRequestField(fieldName, values, queryType, QueryVirtual.MAIN.getCode()));
    }

    public static RequestField getRequestField(String fieldName, String value, QueryType queryType, String virtual) {
        if (value == null) {
            return null;
        }
        RequestField requestField = new RequestField();
        requestField.setFieldName(fieldName);
        requestField.setValue((List)Lists.newArrayList((Object[])new String[]{value}));
        requestField.setFieldQueryType(queryType.getType());
        requestField.setVirtual(virtual);
        return requestField;
    }

    public static RequestField getRequestField(String fieldName, List<String> values, QueryType queryType, String virtual) {
        if (CollectionUtils.isEmpty(values)) {
            return null;
        }
        RequestField requestField = new RequestField();
        requestField.setFieldName(fieldName);
        requestField.setValue(values);
        requestField.setFieldQueryType(queryType.getType());
        requestField.setVirtual(virtual);
        return requestField;
    }

    public static enum QueryField {
        SELLER_NAME("sellerName", "\u9500\u65b9\u516c\u53f8\u540d\u79f0"),
        SELLER_TAX_NO("sellerTaxNo", "\u9500\u65b9\u516c\u53f8\u7a0e\u53f7"),
        SELLER_GROUP_ID("sellerGroupId", "\u9500\u65b9\u79df\u6237id\uff08\u540csellerTenantId\uff09"),
        PURCHASER_NAME("purchaserName", "\u8d2d\u65b9\u516c\u53f8\u540d\u79f0"),
        PURCHASER_TAX_NO("purchaserTaxNo", "\u8d2d\u65b9\u516c\u53f8\u7a0e\u53f7"),
        PURCHASER_GROUP_ID("purchaserGroupId", "\u8d2d\u65b9\u79df\u6237id\uff08\u540cpurchaserTenantId\uff09"),
        SALES_BILL_ID("salesbillId", "\u5355\u636eid"),
        SALES_BILL_NO("salesbillNo", "\u5355\u636e\u53f7"),
        TAX_INVOICE_SOURCE("taxInvoiceSource", "\u56fd\u7a0e\u53d1\u7968\u6765\u6e90"),
        INVOICE_KIND("invoiceKind", "\u53d1\u7968\u7968\u79cd"),
        INVOICE_TYPE("invoiceType", "\u53d1\u7968\u7c7b\u578b"),
        BILL_TYPE("billType", "\u5355\u636e\u7c7b\u578b"),
        SALES_BILL_TYPE("salesbillType", "\u5355\u636e\u7c7b\u578b"),
        INVOICE_CODE("invoiceCode", "\u53d1\u7968\u4ee3\u7801"),
        INVOICE_NO("invoiceNo", "\u53d1\u7968\u53f7\u7801"),
        ALL_ELECTRIC_INVOICE_NO("allElectricInvoiceNo", "\u5168\u7535\u53d1\u7968\u53f7\u7801"),
        PAPER_DRAW_DATE("paperDrawDate", "\u5f00\u7968\u65e5\u671f"),
        TAX_AMOUNT("taxAmount", "\u7a0e\u989d"),
        AMOUNT_WITHOUT_TAX("amountWithoutTax", "\u4e0d\u542b\u7a0e\u91d1\u989d"),
        AMOUNT_WITH_TAX("amountWithTax", "\u542b\u7a0e\u91d1\u989d"),
        PRINT_STATUS("printStatus", "\u6253\u5370\u72b6\u6001"),
        SCAN_STATUS("scanStatus", "\u626b\u63cf\u72b6\u6001"),
        SCAN_TIME("scanTime", "\u626b\u63cf\u65f6\u95f4"),
        RECEIPT_STATUS("receiptStatus", "\u7b7e\u6536\u72b6\u6001"),
        RECEIPT_TIME("receiptTime", "\u7b7e\u6536\u65f6\u95f4"),
        IDENTIFY_STATUS("identifyStatus", "\u8ba4\u8bc1\u72b6\u6001"),
        IDENTIFY_TIME("identifyTime", "\u8ba4\u8bc1\u65f6\u95f4"),
        CHECK_TIME("checkTime", "\u52fe\u9009\u65f6\u95f4"),
        PAYMENT_STATUS("paymentStatus", "\u4ed8\u6b3e\u72b6\u6001"),
        INVOICE_ORIGIN("invoiceOrigin", "\u53d1\u7968\u6765\u6e90"),
        VERIFY_STATUS("verifyStatus", "\u9a8c\u771f\u72b6\u6001"),
        VERIFY_REMARK("verifyRemark", "\u9a8c\u771f\u5907\u6ce8"),
        ASSOCIATE_STATUS("associateStatus", "\u5173\u8054\u72b6\u6001"),
        RETREAT_STATUS("retreatStatus", "\u9000\u7968\u72b6\u6001"),
        RETREAT_TIME("retreatTime", "\u9000\u7968\u65f6\u95f4"),
        APPROVE_STATUS("approveStatus", "\u5ba1\u6838\u72b6\u6001"),
        APPROVE_TIME("approveTime", "\u5ba1\u6838\u65f6\u95f4"),
        IS_AGENCY("isAgency", "\u662f\u5426\u4ee3\u5f00\u53d1\u7968"),
        AGENCY_NAME("agencyName", "\u4ee3\u5f00\u673a\u6784\u540d\u79f0"),
        AGENCY_TAX_NO("agencyTaxNo", "\u4ee3\u5f00\u673a\u6784\u7a0e\u53f7"),
        SALES_LIST_FILE_FLAG("saleListFileFlag", "\u662f\u5426\u542b\u9500\u8d27\u6e05\u5355"),
        SPECIAL_INVOICE_FLAG("specialInvoiceFlag", "\u7279\u6b8a\u4e1a\u52a1\u7c7b\u578b"),
        INVOICE_COLOR("invoiceColor", "\u7ea2\u84dd\u6807\u8bc6"),
        PROCESS_REMARK("processRemark", "\u9519\u8bef\u4fe1\u606f"),
        STATUS("status", "\u72b6\u6001"),
        RED_FLAG("redFlag", "\u7ea2\u51b2\u72b6\u6001"),
        SYS_ORG_ID("sysOrgId", "\u7ec4\u7ec7id"),
        COOPERATE_FLAG("cooperateFlag", "\u662f\u5426\u534f\u540c"),
        PARCEL_NO("parcelNo", "\u7269\u6d41\u5355\u53f7"),
        UPDATE_TIME("updateTime", "\u66f4\u65b0\u65f6\u95f4"),
        EXT1("ext1", "\u6269\u5c55\u5b57\u6bb51"),
        EXT2("ext2", "\u6269\u5c55\u5b57\u6bb52"),
        EXT3("ext3", "\u6269\u5c55\u5b57\u6bb53");

        private final String fieldName;
        private final String desc;

        public String fieldName() {
            return this.fieldName;
        }

        private QueryField(String fieldName, String desc) {
            this.fieldName = fieldName;
            this.desc = desc;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static enum QueryType {
        EQ("eq", "\u7b49\u4e8e"),
        LIKE("like", "\u6a21\u7cca\u67e5\u8be2"),
        CHECKBOX("checkbox", "\u6279\u91cf\u7cbe\u786e\u67e5\u8be2"),
        RANGE("range", "\u8303\u56f4\u67e5\u8be2");

        private final String type;
        private final String desc;

        private QueryType(String type, String desc) {
            this.type = type;
            this.desc = desc;
        }

        public String getType() {
            return this.type;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static enum QueryVirtual {
        MAIN("0", "\u4e3b\u4fe1\u606f"),
        ITEM("2", "\u660e\u7ec6");

        private final String code;
        private final String desc;

        private QueryVirtual(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public String getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }
    }
}

