/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.coop.mix.config;

import com.xforceplus.ant.coop.feign.domain.MixCanaryHolder;
import com.xforceplus.ant.coop.feign.domain.MixCanaryInfo;
import com.xforceplus.ant.coop.security.user.domain.UserAuthInfoHolder;
import com.xforceplus.ant.coop.security.utils.JsonUtils;
import com.xforceplus.coop.mix.model.MixUserInfo;
import com.xforceplus.coop.mix.utils.CommonTools;
import com.xforceplus.tenantsecurity.domain.IAuthorizedUser;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Base64Utils;

public class MixUserInfoInterceptor
implements RequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(MixUserInfoInterceptor.class);
    private static final String HEADER_KEY = "x-phoenix-userinfo";
    private static final String HEADER_NORMAL_USER_KEY = "x-userinfo";

    public void apply(RequestTemplate requestTemplate) {
        try {
            log.info("##### MixFeignConfig.RequestInterceptor \u62e6\u622a\u542f\u52a8");
            IAuthorizedUser authorizedUser = UserAuthInfoHolder.get();
            if (authorizedUser != null) {
                MixUserInfo mixUserInfo = new MixUserInfo();
                long tenantId = authorizedUser.getTenantId();
                MixCanaryInfo mixCanaryInfo = MixCanaryHolder.get();
                if (mixCanaryInfo != null && CommonTools.isEdit(CommonTools.toLong(mixCanaryInfo.getTenantId()))) {
                    log.info("\u9500\u534f\u878d\u5408\u7070\u5ea6\u8bbe\u7f6e\u79df\u6237\u66ff\u6362\u7528\u6237\u79df\u6237:{} -> {}", (Object)tenantId, (Object)mixCanaryInfo.getTenantId());
                    tenantId = CommonTools.toLong(mixCanaryInfo.getTenantId());
                }
                mixUserInfo.setGroupId(tenantId);
                mixUserInfo.setGroupCode(authorizedUser.getTenantCode());
                mixUserInfo.setGroupName(authorizedUser.getTenantName());
                mixUserInfo.setUserId(authorizedUser.getId());
                mixUserInfo.setUserName(authorizedUser.getUsername());
                mixUserInfo.setMobile(authorizedUser.getMobile());
                mixUserInfo.setEmail(authorizedUser.getEmail());
                String userInfoJson = JsonUtils.writeObjectToJson((Object)mixUserInfo);
                String userInfoJsonBase64 = Base64Utils.encodeToString((byte[])userInfoJson.getBytes("UTF-8"));
                log.info("##### MixFeignConfig.RequestInterceptor \u62e6\u622a\u8bbe\u7f6e\u7528\u6237\u4fe1\u606fheader key\uff1a{}\uff0cuserInfoJson \uff1a{}; userInfoJsonBase64\uff1a{}", new Object[]{HEADER_KEY, userInfoJson, userInfoJsonBase64});
                requestTemplate.header(HEADER_KEY, new String[]{userInfoJsonBase64});
                requestTemplate.header(HEADER_NORMAL_USER_KEY, new String[]{""});
            } else if (null != MixCanaryHolder.get()) {
                MixUserInfo mixUserInfo = new MixUserInfo();
                mixUserInfo.setGroupId(Long.valueOf(MixCanaryHolder.get().getTenantId()));
                mixUserInfo.setGroupName(MixCanaryHolder.get().getTenantName());
                String userInfoJson = JsonUtils.writeObjectToJson((Object)mixUserInfo);
                String userInfoJsonBase64 = Base64Utils.encodeToString((byte[])userInfoJson.getBytes("UTF-8"));
                log.info("##### MixFeignConfig.RequestInterceptor (\u6ca1\u6709\u7528\u6237\u4e0a\u4e0b\u6587-IAuthorizedUser,\u5b58\u5728\u7070\u5ea6\u4e0a\u4e0b\u6587-MixCanaryHolder)\u62e6\u622a\u8bbe\u7f6e\u7528\u6237\u4fe1\u606fheader key\uff1a{}\uff0cuserInfoJson \uff1a{}; userInfoJsonBase64\uff1a{}", new Object[]{HEADER_KEY, userInfoJson, userInfoJsonBase64});
                requestTemplate.header(HEADER_KEY, new String[]{userInfoJsonBase64});
                requestTemplate.header(HEADER_NORMAL_USER_KEY, new String[]{""});
            } else {
                log.info("##### MixFeignConfig.RequestInterceptor \u62e6\u622a\u672a\u8bbe\u7f6e\u7528\u6237\u4fe1\u606f,\u4e0a\u4e0b\u6587\u672a\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f");
            }
        }
        catch (Exception e) {
            log.error("##### MixFeignConfig.RequestInterceptor \u62e6\u622a\u5f02\u5e38\uff1a {}", (Throwable)e);
        }
    }
}

