/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.coop.mix.service;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.xforceplus.coop.mix.client.ClientFactory;
import com.xforceplus.coop.mix.common.enums.ClientType;
import com.xforceplus.coop.mix.utils.AssertTools;
import com.xforceplus.coop.mix.utils.FieldNameUtils;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CommonMixService {
    private static final Logger log = LoggerFactory.getLogger(CommonMixService.class);

    public static <T> T getClient(ClientType clientType) {
        return (T)ClientFactory.getClient(clientType);
    }

    public static <T, R> T convertData(Object response, Class<T> aClass, FieldNameUtils.TypeFunctional<R> typeFunctional) {
        String json = JSONObject.toJSONString((Object)response);
        String propertyName = FieldNameUtils.getPropertyName(typeFunctional);
        Object read = JSONPath.read((String)json, (String)String.format(".result.%s", propertyName));
        Object parse = JSONObject.parseObject((String)read.toString(), aClass);
        return (T)parse;
    }

    public static <T> T convertData(Object response, Class<T> aClass, String jsonPath) {
        String json = JSONObject.toJSONString((Object)response);
        Object read = JSONPath.read((String)json, (String)jsonPath);
        Object parse = JSONObject.parseObject((String)read.toString(), aClass);
        return (T)parse;
    }

    public static <T> T convertData(Object response, Class<T> aClass) {
        return CommonMixService.convertData(response, aClass, ".result");
    }

    public static void checkResponseCode(Object response) {
        CommonMixService.checkResponseCode(response, Response.OK.toString());
    }

    public static void checkResponseCode(Object response, String code) {
        String json = JSONObject.toJSONString((Object)response);
        Object read = JSONPath.read((String)json, (String)"code");
        AssertTools.isTrue(code.equals(read.toString()), JsonUtils.writeObjectToJson((Object)response));
    }
}

