/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.coop.mix.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.xforceplus.coop.common.enums.TaxInvoiceSourceEnum;
import com.xforceplus.coop.mix.client.invoice.PhoenixInvoiceQueryClient;
import com.xforceplus.coop.mix.common.enums.InvoiceAssociateStatusEnum;
import com.xforceplus.coop.mix.common.enums.InvoiceGainStatusEnum;
import com.xforceplus.coop.mix.common.enums.InvoiceVerifyStatusEnum;
import com.xforceplus.coop.mix.common.enums.SourceLineEnum;
import com.xforceplus.coop.mix.model.MixSellerInvoiceEntity;
import com.xforceplus.coop.mix.model.MixSellerInvoiceItemEntity;
import com.xforceplus.coop.mix.utils.BeanUtil;
import com.xforceplus.coop.mix.utils.CommonTools;
import com.xforceplus.seller.invoice.client.model.DataListResult;
import com.xforceplus.seller.invoice.client.model.InvoiceDetails;
import com.xforceplus.seller.invoice.client.model.InvoiceDetailsInfoResponse;
import com.xforceplus.seller.invoice.client.model.InvoiceItem;
import com.xforceplus.seller.invoice.client.model.InvoiceOperationLog;
import com.xforceplus.seller.invoice.client.model.InvoicePageQueryResult;
import com.xforceplus.seller.invoice.client.model.LogRequest;
import com.xforceplus.seller.invoice.client.model.QueryCompassInvoiceReuqest;
import com.xforceplus.seller.invoice.client.model.QueryInvoicesReuqest;
import com.xforceplus.seller.invoice.client.model.QuerySellerInvoice;
import com.xforceplus.seller.invoice.client.model.QuerySellerInvoiceDetailsRequest;
import com.xforceplus.seller.invoice.client.model.RequestField;
import com.xforceplus.seller.invoice.client.model.SellerInvoiceInfo;
import com.xforceplus.seller.invoice.client.model.SellerInvoiceItem;
import com.xforceplus.seller.invoice.client.model.SellerInvoiceQueryByConditionRequest;
import com.xforceplus.seller.invoice.client.model.SellerInvoiceQueryResponse;
import com.xforceplus.seller.invoice.client.model.SmartMatchInvoiceRequest;
import com.xforceplus.seller.invoice.client.model.SmartMatchInvoiceResult;
import com.xforceplus.seller.invoice.client.model.Sort;
import com.xforceplus.xplatframework.model.Response;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PhoenixInvoiceQueryMixService {
    private static final Logger log = LoggerFactory.getLogger(PhoenixInvoiceQueryMixService.class);
    public static Pattern TAX_RATE_PATTERN = Pattern.compile("[,\uff0c]+");
    @Autowired
    PhoenixInvoiceQueryClient phoenixInvoiceClient;

    public List<String> splitTaxRateStr(String taxRateStr) {
        if (StringUtils.isEmpty((CharSequence)taxRateStr)) {
            return Lists.newArrayList();
        }
        if (TAX_RATE_PATTERN.matcher(taxRateStr).find()) {
            return Arrays.asList(TAX_RATE_PATTERN.split(taxRateStr));
        }
        return Lists.newArrayList((Object[])new String[]{taxRateStr});
    }

    public MixSellerInvoiceEntity getSellerInvoiceMain(Long invoiceId) {
        return this.getSellerInvoiceById(invoiceId, Boolean.FALSE);
    }

    public MixSellerInvoiceEntity getSellerInvoiceMainAndItem(Long invoiceId) {
        return this.getSellerInvoiceById(invoiceId, Boolean.TRUE);
    }

    public MixSellerInvoiceEntity getSellerInvoiceById(Long invoiceId) {
        return this.getSellerInvoiceById(invoiceId, Boolean.FALSE);
    }

    public MixSellerInvoiceEntity getSellerInvoiceById(Long invoiceId, boolean queryItem) {
        QuerySellerInvoiceDetailsRequest request = new QuerySellerInvoiceDetailsRequest();
        request.setInvoiceId(invoiceId);
        request.setQueryItem(queryItem);
        return this.getSellerInvoiceByCondition(request);
    }

    public MixSellerInvoiceEntity getSellerInvoiceByOrigin(String originInvoiceNo, String originInvoiceCode) {
        QuerySellerInvoiceDetailsRequest request = new QuerySellerInvoiceDetailsRequest();
        request.setOriginInvoiceCode(originInvoiceCode);
        request.setOriginInvoiceNo(originInvoiceNo);
        request.setQueryItem(false);
        return this.getSellerInvoiceByCondition(request);
    }

    public MixSellerInvoiceEntity getSellerInvoiceByAllNo(String allElectricInvoiceNo) {
        QuerySellerInvoiceDetailsRequest request = new QuerySellerInvoiceDetailsRequest();
        request.setAllElectricInvoiceNo(allElectricInvoiceNo);
        request.setQueryItem(false);
        return this.getSellerInvoiceByCondition(request);
    }

    public MixSellerInvoiceEntity getSellerInvoiceByCondition(QuerySellerInvoiceDetailsRequest request) {
        try {
            log.info("\u67e5\u8be2\u5355\u5f20\u53d1\u7968\u4fe1\u606f\u53c2\u6570:{}", JSON.toJSON((Object)request));
            InvoiceDetailsInfoResponse response = this.phoenixInvoiceClient.queryInvoiceByCondition(request);
            if (!Response.OK.equals(response.getCode())) {
                return null;
            }
            InvoiceDetails invoiceDetails = response.getResult();
            if (null == invoiceDetails) {
                return null;
            }
            MixSellerInvoiceEntity invoiceEntity = this.convertBySellerInvoice(invoiceDetails.getInvoiceInfo());
            List invoiceItemList = invoiceDetails.getInvoiceItemList();
            if (CollectionUtils.isNotEmpty((Collection)invoiceItemList)) {
                ArrayList<MixSellerInvoiceItemEntity> itemList = new ArrayList<MixSellerInvoiceItemEntity>();
                for (InvoiceItem invoiceItem : invoiceItemList) {
                    MixSellerInvoiceItemEntity mixSellerInvoiceItemEntity = this.convertBySellerInvoiceItem(invoiceItem);
                    itemList.add(mixSellerInvoiceItemEntity);
                }
                invoiceEntity.setInvoiceItemList(itemList);
            }
            return invoiceEntity;
        }
        catch (Error | Exception e) {
            log.error("\u67e5\u8be2\u5355\u5f20\u53d1\u7968\u4fe1\u606fError:", e);
            return null;
        }
    }

    public InvoicePageQueryResult queryInvoiceList(List<RequestField> requestFieldList) {
        return this.queryInvoiceList(requestFieldList, 1, 1, null, null);
    }

    public InvoicePageQueryResult queryInvoiceList(List<RequestField> requestFieldList, Integer pageNo, Integer pageSize, List<Long> createTime, Sort sort) {
        SellerInvoiceQueryByConditionRequest conditionRequest = new SellerInvoiceQueryByConditionRequest();
        conditionRequest.setPageNo(Optional.ofNullable(pageNo).orElse(1));
        conditionRequest.setPageSize(Optional.ofNullable(pageSize).orElse(1000));
        conditionRequest.setStatus(Integer.valueOf(3));
        conditionRequest.setUserRole(Integer.valueOf(2));
        conditionRequest.setCreateTime(createTime);
        conditionRequest.setQueryWithAuth(Boolean.valueOf(false));
        Sort sort1 = this.getRequestSort("retreatStatus", 1);
        Sort sort2 = this.getRequestSort("invoiceNo", 1);
        if (Objects.nonNull(sort)) {
            conditionRequest.setSortList((List)Lists.newArrayList((Object[])new Sort[]{sort1, sort, sort2}));
        } else {
            conditionRequest.setSortList((List)Lists.newArrayList((Object[])new Sort[]{sort1, sort2}));
        }
        ArrayList requestFieldLists = Lists.newArrayList();
        requestFieldLists.add(requestFieldList);
        conditionRequest.setGroups((List)requestFieldLists);
        conditionRequest.setRequestSource("90");
        try {
            SellerInvoiceQueryResponse sellerInvoiceQueryResponse = this.phoenixInvoiceClient.queryInvoice(conditionRequest);
            return Optional.ofNullable(sellerInvoiceQueryResponse).map(SellerInvoiceQueryResponse::getResult).orElse(null);
        }
        catch (Error | Exception e) {
            log.error("\u590d\u6742\u67e5\u8be2\u53d1\u7968error:", e);
            InvoicePageQueryResult result = new InvoicePageQueryResult();
            result.setNormal(Long.valueOf(0L));
            result.setPanding(Long.valueOf(0L));
            result.setAbandoned(Long.valueOf(0L));
            result.setTotal(Long.valueOf(0L));
            result.setAuditRejected(Long.valueOf(0L));
            result.setAuditPass(Long.valueOf(0L));
            result.setList((List)Lists.newArrayList());
            return result;
        }
    }

    public MixSellerInvoiceEntity getSellerInvoiceEntity(@NotNull String invoiceNo, String invoiceCode) {
        QuerySellerInvoiceDetailsRequest request = new QuerySellerInvoiceDetailsRequest();
        request.setInvoiceNo(invoiceNo);
        request.setInvoiceCode(invoiceCode);
        request.setQueryItem(false);
        return this.getSellerInvoiceByCondition(request);
    }

    public List<MixSellerInvoiceEntity> listSellerInvoiceByPreInvoiceIds(@NotNull List<Long> preInvoiceIds, boolean queryItem) {
        if (CollectionUtils.isEmpty(preInvoiceIds)) {
            return Collections.emptyList();
        }
        QueryInvoicesReuqest request = new QueryInvoicesReuqest();
        request.setPreInvoiceIds(preInvoiceIds);
        request.setQueryItem(queryItem);
        request.setSalesbillIds((List)Lists.newArrayList());
        return this.listSellerInvoiceByCondition(request);
    }

    public List<MixSellerInvoiceEntity> listSellerInvoiceByPreInvoiceIds(@NotNull List<Long> preInvoiceIds) {
        if (CollectionUtils.isEmpty(preInvoiceIds)) {
            return Collections.emptyList();
        }
        QueryInvoicesReuqest request = new QueryInvoicesReuqest();
        request.setPreInvoiceIds(preInvoiceIds);
        request.setQueryItem(Boolean.FALSE.booleanValue());
        request.setSalesbillIds((List)Lists.newArrayList());
        return this.listSellerInvoiceByCondition(request);
    }

    public List<MixSellerInvoiceEntity> listSellerInvoiceByIds(@NotNull List<Long> invoiceIds, boolean queryItem) {
        if (CollectionUtils.isEmpty(invoiceIds)) {
            return Collections.emptyList();
        }
        QueryInvoicesReuqest request = new QueryInvoicesReuqest();
        request.setInvoiceIds(invoiceIds);
        request.setQueryItem(queryItem);
        request.setSalesbillIds((List)Lists.newArrayList());
        return this.listSellerInvoiceByCondition(request);
    }

    public List<MixSellerInvoiceEntity> listSellerInvoiceByIds(@NotNull List<Long> invoiceIds) {
        if (CollectionUtils.isEmpty(invoiceIds)) {
            return Collections.emptyList();
        }
        return this.listSellerInvoiceByIds(invoiceIds, Boolean.FALSE);
    }

    public List<MixSellerInvoiceEntity> listSellerInvoiceByBillIds(@NotNull List<Long> billIds, boolean queryItem) {
        if (CollectionUtils.isEmpty(billIds)) {
            return Collections.emptyList();
        }
        QueryInvoicesReuqest request = new QueryInvoicesReuqest();
        request.setSalesbillIds(billIds);
        request.setQueryItem(queryItem);
        return this.listSellerInvoiceByCondition(request);
    }

    public List<MixSellerInvoiceEntity> listSellerInvoiceByBillIds(@NotNull List<Long> billIds) {
        if (CollectionUtils.isEmpty(billIds)) {
            return Collections.emptyList();
        }
        QueryInvoicesReuqest request = new QueryInvoicesReuqest();
        request.setSalesbillIds(billIds);
        request.setQueryItem(Boolean.FALSE.booleanValue());
        return this.listSellerInvoiceByCondition(request);
    }

    public List<MixSellerInvoiceEntity> listSellerInvoiceByCondition(QueryInvoicesReuqest request) {
        try {
            log.info("listSellerInvoiceByCondition\u67e5\u8be2\u53d1\u7968\u5217\u8868\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)request));
            Response<List<InvoiceDetails>> listResponse = this.phoenixInvoiceClient.queryInvoiceWithDetailsList(request);
            if (Response.OK.equals(listResponse.getCode())) {
                List result = (List)listResponse.getResult();
                return result.stream().map(this::convertByInvoiceWithDetails).collect(Collectors.toList());
            }
            log.info("\u67e5\u8be2\u53d1\u7968\u5217\u8868\u5931\u8d25:{}", (Object)listResponse.getMessage());
        }
        catch (Error | Exception e) {
            log.error("\u67e5\u8be2\u53d1\u7968\u5217\u8868error:", e);
        }
        return Collections.emptyList();
    }

    public MixSellerInvoiceEntity convertByInvoiceWithDetails(InvoiceDetails invoice) {
        SellerInvoiceInfo invoiceInfo = invoice.getInvoiceInfo();
        MixSellerInvoiceEntity mixSellerInvoiceEntity = this.convertBySellerInvoice(invoiceInfo);
        if (CollectionUtils.isNotEmpty((Collection)invoice.getInvoiceItemList())) {
            List<MixSellerInvoiceItemEntity> mixItemEntities = invoice.getInvoiceItemList().stream().map(this::convertBySellerInvoiceItem).collect(Collectors.toList());
            mixSellerInvoiceEntity.setInvoiceItemList(mixItemEntities);
        }
        return mixSellerInvoiceEntity;
    }

    public MixSellerInvoiceEntity convertBySellerInvoice(SellerInvoiceInfo sellerInvoiceInfo) {
        if (sellerInvoiceInfo == null) {
            return null;
        }
        MixSellerInvoiceEntity mixSellerInvoiceEntity = new MixSellerInvoiceEntity();
        BeanUtil.copyInvoiceProperties(sellerInvoiceInfo, mixSellerInvoiceEntity);
        mixSellerInvoiceEntity.setId(sellerInvoiceInfo.getId());
        mixSellerInvoiceEntity.setSalesbillId(NumberUtils.toLong((String)sellerInvoiceInfo.getSalesbillId()));
        if (StringUtils.isNotEmpty((CharSequence)sellerInvoiceInfo.getOfdPath())) {
            mixSellerInvoiceEntity.setPdfPath(sellerInvoiceInfo.getOfdPath());
            mixSellerInvoiceEntity.setOfdToPdf(sellerInvoiceInfo.getPdfPath());
            mixSellerInvoiceEntity.setOfdToImg(sellerInvoiceInfo.getInvoiceUrl());
        } else if (StringUtils.isNotEmpty((CharSequence)sellerInvoiceInfo.getPdfPath())) {
            mixSellerInvoiceEntity.setPdfPath(sellerInvoiceInfo.getPdfPath());
        }
        mixSellerInvoiceEntity.setXmlUrl(sellerInvoiceInfo.getXmlUrl());
        if (TaxInvoiceSourceEnum.isAll((String)sellerInvoiceInfo.getTaxInvoiceSource())) {
            mixSellerInvoiceEntity.setQrCodeUrl(sellerInvoiceInfo.getCipherTextTwoCode());
        }
        InvoiceVerifyStatusEnum invoiceVerifyStatusEnum = InvoiceVerifyStatusEnum.fromValue(sellerInvoiceInfo.getVeriStatus());
        mixSellerInvoiceEntity.setGainStatus(invoiceVerifyStatusEnum.gainStatus().code());
        mixSellerInvoiceEntity.setGainTime(new Date());
        if (InvoiceAssociateStatusEnum.SUCCESS_ASSOCIATE.code().equals(sellerInvoiceInfo.getAssociateStatus())) {
            mixSellerInvoiceEntity.setGainStatus(InvoiceGainStatusEnum.SUCCESS_GAIN.code());
        }
        mixSellerInvoiceEntity.setGainRemark(invoiceVerifyStatusEnum.gainStatus().msg());
        mixSellerInvoiceEntity.setVerifyStatus(sellerInvoiceInfo.getVeriStatus());
        mixSellerInvoiceEntity.setLockStatus(String.valueOf(sellerInvoiceInfo.getLockFlag()));
        mixSellerInvoiceEntity.setSourceLine(Optional.ofNullable(SourceLineEnum.fromType(sellerInvoiceInfo.getSystemOrigType())).map(SourceLineEnum::code).orElse(""));
        mixSellerInvoiceEntity.setSpecialAdditions(sellerInvoiceInfo.getSpecialAdditions());
        mixSellerInvoiceEntity.setPaymentStatus(CommonTools.getOrDefault(mixSellerInvoiceEntity.getPaymentStatus(), "0"));
        mixSellerInvoiceEntity.setRetreatStatus(CommonTools.getOrDefault(mixSellerInvoiceEntity.getRetreatStatus(), "0"));
        mixSellerInvoiceEntity.setIdentifyStatus(CommonTools.getOrDefault(mixSellerInvoiceEntity.getIdentifyStatus(), "0"));
        mixSellerInvoiceEntity.setDeleteTime(CommonTools.getOrDefault(mixSellerInvoiceEntity.getDeleteTime()));
        mixSellerInvoiceEntity.setDeleteUserId(CommonTools.getOrDefault(mixSellerInvoiceEntity.getDeleteUserId()));
        mixSellerInvoiceEntity.setDrawoutStatus(CommonTools.getOrDefault(mixSellerInvoiceEntity.getDrawoutStatus()));
        mixSellerInvoiceEntity.setDrawoutTime(CommonTools.getOrDefault(mixSellerInvoiceEntity.getDrawoutTime()));
        mixSellerInvoiceEntity.setDrawoutUserId(CommonTools.getOrDefault(mixSellerInvoiceEntity.getDrawoutUserId()));
        mixSellerInvoiceEntity.setOutLockConfig(CommonTools.getOrDefault(mixSellerInvoiceEntity.getOutLockConfig()));
        mixSellerInvoiceEntity.setRedUserId(CommonTools.getOrDefault(mixSellerInvoiceEntity.getRedUserId()));
        mixSellerInvoiceEntity.setTerminalType(Optional.ofNullable(sellerInvoiceInfo.getTerminalType()).map(Long::intValue).orElse(0));
        mixSellerInvoiceEntity.setOfdToImg(CommonTools.getOrDefault(mixSellerInvoiceEntity.getOfdToImg()));
        mixSellerInvoiceEntity.setOfdToPdf(CommonTools.getOrDefault(mixSellerInvoiceEntity.getOfdToPdf()));
        mixSellerInvoiceEntity.setQrCodeUrl(CommonTools.getOrDefault(mixSellerInvoiceEntity.getQrCodeUrl()));
        mixSellerInvoiceEntity.setTaxRate(this.formatTaxRate(mixSellerInvoiceEntity.getTaxRate()));
        mixSellerInvoiceEntity.setInvoiceFrom(CommonTools.getOrDefault(mixSellerInvoiceEntity.getInvoiceFrom()));
        return mixSellerInvoiceEntity;
    }

    public String formatTaxRate(String taxRateStrOld) {
        if (StringUtils.isBlank((CharSequence)(taxRateStrOld = CommonTools.getOrDefault(taxRateStrOld)))) {
            return taxRateStrOld;
        }
        List<String> taxRateStrList = this.splitTaxRateStr(taxRateStrOld);
        return taxRateStrList.stream().filter(StringUtils::isNotBlank).map(taxRateStr -> {
            BigDecimal taxRate = CommonTools.toBigDecimal(taxRateStr.replaceAll("%", ""));
            taxRate = taxRate.compareTo(BigDecimal.ONE) < 0 && taxRate.compareTo(BigDecimal.ZERO) >= 0 ? taxRate.multiply(new BigDecimal("100")).setScale(0, 4) : taxRate.setScale(0, 4);
            return taxRate.toPlainString() + "%";
        }).collect(Collectors.joining(","));
    }

    public MixSellerInvoiceItemEntity convertBySellerInvoiceItem(SellerInvoiceItem invoiceItem) {
        if (invoiceItem == null) {
            return null;
        }
        MixSellerInvoiceItemEntity antSellerInvoiceItemEntity = new MixSellerInvoiceItemEntity();
        BeanUtil.copyInvoiceProperties(invoiceItem, antSellerInvoiceItemEntity);
        antSellerInvoiceItemEntity.setId(invoiceItem.getId());
        antSellerInvoiceItemEntity.setTaxRate(CommonTools.formatTaxRate(antSellerInvoiceItemEntity.getTaxRate()));
        return antSellerInvoiceItemEntity;
    }

    public MixSellerInvoiceItemEntity convertBySellerInvoiceItem(InvoiceItem invoiceItem) {
        if (invoiceItem == null) {
            return null;
        }
        MixSellerInvoiceItemEntity antSellerInvoiceItemEntity = new MixSellerInvoiceItemEntity();
        BeanUtil.copyInvoiceProperties(invoiceItem, antSellerInvoiceItemEntity);
        antSellerInvoiceItemEntity.setId(invoiceItem.getId());
        antSellerInvoiceItemEntity.setQuantity(CommonTools.toBigDecimal(invoiceItem.getQuantity()));
        antSellerInvoiceItemEntity.setUnitPrice(CommonTools.toBigDecimal(invoiceItem.getUnitPrice()));
        antSellerInvoiceItemEntity.setAmountWithoutTax(CommonTools.toBigDecimal(invoiceItem.getAmountWithoutTax()));
        antSellerInvoiceItemEntity.setAmountWithTax(CommonTools.toBigDecimal(invoiceItem.getAmountWithTax()));
        antSellerInvoiceItemEntity.setDiscountWithoutTax(CommonTools.toBigDecimal(invoiceItem.getDiscountWithoutTax()));
        antSellerInvoiceItemEntity.setDiscountWithTax(CommonTools.toBigDecimal(invoiceItem.getDiscountWithTax()));
        antSellerInvoiceItemEntity.setDiscountRate(CommonTools.toBigDecimal(invoiceItem.getDiscountRate()));
        antSellerInvoiceItemEntity.setTaxRate(CommonTools.formatTaxRate(antSellerInvoiceItemEntity.getTaxRate()));
        antSellerInvoiceItemEntity.setRowNum(invoiceItem.getRowNum());
        return antSellerInvoiceItemEntity;
    }

    private Sort getRequestSort(String propName, Integer orderBy) {
        Sort sort = new Sort();
        sort.setOrder(orderBy);
        sort.setPropertyName(propName);
        return sort;
    }

    public List<InvoiceOperationLog> queryInvoiceLogsById(Long id, Long sellerTenantId) {
        LogRequest request = new LogRequest();
        request.setId(id);
        request.setSellerGroupId(sellerTenantId);
        try {
            log.info("queryInvoiceLogsById request:{}", (Object)JSON.toJSONString((Object)request));
            Response response = this.phoenixInvoiceClient.queryInvoiceLogs(request);
            if (Response.OK.equals(response.getCode())) {
                List result = (List)response.getResult();
                return result;
            }
            log.info("\u67e5\u8be2\u53d1\u7968\u65e5\u5fd7\u5931\u8d25:{}", (Object)response.getMessage());
        }
        catch (Error | Exception e) {
            log.error("\u67e5\u8be2\u53d1\u7968\u65e5\u5fd7error:", e);
        }
        return Collections.emptyList();
    }

    public DataListResult<QuerySellerInvoice> queryCompassInvoice(QueryCompassInvoiceReuqest request) {
        try {
            log.info("queryCompassInvoice request:{}", (Object)JSON.toJSONString((Object)request));
            Response<DataListResult<QuerySellerInvoice>> response = this.phoenixInvoiceClient.queryCompassInvoice(request);
            if (Response.OK.equals(response.getCode())) {
                return (DataListResult)response.getResult();
            }
            log.info("queryCompassInvoice:{}", (Object)response.getMessage());
        }
        catch (Error | Exception e) {
            log.error("queryCompassInvoice:", e);
        }
        return null;
    }

    public SmartMatchInvoiceResult smartMatchingInvoice(List<Long> rangeTimes, String requestSource, Long id, Long sellerTenantId, List<String> invoiceKindList) {
        try {
            SmartMatchInvoiceRequest smartMatchInvoiceRequest = new SmartMatchInvoiceRequest();
            smartMatchInvoiceRequest.setId(id);
            smartMatchInvoiceRequest.setSellerGroupId(sellerTenantId);
            smartMatchInvoiceRequest.setRequestSource(requestSource);
            smartMatchInvoiceRequest.setRangeTimes(rangeTimes);
            smartMatchInvoiceRequest.setInvoiceKindList(invoiceKindList);
            log.info("smartMatchingInvoice request:{}", (Object)JSON.toJSONString((Object)smartMatchInvoiceRequest));
            Response<SmartMatchInvoiceResult> response = this.phoenixInvoiceClient.smartMatchingInvoice(smartMatchInvoiceRequest);
            if (Response.OK.equals(response.getCode())) {
                return (SmartMatchInvoiceResult)response.getResult();
            }
            log.info("smartMatchingInvoice:{}", (Object)response.getMessage());
        }
        catch (Error | Exception e) {
            log.error("smartMatchingInvoice:", e);
        }
        return null;
    }
}

