/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.coop.mix.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.xforceplus.ant.coop.feign.domain.MixCanaryHolder;
import com.xforceplus.ant.coop.feign.domain.MixCanaryInfo;
import com.xforceplus.ant.coop.security.user.domain.CurrentUser;
import com.xforceplus.coop.common.utils.BeanUtils;
import com.xforceplus.coop.mix.client.preinvoice.PhoenixPreviewInvoiceClient;
import com.xforceplus.coop.mix.common.enums.PreviewMode;
import com.xforceplus.coop.mix.common.enums.SourceLineEnum;
import com.xforceplus.coop.mix.common.exception.CoopMixException;
import com.xforceplus.coop.mix.model.MixPreBillDetailEntity;
import com.xforceplus.coop.mix.model.MixPreInvoiceEntity;
import com.xforceplus.coop.mix.model.MixPreInvoiceItemEntity;
import com.xforceplus.coop.mix.utils.CommonTools;
import com.xforceplus.seller.invoice.client.model.BillRelationParam;
import com.xforceplus.seller.invoice.client.model.PreInvoice;
import com.xforceplus.seller.invoice.client.model.PreInvoiceDetail;
import com.xforceplus.seller.invoice.client.model.PreinvoiceRelationRequest;
import com.xforceplus.seller.invoice.client.model.PreviewInvoiceListResponse;
import com.xforceplus.seller.invoice.client.model.PreviewInvoiceRequest;
import com.xforceplus.seller.invoice.client.model.RequestField;
import com.xforceplus.seller.invoice.client.model.SellerPreInvoice;
import com.xforceplus.seller.invoice.client.model.SellerPreInvoiceQueryByConditionRequest;
import com.xforceplus.seller.invoice.client.model.SellerPreInvoiceQueryResponse;
import com.xforceplus.seller.invoice.client.model.SellerPreInvoiceQueryResponseResult;
import com.xforceplus.seller.invoice.client.model.vo.PreInvoiceRelationVo;
import com.xforceplus.xplatframework.model.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PhoenixPreviewInvoiceQueryMixService {
    private static final Logger log = LoggerFactory.getLogger(PhoenixPreviewInvoiceQueryMixService.class);
    private static final int MAX_QUERY_BILL_SIZE = 200;
    private static final int MAX_QUERY_PRE_INVOICE_SIZE = 1000;
    @Autowired
    private PhoenixPreviewInvoiceClient phoenixPreviewInvoiceClient;

    public SellerPreInvoiceQueryResponseResult queryPreInvoiceList(List<RequestField> requestFieldList, String status, Integer pageNo, Integer pageSize, List<Long> createTime) {
        SellerPreInvoiceQueryByConditionRequest conditionRequest = new SellerPreInvoiceQueryByConditionRequest();
        conditionRequest.setPageNo(Optional.ofNullable(pageNo).orElse(1));
        conditionRequest.setPageSize(Optional.ofNullable(pageSize).orElse(1000));
        conditionRequest.setUserRole("2");
        conditionRequest.setCreateTime(createTime);
        conditionRequest.setRequestSource("90");
        conditionRequest.setQueryWithAuth(Boolean.valueOf(false));
        conditionRequest.setStatus(status);
        ArrayList requestFieldLists = Lists.newArrayList();
        requestFieldLists.add(requestFieldList);
        conditionRequest.setGroups((List)requestFieldLists);
        try {
            SellerPreInvoiceQueryResponse queryResponse = this.phoenixPreviewInvoiceClient.queryPreInvoice(conditionRequest);
            if (queryResponse != null && queryResponse.getResult() != null) {
                return queryResponse.getResult();
            }
        }
        catch (Error | Exception e) {
            log.error("\u9884\u5236\u53d1\u7968\u590d\u6742\u67e5\u8be2error:", e);
        }
        SellerPreInvoiceQueryResponseResult result = new SellerPreInvoiceQueryResponseResult();
        result.setTotal(Long.valueOf(0L));
        result.setPreInvoices((List)Lists.newArrayList());
        result.setTotalAmount("0");
        result.setWaitConfirmedCount(0);
        result.setChangedCount(0);
        result.setConfirmingCount(0);
        result.setPendingInvoiceCount(0);
        result.setProcessingInvoiceCount(0);
        return result;
    }

    public MixPreInvoiceEntity getMixPreInvoiceById(Long preInvoiceId) {
        List<MixPreInvoiceEntity> result = this.queryPreInvoiceByIdList(Arrays.asList(preInvoiceId));
        return CollectionUtils.isEmpty(result) ? null : result.get(0);
    }

    public List<MixPreInvoiceEntity> queryPreInvoiceByIdList(List<Long> preInvoiceIds) {
        return this.queryPreInvoiceByIdList(preInvoiceIds, PreviewMode.ALL);
    }

    private List<MixPreInvoiceEntity> convertPreInvoiceEntity(List<SellerPreInvoice> preInvoices) {
        List<MixPreInvoiceEntity> response = Collections.emptyList();
        if (null == preInvoices || preInvoices.isEmpty()) {
            return response;
        }
        response = preInvoices.stream().map(this::convertPreInvoiceEntity).collect(Collectors.toList());
        return response;
    }

    private MixPreInvoiceEntity convertPreInvoiceEntity(SellerPreInvoice preInvoice) {
        if (null == preInvoice) {
            return null;
        }
        MixPreInvoiceEntity preInvoiceEntity = new MixPreInvoiceEntity();
        BeanUtils.copyProperties((Object)preInvoice, (Object)preInvoiceEntity);
        preInvoiceEntity.setBatchNo(NumberUtils.toLong((String)preInvoice.getSalesbillId()));
        preInvoiceEntity.setSellerTenantId(preInvoice.getSellerGroupId());
        preInvoiceEntity.setPurchaserTenantId(preInvoice.getPurchaserGroupId());
        preInvoiceEntity.setSpecialAdditions(preInvoice.getSpecialAdditions());
        preInvoiceEntity.setSourceLine(Optional.ofNullable(SourceLineEnum.fromType(preInvoice.getSystemOrigType())).map(SourceLineEnum::code).orElse(""));
        return preInvoiceEntity;
    }

    private MixPreInvoiceEntity convertPreInvoiceEntity(PreInvoice preInvoice) {
        if (null == preInvoice) {
            return null;
        }
        MixPreInvoiceEntity preInvoiceEntity = new MixPreInvoiceEntity();
        BeanUtils.copyProperties((Object)preInvoice, (Object)preInvoiceEntity);
        preInvoiceEntity.setBatchNo(preInvoice.getSalesbillId());
        preInvoiceEntity.setSpecialAdditions(preInvoice.getSpecialAdditions());
        preInvoiceEntity.setSellerTenantId(NumberUtils.toLong((String)preInvoice.getSellerGroupId()));
        preInvoiceEntity.setPurchaserTenantId(NumberUtils.toLong((String)preInvoice.getPurchaserGroupId()));
        preInvoiceEntity.setSourceLine(Optional.ofNullable(SourceLineEnum.fromType(preInvoice.getSystemOrigType())).map(SourceLineEnum::code).orElse(""));
        if (!CollectionUtils.isEmpty((Collection)preInvoice.getPreInvoiceDetails())) {
            List<MixPreInvoiceItemEntity> mixItemList = preInvoice.getPreInvoiceDetails().stream().map(this::convertPreItemEntity).collect(Collectors.toList());
            preInvoiceEntity.setInvoiceItemList(mixItemList);
        }
        return preInvoiceEntity;
    }

    @Deprecated
    public List<MixPreInvoiceEntity> getPreInvoiceByIdList(@NotNull List<Long> preInvoiceIds) {
        return this.queryPreInvoiceByIdList(preInvoiceIds);
    }

    public List<MixPreInvoiceEntity> listPreInvoice(List<Long> preInvoiceIds, PreviewMode previewMode) {
        PreviewInvoiceRequest previewInvoiceListParam;
        if (CollectionUtils.isEmpty(preInvoiceIds)) {
            return Collections.emptyList();
        }
        ArrayList preInvoiceEntityList = Lists.newArrayList();
        ArrayList tempPreInvoiceIdList = Lists.newArrayList();
        for (Long preInvoiceId : preInvoiceIds) {
            tempPreInvoiceIdList.add(preInvoiceId);
            if (tempPreInvoiceIdList.size() != 1000) continue;
            previewInvoiceListParam = new PreviewInvoiceRequest();
            previewInvoiceListParam.setPreInvoiceIds((List)tempPreInvoiceIdList);
            previewInvoiceListParam.setPreviewMode(previewMode.mode());
            preInvoiceEntityList.addAll(this.listMixPreInvoice(previewInvoiceListParam, false));
            tempPreInvoiceIdList.clear();
        }
        if (tempPreInvoiceIdList.size() > 0) {
            previewInvoiceListParam = new PreviewInvoiceRequest();
            previewInvoiceListParam.setPreInvoiceIds((List)tempPreInvoiceIdList);
            previewInvoiceListParam.setPreviewMode(previewMode.mode());
            preInvoiceEntityList.addAll(this.listMixPreInvoice(previewInvoiceListParam, false));
        }
        return preInvoiceEntityList;
    }

    public List<MixPreInvoiceEntity> listPreInvoiceByBill(List<Long> billIdList, PreviewMode previewMode) {
        PreviewInvoiceRequest previewInvoiceListParam;
        if (CollectionUtils.isEmpty(billIdList)) {
            return Collections.emptyList();
        }
        ArrayList preInvoiceEntityList = Lists.newArrayList();
        ArrayList tempBillIdList = Lists.newArrayList();
        for (Long billId : billIdList) {
            tempBillIdList.add(billId);
            if (tempBillIdList.size() != 200) continue;
            previewInvoiceListParam = new PreviewInvoiceRequest();
            previewInvoiceListParam.setSalesBillIds((List)tempBillIdList);
            previewInvoiceListParam.setPreviewMode(previewMode.mode());
            preInvoiceEntityList.addAll(this.listMixPreInvoice(previewInvoiceListParam, false));
            tempBillIdList.clear();
        }
        if (tempBillIdList.size() > 0) {
            previewInvoiceListParam = new PreviewInvoiceRequest();
            previewInvoiceListParam.setSalesBillIds((List)tempBillIdList);
            previewInvoiceListParam.setPreviewMode(previewMode.mode());
            preInvoiceEntityList.addAll(this.listMixPreInvoice(previewInvoiceListParam, false));
        }
        return preInvoiceEntityList;
    }

    public List<MixPreInvoiceEntity> listMixPreInvoice(PreviewInvoiceRequest previewInvoiceListParam, boolean needException) {
        return this.listPreInvoice(previewInvoiceListParam, needException).stream().map(this::convertPreInvoiceEntity).collect(Collectors.toList());
    }

    public List<MixPreBillDetailEntity> getRelationByPreInvoiceIds(List<Long> preInvoiceIds) {
        if (CollectionUtils.isEmpty(preInvoiceIds)) {
            return Collections.emptyList();
        }
        BillRelationParam billRelationParam = new BillRelationParam();
        billRelationParam.setPreInvoiceIds(preInvoiceIds);
        return this.queryBillRelation(billRelationParam, false);
    }

    public List<MixPreBillDetailEntity> getRelationByPreInvoiceId(Long preInvoiceId) {
        if (Objects.isNull(preInvoiceId) || preInvoiceId <= 0L) {
            return Collections.emptyList();
        }
        BillRelationParam billRelationParam = new BillRelationParam();
        billRelationParam.setPreInvoiceId(preInvoiceId);
        return this.queryBillRelation(billRelationParam, false);
    }

    public List<MixPreBillDetailEntity> getRelationByBillId(Long billId) {
        if (Objects.isNull(billId) || billId <= 0L) {
            return Collections.emptyList();
        }
        BillRelationParam billRelationParam = new BillRelationParam();
        billRelationParam.setSalesBillId(billId);
        return this.queryBillRelation(billRelationParam, false);
    }

    public List<MixPreBillDetailEntity> getRelationByBillIds(List<Long> billIds) {
        if (CollectionUtils.isEmpty(billIds)) {
            return Collections.emptyList();
        }
        BillRelationParam billRelationParam = new BillRelationParam();
        billRelationParam.setSalesBillIds(billIds);
        return this.queryBillRelation(billRelationParam, false);
    }

    public List<MixPreBillDetailEntity> queryBillRelation(BillRelationParam billRelationParam, boolean needException) {
        try {
            billRelationParam.setRequestSource("90");
            Response<List<MixPreBillDetailEntity>> billRelationResponse = this.phoenixPreviewInvoiceClient.billRelation(billRelationParam);
            log.warn("\u67e5\u8be2\u5173\u8054\u5173\u7cfb\u7ed3\u679c:{}", (Object)JSON.toJSONString(billRelationResponse));
            if (!Response.OK.equals(billRelationResponse.getCode())) {
                return Collections.emptyList();
            }
            return (List)billRelationResponse.getResult();
        }
        catch (Error | Exception e) {
            log.error("\u67e5\u8be2\u660e\u7ec6\u5173\u8054\u5173\u7cfb\u5f02\u5e38 \u53c2\u6570:{} error:", (Object)JSON.toJSONString((Object)billRelationParam), (Object)e);
            if (needException) {
                throw new CoopMixException(String.format("\u67e5\u8be2\u660e\u7ec6\u5173\u8054\u5173\u7cfb\u5f02\u5e38\uff1a%s", e.getMessage()));
            }
            return Collections.emptyList();
        }
    }

    public MixPreBillDetailEntity convertPreBillEntity(PreInvoiceDetail preInvoiceDetail) {
        MixPreBillDetailEntity mixPreBillDetailEntity = new MixPreBillDetailEntity();
        BeanUtils.copyProperties((Object)preInvoiceDetail, (Object)mixPreBillDetailEntity);
        mixPreBillDetailEntity.setBatchNo(preInvoiceDetail.getBillId());
        mixPreBillDetailEntity.setSalesbillId(preInvoiceDetail.getBillId());
        mixPreBillDetailEntity.setSalesbillItemId(preInvoiceDetail.getSalesbillItemId());
        mixPreBillDetailEntity.setPreInvoiceItemId(preInvoiceDetail.getId());
        mixPreBillDetailEntity.setStatus(1);
        return mixPreBillDetailEntity;
    }

    public MixPreInvoiceItemEntity convertPreItemEntity(PreInvoiceDetail preInvoiceDetail) {
        MixPreInvoiceItemEntity mixPreInvoiceItemEntity = new MixPreInvoiceItemEntity();
        BeanUtils.copyProperties((Object)preInvoiceDetail, (Object)mixPreInvoiceItemEntity);
        mixPreInvoiceItemEntity.setTaxRate(CommonTools.formatTaxRate(mixPreInvoiceItemEntity.getTaxRate()));
        return mixPreInvoiceItemEntity;
    }

    public List<MixPreInvoiceEntity> queryPreInvoiceByIdList(List<Long> preInvoiceIds, PreviewMode previewMode) {
        if (CollectionUtils.isEmpty(preInvoiceIds)) {
            return Collections.emptyList();
        }
        PreviewInvoiceRequest previewInvoiceListParam = new PreviewInvoiceRequest();
        previewInvoiceListParam.setPreInvoiceIds(preInvoiceIds);
        previewInvoiceListParam.setPreviewMode(null == previewMode ? PreviewMode.ALL.mode() : previewMode.mode());
        List<MixPreInvoiceEntity> queryResponse = this.listMixPreInvoice(previewInvoiceListParam, false);
        return queryResponse;
    }

    public PreInvoice getPreInvoiceById(Long preInvoiceId) {
        List<PreInvoice> result = this.listPreInvoiceByIdList(Arrays.asList(preInvoiceId), PreviewMode.ALL);
        return CollectionUtils.isEmpty(result) ? null : result.get(0);
    }

    public PreInvoice getPreInvoiceById(Long preInvoiceId, PreviewMode previewMode) {
        List<PreInvoice> result = this.listPreInvoiceByIdList(Arrays.asList(preInvoiceId), previewMode);
        return CollectionUtils.isEmpty(result) ? null : result.get(0);
    }

    public List<PreInvoice> listPreInvoiceByIdList(List<Long> preInvoiceIds, PreviewMode previewMode) {
        if (CollectionUtils.isEmpty(preInvoiceIds)) {
            return Collections.emptyList();
        }
        PreviewInvoiceRequest previewInvoiceListParam = new PreviewInvoiceRequest();
        previewInvoiceListParam.setPreInvoiceIds(preInvoiceIds);
        previewInvoiceListParam.setPreviewMode(null == previewMode ? PreviewMode.ALL.mode() : previewMode.mode());
        List<PreInvoice> queryResponse = this.listPreInvoice(previewInvoiceListParam, false);
        return queryResponse;
    }

    public List<PreInvoice> listPreInvoice(PreviewInvoiceRequest request, boolean needException) {
        try {
            request.setRequestSource("90");
            Long sellerGroupId = Optional.ofNullable(MixCanaryHolder.get()).map(MixCanaryInfo::getTenantId).map(CommonTools::toLong).orElse(CurrentUser.getTenantId());
            request.setSellerTenantId(sellerGroupId);
            PreviewInvoiceListResponse previewInvoiceListResponse = this.phoenixPreviewInvoiceClient.previewInvoiceList(request);
            log.info("\u67e5\u8be2\u9884\u5236\u53d1\u7968\u5217\u8868:{}", (Object)JSON.toJSONString((Object)previewInvoiceListResponse));
            if (!Response.OK.equals(previewInvoiceListResponse.getCode())) {
                return Collections.emptyList();
            }
            return previewInvoiceListResponse.getResult();
        }
        catch (Error | Exception e) {
            log.error("\u67e5\u8be2\u9884\u5236\u53d1\u7968\u5f02\u5e38 \u53c2\u6570:{} error:", (Object)JSON.toJSONString((Object)request), (Object)e);
            if (needException) {
                throw new CoopMixException(String.format("\u67e5\u8be2\u9884\u5236\u53d1\u7968\u5f02\u5e38\uff1a%s", e.getMessage()));
            }
            return Collections.emptyList();
        }
    }

    public List<PreInvoice> listPreInvoiceByBillId(List<Long> billIdList, PreviewMode previewMode) {
        if (CollectionUtils.isEmpty(billIdList)) {
            return Collections.emptyList();
        }
        PreviewInvoiceRequest previewInvoiceListParam = new PreviewInvoiceRequest();
        previewInvoiceListParam.setSalesBillIds(billIdList);
        previewInvoiceListParam.setPreviewMode(null == previewMode ? PreviewMode.ALL.mode() : previewMode.mode());
        List<PreInvoice> queryResponse = this.listPreInvoice(previewInvoiceListParam, false);
        return queryResponse;
    }

    public List<PreInvoiceRelationVo> getRedOrInvRelationByRed(List<Long> redPreIdList) {
        if (CollectionUtils.isEmpty(redPreIdList)) {
            return Collections.emptyList();
        }
        try {
            PreinvoiceRelationRequest request = new PreinvoiceRelationRequest();
            request.setRedPreIds(redPreIdList);
            log.info("getRedOrInvRelationByRed params:{}", (Object)JSON.toJSONString((Object)request));
            Response response = this.phoenixPreviewInvoiceClient.redAndInvalidRelation(request);
            log.info("getRedOrInvRelationByRed result:{}", (Object)JSON.toJSONString((Object)response));
            if (Response.OK.equals(response.getCode())) {
                return JSON.parseArray((String)JSON.toJSONString((Object)response.getResult()), PreInvoiceRelationVo.class);
            }
        }
        catch (Error | Exception e) {
            log.error("getRedOrInvRelationByRed error:", e);
        }
        return Collections.emptyList();
    }

    public List<PreInvoiceRelationVo> getRedOrInvRelationByOriginBlue(List<Long> originBluePreIdList) {
        if (CollectionUtils.isEmpty(originBluePreIdList)) {
            return Collections.emptyList();
        }
        try {
            PreinvoiceRelationRequest request = new PreinvoiceRelationRequest();
            request.setOrginBluePreIds(originBluePreIdList);
            log.info("getRedOrInvRelationByOriginBlue params:{}", (Object)JSON.toJSONString((Object)request));
            Response response = this.phoenixPreviewInvoiceClient.redAndInvalidRelation(request);
            log.info("getRedOrInvRelationByOriginBlue result:{}", (Object)JSON.toJSONString((Object)response));
            if (Response.OK.equals(response.getCode())) {
                return JSON.parseArray((String)JSON.toJSONString((Object)response.getResult()), PreInvoiceRelationVo.class);
            }
        }
        catch (Error | Exception e) {
            log.error("getRedOrInvRelationByOriginBlue error:", e);
        }
        return Collections.emptyList();
    }

    public List<PreInvoiceRelationVo> getRedOrInvRelationByBlue(List<Long> bluePreIdList) {
        if (CollectionUtils.isEmpty(bluePreIdList)) {
            return Collections.emptyList();
        }
        try {
            PreinvoiceRelationRequest request = new PreinvoiceRelationRequest();
            request.setNewBluePreIds(bluePreIdList);
            log.info("getRedOrInvRelationByBlue params:{}", (Object)JSON.toJSONString((Object)request));
            Response response = this.phoenixPreviewInvoiceClient.redAndInvalidRelation(request);
            log.info("getRedOrInvRelationByBlue result:{}", (Object)JSON.toJSONString((Object)response));
            if (Response.OK.equals(response.getCode())) {
                return JSON.parseArray((String)JSON.toJSONString((Object)response.getResult()), PreInvoiceRelationVo.class);
            }
        }
        catch (Error | Exception e) {
            log.error("getRedOrInvRelationByBlue error:", e);
        }
        return Collections.emptyList();
    }
}

