/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.coop.mix.service;

import com.alibaba.fastjson.JSON;
import com.xforceplus.coop.mix.client.smartInvoice.SmartInvoiceClient;
import com.xforceplus.coop.mix.model.MixPreInvoiceEntity;
import com.xforceplus.coop.mix.model.MixPreInvoiceItemEntity;
import com.xforceplus.smart.match.invoice.client.model.PollingRecommendInvoiceRequest;
import com.xforceplus.smart.match.invoice.client.model.SmartMatchInvoiceRequest;
import com.xforceplus.smart.match.invoice.client.model.SmartMatchInvoiceResult;
import com.xforceplus.xplatframework.model.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SmartMatchInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(SmartMatchInvoiceService.class);
    @Resource
    private SmartInvoiceClient smartInvoiceClient;

    public Long smartMatchInvoice(MixPreInvoiceEntity preInvoice) {
        try {
            SmartMatchInvoiceRequest request = this.convertSmartMatchInvoice(preInvoice);
            Response<Long> result = this.smartInvoiceClient.asyncSmartMatchingInvoice(request);
            if (Response.OK.equals(result.getCode())) {
                return (Long)result.getResult();
            }
        }
        catch (Exception e) {
            log.error("smartMatchInvoice error:{}", (Object)JSON.toJSONString((Object)preInvoice), (Object)e);
        }
        return null;
    }

    private SmartMatchInvoiceRequest convertSmartMatchInvoice(MixPreInvoiceEntity preInvoice) {
        SmartMatchInvoiceRequest request = new SmartMatchInvoiceRequest();
        request.setId(preInvoice.getId());
        request.setMatchingMain(this.convertMatchingMain(preInvoice));
        return request;
    }

    private SmartMatchInvoiceRequest.MatchingMain convertMatchingMain(MixPreInvoiceEntity preInvoice) {
        if (Objects.isNull(preInvoice)) {
            return null;
        }
        SmartMatchInvoiceRequest.MatchingMain matchingMain = new SmartMatchInvoiceRequest.MatchingMain();
        matchingMain.setMatchId(preInvoice.getId());
        matchingMain.setSalesbillNo(preInvoice.getSalesbillNo());
        matchingMain.setSellerGroupId(preInvoice.getSellerTenantId());
        matchingMain.setInvoiceType(preInvoice.getInvoiceType());
        matchingMain.setSellerName(preInvoice.getSellerName());
        matchingMain.setSellerTaxNo(preInvoice.getSellerTaxNo());
        matchingMain.setPurchaserName(preInvoice.getPurchaserName());
        matchingMain.setPurchaserTaxNo(preInvoice.getPurchaserTaxNo());
        matchingMain.setAmountWithoutTax(preInvoice.getAmountWithoutTax());
        matchingMain.setAmountWithTax(preInvoice.getAmountWithTax());
        matchingMain.setTaxAmount(preInvoice.getTaxAmount());
        Optional.ofNullable(preInvoice).ifPresent(item -> {
            String priceMethod = item.getInvoiceItemList().get(0).getPriceMethod();
            matchingMain.setPriceMethod(Integer.valueOf(priceMethod));
            matchingMain.setMatchingItemList(this.convertMatchingItemList(item.getInvoiceItemList()));
        });
        return matchingMain;
    }

    private List<SmartMatchInvoiceRequest.MatchingItem> convertMatchingItemList(List<MixPreInvoiceItemEntity> invoiceItemList) {
        ArrayList<SmartMatchInvoiceRequest.MatchingItem> matchingItemList = new ArrayList<SmartMatchInvoiceRequest.MatchingItem>(invoiceItemList.size());
        invoiceItemList.forEach(item -> matchingItemList.add(this.convertMatchingItem((MixPreInvoiceItemEntity)item)));
        return matchingItemList;
    }

    private SmartMatchInvoiceRequest.MatchingItem convertMatchingItem(MixPreInvoiceItemEntity item) {
        SmartMatchInvoiceRequest.MatchingItem matchingItem = new SmartMatchInvoiceRequest.MatchingItem();
        matchingItem.setBillItemId(item.getId());
        matchingItem.setItemName(item.getCargoName());
        matchingItem.setPriceMethod(Integer.valueOf(item.getPriceMethod()));
        matchingItem.setUnitPrice(item.getUnitPrice());
        matchingItem.setAmountWithTax(item.getAmountWithTax());
        matchingItem.setAmountWithoutTax(item.getAmountWithoutTax());
        matchingItem.setTaxAmount(item.getTaxAmount());
        matchingItem.setQuantity(item.getQuantity());
        matchingItem.setQuantityUnit(item.getQuantityUnit());
        matchingItem.setGoodsTaxNo(item.getGoodsTaxNo());
        matchingItem.setItemSpec(item.getItemSpec());
        matchingItem.setTaxRate(item.getTaxRate());
        matchingItem.setTaxPre(item.getTaxPre());
        matchingItem.setTaxPreCon(item.getTaxPreCon());
        matchingItem.setZeroTax(item.getZeroTax());
        matchingItem.setGoodsNoVer(item.getGoodsNoVer());
        return matchingItem;
    }

    public SmartMatchInvoiceResult pollingRecommendInvoice(Long taskId) {
        try {
            PollingRecommendInvoiceRequest pollingRequest = new PollingRecommendInvoiceRequest();
            pollingRequest.setTaskId(taskId);
            log.info("pollingRecommendInvoice request:{}", (Object)JSON.toJSONString((Object)pollingRequest));
            Response<SmartMatchInvoiceResult> response = this.smartInvoiceClient.pollingRecommendInvoice(pollingRequest);
            if (Response.OK.equals(response.getCode())) {
                return (SmartMatchInvoiceResult)response.getResult();
            }
            log.info("pollingRecommendInvoice:{}", (Object)response.getMessage());
        }
        catch (Error | Exception e) {
            log.error("pollingRecommendInvoice:", e);
        }
        return null;
    }
}

