/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.coop.mix.utils;

import com.xforceplus.ant.coop.rule.center.client.bean.FieldBean;
import com.xforceplus.coop.mix.utils.CommonTools;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class BeanUtil {
    private static final Logger logger = LoggerFactory.getLogger(BeanUtil.class);

    public static void copyInvoiceProperties(Object source, Object target) throws BeansException {
        Field[] targetFields;
        Assert.notNull((Object)source, (String)"Source must not be null");
        Assert.notNull((Object)target, (String)"Target must not be null");
        HashSet<FieldBean> fieldBeans = new HashSet<FieldBean>();
        HashMap targetFieldsMap = new HashMap(20);
        for (Field targetField : targetFields = target.getClass().getDeclaredFields()) {
            targetField.setAccessible(true);
            targetFieldsMap.put(targetField.getName(), targetField.getType());
        }
        Field[] sourceFields = source.getClass().getDeclaredFields();
        FieldBean fieldBean = null;
        String fieldName = null;
        for (Field sourceField : sourceFields) {
            sourceField.setAccessible(true);
            fieldName = sourceField.getName();
            if (!targetFieldsMap.containsKey(fieldName)) continue;
            fieldBean = new FieldBean();
            fieldBean.setFieldName(fieldName);
            fieldBean.setGetterName(BeanUtil.getGetterOrSetterName(fieldName, "get"));
            fieldBean.setSetterName(BeanUtil.getGetterOrSetterName(fieldName, "set"));
            fieldBean.setGetterType(sourceField.getType());
            fieldBean.setSetterType((Class)targetFieldsMap.get(fieldName));
            fieldBeans.add(fieldBean);
        }
        BeanUtil.copyProperties(source, target, fieldBeans);
    }

    public static void copyProperties(Object source, Object target, Set<FieldBean> fieldBeans) throws BeansException {
        for (FieldBean fieldBean : fieldBeans) {
            try {
                Object sourceValue;
                Method targetMethod = target.getClass().getDeclaredMethod(fieldBean.getSetterName(), fieldBean.getSetterType());
                Method sourceMethod = source.getClass().getDeclaredMethod(fieldBean.getGetterName(), new Class[0]);
                targetMethod.setAccessible(true);
                sourceMethod.setAccessible(true);
                if (fieldBean.getSetterType().equals(fieldBean.getGetterType())) {
                    sourceValue = sourceMethod.invoke(source, new Object[0]);
                    if (Date.class.equals((Object)fieldBean.getSetterType())) {
                        targetMethod.invoke(target, CommonTools.getOrDefault((Date)sourceValue));
                        continue;
                    }
                    if (String.class.equals((Object)fieldBean.getSetterType())) {
                        targetMethod.invoke(target, CommonTools.getOrDefault((String)sourceValue));
                        continue;
                    }
                    if (Integer.class.equals((Object)fieldBean.getSetterType())) {
                        targetMethod.invoke(target, CommonTools.getOrDefault((Integer)sourceValue));
                        continue;
                    }
                    if (Long.class.equals((Object)fieldBean.getSetterType())) {
                        targetMethod.invoke(target, CommonTools.getOrDefault((Long)sourceValue));
                        continue;
                    }
                    targetMethod.invoke(target, sourceValue);
                    continue;
                }
                if (Date.class.equals((Object)fieldBean.getSetterType()) && String.class.equals((Object)fieldBean.getGetterType())) {
                    sourceValue = (String)sourceMethod.invoke(source, new Object[0]);
                    if (StringUtils.isEmpty((Object)StringUtils.trimWhitespace((String)sourceValue))) continue;
                    targetMethod.invoke(target, new Date(Long.parseLong((String)sourceValue)));
                    continue;
                }
                if (Date.class.equals((Object)fieldBean.getSetterType()) && Long.class.equals((Object)fieldBean.getGetterType())) {
                    sourceValue = (Long)sourceMethod.invoke(source, new Object[0]);
                    if (sourceValue == null) continue;
                    targetMethod.invoke(target, new Date((Long)sourceValue));
                    continue;
                }
                if (BigDecimal.class.equals((Object)fieldBean.getSetterType()) && String.class.equals((Object)fieldBean.getGetterType())) {
                    sourceValue = (String)sourceMethod.invoke(source, new Object[0]);
                    if (StringUtils.isEmpty((Object)StringUtils.trimWhitespace((String)sourceValue))) continue;
                    targetMethod.invoke(target, new BigDecimal((String)sourceValue));
                    continue;
                }
                if (String.class.equals((Object)fieldBean.getSetterType()) && BigDecimal.class.equals((Object)fieldBean.getGetterType())) {
                    sourceValue = (BigDecimal)sourceMethod.invoke(source, new Object[0]);
                    if (sourceValue == null) continue;
                    targetMethod.invoke(target, ((BigDecimal)sourceValue).toPlainString());
                    continue;
                }
                if (String.class.equals((Object)fieldBean.getSetterType()) && Date.class.equals((Object)fieldBean.getGetterType())) {
                    sourceValue = (Date)sourceMethod.invoke(source, new Object[0]);
                    if (sourceValue == null) continue;
                    String dateStr = String.valueOf(((Date)sourceValue).getTime());
                    if ("14400000".equals(dateStr)) {
                        dateStr = "";
                    }
                    targetMethod.invoke(target, dateStr);
                    continue;
                }
                if (String.class.equals((Object)fieldBean.getSetterType()) && Long.class.equals((Object)fieldBean.getGetterType())) {
                    sourceValue = (Long)sourceMethod.invoke(source, new Object[0]);
                    if (sourceValue == null) continue;
                    targetMethod.invoke(target, String.valueOf(sourceValue));
                    continue;
                }
                if (Long.class.equals((Object)fieldBean.getSetterType()) && String.class.equals((Object)fieldBean.getGetterType())) {
                    sourceValue = (String)sourceMethod.invoke(source, new Object[0]);
                    if (StringUtils.isEmpty((Object)StringUtils.trimWhitespace((String)sourceValue))) continue;
                    targetMethod.invoke(target, Long.parseLong((String)sourceValue));
                    continue;
                }
                if (Integer.class.equals((Object)fieldBean.getSetterType()) && String.class.equals((Object)fieldBean.getGetterType())) {
                    sourceValue = (String)sourceMethod.invoke(source, new Object[0]);
                    if (StringUtils.isEmpty((Object)StringUtils.trimWhitespace((String)sourceValue))) continue;
                    targetMethod.invoke(target, Integer.parseInt((String)sourceValue));
                    continue;
                }
                if (!Long.class.equals((Object)fieldBean.getSetterType()) || !Date.class.equals((Object)fieldBean.getGetterType()) || (sourceValue = (Date)sourceMethod.invoke(source, new Object[0])) == null) continue;
                targetMethod.invoke(target, ((Date)sourceValue).getTime());
            }
            catch (NoSuchMethodException nsme) {
            }
            catch (Throwable th) {
                throw new FatalBeanException("Could not copy property '" + fieldBean.getFieldName() + "' from source to target", th);
            }
        }
    }

    public static String getGetterOrSetterName(String fieldName, String prefix) {
        String first = fieldName.substring(0, 1);
        String last = fieldName.substring(1);
        return prefix + first.toUpperCase() + last;
    }

    public static <T, S> void copyInvoiceList(List<T> sourceList, List<S> targetList, Class<S> targetClazz) {
        if (!CollectionUtils.isEmpty(sourceList)) {
            Object targetObject = null;
            for (T sourceObject : sourceList) {
                try {
                    targetObject = targetClazz.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
                BeanUtil.copyInvoiceProperties(sourceObject, targetObject);
                targetList.add(targetObject);
            }
        }
    }
}

