/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.coop.mix.utils;

import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class CommonTools {
    private static final Date DEFAULT_DATE = new Date(14400000L);
    private static final Integer DEFAULT_INT_ZERO = 0;
    private static final Long DEFAULT_LONG_ZERO = 0L;

    public static Date getOrDefault(Date date) {
        return date == null || date.before(DEFAULT_DATE) ? DEFAULT_DATE : date;
    }

    public static String getOrDefault(String str) {
        return CommonTools.getOrDefault(str, "");
    }

    public static String getOrDefault(String str, String defaultValue) {
        return StringUtils.isEmpty((CharSequence)str) ? defaultValue : str;
    }

    public static Integer getOrDefault(Integer number) {
        return CommonTools.getOrDefault(number, DEFAULT_INT_ZERO);
    }

    public static Integer getOrDefault(Integer number, Integer defaultValue) {
        return number == null ? defaultValue : number;
    }

    public static Long getOrDefault(Long number) {
        return number == null ? DEFAULT_LONG_ZERO : number;
    }

    public static BigDecimal toBigDecimal(String numStr) {
        try {
            return new BigDecimal(numStr);
        }
        catch (Exception e) {
            return BigDecimal.ZERO;
        }
    }

    public static BigDecimal formatTaxRate(BigDecimal taxRate) {
        if (null == taxRate) {
            return null;
        }
        if ((taxRate = taxRate.stripTrailingZeros()).scale() < 2) {
            taxRate = taxRate.setScale(2, 4);
        }
        return taxRate;
    }

    public static boolean isEdit(Long id) {
        return id != null && id > 0L;
    }

    public static Long toLong(String numStr) {
        try {
            return Long.parseLong(numStr);
        }
        catch (Exception e) {
            return 0L;
        }
    }
}

