/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.coop.mix.utils;

import com.alibaba.fastjson.JSON;
import com.xforceplus.ant.coop.feign.domain.MixCanaryHolder;
import com.xforceplus.ant.coop.feign.domain.MixCanaryInfo;
import com.xforceplus.ant.coop.rule.center.client.data.canary.ClientCanaryRouteConfig;
import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import com.xforceplus.ant.coop.security.user.domain.CurrentUser;
import com.xforceplus.ant.coop.security.user.domain.UserAuthInfoHolder;
import com.xforceplus.ant.coop.security.utils.JsonUtils;
import com.xforceplus.coop.common.snowflake.IdGenerator;
import com.xforceplus.coop.mix.client.rule.CanaryClient;
import com.xforceplus.coop.mix.common.enums.CoopClientTypeEnum;
import com.xforceplus.coop.mix.config.MixCanaryConfig;
import com.xforceplus.coop.mix.service.CommonMixService;
import com.xforceplus.coop.mix.utils.CanaryCall;
import com.xforceplus.coop.mix.utils.CanaryVoidCall;
import com.xforceplus.coop.mix.utils.CommonTools;
import com.xforceplus.tenantsecurity.domain.AuthorizedUser;
import com.xforceplus.tenantsecurity.domain.IAuthorizedUser;
import com.xforceplus.tenantsecurity.domain.UserInfoHolder;
import com.xforceplus.xplatframework.model.Response;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MixCanaryUtils {
    private static final Logger log = LoggerFactory.getLogger(MixCanaryUtils.class);

    public static <T> T execute(CanaryCall<T> coopCall, CanaryCall<T> mixCall) {
        T result = null;
        result = MixCanaryUtils.getCanaryResult() ? (T)mixCall.apply() : (T)coopCall.apply();
        return result;
    }

    public static void execute(CanaryVoidCall coopCall, CanaryVoidCall mixCall) {
        if (MixCanaryUtils.getCanaryResult()) {
            mixCall.apply();
        } else {
            coopCall.apply();
        }
    }

    public static <T, P1, P2> T execute(CanaryCall<P1> coopCall, CanaryCall<P2> mixCall, Class<T> resultClass) {
        Object result = null;
        if (MixCanaryUtils.getCanaryResult()) {
            log.info("<<<<<<<<<<<<<<\u6267\u884c\u7070\u5ea6\u4e1a\u52a1>>>>>>>>>>>>>");
            result = mixCall.apply();
        } else {
            log.info("<<<<<<<<<<<<<<\u6267\u884c\u534f\u540c\u4e1a\u52a1>>>>>>>>>>>>>");
            result = coopCall.apply();
        }
        if (result instanceof String) {
            return (T)JSON.parseObject((String)result.toString(), resultClass);
        }
        return (T)JSON.parseObject((String)JSON.toJSONString((Object)result), resultClass);
    }

    public static boolean getCanaryResult() {
        if (null != MixCanaryHolder.get() || MixCanaryUtils.getMixCanarySwitch()) {
            return Boolean.TRUE;
        }
        if (null != UserAuthInfoHolder.get() && UserAuthInfoHolder.get().getId() > 0L) {
            log.info("mix\u7070\u5ea6\u4e0a\u4e0b\u6587\u4e3a\u7a7a\uff0c\u5b58\u5728\u7528\u6237\u4e0a\u4e0b\u6587\uff0c\u4f7f\u7528\u79df\u6237ID: {} \u8865\u507f", (Object)CurrentUser.getTenantId());
            MixCanaryUtils.setMixCanaryConfig(CurrentUser.getTenantId().toString());
            if (null != MixCanaryHolder.get()) {
                log.info("mxi\u7070\u5ea6\u4fe1\u606f\u4e3a\u7a7a\uff0c\u4f7f\u7528\u7528\u6237\u4e0a\u4e0b\u6587\u8865\u507f\u540e\u8bbe\u7f6e\u6210\u529f,\u79df\u6237ID: {}", (Object)CurrentUser.getTenantId());
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public static void setMixCanaryConfig(String tenantId) {
        MixCanaryUtils.setMixCanaryConfig(tenantId, null);
    }

    public static void setMixCanaryConfig(String tenantId, String taxNo) {
        try {
            if (MixCanaryUtils.getMixCanarySwitch()) {
                MixCanaryInfo mixCanaryInfo = new MixCanaryInfo();
                mixCanaryInfo.setHeaderKey("mix-canary");
                mixCanaryInfo.setTenantId(tenantId);
                mixCanaryInfo.setTaxNo(taxNo);
                MixCanaryHolder.put((MixCanaryInfo)mixCanaryInfo);
                log.info("\u79df\u6237ID: {}, \u7070\u5ea6\u603b\u5f00\u5173\u5f00\u542f\uff0c\u8bbe\u7f6e\u878d\u5408\u7070\u5ea6\u6210\u529f: {}", (Object)tenantId, (Object)JsonUtils.writeObjectToJson((Object)MixCanaryHolder.get()));
                return;
            }
            MixCanaryInfo oldMixCanaryInfo = MixCanaryHolder.get();
            if (oldMixCanaryInfo != null) {
                boolean isSameTenant = Optional.ofNullable(oldMixCanaryInfo.getTenantId()).map(o -> o.equals(tenantId)).orElse(false);
                boolean isSameTaxNo = Optional.ofNullable(oldMixCanaryInfo.getTaxNo()).map(o -> o.equals(taxNo)).orElse(false);
                if (isSameTenant || isSameTaxNo) {
                    return;
                }
                log.warn("\u8bbe\u7f6e\u878d\u5408\u7070\u5ea6\uff0c\u524d\u540e\u7070\u5ea6\u4e0d\u4e00\u81f4:old-{},new-{}/{}", new Object[]{oldMixCanaryInfo, tenantId, taxNo});
                MixCanaryHolder.clearContext();
            }
            CanaryClient client = (CanaryClient)CommonMixService.getClient(CoopClientTypeEnum.CANARY_CLIENT);
            BaseResult<ClientCanaryRouteConfig> result = client.getCanaryRouteConfig("mix-canary", tenantId);
            log.info("\u8bbe\u7f6e\u878d\u5408\u7070\u5ea6 \u83b7\u53d6\u914d\u7f6e\u54cd\u5e94: {}", (Object)JsonUtils.writeObjectToJson(result));
            if (Response.OK.equals(result.getCode()) && null != result.getResult()) {
                MixCanaryInfo mixCanaryInfo = new MixCanaryInfo();
                mixCanaryInfo.setHeaderKey("mix-canary");
                mixCanaryInfo.setTenantId(tenantId);
                mixCanaryInfo.setTaxNo(taxNo);
                MixCanaryHolder.put((MixCanaryInfo)mixCanaryInfo);
                log.info("\u79df\u6237ID: {}, \u8bbe\u7f6e\u878d\u5408\u7070\u5ea6\u4e0a\u4e0b\u6587\u6210\u529f: {}", (Object)tenantId, (Object)JsonUtils.writeObjectToJson((Object)MixCanaryHolder.get()));
            } else {
                log.info("\u79df\u6237ID: {}, \u8bbe\u7f6e\u878d\u5408\u7070\u5ea6\u4e0a\u4e0b\u6587\u5931\u8d25,\u672a\u627e\u5230\u7070\u5ea6\u914d\u7f6e", (Object)tenantId);
            }
        }
        catch (Exception e) {
            log.error("\u79df\u6237ID: {}, \u8bbe\u7f6e\u878d\u5408\u7070\u5ea6\u4e0a\u4e0b\u6587\u53d1\u751f\u5f02\u5e38: {}", (Object)tenantId, (Object)e);
        }
    }

    public static boolean getMixCanarySwitch() {
        try {
            MixCanaryConfig config = (MixCanaryConfig)CommonMixService.getClient(CoopClientTypeEnum.CANARY_CONFIG);
            return config.isOpen();
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }

    public static void setCurrentUser(Long userId, String username, Long tenantId) {
        AuthorizedUser authorizedUser = new AuthorizedUser();
        authorizedUser.setId(CommonTools.isEdit(userId) ? userId : IdGenerator.nextId());
        authorizedUser.setUsername(username);
        authorizedUser.setTenantId(tenantId.longValue());
        UserAuthInfoHolder.put((IAuthorizedUser)authorizedUser);
        MixCanaryUtils.setMixCanaryConfig(String.valueOf(tenantId));
    }

    public static void setCurrentUser(Long tenantId) {
        log.info("\u8bbe\u7f6e\u8bfb\u53d6\u767b\u5f55\u7528\u6237\u4e0a\u4e0b\u6587\uff0c\u5982\u679c\u5df2\u7ecf\u5b58\u5728\u4f1a\u8fdb\u884c\u8986\u76d6,tenantId: {}", (Object)tenantId);
        MixCanaryUtils.setCurrentUser(0L, "", tenantId);
    }

    public static void setCurrentUserAndMixCanary(Long tenantId) {
        MixCanaryUtils.setCurrentUser(0L, "", tenantId);
    }

    public static void clearCurrentUser() {
        UserAuthInfoHolder.clearContext();
        MixCanaryHolder.clearContext();
        log.info("\u6e05\u7406\u7528\u6237\u4e0a\u4e0b\u6587\u540e\uff1a{}", (Object)UserInfoHolder.get());
        log.info("\u6e05\u7406\u7070\u5ea6\u4e0a\u4e0b\u6587\u540e\uff1a{}", (Object)UserInfoHolder.get());
    }

    public static void setCurrentUserIfNotExists(Long userId, String username, Long tenantId) {
        if (!CommonTools.isEdit(tenantId)) {
            log.warn("\u8bbe\u7f6e\u7528\u6237\u4e0a\u4e0b\u6587\u65f6\uff0c\u79df\u6237\u5fc5\u586b");
            return;
        }
        IAuthorizedUser authorizedUser = UserAuthInfoHolder.get();
        MixCanaryInfo mixCanaryInfo = MixCanaryHolder.get();
        if (authorizedUser != null && CommonTools.isEdit(authorizedUser.getTenantId()) && authorizedUser.getTenantId() == tenantId.longValue() && mixCanaryInfo != null && CommonTools.toLong(mixCanaryInfo.getTenantId()).equals(tenantId)) {
            log.info("\u7528\u6237\u4e0a\u4e0b\u6587\u5df2\u5b58\u5728\uff0c\u65e0\u9700\u91cd\u65b0\u8bbe\u7f6e:user[{}],mix[{}]", (Object)authorizedUser.getTenantId(), (Object)mixCanaryInfo.getTenantId());
            return;
        }
        log.info("\u767b\u5f55\u7528\u6237\u4e0a\u4e0b\u6587\u4e0d\u5b58\u5728\uff0c\u8fdb\u884c\u8bbe\u7f6e:{},{},{}", new Object[]{userId, username, tenantId});
        MixCanaryUtils.setCurrentUser(userId, username, tenantId);
    }
}

