package com.xforceplus.antc.client;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class AntcSwaggerPrefixConfig implements WebMvcConfigurer {

  @Value("${swagger.prefix:/}")
  private String swaggerPrefix;

  @Override
  public void addResourceHandlers(ResourceHandlerRegistry registry) {
    if (isPrefixSet()) {
      registry.addResourceHandler(swaggerPrefix + "/swagger-ui.html*").addResourceLocations("classpath:/META-INF/resources/");
      registry.addResourceHandler(swaggerPrefix + "/webjars/**").addResourceLocations("classpath:/META-INF/resources/webjars/");
    }
  }

  @Override
  public void addViewControllers(ViewControllerRegistry registry) {
    if (isPrefixSet()) {
      registry.addViewController(swaggerPrefix + "/v2/api-docs").setViewName("forward:/v2/api-docs");
      registry.addViewController(swaggerPrefix + "/swagger-resources").setViewName("forward:/swagger-resources");
      registry.addViewController(swaggerPrefix + "/swagger-resources/configuration/ui").setViewName("forward:/swagger-resources/configuration/ui");
      registry.addViewController(swaggerPrefix + "/swagger-resources/configuration/security").setViewName("forward:/swagger-resources/configuration/security");
    }
  }

  private boolean isPrefixSet() {
    return swaggerPrefix != null && !"".equals(swaggerPrefix) && !"/".equals(swaggerPrefix);
  }

}
