/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.antc.oss;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;
import com.xforceplus.antc.common.util.AntcUtils;
import com.xforceplus.antc.oss.AntcOssConfig;
import com.xforceplus.antc.oss.DateTool;
import com.xforceplus.antc.oss.Module;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Date;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class AntcOssUtil {
    private static final Logger logger = LoggerFactory.getLogger(AntcOssUtil.class);
    @Autowired
    private AntcOssConfig antcOssConfig;
    public static final String DEFAULT_URL_ENCODE = "UTF-8";
    private String accessId = "";
    private String accessKey = "";
    private String ossEndpoint = "";
    private String bucketName = "";
    private String domainName = "";
    private String protocol = "";
    private String downloadInterface;
    private OSSClient client = null;

    @PostConstruct
    public void init() {
        this.accessId = this.antcOssConfig.getAccessId();
        this.accessKey = this.antcOssConfig.getAccessKey();
        this.ossEndpoint = this.antcOssConfig.getOssEndpoint();
        this.bucketName = this.antcOssConfig.getBucketName();
        this.protocol = this.antcOssConfig.getProtocol();
        this.domainName = this.antcOssConfig.getDomainName();
        this.downloadInterface = this.antcOssConfig.getDownloadInterface();
        if (this.downloadInterface == null || this.downloadInterface.trim().length() == 0) {
            this.downloadInterface = "/api/v1/file/security/download";
        }
        if (!this.downloadInterface.startsWith("/")) {
            this.downloadInterface = "/" + this.downloadInterface;
        }
        this.client = new OSSClient(this.protocol + "://" + this.ossEndpoint, this.accessId, this.accessKey);
    }

    public String uploadFile(String localFile, Module module, boolean perpetual) throws FileNotFoundException, RuntimeException {
        String key = "";
        key = this.uploadFile(key, localFile, module, perpetual);
        return key;
    }

    public String uploadFile(String key, String localFile, Module module, boolean perpetual) throws FileNotFoundException, RuntimeException {
        File file = new File(localFile);
        if (!file.exists()) {
            throw new FileNotFoundException("\u6587\u4ef6" + localFile + "\u672a\u627e\u5230");
        }
        if (module == null) {
            throw new RuntimeException("moduleName is required");
        }
        key = AntcOssUtil.formatKey(key, localFile.substring(localFile.lastIndexOf("/") + 1), module, perpetual);
        FileInputStream content = new FileInputStream(file);
        ObjectMetadata meta = new ObjectMetadata();
        meta.setContentLength(file.length());
        PutObjectResult result = this.client.putObject(this.bucketName, key, (InputStream)content, meta);
        logger.info("\u4e0a\u4f20\u6587\u4ef6:{}\uff0c result:{}", (Object)localFile, (Object)result.getETag());
        return key;
    }

    public String uploadFile(String key, File file, Module module, boolean perpetual) throws FileNotFoundException, RuntimeException {
        if (module == null) {
            throw new RuntimeException("moduleName is required");
        }
        String localFile = file.getAbsolutePath();
        key = AntcOssUtil.formatKey(key, localFile.substring(localFile.lastIndexOf("/") + 1), module, perpetual);
        FileInputStream content = new FileInputStream(file);
        ObjectMetadata meta = new ObjectMetadata();
        meta.setContentLength(file.length());
        PutObjectResult result = this.client.putObject(this.bucketName, key, (InputStream)content, meta);
        logger.info("\u4e0a\u4f20\u6587\u4ef6:{}\uff0c result:{}", (Object)localFile, (Object)result.getETag());
        return key;
    }

    private static String formatKey(String key, String fileName, Module module, boolean perpetual) {
        if (key == null || key.trim().length() == 0) {
            key = "tmp/" + DateTool.today() + "/" + fileName;
        }
        if (key.indexOf("/") < 0) {
            key = "tmp/" + DateTool.today() + "/" + key;
        }
        if (perpetual) {
            if (!(key.startsWith("perpetual/") || key.startsWith("/perpetual/") || key.startsWith("perpetual\\") || key.startsWith("\\perpetual\\"))) {
                key = "perpetual" + "/" + module.value() + (key.startsWith("/") || key.startsWith("\\") ? "" : "/") + key;
            }
        } else if (!(key.startsWith("temp/") || key.startsWith("/temp/") || key.startsWith("temp\\") || key.startsWith("\\temp\\"))) {
            key = "temp" + "/" + module.value() + (key.startsWith("/") || key.startsWith("\\") ? "" : "/") + key;
        }
        return key;
    }

    public String uploadFileByInputStream(String key, InputStream inputStream, Module module, boolean perpetual) {
        if (module == null) {
            throw new RuntimeException("moduleName is required");
        }
        key = AntcOssUtil.formatKey(key, UUID.randomUUID().toString(), module, perpetual);
        ObjectMetadata meta = new ObjectMetadata();
        PutObjectResult result = this.client.putObject(this.bucketName, key, inputStream, meta);
        logger.info("\u4e0a\u4f20\u6587\u4ef6:{}, result:{}", (Object)key, (Object)result.getETag());
        return key;
    }

    public void downLoadToLocalPath(String key, String localPath) {
        GetObjectRequest getObjectRequest = new GetObjectRequest(this.bucketName, key);
        ObjectMetadata objectMetadata = this.client.getObject(getObjectRequest, new File(localPath));
    }

    public String fileKeyToDownloadUrl(String key) {
        Date expiration = new Date(new Date().getTime() + 86400000L);
        URL url = this.client.generatePresignedUrl(this.bucketName, key, expiration);
        return url.getProtocol() + "://" + url.getHost() + "/" + key;
    }

    public String fileKeyToDownloadUrlViaPlatform(String key) throws Exception {
        return this.fileKeyToDownloadUrlViaPlatform(key, false);
    }

    public String fileKeyToDownloadUrlViaPlatform(String key, boolean view) throws Exception {
        if (this.domainName == null || this.domainName.length() == 0) {
            throw new Exception("\u672a\u914d\u7f6e\u4e0b\u8f7d\u57df\u540d");
        }
        String host = this.domainName;
        if (host.endsWith("/")) {
            host = host.substring(0, host.length() - 1);
        }
        StringBuilder url = new StringBuilder();
        if (!host.startsWith("http")) {
            url.append(this.protocol).append("://");
        }
        url.append(host).append(this.downloadInterface).append("?key=").append(key);
        if (view) {
            url.append("&view=true");
        }
        return url.toString();
    }

    public void download(OutputStream out, String key) throws Exception {
        GetObjectRequest getObjectRequest = new GetObjectRequest(this.bucketName, key);
        OSSObject ossObject = this.client.getObject(getObjectRequest);
        InputStream in = ossObject.getObjectContent();
        int read = 0;
        byte[] bufs = new byte[10240];
        try {
            while ((read = in.read(bufs, 0, 10240)) != -1) {
                out.write(bufs, 0, read);
            }
        }
        catch (IOException e) {
            logger.error("\u4e0b\u8f7d\u6587\u4ef6\u53d1\u751f\u5f02\u5e38", (Object)key, (Object)e);
            throw e;
        }
        finally {
            try {
                if (in != null || out != null) {
                    in.close();
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void download(HttpServletRequest request, HttpServletResponse response, String key, String fileName) throws Exception {
        this.download(request, response, key, fileName, true);
    }

    public void download(HttpServletRequest request, HttpServletResponse response, String key, String fileName, boolean download) throws Exception {
        if (key == null || key.trim().length() == 0) {
            throw new Exception("\u8bf7\u8f93\u5165\u8981\u4e0b\u8f7d\u7684\u6587\u4ef6");
        }
        key = URLDecoder.decode(key, DEFAULT_URL_ENCODE);
        key = URLDecoder.decode(key, DEFAULT_URL_ENCODE);
        int lastIndexOf = key.lastIndexOf(".");
        String suffix = "";
        if (lastIndexOf > 0) {
            suffix = key.substring(lastIndexOf + 1);
        }
        lastIndexOf = key.lastIndexOf("/");
        if (AntcUtils.isEmpty((String)fileName) && lastIndexOf > 0) {
            fileName = key.substring(lastIndexOf + 1);
        }
        this.download(request, response, key, fileName, suffix, download);
    }

    public void download(HttpServletRequest request, HttpServletResponse response, String key, String fileName, String suffix) throws Exception {
        this.download(request, response, key, fileName, suffix, true);
    }

    public void download(HttpServletRequest request, HttpServletResponse response, String key, String fileName, String suffix, boolean download) throws Exception {
        String contentType = "";
        if (key == null || key.trim().length() == 0) {
            throw new Exception("\u8bf7\u8f93\u5165\u8981\u4e0b\u8f7d\u7684\u6587\u4ef6");
        }
        if (key.startsWith("/")) {
            key = key.substring(1);
        }
        if (suffix.equals("gif")) {
            contentType = "image/gif";
        } else if (suffix.equals("jpg")) {
            contentType = "image/jpeg";
        } else if (suffix.equals("jpeg")) {
            contentType = "image/jpeg";
        } else if (suffix.equals("png")) {
            contentType = "image/png";
        } else if (suffix.equals("txt")) {
            contentType = "text/plain";
        } else if (suffix.equals("pdf")) {
            contentType = "application/pdf";
        } else if (suffix.equals("doc")) {
            contentType = "application/ms-word";
        } else if (suffix.equals("xls")) {
            contentType = "application/vnd.ms-excel";
        } else if (suffix.equals("zip")) {
            contentType = "application/zip";
        }
        try {
            if (download) {
                response.setHeader("Content-Disposition", String.format("attachment;filename*=utf-8'zh_cn'%s", URLEncoder.encode(fileName, "utf-8")));
            } else {
                response.setContentType("text/html; charset=UTF-8");
            }
            response.setContentType(contentType);
            ServletOutputStream outputStream = response.getOutputStream();
            this.download((OutputStream)outputStream, key);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u6587\u4ef6\u53d1\u751f\u5f02\u5e38, \u6587\u4ef6key:{}", (Object)key, (Object)e);
            throw e;
        }
    }
}

