/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.antc.redis;

import java.util.HashSet;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

@Component
@Configuration
public class AntcRedisConfig {
    private static final String STANDALONE = "standalone";
    private static final String SENTINEL = "sentinel";
    private static final String CLUSTER = "cluster";
    @Value(value="${antc.redis.maxIdle}")
    private Integer maxIdle;
    @Value(value="${antc.redis.minIdle}")
    private Integer minIdle;
    @Value(value="${antc.redis.maxTotal}")
    private Integer maxTotal;
    @Value(value="${antc.redis.maxWaitMillis}")
    private Integer maxWaitMillis;
    @Value(value="${antc.redis.minEvictableIdleTimeMillis}")
    private Integer minEvictableIdleTimeMillis;
    @Value(value="${antc.redis.numTestsPerEvictionRun}")
    private Integer numTestsPerEvictionRun;
    @Value(value="${antc.redis.timeBetweenEvictionRunsMillis}")
    private long timeBetweenEvictionRunsMillis;
    @Value(value="${antc.redis.testOnBorrow}")
    private boolean testOnBorrow;
    @Value(value="${antc.redis.testWhileIdle:false}")
    private boolean testWhileIdle;
    @Value(value="${antc.redis.sentinelNodes:}")
    private String sentinelNodes;
    @Value(value="${antc.redis.sentinelMaster:}")
    private String sentinelMaster;
    @Value(value="${antc.redis.standaloneHost:}")
    private String standaloneHost;
    @Value(value="${antc.redis.standalonePort:}")
    private Integer standalonePort;
    @Value(value="${antc.redis.password:}")
    private String password;
    @Value(value="${antc.redis.timeout}")
    private Integer timeout;
    @Value(value="${antc.redis.type:standalone}")
    private String type;
    @Value(value="${antc.redis.clusterNodes:}")
    private String clusterNodes;
    @Value(value="${antc.redis.database:0}")
    private int database;

    @Bean
    public JedisConnectionFactory jedisConnectionFactory(JedisPoolConfig jedisPoolConfig) {
        if (STANDALONE.equalsIgnoreCase(this.type)) {
            RedisStandaloneConfiguration redisStandaloneConfiguration = new RedisStandaloneConfiguration(this.standaloneHost, this.standalonePort.intValue());
            if (!StringUtils.isEmpty((Object)this.password)) {
                RedisPassword redisPassword = RedisPassword.of((String)this.password);
                redisStandaloneConfiguration.setPassword(redisPassword);
            }
            redisStandaloneConfiguration.setDatabase(this.database);
            JedisConnectionFactory jedisSentinelConnectionFactory = new JedisConnectionFactory(redisStandaloneConfiguration);
            return jedisSentinelConnectionFactory;
        }
        if (CLUSTER.equalsIgnoreCase(this.type)) {
            String[] hosts = this.clusterNodes.split(",");
            HashSet<String> sentinelHostAndPorts = new HashSet<String>();
            String[] var4 = hosts;
            int var5 = hosts.length;
            for (int var6 = 0; var6 < var5; ++var6) {
                String hn = var4[var6];
                sentinelHostAndPorts.add(hn);
            }
            RedisClusterConfiguration clusterConfiguration = new RedisClusterConfiguration(sentinelHostAndPorts);
            if (!StringUtils.isEmpty((Object)this.password)) {
                RedisPassword redisPassword = RedisPassword.of((String)this.password);
                clusterConfiguration.setPassword(redisPassword);
            }
            JedisConnectionFactory jedisSentinelConnectionFactory = new JedisConnectionFactory(clusterConfiguration, jedisPoolConfig);
            return jedisSentinelConnectionFactory;
        }
        String[] hosts = this.sentinelNodes.split(",");
        HashSet<String> sentinelHostAndPorts = new HashSet<String>();
        String[] var4 = hosts;
        int var5 = hosts.length;
        for (int var6 = 0; var6 < var5; ++var6) {
            String hn = var4[var6];
            sentinelHostAndPorts.add(hn);
        }
        RedisSentinelConfiguration sentinelConfig = new RedisSentinelConfiguration(this.sentinelMaster, sentinelHostAndPorts);
        if (!StringUtils.isEmpty((Object)this.password)) {
            RedisPassword redisPassword = RedisPassword.of((String)this.password);
            sentinelConfig.setPassword(redisPassword);
        }
        sentinelConfig.setDatabase(this.database);
        JedisConnectionFactory jedisSentinelConnectionFactory = new JedisConnectionFactory(sentinelConfig, jedisPoolConfig);
        return jedisSentinelConnectionFactory;
    }

    @Bean
    public JedisPoolConfig jedisPoolConfig() {
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMaxIdle(this.maxIdle.intValue());
        jedisPoolConfig.setMinIdle(this.minIdle.intValue());
        jedisPoolConfig.setMaxTotal(this.maxTotal.intValue());
        jedisPoolConfig.setMaxWaitMillis((long)this.maxWaitMillis.intValue());
        jedisPoolConfig.setMinEvictableIdleTimeMillis((long)this.minEvictableIdleTimeMillis.intValue());
        jedisPoolConfig.setNumTestsPerEvictionRun(this.numTestsPerEvictionRun.intValue());
        jedisPoolConfig.setTimeBetweenEvictionRunsMillis(this.timeBetweenEvictionRunsMillis);
        jedisPoolConfig.setTestOnBorrow(this.testOnBorrow);
        jedisPoolConfig.setTestWhileIdle(this.testWhileIdle);
        return jedisPoolConfig;
    }

    @Bean
    public JedisPool JedisPoolFactory(JedisPoolConfig jedisPoolConfig) {
        JedisPool jp = StringUtils.isEmpty((Object)this.password) ? new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, this.standaloneHost, this.standalonePort.intValue()) : new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, this.standaloneHost, this.standalonePort.intValue(), this.timeout.intValue(), this.password);
        return jp;
    }

    protected void initDomainRedisTemplate(RedisTemplate<String, Object> redisTemplate, RedisConnectionFactory factory) {
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setHashValueSerializer((RedisSerializer)new GenericJackson2JsonRedisSerializer());
        redisTemplate.setValueSerializer((RedisSerializer)new GenericJackson2JsonRedisSerializer());
        redisTemplate.setConnectionFactory(factory);
    }

    @Bean
    public RedisTemplate<String, Object> functionDomainRedisTemplate(RedisConnectionFactory redisSentinelConnectionFactory) {
        RedisTemplate redisSentinelTemplate = new RedisTemplate();
        this.initDomainRedisTemplate((RedisTemplate<String, Object>)redisSentinelTemplate, redisSentinelConnectionFactory);
        return redisSentinelTemplate;
    }
}

