/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.antc.redis;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;

@Component
public final class AntcRedisService {
    private static Logger logger = LoggerFactory.getLogger(AntcRedisService.class);
    private static final Long RELEASE_SUCCESS = 1L;
    private static final String LOCK_SUCCESS = "OK";
    private static final String SET_IF_NOT_EXIST = "NX";
    private static final String SET_WITH_EXPIRE_TIME = "PX";
    public static final String UNLOCK_LUA;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    RedissonClient redissonClient;

    public String getInvoiceLockKey(String invoiceCode, String invoiceNo) {
        return "AntSellerSyncLock" + invoiceCode + invoiceNo;
    }

    public Long sremDistributedLockValue(String lockKey, String lockValue) {
        try {
            RedisCallback callback = connection -> {
                Object nativeConnection = connection.getNativeConnection();
                if (nativeConnection instanceof JedisCluster) {
                    logger.info("redis\u96c6\u7fa4\u6a21\u5f0f\u5220\u9664set\u9501\u503c\uff0clockKey[{}]", (Object)lockKey);
                    return ((JedisCluster)nativeConnection).srem(lockKey, new String[]{lockValue});
                }
                if (nativeConnection instanceof Jedis) {
                    logger.info("redis\u5355\u673a\u6a21\u5f0f\u5220\u9664set\u9501\u503c\uff0clockKey[{}]", (Object)lockKey);
                    return ((Jedis)nativeConnection).srem(lockKey, new String[]{lockValue});
                }
                return null;
            };
            return (Long)this.redisTemplate.execute(callback);
        }
        catch (Exception e) {
            logger.error("srem redis distributed value occur an exception", (Throwable)e);
            return null;
        }
    }

    public Long saddDistributedLockValue(String lockKey, String lockValue) {
        try {
            RedisCallback callback = connection -> {
                Object nativeConnection = connection.getNativeConnection();
                if (nativeConnection instanceof JedisCluster) {
                    logger.info("redis\u96c6\u7fa4\u6a21\u5f0f\u6dfb\u52a0set\u9501\u503c\uff0clockKey[{}]", (Object)lockKey);
                    return ((JedisCluster)nativeConnection).sadd(lockKey, new String[]{lockValue});
                }
                if (nativeConnection instanceof Jedis) {
                    logger.info("redis\u5355\u673a\u6a21\u5f0f\u6dfb\u52a0set\u9501\u503c\uff0clockKey[{}]", (Object)lockKey);
                    return ((Jedis)nativeConnection).sadd(lockKey, new String[]{lockValue});
                }
                return null;
            };
            return (Long)this.redisTemplate.execute(callback);
        }
        catch (Exception e) {
            logger.error("sadd redis distributed value occur an exception", (Throwable)e);
            return null;
        }
    }

    public Set<String> smembersDistributedLockValue(String lockKey) {
        try {
            RedisCallback callback = connection -> {
                Object nativeConnection = connection.getNativeConnection();
                if (nativeConnection instanceof JedisCluster) {
                    logger.info("redis\u96c6\u7fa4\u6a21\u5f0f\u67e5\u8be2set\u9501\u503c\uff0clockKey[{}]", (Object)lockKey);
                    return ((JedisCluster)nativeConnection).smembers(lockKey);
                }
                if (nativeConnection instanceof Jedis) {
                    logger.info("redis\u5355\u673a\u6a21\u67e5\u8be2set\u9501\u503c\uff0clockKey[{}]", (Object)lockKey);
                    return ((Jedis)nativeConnection).smembers(lockKey);
                }
                return null;
            };
            return (Set)this.redisTemplate.execute(callback);
        }
        catch (Exception e) {
            logger.error("smembers redis distributed value occur an exception", (Throwable)e);
            return null;
        }
    }

    public String getDistributedLockValue(String lockKey) {
        try {
            RedisCallback callback = connection -> {
                Object nativeConnection = connection.getNativeConnection();
                if (nativeConnection instanceof JedisCluster) {
                    logger.info("redis\u96c6\u7fa4\u6a21\u5f0f\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u503c\uff0clockKey[{}]", (Object)lockKey);
                    return ((JedisCluster)nativeConnection).get(lockKey);
                }
                if (nativeConnection instanceof Jedis) {
                    logger.info("redis\u5355\u673a\u6a21\u5f0f\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u503c\uff0clockKey[{}]", (Object)lockKey);
                    return ((Jedis)nativeConnection).get(lockKey);
                }
                return null;
            };
            return (String)this.redisTemplate.execute(callback);
        }
        catch (Exception e) {
            logger.error("get redis distributed value occur an exception", (Throwable)e);
            return null;
        }
    }

    public Long getDistributedLockExpire(String lockKey) {
        try {
            RedisCallback callback = connection -> {
                Object nativeConnection = connection.getNativeConnection();
                if (nativeConnection instanceof JedisCluster) {
                    logger.info("redis\u96c6\u7fa4\u6a21\u5f0f\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u6709\u6548\u671f\uff0clockKey[{}]", (Object)lockKey);
                    return ((JedisCluster)nativeConnection).ttl(lockKey);
                }
                if (nativeConnection instanceof Jedis) {
                    logger.info("redis\u5355\u673a\u6a21\u5f0f\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u6709\u6548\u671f\uff0clockKey[{}]", (Object)lockKey);
                    return ((Jedis)nativeConnection).ttl(lockKey);
                }
                return null;
            };
            return (Long)this.redisTemplate.execute(callback);
        }
        catch (Exception e) {
            logger.error("get redis distributed expire occur an exception", (Throwable)e);
            return null;
        }
    }

    public boolean setExpire(String lockKey, int expireTime) {
        boolean hasExpire = false;
        try {
            RedisCallback callback = connection -> {
                Object nativeConnection = connection.getNativeConnection();
                if (nativeConnection instanceof JedisCluster) {
                    logger.info("redis\u96c6\u7fa4\u6a21\u5f0f\u8bbe\u7f6e\u8d85\u65f6\u65f6\u95f4\uff0clockKey[{}],expireTime[{}]", (Object)lockKey, (Object)expireTime);
                    return ((JedisCluster)nativeConnection).expire(lockKey, expireTime);
                }
                if (nativeConnection instanceof Jedis) {
                    logger.info("redis\u5355\u673a\u6a21\u5f0f\u8bbe\u7f6e\u8d85\u65f6\u65f6\u95f4\uff0clockKey[{}],expireTime[{}]", (Object)lockKey, (Object)expireTime);
                    return ((Jedis)nativeConnection).expire(lockKey, expireTime);
                }
                return null;
            };
            Long result = (Long)this.redisTemplate.execute(callback);
            if (RELEASE_SUCCESS.equals(result)) {
                hasExpire = true;
            }
        }
        catch (Exception e) {
            logger.error("redis setExpire exception {}:{}", new Object[]{lockKey, expireTime, e});
        }
        return hasExpire;
    }

    public Object get(String key) {
        return key == null ? null : this.redisTemplate.opsForValue().get((Object)key);
    }

    public long getExpire(String key) {
        return this.redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
    }

    public boolean set(String key, Object value) {
        try {
            this.redisTemplate.opsForValue().set((Object)key, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setExpire(String key, Object value, long time) {
        return this.set(key, value, time, TimeUnit.SECONDS);
    }

    public boolean setExpireTimeUnit(String key, Object value, long time, TimeUnit timeUnit) {
        return this.set(key, value, time, TimeUnit.SECONDS);
    }

    public RLock getLock(String name) {
        return this.redissonClient.getLock(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T lock(String key, long time, Supplier<T> supplier) {
        RLock lock = this.redissonClient.getLock(key);
        try {
            if (!lock.tryLock(0L, time, TimeUnit.SECONDS)) throw new RuntimeException("\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01");
            try {
                T t = supplier.get();
                return t;
            }
            finally {
                lock.unlock();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T reentrantLock(String key, long time, Supplier<T> supplier) {
        RLock lock = this.redissonClient.getLock(key);
        lock.lock(time, TimeUnit.SECONDS);
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    public void setRedisTemplate(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public boolean expire(String key, long time) {
        try {
            if (time > 0L) {
                this.redisTemplate.expire((Object)key, time, TimeUnit.SECONDS);
            }
            return true;
        }
        catch (Exception var5) {
            var5.printStackTrace();
            return false;
        }
    }

    public boolean hasKey(String key) {
        try {
            return this.redisTemplate.hasKey((Object)key);
        }
        catch (Exception var3) {
            var3.printStackTrace();
            return false;
        }
    }

    public void del(String ... key) {
        if (key != null && key.length > 0) {
            if (key.length == 1) {
                this.redisTemplate.delete((Object)key[0]);
            } else {
                this.redisTemplate.delete((Collection)CollectionUtils.arrayToList((Object)key));
            }
        }
    }

    public boolean set(String key, Object value, long time, TimeUnit timeUnit) {
        try {
            if (time > 0L) {
                this.redisTemplate.opsForValue().set((Object)key, value, time, timeUnit);
            } else {
                this.set(key, value);
            }
            return true;
        }
        catch (Exception var6) {
            var6.printStackTrace();
            return false;
        }
    }

    public long incr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.redisTemplate.opsForValue().increment((Object)key, delta);
    }

    public long decr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.redisTemplate.opsForValue().increment((Object)key, -delta);
    }

    public Object hget(String key, String item) {
        return this.redisTemplate.opsForHash().get((Object)key, (Object)item);
    }

    public Map<Object, Object> hmget(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    public boolean hmset(String key, Map<String, Object> map) {
        try {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            return true;
        }
        catch (Exception var4) {
            var4.printStackTrace();
            return false;
        }
    }

    public boolean hmset(String key, Map<String, Object> map, long time) {
        try {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception var6) {
            var6.printStackTrace();
            return false;
        }
    }

    public boolean hset(String key, String item, Object value) {
        try {
            this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            return true;
        }
        catch (Exception var5) {
            var5.printStackTrace();
            return false;
        }
    }

    public boolean hset(String key, String item, Object value, long time) {
        try {
            this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception var7) {
            var7.printStackTrace();
            return false;
        }
    }

    public void hdel(String key, Object ... item) {
        this.redisTemplate.opsForHash().delete((Object)key, item);
    }

    public boolean hHasKey(String key, String item) {
        return this.redisTemplate.opsForHash().hasKey((Object)key, (Object)item);
    }

    public double hincr(String key, String item, double by) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, by);
    }

    public double hdecr(String key, String item, double by) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, -by);
    }

    public Set<Object> sGet(String key) {
        try {
            return this.redisTemplate.opsForSet().members((Object)key);
        }
        catch (Exception var3) {
            var3.printStackTrace();
            return null;
        }
    }

    public boolean sHasKey(String key, Object value) {
        try {
            return this.redisTemplate.opsForSet().isMember((Object)key, value);
        }
        catch (Exception var4) {
            var4.printStackTrace();
            return false;
        }
    }

    public long sSet(String key, Object ... values) {
        try {
            return this.redisTemplate.opsForSet().add((Object)key, values);
        }
        catch (Exception var4) {
            var4.printStackTrace();
            return 0L;
        }
    }

    public long sSetAndTime(String key, long time, Object ... values) {
        try {
            Long count = this.redisTemplate.opsForSet().add((Object)key, values);
            if (time > 0L) {
                this.expire(key, time);
            }
            return count;
        }
        catch (Exception var6) {
            var6.printStackTrace();
            return 0L;
        }
    }

    public long sGetSetSize(String key) {
        try {
            return this.redisTemplate.opsForSet().size((Object)key);
        }
        catch (Exception var3) {
            var3.printStackTrace();
            return 0L;
        }
    }

    public long setRemove(String key, Object ... values) {
        try {
            Long count = this.redisTemplate.opsForSet().remove((Object)key, values);
            return count;
        }
        catch (Exception var4) {
            var4.printStackTrace();
            return 0L;
        }
    }

    public List<Object> lGet(String key, long start, long end) {
        try {
            return this.redisTemplate.opsForList().range((Object)key, start, end);
        }
        catch (Exception var7) {
            var7.printStackTrace();
            return null;
        }
    }

    public long lGetListSize(String key) {
        try {
            return this.redisTemplate.opsForList().size((Object)key);
        }
        catch (Exception var3) {
            var3.printStackTrace();
            return 0L;
        }
    }

    public Object lGetIndex(String key, long index) {
        try {
            return this.redisTemplate.opsForList().index((Object)key, index);
        }
        catch (Exception var5) {
            var5.printStackTrace();
            return null;
        }
    }

    public boolean lSet(String key, Object value) {
        try {
            this.redisTemplate.opsForList().rightPush((Object)key, value);
            return true;
        }
        catch (Exception var4) {
            var4.printStackTrace();
            return false;
        }
    }

    public boolean lSet(String key, Object value, long time) {
        try {
            this.redisTemplate.opsForList().rightPush((Object)key, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception var6) {
            var6.printStackTrace();
            return false;
        }
    }

    public boolean lSet(String key, List<Object> value) {
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)key, value);
            return true;
        }
        catch (Exception var4) {
            var4.printStackTrace();
            return false;
        }
    }

    public boolean lSet(String key, List<Object> value, long time) {
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)key, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception var6) {
            var6.printStackTrace();
            return false;
        }
    }

    public boolean lUpdateIndex(String key, long index, Object value) {
        try {
            this.redisTemplate.opsForList().set((Object)key, index, value);
            return true;
        }
        catch (Exception var6) {
            var6.printStackTrace();
            return false;
        }
    }

    public long lRemove(String key, long count, Object value) {
        try {
            Long remove = this.redisTemplate.opsForList().remove((Object)key, count, value);
            return remove;
        }
        catch (Exception var6) {
            var6.printStackTrace();
            return 0L;
        }
    }

    public Object lPop(String key, long time) {
        return this.redisTemplate.opsForList().leftPop((Object)key, time, TimeUnit.SECONDS);
    }

    public Object lPop(String key) {
        return this.redisTemplate.opsForList().leftPop((Object)key);
    }

    static {
        StringBuilder unlockSb = new StringBuilder();
        unlockSb.append("if redis.call(\"get\",KEYS[1]) == ARGV[1] ");
        unlockSb.append("then ");
        unlockSb.append("    return redis.call(\"del\",KEYS[1]) ");
        unlockSb.append("else ");
        unlockSb.append("    return 0 ");
        unlockSb.append("end ");
        UNLOCK_LUA = unlockSb.toString();
    }
}

