/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.antc.security.microservice;

import com.xforceplus.antc.security.microservice.UserTokenService;
import com.xforceplus.antc.security.utils.JsonUtils;
import com.xforceplus.tenantsecurity.domain.AuthorizedUser;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;

@ConditionalOnBean(value={ContextHolder.class})
public class ContextHolderConfig {
    private static final Logger log = LoggerFactory.getLogger(ContextHolderConfig.class);
    private ContextHolder contextHolder;

    public ContextHolderConfig() {
        UserTokenService.contextHolderConfig = this;
        log.info("##### ContextHolderConfig init");
    }

    @Autowired
    public void setContextHolder(ContextHolder ch) {
        this.contextHolder = ch;
    }

    public String getUserSessionInfo() {
        if (null == this.contextHolder || null == this.contextHolder.get()) {
            return null;
        }
        UserContext userContext = (UserContext)this.contextHolder.get();
        UserSessionInfo userSessionInfo = userContext.getUserSessionInfo();
        AuthorizedUser authorizedUser = new AuthorizedUser();
        authorizedUser.setTenantId(userSessionInfo.getGroupId());
        authorizedUser.setTenantCode(userSessionInfo.getGroupCode());
        authorizedUser.setTenantName(userSessionInfo.getGroupName());
        authorizedUser.setUsername(userSessionInfo.getSysUserName());
        authorizedUser.setId(userSessionInfo.getSysUserId());
        authorizedUser.setAccountId(userSessionInfo.getAccountId());
        authorizedUser.setEmail(userSessionInfo.getEmail());
        userSessionInfo.setIsAdmin(userSessionInfo.getIsAdmin());
        String userSessionInfoStr = JsonUtils.writeObjectToJson(authorizedUser);
        return userSessionInfoStr;
    }
}

