/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.antc.security.microservice.interceptor;

import com.xforceplus.antc.security.microservice.ServiceConfig;
import com.xforceplus.antc.security.utils.SecurityStringUtils;
import com.xforceplus.tenantsecurity.domain.UserType;
import com.xforceplus.tenantsecurity.utils.CompressionUtils;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmsTokenFeignInterceptor
implements RequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(CmsTokenFeignInterceptor.class);

    public CmsTokenFeignInterceptor() {
        log.debug("##### \u6dfb\u52a0\u5fae\u670d\u52a1\u8c03\u7528\u8ba4\u8bc1feign \u62e6\u622a\u5668 CmsTokenFeignInterceptor");
    }

    public void apply(RequestTemplate template) {
        this.msAuth(template);
        this.userInfo(template);
    }

    private void msAuth(RequestTemplate template) {
        String authToken = ServiceConfig.getMsAuthToken();
        log.debug("##### CmsTokenFeignInterceptor \u8bbe\u7f6e\u8ba4\u8bc1token , header key\uff1a{}\uff0cheader value\uff1a{}", (Object)UserType.APPID.tokenKey(), (Object)SecurityStringUtils.privacyOut(authToken));
        template.header(UserType.APPID.tokenKey(), new String[]{authToken});
    }

    private void userInfo(RequestTemplate template) {
        try {
            String userInfoJson = ServiceConfig.getUserInfoJson();
            if (StringUtils.isEmpty((CharSequence)userInfoJson)) {
                log.debug("##### \u5f53\u524d\u4e0a\u4e0b\u6587\u6ca1\u6709\u7528\u6237\u8ba4\u8bc1\u4fe1\u606f");
                return;
            }
            log.debug("##### CmsTokenFeignInterceptor \u8bbe\u7f6e\u8ba4\u8bc1\u7528\u6237\u4fe1\u606f , header key\uff1a{}\uff0cheader value\uff1a{}", (Object)UserType.USER.userinfoKey(), (Object)userInfoJson);
            String encode = CompressionUtils.encode((String)userInfoJson);
            template.header(UserType.USER.userinfoKey(), new String[]{encode});
        }
        catch (Exception e) {
            log.error("##### \u8f6c\u53d1\u8ba4\u8bc1\u7528\u6237json \u5f02\u5e38\uff1a{}", (Throwable)e);
        }
    }
}

