/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.antc.security.user.intercepter;

import com.alibaba.fastjson.JSON;
import com.auth0.jwt.exceptions.TokenExpiredException;
import com.xforceplus.antc.security.user.domain.MsAuthInfo;
import com.xforceplus.antc.security.user.domain.MsAuthInfoHolder;
import com.xforceplus.antc.security.user.domain.UserAuthInfoHolder;
import com.xforceplus.antc.security.utils.JsonUtils;
import com.xforceplus.antc.security.utils.TokenUtils;
import com.xforceplus.tenantsecurity.annotation.WithoutAuth;
import com.xforceplus.tenantsecurity.domain.AuthorizedUser;
import com.xforceplus.tenantsecurity.domain.IAuthorizedUser;
import com.xforceplus.tenantsecurity.domain.UserType;
import com.xforceplus.tenantsecurity.jwt.JwtUtils;
import com.xforceplus.tenantsecurity.utils.CompressionUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;
import org.springframework.web.util.WebUtils;

public class NewBssTokenParserInterceptor
implements HandlerInterceptor {
    private Logger logger = LoggerFactory.getLogger(NewBssTokenParserInterceptor.class);
    @Value(value="${antc.security.uCenter.jwt.secret:my_sessionjw_tsecret_xdfdffdsdfdfs}")
    private String secret;
    @Value(value="${antc.security.uCenter.appid:90}")
    private String appid;
    @Value(value="${antc.security.uCenter.login-url:https://paas.xforceplus.com/login/}")
    private String loginUrl;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        if (handler instanceof ResourceHttpRequestHandler) {
            return true;
        }
        HandlerMethod method = (HandlerMethod)handler;
        boolean isWithoutAuth = method.hasMethodAnnotation(WithoutAuth.class);
        if (isWithoutAuth) {
            return true;
        }
        String token = null;
        Cookie tokenCookie = WebUtils.getCookie((HttpServletRequest)request, (String)"xforce-saas-token");
        if (tokenCookie != null) {
            token = tokenCookie.getValue();
        }
        if (StringUtils.isEmpty(token)) {
            token = request.getHeader("xforce-saas-token");
        }
        if (StringUtils.isEmpty((CharSequence)token)) {
            this.logger.warn("TokenParser: 1\u3001Cookie\u4e2d\u65e0xforce-saas-token;2\u3001Header\u4e2d\u65e0xforce-saas-token;3\u3001Header\u4e2d\u65e0x-access-token;4\u3001 Header\u4e2d\u65e0X-Access-Token;5\u3001url\u53c2\u6570\u4e2d\u65e0x-access-token");
            token = request.getHeader("x-app-token");
        }
        if (StringUtils.isEmpty((CharSequence)token)) {
            token = request.getHeader("x-access-token");
        }
        if (StringUtils.isEmpty((CharSequence)token)) {
            token = request.getHeader("X-Access-Token");
        }
        if (StringUtils.isEmpty((CharSequence)token) && StringUtils.isEmpty((CharSequence)token)) {
            token = WebUtils.findParameterValue((ServletRequest)request, (String)"x-access-token");
        }
        if (StringUtils.isBlank((CharSequence)token)) {
            String message = "\u8bbf\u95ee\u5931\u8d25\uff0c\u6ca1\u6709\u767b\u5f55";
            this.logger.warn("TokenParser: token is Blank, " + message);
            this.responseUnauthorized(message, request, response);
            return false;
        }
        Map claims = null;
        if (StringUtils.isNotBlank((CharSequence)token)) {
            try {
                claims = JwtUtils.verifyAndDecodeToken((String)this.secret, (String)token);
            }
            catch (TokenExpiredException e) {
                this.logger.error("token\u8fc7\u671f\u5f02\u5e38TokenExpiredException,token=={}", (Object)token);
                String message = "token\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55";
                this.responseUnauthorized(message, request, response);
                return false;
            }
            catch (Exception e) {
                String message = "token\u89e3\u6790\u5931\u8d25\u3002";
                this.logger.warn("token:{};secret:{};message:{};error:{}", new Object[]{token, this.secret, message, e.getMessage()});
                this.responseUnauthorized(message, request, response);
                return false;
            }
        }
        if (claims == null) {
            String message = "Token\u89e3\u6790\u8fd4\u56de\u4e3a\u7a7a";
            this.logger.warn("TokenParser: claims == null, " + message);
            this.responseUnauthorized(message, request, response);
            return false;
        }
        this.logger.info("##### token \u8fc7\u671f\u65f6\u95f4\uff1a{}", claims.get("expireTime"));
        String systemType = (String)claims.get("type");
        if ("3".equals(systemType)) {
            this.logger.info("##### x-app-token \u8ba4\u8bc1");
            if (this.microServiceAuth(claims, request)) {
                return true;
            }
            this.responseUnauthorized("\u5fae\u670d\u52a1\u8ba4\u8bc1 token \u89e3\u6790\u5931\u8d25", request, response);
            return false;
        }
        if (!"1".equals(systemType)) {
            String message = "token\u975e\u6cd5\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55";
            this.logger.warn("TokenParser: claims == null, " + message);
            this.responseUnauthorized(message, request, response);
            return false;
        }
        try {
            AuthorizedUser userAuthInfo = TokenUtils.getUserAuthInfo(claims, token);
            UserAuthInfoHolder.put((IAuthorizedUser)userAuthInfo);
            return null != userAuthInfo;
        }
        catch (Exception e) {
            String message = "\u89e3\u6790\u7528\u6237\u4e0a\u4e0b\u6587\u53d1\u751f\u5f02\u5e38 ";
            this.logger.warn("TokenParser: {}\uff0c{}", (Object)message, (Object)e);
            this.responseUnauthorized(message, request, response);
            return false;
        }
    }

    private void responseUnauthorized(String message, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        response.setContentType("application/json;charset=UTF-8");
        response.setStatus(401);
        LinkedHashMap<String, String> error = new LinkedHashMap<String, String>();
        error.put("code", "0");
        error.put("message", message);
        error.put("loginUrl", this.loginUrl);
        response.getWriter().write(JSON.toJSONString(error));
    }

    private boolean microServiceAuth(Map<String, String> claims, HttpServletRequest request) {
        try {
            MsAuthInfo msAuthInfo = TokenUtils.getMsAuthInfo(claims);
            if (null == msAuthInfo) {
                return false;
            }
            MsAuthInfoHolder.put(msAuthInfo);
            this.logger.info("##### \u5fae\u670d\u52a1 \u8ba4\u8bc1token \u89e3\u6790\u7ed3\u679c\uff1a{}", (Object)msAuthInfo);
            try {
                String userInfoStr = request.getHeader(UserType.USER.userinfoKey());
                if (StringUtils.isNotEmpty((CharSequence)userInfoStr)) {
                    String userInfoJson = CompressionUtils.decode((String)userInfoStr);
                    AuthorizedUser authorizedUser = JsonUtils.writeJsonToObject(userInfoJson, AuthorizedUser.class);
                    UserAuthInfoHolder.put((IAuthorizedUser)authorizedUser);
                }
            }
            catch (Exception e) {
                this.logger.warn("##### \u5fae\u4efb\u52a1\u8ba4\u8bc1 \u643a\u5e26\u7528\u6237\u4fe1\u606f\u89e3\u6790\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            }
            return true;
        }
        catch (Exception e) {
            this.logger.warn("##### \u5904\u7406 \u5fae\u670d\u52a1 \u8ba4\u8bc1token \u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            return false;
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        UserAuthInfoHolder.clearContext();
        MsAuthInfoHolder.clearContext();
    }

    public static interface JwtConstants {
        public static final String TYPE_KEY = "type";
        public static final String USERINFO_KEY = "userinfo";
        public static final String TOKEN_EXPIRE_KEY = "expireTime";
    }
}

