/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.antc.security.utils;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static Logger logger = LoggerFactory.getLogger(JsonUtils.class);

    public static String writeObjectToJson(Object o) {
        ObjectMapper objectMapper = new ObjectMapper();
        String jsonStr = "";
        try {
            jsonStr = objectMapper.writeValueAsString(o);
        }
        catch (JsonProcessingException var4) {
            logger.error("Map\u5e8f\u5217\u5316\u9519\u8bef " + var4.getMessage(), (Throwable)var4);
        }
        return jsonStr;
    }

    public static <T> T writeJsonToObject(String json, Class<T> t) {
        Object instance = null;
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            instance = objectMapper.readValue(json, t);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return (T)instance;
    }

    public static <T> T writeJsonToObjectForUpperCaseKey(String json, Class<T> t) {
        Object instance = null;
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setPropertyNamingStrategy(new PropertyNamingStrategy());
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            instance = objectMapper.readValue(json, t);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return (T)instance;
    }

    public static <T> List<T> writeJsonToListObject(String json, Class<T> t) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        List jsonList = null;
        JavaType javaType = mapper.getTypeFactory().constructParametricType(List.class, new Class[]{t});
        try {
            jsonList = (List)mapper.readValue(json, javaType);
            return jsonList;
        }
        catch (IOException var6) {
            logger.error("\u89e3\u6790\u53d1\u7968\u6587\u672c\u9519\u8bef!", (Throwable)var6);
            throw new RuntimeException(var6);
        }
    }

    public static <T> List<T> writeJsonToListObjectForUpperCaseKey(String json, Class<T> t) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setPropertyNamingStrategy(new PropertyNamingStrategy());
        List jsonList = null;
        JavaType javaType = mapper.getTypeFactory().constructParametricType(List.class, new Class[]{t});
        try {
            jsonList = (List)mapper.readValue(json, javaType);
            return jsonList;
        }
        catch (IOException var6) {
            logger.error("\u89e3\u6790\u53d1\u7968\u6587\u672c\u9519\u8bef!", (Throwable)var6);
            throw new RuntimeException(var6);
        }
    }

    public static Map writeJsonToMap(String json) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        mapper.configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
        Map map = null;
        try {
            map = (Map)mapper.readValue(json, Map.class);
        }
        catch (IOException var4) {
            logger.error("\u89e3\u6790\u53d1\u7968\u6587\u672c\u9519\u8bef!", (Throwable)var4);
        }
        return map;
    }

    public static <T> List<T> transforMapListToBeanList(List<Map> mList, Class<T> t) {
        String mStr = JsonUtils.writeObjectToJson(mList);
        return JsonUtils.writeJsonToListObject(mStr, t);
    }

    public static String writeObjectToFastJson(Object o) {
        String jsonStr = "";
        try {
            jsonStr = JSONObject.toJSONString((Object)o);
        }
        catch (Exception var3) {
            logger.error("Map\u5e8f\u5217\u5316\u9519\u8bef " + var3.getMessage(), (Throwable)var3);
        }
        return jsonStr;
    }

    public static <T> T writeFastJsonToObject(String json, Class<T> t) {
        Object instance = null;
        try {
            instance = JSONObject.parseObject((String)json, t);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (T)instance;
    }
}

