/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.antc.security.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.auth0.jwt.exceptions.TokenExpiredException;
import com.xforceplus.antc.security.user.domain.MsAuthInfo;
import com.xforceplus.antc.security.user.domain.MsAuthInfoHolder;
import com.xforceplus.antc.security.user.domain.UserAuthInfoHolder;
import com.xforceplus.antc.security.utils.JsonUtils;
import com.xforceplus.tenantsecurity.domain.AuthorizedUser;
import com.xforceplus.tenantsecurity.domain.IAuthorizedUser;
import com.xforceplus.tenantsecurity.jwt.JwtUtils;
import com.xforceplus.tenantsecurity.utils.CompressionUtils;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenUtils {
    private static final Logger log = LoggerFactory.getLogger(TokenUtils.class);

    public static <T> T getCurrentAuthInfo(String token, String jwtSecret) {
        String systemType;
        Map<String, String> claims = TokenUtils.decodeToken(token, jwtSecret);
        switch (systemType = claims.get("type")) {
            case "1": {
                log.info("\u7528\u6237\u8ba4\u8bc1token \u89e3\u6790");
                return (T)TokenUtils.getUserAuthInfo(claims, token);
            }
            case "3": {
                log.info("\u5fae\u670d\u52a1\u8ba4\u8bc1token \u89e3\u6790");
                return (T)TokenUtils.getMsAuthInfo(claims);
            }
        }
        throw new RuntimeException("\u975e\u6cd5token\u4fe1\u606f");
    }

    public static void setCurrentAuthInfo(String token, String jwtSecret) {
        Object currentAuthInfo = TokenUtils.getCurrentAuthInfo(token, jwtSecret);
        if (null == currentAuthInfo) {
            throw new RuntimeException("\u8bbf\u95ee\u5931\u8d25\uff0c\u65e0\u6548\u4ee4\u724c");
        }
        if (currentAuthInfo instanceof MsAuthInfo) {
            MsAuthInfoHolder.put((MsAuthInfo)currentAuthInfo);
        } else if (currentAuthInfo instanceof IAuthorizedUser) {
            UserAuthInfoHolder.put((IAuthorizedUser)currentAuthInfo);
        } else {
            throw new RuntimeException("\u975e\u6cd5\u7528\u6237\u4fe1\u606f");
        }
    }

    private static Map<String, String> decodeToken(String token, String jwtSecret) {
        Map claims = null;
        try {
            claims = JwtUtils.verifyAndDecodeToken((String)jwtSecret, (String)token);
        }
        catch (TokenExpiredException e) {
            log.error("token\u8fc7\u671f\u5f02\u5e38TokenExpiredException,token=={}", (Object)token);
            String message = "token\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55";
            throw new RuntimeException(message);
        }
        catch (Exception e) {
            String message = "token\u89e3\u6790\u5931\u8d25\u3002";
            log.error(message + ",jwtSecret = " + jwtSecret + ", token=" + token, (Throwable)e);
            throw new RuntimeException(message);
        }
        if (claims == null) {
            String message = "Token\u89e3\u6790\u8fd4\u56de\u4e3a\u7a7a";
            log.warn("TokenParser: claims == null, " + message);
            throw new RuntimeException(message);
        }
        return claims;
    }

    public static MsAuthInfo getMsAuthInfo(Map<String, String> claims) {
        String userinfoStr = claims.get("userinfo");
        claims.remove("userinfo");
        MsAuthInfo msAuthInfo = JsonUtils.writeFastJsonToObject(JsonUtils.writeObjectToJson(claims), MsAuthInfo.class);
        if (null != userinfoStr) {
            MsAuthInfo.Userinfo userinfo = JsonUtils.writeFastJsonToObject(userinfoStr, MsAuthInfo.Userinfo.class);
            msAuthInfo.setUserinfo(userinfo);
            try {
                Object extensionStr = JsonUtils.writeJsonToMap(userinfoStr).get("fieldlimit");
                if (null != extensionStr) {
                    MsAuthInfo.Extension extension = JsonUtils.writeFastJsonToObject(extensionStr.toString(), MsAuthInfo.Extension.class);
                    msAuthInfo.setExtension(extension);
                }
            }
            catch (Exception e) {
                log.error("#### ms token \u5f02\u5e38\uff1a{}", (Throwable)e);
            }
        }
        log.info("##### \u5fae\u670d\u52a1 \u8ba4\u8bc1token \u89e3\u6790\u7ed3\u679c\uff1a{}", (Object)msAuthInfo);
        return msAuthInfo;
    }

    public static AuthorizedUser getUserAuthInfo(Map<String, String> claims, String token) {
        String encodedUserInfo = claims.get("userinfo");
        if (StringUtils.isBlank((CharSequence)encodedUserInfo)) {
            String message = "\u8bbf\u95ee\u5931\u8d25\uff0c\u65e0\u6548\u4ee4\u724c";
            log.warn("TokenParser: encodedUserInfo == null, " + message);
            throw new RuntimeException(message);
        }
        String userinfo = CompressionUtils.decode((String)encodedUserInfo);
        JSONObject userInfo = JSON.parseObject((String)userinfo);
        if (StringUtils.isBlank((CharSequence)userinfo)) {
            String message = "\u8bbf\u95ee\u5931\u8d25\uff0c\u65e0\u6548\u4ee4\u724c";
            log.warn("TokenParser: userinfo == null, " + message);
            throw new RuntimeException(message);
        }
        AuthorizedUser authorizedUser = new AuthorizedUser();
        authorizedUser.setTenantName(userInfo.get("tenantName") + "");
        authorizedUser.setUsername(userInfo.get("username") + "");
        authorizedUser.setAccountId(Long.parseLong(userInfo.get("accountId") + ""));
        authorizedUser.setEmail(userInfo.get("email") + "");
        authorizedUser.setTenantCode(userInfo.get("tenantCode") + "");
        authorizedUser.setTenantId(Long.parseLong(userInfo.get("tenantId") + ""));
        authorizedUser.setMobile(userInfo.get("mobile") + "");
        authorizedUser.setId(Long.parseLong(userInfo.get("id") + ""));
        authorizedUser.setToken(token);
        log.info("TokenParser: setUserInfoHolder: userId\uff1a{}\uff0c username\uff1a{}", (Object)authorizedUser.getId(), (Object)authorizedUser.getUsername());
        return authorizedUser;
    }
}

